# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2
# kst-depend-misc

if(description)
{
 script_id(80015);
 script_version ("$Revision: 1.3 $");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");

 script_cve_id("CVE-2007-0347");
 script_bugtraq_id(22296);
 script_xref(name:"OSVDB", value:"31935");

 name = "CVSTrac text output formatter DoS";

 script_name(name);
 
 desc = "
Synopsis :

The remote web server contains a CGI script or is itself subject to a
denial of service attack. 

Description :

According to its version number, the version of CVSTrac installed on 
the remote host contains a flaw related to its Wiki-style text output 
formatter that may allow an attacker to cause a partial denial of service,
depending on the pages requested. 

See also :

http://www.securityfocus.com/archive/1/458455/30/0/threaded

Solution :

Upgrade to CVSTrac 2.0.1 or later.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:N/A:P)";


 script_description(desc);
 
 summary = "Checks CVSTrac version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2007 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("cvstrac_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("global_settings.inc");
include("http_func.inc");

if (report_paranoia < 2) exit(0);

port = get_http_port(default:80);
kb = get_kb_item("www/" + port + "/cvstrac" );
if ( ! kb ) exit(0);
stuff = eregmatch(pattern:"(.*) under (.*)", string:kb );
version = stuff[1]; 
if(ereg(pattern:"^([01]\.|2\.0\.0[^0-9.]?)", string:version))
	security_warning(port);
