"testLmResidualMean" <-
function(x, beta, y, testLevel = 0.95){

  # Checking for NAs in y, beta is assumed not to contain any
  indexNA <- which(is.na(y))

  if(length(indexNA) > 0) {
    x[indexNA, ] <- NA 
  }

  # Checking for NAs in x, beta is assumed not to contain any
  indexNA <- which(is.na(x), arr.ind=TRUE)

  if(length(indexNA) > 0) {

    x[indexNA[, 1], ] <- NA 
    y[indexNA[, 1]] <- NA
    # Eliminating the NAs
    x <- matrix(x[ ! is.na(x)], ncol = ncol(x))
    y <- y[ ! is.na(y)]
  }

  # Prediction.
  completeX <- cbind(rep(1, nrow(x)), x)
  predictedSample <- completeX %*% beta

  # Residuals.
  residual <- y - predictedSample  
  tTest <- t.test(residual)

  return(list(test = "ResidualMean",
       testResult = as.numeric(tTest$p.value > 1 - testLevel), 
       pValue = tTest$p.value,
       threshold = 1 - testLevel))
}

