//------------------------------------------------------------------------------
// This file is part of the OpenStructure project <www.openstructure.org>
//
// Copyright (C) 2008-2020 by the OpenStructure authors
// Copyright (C) 2003-2010 by the IPLT authors
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3.0 of the License, or (at your option)
// any later version.
// This library is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//------------------------------------------------------------------------------
#ifndef DX_IO_JPK_IO_PLUGIN_OST_HH
#define DX_IO_JPK_IO_PLUGIN_OST_HH

#include "map_io_handler.hh"
#include "map_io_tiff_handler.hh"

namespace ost { namespace io {

class DLLEXPORT_OST_IO JPK: public TIF
{
 public:
  JPK(boost::logic::tribool normalize_on_save = true, Format bit_depth = OST_DEFAULT_FORMAT, bool sign = false, bool phasecolor = false, int subimage = -1);
  static String FORMAT_STRING;
  static String FORMAT_NAME_STRING;
  static String FORMAT_DESCRIPTION_STRING;
};


class DLLEXPORT_OST_IO MapIOJpkHandler: public MapIOTiffHandler
{
 public:
  /// \brief Map IO handler to read/write Situs map files
  ///
  /// This map IO handler reads Jpk formatted map files, as
  /// generated by the software released together with hardware from JPK
  virtual void Import(img::MapHandle& sh, const boost::filesystem::path& loc,const ImageFormatBase& formatstruct);
  virtual void Import(img::MapHandle& sh, std::istream& loc,const ImageFormatBase& formatstruct);
  void Export(const img::MapHandle& image , const boost::filesystem::path& location,const ImageFormatBase& formatstruct) const;
  void Export(const img::MapHandle& image, std::ostream& loc,const ImageFormatBase& formatstruct) const;
  static bool MatchContent(unsigned char* header);
  static bool MatchType(const ImageFormatBase& type);
  static bool MatchSuffix(const String& loc);
  static String GetFormatName() { return String("Jpk");}
  static String GetFormatDescription() { return String("Format used by JPK Instruments AG's software (Customized Tiff format)"); }

};

typedef MapIOHandlerFactory<MapIOJpkHandler> MapIOJpkHandlerFactory;

}} // ns

#endif
