// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2017.
//
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS.
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// --------------------------------------------------------------------------
// $Maintainer: Oliver Alka $
// $Authors: Oliver Alka $
// --------------------------------------------------------------------------

#pragma once

#include <OpenMS/KERNEL/BaseFeature.h>
#include <OpenMS/ANALYSIS/QUANTITATION/KDTreeFeatureMaps.h>
#include <OpenMS/KERNEL/MSExperiment.h>

namespace OpenMS
{

  class OPENMS_DLLAPI FeatureMapping
      {
          public:

          /**
            @brief Allocate ms2 spectra to feature within the minimal distance

            @return FeatureToMS2Indices

            @param spectra: Input of PeakMap/MSExperiment with spectra information
            @param fp_map_kd: KDTree used for query and match spectra with features
            @param precursor_mz_tolerance: mz_tolerance used for query
            @param precursor_rt_tolernace: rt tolerance used for query
            @param ppm: mz tolernace window calculation in ppm or Da

          */

          struct FeatureToMs2Indices
          {
             std::map<const BaseFeature*, std::vector<size_t>> assignedMS2;
             std::vector<size_t> unassignedMS2;
          };

          // return map of ms2 to feature and a vector of unassigned ms2
          static FeatureToMs2Indices assignMS2IndexToFeature(PeakMap& spectra,
                                                             const KDTreeFeatureMaps& fp_map_kd,
                                                             const double& precursor_mz_tolerance,
                                                             const double& precursor_rt_tolerance,
                                                             bool& ppm);

      };
}
