/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_LIBRARY_H_
#define _OPENRIJN_LIBRARY_H_

#include <GTLFragment/Library.h>
#include <OpenRijn/Export.h>

namespace OpenRijn {
  /**
   * @ingroup OpenRijn
   *
   * Hold the code of either a Sketch or a Library.
   */
  class OPENRIJN_EXPORT Library : public GTLFragment::Library {
      friend class Sketch;
      friend class KernelPrivate;
      friend class LibrariesManager;
      Library(GTLFragment::Library::Type _type);
      ~Library();
      GTL_NO_COPY(Library);
    private:
      struct Private;
      Private* const d;
  };
}


#endif
