# $Id: ooo2dbk.spec 20671 2005-03-25 10:31:22Z madarche $
#
# One can learn how to use and build RPM packages at:
# http://www.rpm.org/max-rpm/
# http://qa.mandrakesoft.com/twiki/bin/view/Main/RpmHowTo
#
Name:       ooo2dbk
Summary:    An OpenOffice.org document to DocBook XML converter
Group:      Applications/Internet
Version:    1.3.13
Release:    1
Copyright:  2004-2005 Nuxeo SARL (LGPL 2.1)
# RPM actually ignores everything prior to the last filename in the source line,
# only the last filename is used by the system.
Source:     ooo2dbk-1.3.13.tar.gz
URL:        http://cvs.nuxeo.org/cgi-bin/viewcvs.cgi/Indesko/ooo2dbk/
Vendor:     Indesko
Packager:   M.-A. DARCHE <madarche@nuxeo.com>
# Disabling automatic dependency processing,
AutoReqProv: no
Buildarch:  noarch
Patch: distrib.patch
BuildRoot:  /tmp/%{name}-buildroot
#Prefix:     /usr/local/nuxeo/product
# To find out the value of a macro read /usr/lib/rpm/macros
# It is possible from here to find the value of the %{_vendor} value.
%if "%{_vendor}" == "redhat"
Requires:   python >= 2.3, libxslt
%endif
%if "%{_vendor}" == "MandrakeSoft"
Requires:   python >= 2.3, libxslt-proc
%endif
%if "%{_vendor}" == "mandrake"
Requires:   python >= 2.3, libxslt-proc
%endif
# Other approach
#%if "%{_vendor}" == "redhat"
#Requires:   python >= 2.3, libxslt
#%else
#Requires:   python >= 2.3, libxslt-proc
#%endif


%description
OOo2DBK is an OpenOffice.org document to DocBook XML converter. It can produce
both DocBook article and DocBook book documents.

The online reference presenting all the available DocBook elements can is
http://docbook.org/tdg/en/html/

OOo2DBK can at the moment only process files generated by the OpenOffice.org
1.1.x series. Future versions of OOo2DBK will process files generated by the
OpenOffice.org 2.x series.

%prep
rm -rf $RPM_BUILD_ROOT
# The setup macro by default untar the original sources
%setup
# Applying the patch distrib.patch defined in the preamble
%patch -p 1

%build
# No build required

%install
# In this section there are the script commands which deploy the package
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/share/%{name}
mkdir -p $RPM_BUILD_ROOT/usr/share/doc/%{name}
cp -a ooo2dbk.xml $RPM_BUILD_ROOT/etc
cp -a ooo2dbk $RPM_BUILD_ROOT/usr/bin
cp -a ole2img.py $RPM_BUILD_ROOT/usr/bin
cp -a *.xsl $RPM_BUILD_ROOT/usr/share/%{name}
chown -R root:root $RPM_BUILD_ROOT
chmod a+x $RPM_BUILD_ROOT/usr/bin/*

%files
# This section contains a list of the files that are part of the package. Always
# remember if a file isn't in the file list, it won't be put in the package!
%defattr(-,root,root)
%config /etc/ooo2dbk.xml
/usr/bin/ooo2dbk
/usr/bin/ole2img.py
/usr/share/ooo2dbk
%doc README.txt
%doc HISTORY
%doc doc/ABOUT.txt
%doc doc/template.stw
%doc doc/TODO.txt
%doc doc/ooo2dbk.1

%clean
rm -rf $RPM_BUILD_ROOT