/*
// $Id: BooleanType.java 482 2012-01-05 23:27:27Z jhyde $
//
// Licensed to Julian Hyde under one or more contributor license
// agreements. See the NOTICE file distributed with this work for
// additional information regarding copyright ownership.
//
// Julian Hyde licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at:
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/
package org.olap4j.type;

/**
 * The type of a boolean (logical) expression.
 *
 * <p>An example of a boolean expression is the predicate
 *
 * <blockquote>
 * <code>[Measures].[Unit Sales] &gt; 1000</code>
 * </blockquote>
 *
 * @author jhyde
 * @since Feb 17, 2005
 * @version $Id: BooleanType.java 482 2012-01-05 23:27:27Z jhyde $
 */
public class BooleanType extends ScalarType {
    /**
     * Creates a boolean type.
     */
    public BooleanType() {
    }

    public String toString() {
        return "BOOLEAN";
    }
}

// End BooleanType.java
