      Subroutine PStat_Print_All
C$Id$
      Implicit NONE
C
#include "pstatP.fh"
#include "global.fh"
#include "msgids.fh"
#include "util.fh"
#include "stdio.fh"
C
      Integer I, IMAM(3), icalls, ntime, total_calls
      Double Precision DMAM(3, 2), now_cpu, now_wall, overhead
      double precision fmam(3)
C
      Call GA_Sync()
C
C  Attempt to determine timer overhead
c
      overhead = -util_cpusec()
      ntime = 0
      do i = 1, 10000
        now_wall = util_wallsec()
        now_cpu = util_cpusec()
        ntime = ntime + 1
        if ((now_cpu+overhead) .gt. 1.0d0) goto 10
      enddo
10    overhead = (overhead + now_cpu) / dble(i)
c
      total_calls = 0
C
      If ( GA_NodeID() .eq. 0) then
         Call Banner(luout, 'Performance information', '-',
     $   .TRUE., .TRUE., .FALSE.)
          write(luout, 8999) overhead
8999      format(/' Timer overhead = ',1p,d9.2,' seconds/call'/)
         Write (luout, 9000)
      EndIf
 9000 Format(10X,
     $   '     Nr. of calls    ',1X,
     $   '    CPU time (s)  ',1X, '              Wall time (s)  ',
     $   10X,'    GFlops'/
     $   10X,
     $   '   ---------------    -------------------  ',
     $     '   ------------------------------',
     $     '   -------------------'/,
     $   'Name', 6X, '   Min', 1X, '  Avg', 1X,
     $                     '  Max',1X,
     $  '   Min',1X, '    Avg',1X, '    Max',1X,
     $  '    Min',1X, '    Avg',1X, '    Max',1X, '  Mx/calls',1X,
     $  '  Min',1X, '    Max',1X, '    Sum')
C
      Do I = 1, PStat_max_items
         if (pstat_active(i)) then
C     
C     Determine the min/avg/max for the number of calls
C     
            iMAM(1) = PStat_Nr_Calls( I )
            iMAM(2) = PStat_Nr_Calls( I )
            iMAM(3) = PStat_Nr_Calls( I )
C     
            Call ga_IGOp(Msg_PStat_Min, iMAM(1), 1, 'min')
            Call ga_IGOp(Msg_PStat_Avg, iMAM(2), 1, '+')
            iMAM(2) = iMAM(2) / GA_NNodes()
            Call ga_IGOp(Msg_PStat_Max, iMAM(3), 1, 'max')
C     
C     Determine min/avg/max for the times
C     
            dMAM(1, 1) = PStat_Times( I, 1)
            dMAM(2, 1) = PStat_Times( I, 1)
            dMAM(3, 1) = PStat_Times( I, 1)
            dMAM(1, 2) = PStat_Times( I, 2)
            dMAM(2, 2) = PStat_Times( I, 2)
            dMAM(3, 2) = PStat_Times( I, 2)
C     
            Call ga_DGOp(Msg_PStat_Min, dMAM(1, 1), 1, 'min')
            Call ga_DGOp(Msg_PStat_Avg, dMAM(2, 1), 1, '+')
            dMAM(2, 1) = dMAM(2, 1) / GA_NNodes()
            Call ga_DGOp(Msg_PStat_Max, dMAM(3, 1), 1, 'max')
C     
            Call ga_DGOp(Msg_PStat_Min, dMAM(1, 2), 1, 'min')
            Call ga_DGOp(Msg_PStat_Avg, dMAM(2, 2), 1, '+')
            dMAM(2, 2) = dMAM(2, 2) / GA_NNodes()
            Call ga_DGOp(Msg_PStat_Max, dMAM(3, 2), 1, 'max')
C
            if(abs(pstat_flop(i)).gt.1d-3.
     .           and.pstat_times(i,2).gt.1d-5) then
               fmam(1) = pstat_flop(i)/pstat_times(i,2)
               fmam(2) = pstat_flop(i)/pstat_times(i,2)
               fmam(3) = pstat_flop(i)/pstat_times(i,2)
            else
               fmam(1)=0d0
               fmam(2)=0d0
               fmam(3)=0d0
            endif
            Call ga_DGOp(Msg_PStat_Min, fmam(1), 1, 'min')
            Call ga_DGOp(Msg_PStat_Avg, fmam(2), 1, 'max')
            Call ga_DGOp(Msg_PStat_Max, fmam(3), 1, '+')
c
            
            If ( GA_NodeID() .eq. 0) then
              icalls = iMAM(1) + iMAM(2) + iMAM(3)
              total_calls = total_calls + iMAM(2)
              if (icalls.gt.0) then
                 if(imam(1).gt.99999.or.imam(2).gt.99999.
     O                or.imam(3).gt.9999) then
                    Write (luout, 9110) PStat_Name(I), 
     ,                   dble(iMAM(1)),dble(iMAM(2)),dble(iMAM(3)), 
     ,                   dMAM, dmam(3,2)/imam(3),fmam
                 else
                    Write (luout, 9010) PStat_Name(I), iMAM, dMAM,
     ,                   dmam(3,2)/imam(3),fmam
                 endif
              endif
            endif
         endif
      EndDo
c
      if (ga_nodeid() .eq. 0) then
         write(luout,9011) dble(total_calls),
     $        dble(total_calls)*overhead
         call util_flush(luout)
      endif
C
 9010 Format(A9, 1X, 3(I5,1X), 1X,1P, 3(1X,G7.2E1), 1X, 4(1X,G7.2E1),
     $     1X, 3(1X,G7.2E1))
 9110 Format(A9, 1X, 3(1PE6.0),1X,1P,3(1X,G7.2E1),1X,4(1X,G7.2E1),
     $     1X, 3(1X,G7.2E1))
 9011 Format(/1p,' The average no. of pstat calls per process was',
     $     d9.2,/' with a timing overhead of',d9.2,'s'/)
C
      Return
      End
