package main

import (
	"fmt"

	"launchpad.net/go-dbus/v1"
)

const (
	pushInterface string = "org.ofono.PushNotificationAgent"
	pushMethod    string = "ReceiveNotification"
)

func push(endPoint, sender string) error {
	conn, err := dbus.Connect(dbus.SystemBus)
	if err != nil {
		return err
	}

	obj := conn.Object(endPoint, "/nuntium")

	data := []byte{
		0x01, 0x06, 0x26, 0x61, 0x70, 0x70, 0x6C, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
		0x6e, 0x2f, 0x76, 0x6e, 0x64, 0x2e, 0x77, 0x61, 0x70, 0x2e, 0x6d, 0x6d, 0x73,
		0x2d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x00, 0xaf, 0x84, 0xb4, 0x86,
		0xc3, 0x95, 0x8c, 0x82, 0x98, 0x6d, 0x30, 0x34, 0x42, 0x4b, 0x6b, 0x73, 0x69,
		0x6d, 0x30, 0x35, 0x40, 0x6d, 0x6d, 0x73, 0x2e, 0x70, 0x65, 0x72, 0x73, 0x6f,
		0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x72, 0x00, 0x8d, 0x90,
		0x89, 0x19, 0x80, 0x2b, 0x35, 0x34, 0x33, 0x35, 0x31, 0x35, 0x39, 0x32, 0x34,
		0x39, 0x30, 0x36, 0x2f, 0x54, 0x59, 0x50, 0x45, 0x3d, 0x50, 0x4c, 0x4d, 0x4e,
		0x00, 0x8a, 0x80, 0x8e, 0x02, 0x74, 0x00, 0x88, 0x05, 0x81, 0x03, 0x02, 0xa2,
		0xff, 0x83,
		// h     t     t     p     :     /     /
		0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
		// l     o     c     a     l     h     o     s     t
		0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73, 0x74,
		// :     9     1     9     1     /     m     m     s
		0x3a, 0x39, 0x31, 0x39, 0x31, 0x2f, 0x6d, 0x6d, 0x73, 0x00,
	}

	info := map[string]*dbus.Variant{"LocalSentTime": &dbus.Variant{"2014-02-05T08:29:55-0300"},
		"Sender": &dbus.Variant{sender}}

	reply, err := obj.Call(pushInterface, pushMethod, data, info)
	if err != nil || reply.Type == dbus.TypeError {
		return fmt.Errorf("notification error: %s", err)
	}

	return nil
}
