/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Command-line interface (CLI).
*
* @module @stdlib/cli/ctor
*
* @example
* var CLI = require( '@stdlib/cli/ctor' );
*
* var opts = {
*     'pkg': require( './path/to/package.json' ),
*     'help': 'Usage: beep [options] <boop>',
*     'title': 'foo',
*     'updates': true,
*     'options': {
*         'boolean': [
*             'help',
*             'version'
*         ]
*     }
* };
* var cli = new CLI( opts );
* // returns <CLI>
*
* cli.close();
*/

// MODULES //

var CLI = require( './main.js' );


// EXPORTS //

module.exports = CLI;
