if (typeof T === 'undefined') require('../setup');

T('cubeRoot', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).cbrt().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0', 40, 4, '0');
  t('-0', 40, 4, '-0');
  t('Infinity', 40, 4, 'Infinity');
  t('-Infinity', 40, 4, '-Infinity');
  t('1', 40, 4, '1');
  t('-1', 40, 4, '-1');
  t('8', 40, 4, '2');
  t('-8', 40, 4, '-2');

  t('-4', 5, 2, '-1.5874');
  t('-0.8667', 7, 0, '-0.9534318');
  t('-0.0000000071', 9, 2, '-0.00192199734');
  t('-21791364.26687703933853824404550506158463693222', 3, 1, '-279');
  t('36', 9, 6, '3.30192725');
  t('0.898', 7, 0, '0.9647737');
  t('-94444444444444444.444444444444444444444444444444444444444444414404441444441', 8, 2, '-455399.06');
  t('-3782929120857330517139808', 5, 2, '-155810000');
  t('966666666692107298099458326175656566655348300467903965479870253722013788135743211111111111111111111.22222', 1, 5, '1000000000000000000000000000000000');
  t('16.84', 7, 4, '2.563189');
  t('-58918', 2, 3, '-39');
  t('-74535634133038239268820777237286', 2, 4, '-42000000000');
  t('6888888888.66666666666602248', 3, 5, '1900');
  t('608785700000000000000000100000000000000000000.000000500020900040006', 1, 5, '800000000000000');
  t('-3834369', 8, 0, '-156.51813');
  t('4345752', 8, 0, '163.18804');
  t('5000300.5', 5, 5, '171');
  t('0.73', 7, 3, '0.9004113');
  t('0.612', 20, 3, '0.84901847487755466985');
  t('-26403122.886392512193592', 9, 3, '-297.772851');
  t('-15047905.6442424463707664865226022703526330746497470178339129', 10, 2, '-246.8834739');
  t('-0.57216409476227961', 122, 4, '-0.83018242216788557900092187018458431268949382089457981268783675303907114542359515145805957769873268594828033331460924645988');
  t('-58892300900.0000037', 72, 3, '-3890.62620353612987584901759020572729952315745798457018660549639374283766');
  t('4312692950776.434730495181946194732352621783', 134, 0, '16277.3179326290103123151730291347428666068760542903239801418389563715424057253795836596796134792716104557634024961949417454938847683');
  t('0.772144893677647945980591', 32, 4, '0.91741591091195652167447475342283');
  t('-6404156859301838811126951723297929248851328010128081790499875', 82, 4, '-185703741377679767357.3800976029196648819860800202650959861930855922060702625367479');
  t('82632936267840682945343488907.06731470799523118845064687431515', 138, 6, '4355630815.60590669653353707630763857376582544155292301618426362137145407016564135319408858966461324112682532653188194626242452174990441469');
  t('-61298.9118623440767849615617799359637', 197, 2, '-39.429165763027824633368109569426988335873352574747430934500984379971077138739905025020214349026555314495729845811145173351353942674905845843718751365519784088965133478757694847415073443325596801746');
  t('-2667296564625933848.771563268738963983215162122262769664228', 16, 0, '-1386831.726818274');
  t('-0.334827956215', 18, 4, '-0.694396042925351186');
  t('-99720206756351473857877956382713150380254708747259063563139776823977600150709529793618374286723970525922071298906643096473046848495659004519869163757701760515093579766384020476650579781490788310361655846842647878265152413279324940775571807902246099745918912445535151332', 222, 0, '-463725583930338667619983284372725899222416698496535412229926661119869463138884485967116667.268764679696065784024043219821875298578444546083384238930673115329612447425356818168403301703207667321878308803543383110193582598871');
  t('-7500005000000.0400000000000300010000000000000000000000000000000005000080000000000000000000000000000000000000000000000000000000000002', 148, 3, '-19574.34255569632077437589146736430354513462358173952556661853843109637110903043841920141950812963359142265525718451865996670282229623898813004424264');
  t('-0.448468', 65, 3, '-0.76543882436933301547484358146042454236821782800684597996385314496');
  t('4456480839.850118829380687717773702938945780108504222', 186, 0, '1645.62426023819366824168925970611179098042486858393864888187997539499903266584393283173483354076296462532577165369465744086271078047145002431391610101290550337528381582739390745330190718');
  t('-96609.9150016783612444151212219171469160528', 240, 2, '-45.8853342870476892493411403085005845531506513402973065908688567063670288324040964632169186092910604211131726914840870130664139857417136966852726525679016120128473243314724524836298854193278510304781073613018919609658048462067078117541267917');
  t('4685555525555555055595555555555555555555545555555555557555555.5555555555555555155555555555555', 248, 1, '167335093070845212053.23568655992334896377737501807442809961373434087576897330216500135950283334739701735651884253417447515894217902592534791090429673074268316351070024795424585615393609483094797289624124159380909320002173012536209191509994668942513');
  t('-166.616666666', 209, 4, '-5.5026617052342616148242191958679981633756294691968284245117501906609287423436017722548887408126098326860453334063765780606472030703630175042357147586923686464448738079927220693696480524411130124852775767369759');
  t('90000000000000990188336751810563895553131772327584661674356934574327131997430235171176535358829942834766892027903586810380716666666666.13894530889067032955500919787773607496418660983547640753478416765344978700918917680179444881557185725915289743352494311111111111', 154, 6, '448140474655718114369086092178601538485288241.3695491088028300586188927081853222791393481056106217377422579723430885965770967892400223712781827123169146742');
  t('-85690377176662769530000000', 172, 6, '-440870139.6162986343668488373525420672013683234193107109561329235272890252923129958712015571449424496445764927227011775235765025343956947502249567673085220140428475752341634');
  t('-770000', 315, 4, '-91.6565645433022286626092137070830558694163526764780961804072197329043071216124465836059153674866409019818795567376022473570999553232243320951491034642924310116859135403989828713296248110330728429307978818049273063638547762257276709121136983687240301319624468569985024000817994013321153096111049926913537599622929478');
  t('-751306536843521448000318938740388', 22, 5, '-90908757590.86052782049');

  /*
  t('-0.3818933', 2, 6, '-0.73');
  t('68', 1, 5, '4');
  t('-0.6', 3, 0, '-0.844');
  t('0.3119015270933389452638101937338812', 3, 0, '0.679');
  t('7366.201', 4, 4, '19.46');
  t('-22399399999999990999999999999999799909395999979999999999.9999', 8, 0, '-2818894400000000000');
  t('-80000000000000000000000000000000000000.000000000001', 10, 5, '-4308869380000');
  t('-6999959999999999.9399999999499999', 1, 6, '-200000');
  t('335178', 9, 6, '69.4637943');
  t('28888888888888886049', 1, 4, '3000000');
  t('500000000', 9, 0, '793.700526');
  t('769653863626666666666666666666', 1, 5, '9000000000');
  t('-0.844444', 3, 2, '-0.945');
  t('954465369366093944592507572598188976743757.28429627374490584', 7, 2, '98458550000000');
  t('-7345857896', 6, 3, '-1943.94');
  t('0.83519222', 6, 1, '0.941735');
  t('26533.9217548', 2, 5, '30');
  t('-5000074333485388075063.444444549041878', 10, 4, '-17099844.21');
  t('0.68', 6, 6, '0.879366');
  t('0.0272', 8, 1, '0.30073891');
  t('-503454616900973495983778488.26', 3, 0, '-796000000');
  t('0.8297554395897924988305738463663690325842972721733405078270324064904499', 1, 0, '1');
  t('-1000000000000000000000.0000000000000000040000000000000100008', 6, 6, '-10000000');
  t('-4999999960368855400453841296666666666666666666.444444480304322222', 2, 1, '-1700000000000000');
  t('-0.237', 10, 0, '-0.6188462763');
  t('9219991.6', 3, 4, '210');
  t('-11.9', 1, 5, '-2');
  t('82', 4, 6, '4.344');
  t('-6', 5, 1, '-1.8171');
  t('6.407', 9, 2, '1.85731219');
  t('8805824325740535689820760681109868830.4500898323470577748', 7, 0, '2065016000000');
  t('-40.4', 3, 0, '-3.44');
  t('975435.161933643', 2, 1, '99');
  t('-207738428807874275276125610588522932638016305909263402564', 8, 5, '-5922507400000000000');
  t('1625199339405966916842602870069151508760', 3, 5, '11800000000000');
  t('67777777777777777.1111111111111185777', 4, 3, '407700');
  t('-0.00000015101129203376903282', 5, 2, '-0.0053252');
  t('0.7244525383', 2, 1, '0.89');
  t('-77.732', 8, 4, '-4.2677596');
  t('-0.55648377779113352938', 1, 4, '-0.8');
  t('2', 8, 2, '1.2599211');
  t('90.5', 4, 5, '4.49');
  t('-0.97550590975788566729878137257533567618255023', 3, 2, '-0.991');
  t('-333995555555', 2, 0, '-7000');
  t('0.50338', 8, 0, '0.79548499');
  t('-5', 4, 1, '-1.709');
  t('-0.7351794040135875032087894175170651566358350521', 9, 2, '-0.902535813');
  t('-62.1', 2, 5, '-4');
  t('10148322508989558.1791419395907316907543', 4, 2, '216600');
  t('9666666557788888888888888888888.2638', 4, 3, '21300000000');
  t('9964904728277204840222222222222222222', 9, 4, '2151911390000');
  t('-1255.559', 4, 1, '-10.78');
  t('387', 6, 0, '7.28737');
  t('-0.00000207705325742303133289292195931068216667127350664', 4, 0, '-0.01276');
  t('9099999979999999999999999.9045', 4, 0, '208800000');
  t('-506706588188819442960350735312948540', 7, 4, '-797233500000');
  t('-0.3230010071', 8, 4, '-0.68612192');
  t('300000.0004', 10, 5, '66.94329504');
  t('-3744.444444', 7, 3, '-15.52849');
  t('-8', 9, 3, '-2');
  t('-0.00000006502345078780795619440224', 4, 5, '-0.004021');
  t('8094000', 6, 5, '200.78');
  t('22.5', 8, 0, '2.8231081');
  t('-401643003658', 9, 2, '-7378.13734');
  t('-363.85', 5, 2, '-7.139');
  t('0.0086', 2, 1, '0.2');
  t('0.73', 6, 1, '0.900411');
  t('219930000000000000.77777777777999999', 3, 6, '604000');
  t('1488.68878838888888888986', 1, 0, '20');
  t('3400000000', 6, 5, '1503.69');
  t('-0.5', 6, 5, '-0.793701');
  t('18200000', 4, 1, '263');
  t('-0.70678', 6, 2, '-0.890761');
  t('-344', 6, 5, '-7.0068');
  t('-62', 1, 2, '-3');
  t('0.927', 1, 2, '1');
  t('810.8', 5, 0, '9.3248');
  t('-1.77777777755555555552568', 7, 2, '-1.211413');
  t('-9', 5, 0, '-2.0801');
  t('0.9', 5, 0, '0.96549');
  t('-783333333333332333333333339333337.9', 2, 3, '-93000000000');
  t('70000000000000000000000000000000000000000000000000000000000000000000000000000', 7, 6, '41212850000000000000000000');
  t('-362515477364205', 5, 3, '-71304');
  t('-7222222222299183', 9, 5, '-193296.333');
  t('2688888888889888888.8888888888888888888888888', 6, 6, '1390560');
  t('-3349552733416603170933246099', 4, 4, '-1496000000');
  t('-67803227653503', 1, 3, '-50000');
  t('742896078807444528609947593057', 8, 6, '9056826000');
  t('553800000', 2, 5, '820');
  t('1', 8, 5, '1');
  t('0.7743', 5, 5, '0.91827');
  t('-0.6', 3, 4, '-0.843');
  t('686626666666696.62666666666661666666666666', 6, 1, '88221.3');
  t('85555555555555555528133143344444444444444', 1, 5, '40000000000000');
  t('0.00000773', 3, 6, '0.0198');
  t('39300000000000700000040000000900800000000', 1, 1, '30000000000000');
  t('-4999999999999914118528055233382328193673510034743156443300333333', 2, 1, '-1700000000000000000000');
  t('-95999.64199', 4, 5, '-45.79');
  t('34.5593', 1, 1, '3');
  t('-54589', 5, 6, '-37.935');
  t('-7', 8, 2, '-1.9129311');
  t('-77175.27642727049456729999', 10, 3, '-42.57546481');
  t('-8.7263794638868921828943152093844917', 4, 6, '-2.059');
  t('69.1616', 4, 0, '4.105');
  t('0.91352685034512351562995274', 3, 6, '0.97');
  t('10', 1, 1, '2');
  t('171093357128829267501683724199412', 1, 5, '60000000000');
  t('-66', 2, 6, '-4');
  t('-2419869044651283665417167346.02866228', 6, 0, '-1342560000');
  t('-87399799399969997.99', 3, 0, '-444000');
  t('-60.02', 1, 2, '-3');
  t('9.5285008666', 8, 5, '2.1200277');
  t('-0.0740010436456', 4, 1, '-0.4198');
  t('617', 1, 3, '8');
  t('-379171991133333333333333333333.222222222222222222225548', 6, 6, '-7237890000');
  t('-78869.48', 1, 0, '-50');
  t('4.8497061095902842395', 5, 6, '1.6927');
  t('-7986', 2, 6, '-20');
  t('3', 2, 2, '1.5');
  t('68925.04429', 7, 2, '41.00081');
  t('-5853333333333333333333333333.33333333333333333333333333333', 2, 6, '-1800000000');
  t('3434444444444111.11111144', 8, 3, '150875.53');
  t('52532642', 1, 6, '400');
  t('43', 10, 6, '3.50339806');
  t('0.5286', 4, 6, '0.8086');
  t('0.177843759307169792769565570223542845980290358200654777715307', 4, 5, '0.5624');
  t('-7', 3, 5, '-1.91');
  t('0.7', 1, 1, '0.8');
  t('8454', 9, 0, '20.371394');
  t('635.224', 8, 0, '8.5962486');
  t('33333333333333333333333333.333333333333333333333333333333323333333333333333333333353333333333', 1, 6, '300000000');
  t('4.6748', 8, 3, '1.6720695');
  t('-9000000000', 7, 6, '-2080.084');
  t('376132380430878165586552708948486621904851168441160549361', 3, 6, '7220000000000000000');
  t('-5.5', 10, 6, '-1.765174168');
  t('-0.03495634077066065579569482530413804639314179994642585487432131219689628995275', 5, 1, '-0.32697');
  t('0.00000032', 1, 1, '0.006');
  t('-9', 1, 1, '-2');
  t('8.66454', 8, 5, '2.053912');
  t('-48635412637237223941782255406026508', 9, 5, '-365020735000');
  t('0.047892279290449515642827450578515631977', 9, 1, '0.363152051');
  t('-9333333333333333385888888888', 6, 1, '-2105450000');
  t('-146442000000', 9, 2, '-5270.9458');
  t('-0.00000136217448949208241555690431', 11, 4, '-0.011085218236');
  t('-7.599', 6, 0, '-1.96601');
  t('157777776717777873.777', 15, 3, '540358.445963008');
  t('-0.24', 10, 0, '-0.6214465012');
  t('-339720971392858', 3, 2, '-69700');
  t('-7.17', 10, 6, '-1.928293121');
  t('91280925.40638118646515161604082790722332930532234', 20, 0, '450.25652107879028395');
  t('-0.3', 18, 1, '-0.669432950082169521');
  t('-96892992', 20, 0, '-459.30106837422135622');
  t('79999999999141058824444444444444444', 2, 5, '430000000000');
  t('0.27658', 18, 2, '0.651538760691784225');
  t('73109', 16, 2, '41.81418289652367');
  t('976546316084487560536', 8, 5, '9921201.8');
  t('-443507770096348001165816', 14, 6, '-76260633.907192');
  t('-48.2249', 6, 3, '-3.63991');
  t('48967159548368479836338889353038416287', 5, 0, '3658500000000');
  t('-846422028274222.22', 2, 1, '-94000');
  t('277564088680007693371731571', 6, 4, '652311000');
  t('-6361119110.3', 18, 6, '-1852.86812094016191');
  t('75756535.389311', 19, 4, '423.1295617915019781');
  t('0.7', 20, 3, '0.88790400174260070842');
  t('8', 3, 5, '2');
  t('782400958507404', 15, 3, '92145.9937257919');
  t('-227511', 6, 3, '-61.0475');
  t('75555555555555140217373626015737777777777777', 11, 1, '422755047020000');
  t('-2855555555555555555555', 14, 2, '-14187205.885874');
  t('-724.06', 4, 2, '-8.979');
  t('0.934477', 14, 3, '0.97766380912616');
  t('-0.00000000918315', 3, 2, '-0.00209');
  t('64471191009935131000307697', 4, 5, '401000000');
  t('-5940', 20, 2, '-18.110432210393057671');
  t('-2290', 1, 6, '-10');
  t('22384252102.3559696', 3, 2, '2820');
  t('-2', 18, 4, '-1.25992104989487316');
  t('-44799.8999995099999', 18, 3, '-35.5161336438405426');
  t('26933.31001317073204642547748', 18, 1, '29.9752796406007609');
  t('-2', 1, 3, '-2');
  t('-38888888888888888888888888888888888888888888.8888888', 18, 4, '-338798785604951.143');
  t('0.9012849960174826221457183472415269', 6, 3, '0.965948');
  t('-0.689027527414476475', 6, 1, '-0.88324');
  t('0.4996683993951343861785828972876376718966803829355326206', 15, 3, '0.793525026131476');
  t('0.1', 4, 6, '0.4642');
  t('201101732983371570150340396098773058768604756', 20, 3, '585875410795702.86759');
  t('0.961025299904131966523108898', 10, 3, '0.9868359001');
  t('0.09686204958039', 14, 4, '0.45925217113478');
  t('-755555555555555555517531112888888888888888', 3, 1, '-91000000000000');
  t('-63', 20, 4, '-3.9790572078963918597');
  t('71048553160427606692477034809930243829', 11, 2, '4141761430100');
  t('-44161531326452420', 4, 2, '-353400');
  t('6339.43', 5, 4, '18.508');
  t('7987752440751033707833300', 9, 5, '199897885');
  t('0.76102372474037253', 12, 3, '0.91299009379');
  t('-4210797338.941679528747', 4, 0, '-1615');
  t('-33333333398660255034462752266861136128802.265233333333333', 2, 0, '-33000000000000');
  t('-60', 12, 3, '-3.91486764117');
  t('-2', 14, 6, '-1.2599210498949');
  t('3', 6, 0, '1.44225');
  t('-1000000007000020000000000060000000000000000000000010000.000000000000000090065', 7, 5, '-1000000000000000000');
  t('-24360000', 9, 4, '-289.885012');
  t('-0.11', 17, 3, '-0.4791419857062784');
  t('-8735875.5555', 15, 2, '-205.953327437355');
  t('85999999999999999.97', 20, 4, '441400.49624421037719');
  t('5680.44914345444444944', 17, 0, '17.842713085635244');
  t('-6.04', 2, 0, '-1.9');
  t('5363393723934555300333716221047.39887467952', 15, 0, '17504373028.4339');
  t('0.00000001', 4, 6, '0.002154');
  t('8829612121.2662376719993', 15, 3, '2066.87339611447');
  t('-94.6', 16, 6, '-4.556489552254712');
  t('-0.6', 2, 5, '-0.84');
  t('32222222225382815091210706697714788888888', 18, 6, '31821342365573.8915');
  t('-0.59929999829', 3, 2, '-0.843');
  t('-3', 1, 6, '-1');
  t('-82379807156556933.975361290675288700595834832857115', 16, 4, '-435117.873823822');
  t('781094765917092', 9, 0, '92094.687');
  t('100', 5, 4, '4.6416');
  t('7.5', 4, 2, '1.958');
  t('56666666666811', 8, 2, '38409.846');
  t('-0.7', 20, 2, '-0.88790400174260070842');
  t('0.66735078430658921245869653996855224044707', 4, 6, '0.8739');
  t('5000000.0000007', 5, 1, '170.99');
  t('-0.0000000032', 12, 2, '-0.00147361259945');
  t('-0.62', 4, 4, '-0.8527');
  t('15900070.00004', 8, 4, '251.45851');
  t('-45555555555559008066979.377298', 16, 0, '-35714708.98969334');
  t('-87585451621', 11, 5, '-4440.9647354');
  t('-6', 19, 2, '-1.817120592832139658');
  t('56404825428', 2, 6, '3800');
  t('75309002680', 6, 6, '4222.95');
  t('47.9230999999', 18, 2, '3.6322993625605057');
  t('-0.214831165', 2, 1, '-0.59');
  t('-8791000005000060.07007000300000000006', 19, 0, '-206385.6163875007765');
  t('-72', 6, 2, '-4.16016');
  t('-1135983465892976189803592754542843333333333', 13, 1, '-104341562701500');
  t('-70007400004000.200080000005000002', 19, 6, '-41214.30521013758219');
  t('-837893.2120728642402941', 8, 3, '-94.274932');
  t('0.077053232660958557020664089663', 5, 6, '0.42553');
  t('594.9668965', 5, 4, '8.4107');
  t('0.18', 5, 1, '0.56462');
  t('724.6167', 20, 4, '8.981925453892595145');
  t('0.74', 20, 2, '0.90450416965102748017');
  t('52233.222222747757678356196', 14, 6, '37.380829924889');
  t('0.122894333403145798064053367879002109205419623904', 5, 5, '0.49718');
  t('8222222222222222222222222222222.22', 20, 2, '20183496488.370349058');
  t('0.22', 3, 2, '0.604');
  t('6.237', 11, 3, '1.8407377318');
  t('-8479616330832523', 7, 1, '-203919.4');
  t('-97999999999999.999999999990197', 20, 3, '-46104.362920584465697');
  t('42', 12, 4, '3.47602664489');
  t('209208253.67494313', 15, 0, '593.644257958926');
  t('-1', 13, 0, '-1');
  t('62222222222222229096992166666666666666666.99995324262866624345593', 16, 5, '39626146351754.2');
  t('7617468.88888883488', 6, 0, '196.761');
  t('-422220000000000000.2222212901131', 4, 1, '-750200');
  t('343368297564095719915273411', 8, 5, '700250450');
  t('6853.2', 14, 3, '18.994642995749');
  t('-9400000000000000000.3', 1, 5, '-2000000');
  t('-0.103968979964', 7, 3, '-0.4702202');
  t('1213208415', 13, 5, '1066.543249664');
  t('-554352693.2852517', 15, 3, '-821.476960039875');
  t('0.5', 6, 1, '0.7937');
  t('-581125607535033826', 6, 5, '-834494');
  t('-0.68244239366854656991', 11, 4, '-0.88041749889');
  t('-53', 13, 5, '-3.756285754221');
  t('-886', 7, 2, '-9.604569');
  t('0.0000003766', 9, 4, '0.0072214893');
  t('9.2682889565720055831826542', 8, 3, '2.1005507');
  t('-87', 18, 5, '-4.43104762169363416');
  t('-6777777777777777772810830980831666251088888888888888888888', 1, 5, '-20000000000000000000');
  t('8222222222222228239250491378488487777', 16, 4, '2018349648837.035');
  t('714322.8', 9, 6, '89.3919005');
  t('-56728411622164771011022834983525569666', 9, 1, '-3842379060000');
  t('-53704732137158', 20, 1, '-37728.614031772919273');
  t('0.38465316656552994163628811014607061649030905', 12, 2, '0.727260115643');
  t('-9035000.80713', 20, 6, '-208.27768022208090884');
  t('-625', 14, 4, '-8.5498797333835');
  t('-7247627357', 12, 5, '-1935.22716605');
  t('81111111111111111225481', 14, 5, '43287262.014676');
  t('-0.2', 15, 6, '-0.584803547642573');
  t('-0.132558', 1, 4, '-0.5');
  t('0.9', 3, 5, '0.965');
  t('3755555.59391', 11, 5, '155.43830976');
  t('0.7', 5, 5, '0.8879');
  t('30', 19, 6, '3.107232505953858867');
  t('2', 6, 0, '1.25993');
  t('0.3506438836338320446526314426143055702196015101566868', 16, 1, '0.705161764689684');
  t('19716567777777.777777777', 17, 2, '27015.34006102092');
  t('2.38', 9, 2, '1.33513645');
  t('-0.4979584110806576577783804498400335989992388566529', 16, 2, '-0.7926187788573717');
  t('-3', 6, 6, '-1.44225');
  t('22797.87', 14, 3, '28.355115737103');
  t('-5472878560769', 11, 1, '-17622.679269');
  t('-0.73260018423433424', 12, 1, '-0.901479125065');
  t('-8097160207254836569', 20, 6, '-2008064.1251795318772');
  t('480', 15, 2, '7.82973528233773');
  t('0.526872495', 19, 4, '0.8076722761506822232');
  t('-646925675.8', 4, 5, '-864.9');
  t('-2862688482708367427751267', 20, 6, '-141990088.62099197018');
  t('-30', 7, 2, '-3.107232');
  t('-400.000000000000002020000000000000000000000000000000000000001', 12, 0, '-7.36806299729');
  t('-0.8', 10, 0, '-0.9283177668');
  t('450919013', 18, 2, '766.830743101908863');
  t('-0.84596', 18, 0, '-0.945765083127084699');
  t('154766705', 15, 5, '536.898897516556');
  t('30605216213361952', 36, 5, '312798.852116888449424430123851279558');
  t('1555.55555555555545555555555455555555555555555555555525555555555555555555555558555555556', 34, 4, '11.58675548295483237417859990230964');
  t('74326901309076267608214048.527011853596990954896772624192229777', 5, 0, '420460000');
  t('-4773844', 10, 4, '-168.3795745');
  t('-23101344770296', 5, 1, '-28480');
  t('-0.05084548815', 34, 6, '-0.3704680906661542489843134278806554');
  t('3.7614', 7, 0, '1.555189');
  t('5322396392259788706886367688487', 3, 1, '17400000000');
  t('37555555555555555.555555555555555155555555555555555555555555558555555555565555555355555555553', 33, 0, '334881.685568918487704853146112136');
  t('-8111111111111111.8888888654603333333', 19, 2, '-200921.6720049913782');
  t('0.0000002476650421760215078', 19, 4, '0.006279931455024406975');
  t('7083.6554426791864086812788154', 3, 2, '19.3');
  t('40000', 11, 5, '34.199518934');
  t('19999961740711.00000000000000000063228622222222222', 18, 5, '27144.1588573233521');
  t('-7000000000', 6, 3, '-1912.94');
  t('-1061327724.0871', 22, 6, '-1020.038356909205102836');
  t('-69999969999999919999999999.99999999191997', 25, 6, '-412128471.1053428311686475');
  t('341186.95443', 23, 2, '69.876445613741915029436');
  t('-0.35764956557712666144321146208892', 29, 1, '-0.7098270858273914280961516879');
  t('-8834.7174015697601489246943709956659963875961204915069431458569263396777777777777777777', 38, 6, '-20.672716746508325630647525479849959468');
  t('7777077777777777777777.7777777777777777775', 13, 0, '19812478.76585');
  t('-82.11111111112222222221734400130859529345977330105702479024583936', 26, 3, '-4.3464428772252284862039557');
  t('22222222224120423260860177044984487412450415274556', 19, 0, '28114422177525477.15');
  t('8222222428821702', 19, 6, '201834.9665742034256');
  t('-270758006228512', 5, 5, '-64693');
  t('595', 26, 3, '8.4108325852102816916454812');
  t('60.2115396725866805858', 17, 2, '3.9194630770706516');
  t('-0.7078847495674886595066191985885874', 10, 5, '-0.8912253246');
  t('-5281727033113027333441806877059765049771299284236932239188', 37, 3, '-17415073731603190024.25750111029804408');
  t('-0.919677652526979329', 35, 4, '-0.97247522180821600969345301406017031');
  t('-578.44444446444444444444444', 31, 5, '-8.332088703101613942194942942097');
  t('-2', 1, 4, '-1');
  t('-35912.232981326391384944656947376265743', 5, 3, '-32.993');
  t('3', 35, 1, '1.4422495703074083823216383107801095');
  t('-77779.3086', 15, 4, '-42.6862522128472');
  t('0.96', 20, 5, '0.9864848297321880406');
  t('-0.902282756816', 22, 0, '-0.9663049833863257348939');
  t('0.00000000421892713', 33, 3, '0.00161584863143063240306254152369019');
  t('-0.0000000608581734', 26, 6, '-0.0039334439958970308121838055');
  t('-652823343.33303', 31, 2, '-867.4914940000540132948097524534');
  t('0.3829', 38, 0, '0.72615353424989733378322712453946820726');
  t('-0.477', 2, 2, '-0.78');
  t('-0.57881678935624', 3, 5, '-0.833');
  t('0.0007', 25, 1, '0.08879040017426007084292689');
  t('-69827833', 35, 1, '-411.79037196117556474135197450407264');
  t('-0.7468115066925299289222871310934272372128897', 33, 1, '-0.907270939339107104117039358656917');
  t('-9', 32, 6, '-2.0800838230519041145300568243579');
  t('-978984215987534204444444444444.11111111111111827548789862991403896399522138613997741916404317335', 8, 1, '-9929450800');
  t('0.25241229338437439177416092', 21, 6, '0.631980242085462024007');
  t('0.738', 26, 0, '0.90368856580957908025489727');
  t('-0.5', 31, 4, '-0.7937005259840997373758528196362');
  t('-8222222222222.000002', 23, 3, '-20183.496488370167226227');
  t('-0.3', 37, 4, '-0.6694329500821695218826593246399307933');
  t('-8000000009822816382948888', 18, 3, '-200000000.081856804');
  t('-50000200000000.0000500406', 30, 2, '-36840.3641067583541941421169928');
  t('-922627958844572906787533678888888888888.1111111111111111888888', 24, 4, '-9735140050656.69041390969');
  t('-3421.78251', 3, 0, '-15.1');
  t('0.79814422', 39, 2, '0.927599396985329992917473895643267747501');
  t('6227777487920800600782989190699420219319010', 12, 5, '183982999846000');
  t('-4', 31, 3, '-1.587401051968199474751705639273');
  t('0.6204', 12, 1, '0.852885235658');
  t('8920004800.000000000400230000008', 32, 1, '2073.9026316402901109714600381981');
  t('76454444.44441944464342', 35, 4, '424.42495598275381783951469231618944');
  t('-8', 37, 4, '-2');
  t('1700000000000004000000000000000000000000000000000000000000000000000000000000000000000.09', 8, 2, '11934832000000000000000000000');
  t('0.000030959007223101513810340323846095584550894023468313224625906569282035173072', 8, 2, '0.031399954');
  t('62.29999099992999997999909999999999999999', 32, 3, '3.9642648462330796701982108855154');
  t('0.0000003807294171', 5, 0, '0.0072478');
  t('-780.6666', 26, 1, '-9.2077856274677166841928101');
  t('-6', 20, 0, '-1.8171205928321396589');
  t('815882901438647219486921.894', 33, 4, '93442104.3943467597917142753820441');
  t('0.0000015665213669512347839036', 7, 6, '0.01161392');
  t('-28885605412983735817101486', 10, 5, '-306827177.3');
  t('-9120656529310649022508772557600822755989', 22, 3, '-20893379868975.93410893');
  t('-68830003436832119168697206111111111.333333333333333331', 14, 5, '-409819479198.43');
  t('0.063413340249', 22, 0, '0.3987740385705949818971');
  t('-9663639312.1889995622529073081830811281157871525928558911559008454893814786766', 29, 3, '-2130.0031087399799336969947731');
  t('8456009', 5, 6, '203.73');
  t('-133333313333333336333333333333333333333333333338333.333339333338333333333333333333333333333333339', 35, 2, '-51087292938538638.45963672563255537');
  t('0.000000828', 8, 0, '0.0093902419');
  t('-0.533779136427110683342022472', 21, 0, '-0.811186158520637675529');
  t('553454888888888888888', 3, 4, '8210000');
  t('-253999919999999999.9099', 10, 6, '-633302.4866');
  t('0.966', 17, 4, '0.9885357396476798');
  t('-472.2', 20, 0, '-7.7870923929575451614');
  t('890606400', 33, 6, '962.118585030255343542794621864724');
  t('2', 23, 4, '1.2599210498948731647672');
  t('0.82245387646977936582376895918587801438031818414386874050664779675441964', 3, 6, '0.937');
  t('-96199999999999999199999999989999999999999999989099999999.99999999999999999999999999949999999999799999', 26, 2, '-4582034526382497317.9233569');
  t('-0.00004', 19, 3, '-0.03419951893353393979');
  t('-200000000000000000000.0000000000007', 20, 6, '-5848035.476425732131');
  t('60279.423406252475', 22, 0, '39.20935485081682681592');
  t('-97777777777777712029297332', 38, 1, '-460694882.00074551487967316547165888621');
  t('0.77649', 20, 2, '0.91913355728380293545');
  t('-89999999999999900000000.999942455962', 19, 1, '-44814047.46557163048');
  t('657784786706774969939699941134092485280219814777777777.00000000000000053505631693522700943183624999999', 16, 1, '869683588953107700');
  t('11225003', 18, 4, '223.90415622255316');
  t('0.2179879021284641771886423751003609459775768167269363647', 13, 3, '0.6018350321591');
  t('61437815991318058497644444444444', 26, 1, '39458925629.182959223571627');
  t('13318364884783059091217.13239214366191085313377401', 18, 6, '23703745.1782159442');
  t('-8.4064144', 32, 1, '-2.033310008391993884248411527567');
  t('-453', 39, 5, '-7.68008571952935784930001064291224888536');
  t('0.763', 25, 6, '0.9137797144320912638366951');
  t('1611484839641139334887115912095502769965101742318128374453911269', 30, 3, '1172398915553242562427.04711067');
  t('500163293486811.333445', 9, 6, '79378.6921');
  t('24511111111111111111111111111111111111111.111111121111111111', 3, 4, '29000000000000');
  t('-0.42175386188897175455873804974780281862102270904', 32, 4, '-0.74992820758074132846372269243787');
  t('2.9', 40, 6, '1.426043147142408726435983115273598211993');
  t('-4555555555505.5555555', 21, 1, '-16577.2994441679860622');
  t('-0.000000066924422225974', 2, 1, '-0.004');
  t('1.173937', 13, 0, '1.054908836639');
  t('197', 15, 5, '5.81864786749696');
  t('-37788189521071423', 5, 6, '-335570');
  t('-10000000000000900001.4', 37, 3, '-2154434.690031948354900534806626827261');
  t('8333355568526352727297334146112460880', 33, 3, '2027402468375.33435686950289609612');
  t('23290906112798700', 40, 1, '285580.6612856533004404239892443930875337');
  t('8907204187376523669', 29, 2, '2072910.1085135091276335169742');
  t('4579848061800339', 3, 2, '167000');
  t('-24842.93340891298153832688061127141128026704014', 35, 1, '-29.178813292376147719745493637646888');
  t('9.99184683875871', 16, 4, '2.153849015719408');
  t('-9222222222222223615', 6, 5, '-2097060');
  t('-0.0004692526698680109221628', 34, 1, '-0.07770857005638567506282900761888083');
  t('-76', 5, 6, '-4.2358');
  t('-34231836867333305216541022551584237057639985600267422790312876836', 27, 3, '-3246958475723496211199.67475');
  t('696.116148', 16, 2, '8.862588182748634');
  t('3437203096792518549', 11, 6, '1509159.2321');
  t('-8196696.3212529', 11, 6, '-201.62588272');
  t('1299998999999.999199', 14, 0, '10913.926032168');
  t('9338804', 29, 6, '210.58644843232382837669233209');
  t('-60000000000.00007', 30, 6, '-3914.86764116886511787346318164');
  t('911111114444444444444.22222222221175209740160761862374840394', 27, 5, '9694463.53714067931083453616');
  t('551414371.0368018318871978921581971673011423266337626938349196375', 29, 6, '820.02298717871313585995909702');
  t('1366', 33, 5, '11.0955857241236546553135433026986');
  t('-677777.7777777701', 23, 4, '-87.840697409140936494786');
  t('2999999999999999989979.99999999999999999998', 30, 6, '14422495.7030740838071593378917');
  t('2700.294', 33, 2, '13.9252718999454359654695575635934');
  t('0.17656681235139904232276', 31, 4, '0.561008823921671674419747744567');
  t('-62589.499999999999999999399929', 12, 0, '-39.7039602502');
  t('1690217844595.531311', 5, 4, '11912');
  t('-43149245342383', 2, 1, '-35000');
  t('-7427368.2432', 6, 6, '-195.109');
  t('0.31559022679197054969487048105816446502323333675805181540650757', 37, 4, '0.6808339154882989194380024736345783727');
  t('-73.1', 24, 3, '-4.18124669970238870480732');
  t('-4279999999.9999999999999969999999429', 20, 2, '-1623.6082758598468032');
  t('-0.0000000328578853', 25, 2, '-0.003202923282468980388900329');
  t('-0.57003551', 38, 5, '-0.82915165170097697620872686667157235259');
  t('-63170799234756597835676', 25, 1, '-39826498.35818326438200275');
  t('-0.5222452668661621992421', 17, 0, '-0.8053008748219385');
  t('-14999999999999999999999149999999999999999999910959999199999999999999.9999999999', 4, 5, '-24660000000000000000000');
  t('0.823624323', 18, 6, '0.937367131818894711');
  t('-4201173425650602057484204974278561701040576817779576', 14, 1, '-161357888906180000');
  t('-5154947.470431910704543384861404', 26, 6, '-172.74603240504542544372558');
  t('0.3', 11, 4, '0.66943295008');
  t('-5.43799', 15, 0, '-1.7585152336593');
  t('623.25', 12, 6, '8.54189238613');
  t('591949.9', 35, 6, '83.964360353306688632540221375977156');
  t('735209879.000000000000000000009999999999', 21, 6, '902.548283674048747014');
  t('5222222222222222222222222222222224.0222222222222222222222222282222', 34, 3, '173494262113.1400447770433961948133');
  t('988881298503509106112', 31, 3, '9962799.445154117832093512091153');
  t('-995.53', 26, 3, '-9.9850777437026814287892541');
  t('608505555455555555.555555155525555555', 22, 6, '847399.4592254247578725');
  t('662.969', 15, 1, '8.71962364758999');
  t('-792734644838302063684220', 22, 5, '-92549898.36986346512032');
  t('181.50343949228397002512533756681890566276379', 3, 6, '5.66');
  t('-0.1913223936686635002105502296708709704', 12, 1, '-0.576220363283');
  t('519949999790797999999999.9999999', 16, 5, '80411937.69007677');
  t('190083553254611', 68, 5, '57497.396555557598945480190459661968176685612641464842714635054836109');
  t('427777677774777.77777777777737777277777273', 76, 3, '75348.16951798434534353643448783853246144346430067525820886033715512932023151');
  t('546171561825002947294080072307212773280', 16, 3, '8174157996118.782');
  t('522985096568498402721582352.1215694977095639301679629', 31, 3, '805680967.235151049332930059641');
  t('64.9099992', 58, 1, '4.018869165352236942066012896861710689344927659713155032172');
  t('0.622222222222222922222222', 80, 2, '0.85371944332499649030906483432917416186241639965314884631474488059421492067199314');
  t('8794999.99999959999999996999999929999993999399999399966999999', 4, 5, '206.4');
  t('5', 25, 5, '1.709975946676696989353109');
  t('-0.552605', 9, 0, '-0.820612769');
  t('3848.66666638677316979763946277553241716773444444444', 49, 2, '15.67124256418039359054784961648853429741398544294');
  t('-0.35', 53, 6, '-0.70472987320648919207554481663284854286711480387909973');
  t('89273713993947331.4743931838348340267', 24, 3, '446931.742725088818839951');
  t('0.51', 68, 4, '0.79895697404540129868930301132607109484003577983641973039863493529708');
  t('-9', 6, 6, '-2.08008');
  t('628629.7', 54, 5, '85.6639899506997541353732791802583971585340677864297375');
  t('0.793206288149423029961029867426843938373894729291545543677796351148224', 61, 2, '0.9256824914542190809682539550820521270670422844262301051707097');
  t('0.0698662830726', 67, 2, '0.4118659409892579213714309499559354149575987977349873047664318860863');
  t('-9030.0000000000700000003000060000000405', 62, 3, '-20.823924640400472684412707477423805625015209868245827862949254');
  t('-7.958105863885', 21, 6, '-1.99650271003649585776');
  t('81111111111111111288833156333333333.05673220566188', 32, 5, '432872620146.7613955527490256419');
  t('0.0000000710633771602494959172972083163271336209255171598326202220311305227519', 75, 1, '0.00414204946408468183711149537360290487199347861478325008670596401061026171227');
  t('-0.2743913654', 8, 0, '-0.64981563');
  t('-84897051062435491923', 58, 6, '-4395053.861136635860244215030060880434157604594404162723997');
  t('12227222222222292222252222222.22222222222222', 53, 4, '2303788477.3270815027773508878518255502487884933382556');
  t('-5744587095066134000', 26, 2, '-1790961.5938680570422494081');
  t('-28158704869', 1, 6, '-3000');
  t('-9', 58, 2, '-2.080083823051904114530056824357885386337805340373262109697');
  t('-288888888888888876936205421.8888880607688', 12, 0, '-661064160.894');
  t('-57116251296177777', 15, 6, '-385111.568938615');
  t('40084858.57050075', 41, 5, '342.2368620398633435954991713953035735131');
  t('-39.9999999999', 42, 0, '-3.41995189335054401879508754180553909512638');
  t('-0.0000000781', 69, 5, '-0.00427448382445799736966808734512338969330660711441009839867977642505046');
  t('-32788', 39, 2, '-32.0065090925679555063786003491251965255');
  t('905356417977978248323', 18, 0, '9674009.91580975224');
  t('4662076255.225187', 80, 4, '1670.5512009402885396428886958629310373585791511636552403799410691079829339579262');
  t('-499999999999999999199919.999099997989999999999965', 46, 2, '-79370052.59840997369525035412736937389009915928');
  t('-3078786.83696704573083305', 18, 3, '-145.476621649278813');
  t('-7666666666666666666666666666666666666.66666', 70, 6, '-1971827233233.572229603337758893347392027986101760363801943674844374856');
  t('-0.00005424495799878575807532622250516060480220764475560855744121424125628903936005650488919995462', 36, 4, '-0.037854698578278600379593368884078452');
  t('6999999999999999999999999999999999999999.9999865', 42, 3, '19129311827723.8910119911683954876028286243');
  t('0.1871246006301609393460142', 4, 5, '0.572');
  t('-2330974078269618476', 67, 3, '-1325905.222793466277001224712671858413192217680079713012807710978752');
  t('166666879641108', 36, 2, '55032.1442557708320139014841862925342');
  t('0.000009594823001647349765109598012352854782286', 80, 2, '0.021249350292770477994556821613879363484044602090572948149077662334118723742709098');
  t('-71', 56, 4, '-4.1408177494228532500045188093255718381593507907320916972');
  t('-20560088583263631805680340015297262', 5, 4, '-273950000000');
  t('-63555555555555556.55555552555555555555555555555557555555555555855555', 39, 5, '-399071.922419458655215352788196447840256');
  t('-80567525886.0758703', 45, 3, '-4319.03452586372310664568734824001540654078942');
  t('-3.10006000000002088', 32, 0, '-1.458109142861094467205073617593');
  t('-730500406876657225817429042993.139094878043', 32, 5, '-9006170282.6636206044471890925123');
  t('-95958188714879921780', 8, 0, '-4578192.2');
  t('-90657056', 7, 4, '-449.2284');
  t('-29999999978371726978812003851', 25, 5, '-3107232505.207146944708437');
  t('0.41', 56, 2, '0.74289588414465652154744763881657973470421505511967252574');
  t('-0.00035167447185522407348', 34, 3, '-0.07058519431649929665093174422506027');
  t('2', 78, 0, '1.25992104989487316476721060727822835057025146470150798008197511215529967651396');
  t('-0.638209885510603951064915811914377393843970396158', 41, 2, '-0.86096964973397973858997223739696214052976');
  t('-0.2', 79, 1, '-0.5848035476425732131013574720275845557060997270202060082845147020145121117186434');
  t('8.3', 59, 1, '2.0246938520054570738873895392278613882354294240035565410806');
  t('-94', 33, 5, '-4.54683594377634389380192154132128');
  t('-9893111555555555', 27, 1, '-214673.103768153134119737804');
  t('-220511265573', 42, 1, '-6041.48350302234073289676574962951933783517');
  t('0.0027962459343658070652934145120013227247925261722687085290561886066', 74, 1, '0.14088295594051797098822392958928339704939850971044967086499430607988967815');
  t('8378', 58, 2, '20.31016501759315420904307771085017217522109296970386829876');
  t('4373952724599.331549321897031863', 2, 4, '16000');
  t('6196722971.15026461303816', 32, 5, '1836.7668263739955787226813173287');
  t('9181111111111111111171191111111.1111111111111111111', 35, 2, '20939440881.76686255478254865282532');
  t('-110041253121816343325184123868060195618846912461901764444444', 70, 5, '-47920187550103152119.58925761782897985190653987385527863135093825526904');
  t('-0.3', 9, 3, '-0.669432951');
  t('6577777777777.0275', 16, 2, '18736.6983847358');
  t('8578744.50294903841928369889455281001', 66, 2, '204.711030517640249446574306228627533211589985153897156259864604954');
  t('0.78771', 53, 3, '0.92353945302856403979711704138480732047227563846331275');
  t('0.6771249627191616957275035900802683145534522585', 61, 0, '0.8781248651546850239434971281445626213610129377439629305099637');
  t('-7077710.91937851', 62, 0, '-191.99839878021651605399436486269092820663925076672584191864672');
  t('-300000000000000000.0000000000000000000000000000004', 36, 3, '-669432.950082169521882659324639930794');
  t('2200000710.2000000000000070000800008', 42, 5, '1300.5915868028939927953703562096115839217');
  t('-0.44402817317295797128980077', 49, 6, '-0.7629044981192485835380835650924556945035711976182');
  t('-0.00000970561327720508890187', 9, 0, '-0.0213308255');
  t('7642.857784342453979181129525786781038237665995918300221757673', 18, 3, '19.6978394259656285');
  t('-7000000000000000000000000000000.008000000000000000000000000000000000060000000000000007', 48, 0, '-19129311827.7238910119911683954876101159812772555');
  t('542770000000000000000000010.00090000000000001', 15, 1, '815715306.618792');
  t('-43426000', 11, 5, '-351.49294245');
  t('-9082', 24, 1, '-20.8638202534165193900452');
  t('-10751727', 41, 2, '-220.71206607310159403001763511889702820882');
  t('94559999999999999999599999999999999999999999999999999199969999992999999.999959999999999999999999999', 47, 1, '455584725036401328416463.25477234792211543595132');
  t('1384470686149009269.611', 62, 1, '1114537.2505539140308371278549396938503929197531025427964858566');
  t('311.2260870142', 2, 6, '6.8');
  t('53007675.811556', 4, 5, '375.6');
  t('-37860603401819.66294540538706081407', 16, 4, '-33578.59422960415');
  t('238734191175987482376448664974883671063134.70247158385074277612470949077', 56, 5, '62035202968440.050211601264407039974381303322673615544567');
  t('-0.5560986938994064959245371245686540537385954926803398753', 71, 4, '-0.82233850305551594240148500047628002080453296664759183573348648028399817');
  t('0.93', 73, 0, '0.9761000076685076115311962561496857123875368468154982203611379430735287729');
  t('0.635739982568', 5, 4, '0.85986');
  t('-96666666634053992659153661758395739180812441764338777', 34, 5, '-458943173466921642.1171000857394366');
  t('0.72', 78, 5, '0.896280949311432941749496402807715894233349999468515536883522501252545132973286');
  t('-86', 36, 4, '-4.41400496244210377245164143865335132');
  t('0.578840623382497', 58, 0, '0.8333990495966651700539877210106533569205827803791114529105');
  t('-0.11256085014081744874', 58, 6, '-0.4828317138964906758001480539221236633628550564791782106879');
  t('-262891246115892815600757743406447606585992233659045972242604894392977494562777777', 77, 2, '-640607533549306651453856248.58448667909440682564928680375476759591748422139438');
  t('-0.000002495354006619', 44, 4, '-0.013563675425280118756666446842202219898735203');
  t('20000000000000000808176375252666666666666666666.8780034342087325555', 52, 3, '2714417616594906.608080225974707060171652206149639126');
  t('451331333334.3353333328', 34, 1, '7670.644019013497054692225494054739');
  t('23333333333219416371398433333', 1, 2, '3000000000');
  t('92222222222222228222222222222222222222222.22222222222222222222222222222222222222222222', 46, 6, '45179892612041.49000809994509369661943620355513');
  t('-358905019432949391115762037777777777777777', 55, 1, '-71065668228949.06718591446657109529563408522253008055962');
  t('4740653103794266403091226744357138', 5, 1, '167980000000');
  t('93513215.6615', 72, 6, '453.89736736596846522976766254373109582032771449264826647810688058162461');
  t('-83525449894758523723063520766638259728', 42, 2, '-4371256333057.70019981327121654690655675087');
  t('96.8907029', 1, 6, '5');
  t('-76164138181607236328312553520780998593788', 38, 4, '-42388707792525.65333639476095263672376');
  t('-811111111144186', 60, 5, '-93259.5789221853464970653887991503226136601474228057694991467');
  t('98063006.11366530159', 25, 1, '461.1424126896267568258957');
  t('0.691', 5, 6, '0.88408');
  t('-37.77777777777777760371348888888888888', 36, 6, '-3.35540903186704310733799481273049299');
  t('79999999999999999999.9999999999992999997999999999999934', 73, 3, '4308869.380063767443518587133038688422979407307245786977735826208747140919');
  t('-999992999999999.999799999999', 26, 0, '-99999.766666122220098261694');
  t('-33333333333333337771156419069557322464210130528', 19, 3, '-3218297948685432.67');
  t('54276.35015542019326172851580003368352971897539088915695454662323526031352314', 46, 4, '37.86199948088373653952550856026791817364516245');
  t('8489888132804567133774601751196.59987803505788118', 46, 0, '20400179522.96566820584897289095711477040148564');
  t('18146800.9748965960145324063', 40, 2, '262.7846694382357102673981792034389051619');
  t('-500079043952493124458778348581660368530250605627548115333312268234887', 3, 4, '-79400000000000000000000');
  t('-0.08932570353455987981', 15, 3, '-0.447018484446593');
  t('-4.438', 48, 5, '-1.64334633015251774898249908635733926732572691097');
  t('-30000000000000', 74, 2, '-31072.325059538588668776624275223863628549068290674220014710384042591307226');
  t('-7888888888888888888.888888888888888888888888888888888888888888888888888888838888', 49, 3, '-1990697.539942133311276975376128903406090081062864');
  t('-2666666597845523014132441', 53, 5, '-138672253.67717903407643485161238193329852619997701256');
  t('-1076.1809886', 10, 6, '-10.24774803');
  t('9216788091552305362.909312', 38, 1, '2096652.8759366679702358604959653287734');
  t('4741.8140673856435018624822718788906388079391623', 67, 5, '16.80021502392216445835596170850399645067790675363174957444280118878');
  t('-79999999999311940367043634246890228907788979677205499598044', 19, 0, '-43088693800514142810');
  t('290844787777777777777744444444444.77777', 18, 2, '66255270042.1163829');
  t('-0.37875271361357', 18, 6, '-0.723522294080478167');
  t('-9991406.58', 6, 2, '-215.381');
  t('-6738129028121126791606838741675150', 33, 3, '-188877303678.79474419948880026566');
  t('-0.502160316994057971939225', 54, 1, '-0.794841980113590041816031553223689914512597942576296128');
  t('-733609592072036673808173056752609127045.8559623254790296334481324712071053568161', 23, 6, '-9018929672065.1805741195');
  t('7999999999993467227679756696779', 39, 4, '19999999999.9945560230664624321382573557');
  t('60', 29, 0, '3.9148676411688635954249360605');
  t('-58704', 68, 0, '-38.864751764188763692646037493072246758297604206169656083742519721013');
  t('-29', 52, 3, '-3.072316825685847293312637982105597485502783238876096');
  t('-983167977058863254673822048588175665', 46, 4, '-994357548305.2292662769379386504802402173937149');
  t('80000.00000000000000000000000000000000000800000000005', 48, 1, '43.0886938006376744351858713303870099051883351336');
  t('-632446837983.5248250060342675255523783173070245062004', 72, 5, '-8583.70285700719310952320051477762621057584292163627657361395695214226832');
  t('94.589892564831076', 45, 3, '4.55632726873442916526079248390445485637288476');
  t('-29150168312768537777777777777', 38, 0, '-3077610740.2630452678906404628753071677');
  t('-65876.7592186515413241046395745', 31, 1, '-40.38723071645668806606497723789');
  t('-5666063373', 47, 1, '-1782.7638094449886240717553196512228686769485213');
  t('-0.139725999999992', 46, 1, '-0.5189104405267407116753364325784027919669908571');
  t('68.267239742', 24, 4, '4.08699507567719377180069');
  t('0.8', 76, 1, '0.9283177667225557784820152701838893153102698250022487275301385717369555739385');
  t('-1888888888888888885637141809007941865764736068491150620125461933301770', 41, 6, '-123614325642206315683692.55454636042913382');
  t('0.0000002246998216971028117596695865291833893978504414795642811734126305748247193907875', 80, 6, '0.0060794959843145001131062106532389655005752557500009879296180198722004596636853181');
  t('77956248430982.9779', 38, 5, '42718.596625359543566496985925511890764');
  t('-28025.81006501597216999', 56, 0, '-30.375217157987425639914003812000075009262382915415726707');
  t('-5111111114222248087909852777777777', 12, 1, '-172254975113');
  t('444444444444437386196755', 70, 4, '76314282.83688838720336993531707319785684914925123263945112896200880283');
  t('303700006.00000008', 3, 0, '673');
  t('5111111117792088111396638516069154709400490780.5555555603936711111111111111', 39, 0, '1722549751538416.71018646122626799371576');
  t('-880960929.78835331001506', 67, 1, '-958.632648927890314563139859812747286403802932806246702992898616543');
  t('61999.09179', 36, 3, '39.5787228379712136369601265185064235');
  t('0.870731830383098', 16, 5, '0.9549078720674807');
  t('5738012899796164830204444444444444', 48, 3, '179027813159.873904958103685150435410088455529157');
  t('-3831640539439787930786871750123448', 54, 2, '-156480990514.52173031532925524692040509815236073117521');
  t('0.000000008', 77, 1, '0.002');
  t('3149999990999.9999699999902999999369999899999999', 3, 1, '14600');
  t('82776728273051551409555555555555', 112, 4, '43581558053.74474521864863300705184902455145527483948731386434099961702979317990310205860786206482687718586705261');
  t('636376033.7', 100, 2, '860.144213106029054921197862188864450908194296444549177622081102948831111142733451932872729734806943');
  t('0.77795481', 71, 1, '0.91971116090215414648453499783441147293820871989783932873327322223739659');
  t('9.70316218201244384213952', 81, 2, '2.13290295928319569177379523820743230584845501008854234203250352744189412761501392');
  t('0.00181186257565040142431491571234663212884320254245585841641', 137, 1, '0.12191067939515882894069376601221357826801334075784297236769250526078036589701068176206067766104960548339838823250498818117013950672762615');
  t('353', 29, 1, '7.0673766147219547428863994574');
  t('466666666666667378082195511311111111222.555555555555555111', 60, 2, '7756555904835.21041894399125448188971136254722965099357605993');
  t('-661.8', 43, 4, '-8.714495586248373950058566442188587266015331');
  t('-1445782507', 43, 0, '-1130.752756847083713326681250471878173647552');
  t('-96431622749744444444444555555555555555.4444444444444', 75, 2, '-4585708999008.27550013125419286369006721924062122910608942441210123025057816');
  t('499999999999999999999999999999999999992.9999999999999999999999999999997', 47, 1, '7937005259840.9973737585281963615413019204272816');
  t('-0.0000000686316994432396044', 117, 0, '-0.00409425527881064612229042772151200037039500662592659730778909262376378001655456283942223775620187033364272337902504097');
  t('-599999999999999999999999990.9999999999996999969999999999999999999999999999999999999999999', 159, 1, '-843432665.301749242845709747188909616731229783764284784453365375749672919741789350058645758446637130488935694032755752063036880565022224985536959946161612180905');
  t('84025768600136117500000000000000', 14, 4, '43799669277.427');
  t('0.123223725749812396270285316641884411484091734351855', 137, 6, '0.49762032660982554025397607388346058751014461459148740386278232128841926105732866161903457277201239853858123118377125104914763239955263879');
  t('5683919999799.999295999999999799999999999999999999', 50, 5, '17846.346418335262245115777162462069143502052478305');
  t('0.00465566481', 28, 1, '0.1669785050083134684129221262');
  t('9404483.59592818623081360038632773352855722645934935876579616346426561463933612720026815689011150820586211117100157209214772525', 103, 3, '211.0789788115077193292720852315830318355441614656098768099955373384925988386839320981935725778643446229');
  t('-578366862674170179059334283952228171204.36089287550596157704924551419962862', 63, 0, '-8331716182590.68932931535600060162570391991023694283431933947186');
  t('95.8881477772834512616724651188088455801629460797496194699699085', 12, 6, '4.57707796199');
  t('-24444.485785827656282219', 9, 3, '-29.0219754');
  t('766666666666.6666646666666666666666666666666666666666', 141, 0, '9152.41126759052944167203975215594026371347635147759017682577739176762107986928730371229904875068521357914298298505531974350201698511730534769');
  t('-488888888888826755189947563588888', 99, 1, '-78777716697.8300827444483985263972258563173451818387104634814849656410990826684587731700647815402294');
  t('-0.93119', 64, 0, '-0.9765161596143984257691603580673962160184815852749412409877993735');
  t('43921954171092205284640844157041884886136450649590454797123487646372681162500398396370240486126497853068138338093447645', 93, 4, '3528259759332751349984485524958910184146.84947758519096836105450685070120550013816503300203742');
  t('37739049762', 45, 1, '3354.26203688270476088390500251319549444548488');
  t('1666669261277.5555555557777777777777777777', 19, 0, '11856.31716746641565');
  t('-0.87508130314522331714075160118465596943207930831795166748487868911086218158013807044478343658', 135, 4, '-0.956495214720463906171773082803269976950458764649816467310897091404170907626465238895898163664576312299168902947076663431770912067038187');
  t('-0.00000005690410744922351517051628284', 101, 6, '-0.0038463417761089907278564874060595717888448147954882058216091786932982543755356062337102395794883869754');
  t('110821061220650227209631389.442189848022639078051101733333', 94, 2, '480331167.9056548334940134194952187610074168036994182375036133309976063974642093619384961197749');
  t('0.0000000720374687', 113, 5, '0.0041608891694467038994141767474219272547761688870750977477255235231670146462788248091310958594566864043463352046753');
  t('87074221178179668787911995735893535906691636996053118628219655670342739566', 32, 3, '4432307330872449002060944.4615279');
  t('0.005032313059756019443519186468931714599163438688829781446064655482531427885380299', 98, 4, '0.17136516767359008761032739486761079482107735684713612426709119939416240689556516522340562899699717');
  t('10148.5977', 160, 6, '21.65053731596572331412615208556528830271489610293122817763890262386718966501471244637895650110030829334214464535861088506285723435433974666728067779501793198954');
  t('-0.212895562117067555439641740586945267287', 143, 4, '-0.59711163840251428250532993677747034851713802847294194690972578890042276451962217937400524463773699201129154715832555819921696826114717724875142');
  t('-30000000', 25, 4, '-310.7232505953858866877662');
  t('-672.395591445152975029565505390802021591817222371328410506211100219883368902633513917908002520410928963251816322', 111, 6, '-8.76075669292588138901715870963309202194698610503137591171065258550496118269857816967030108216039948778282481392');
  t('-69343830770429238892077439877984867437350405464970.08434805422042264077734449605338645891340041899823', 117, 2, '-41083674204990584.0131798527406406987135724833192745343006865591258087525884504806388645170600356102712673427281129295');
  t('0.2119654136212323126', 70, 0, '0.5962407680193418420857572873464692462702426385958382203537195447939645');
  t('19279652049387273020376009630218485586509755555555555555555.677684976', 125, 5, '26814295878325615815.487734142403395997322444695201037467003923385142367719736702490378125777406755297158264517924654536720688');
  t('-313498433369129.627593263158', 28, 3, '-67932.63465286048219530417783');
  t('-7.0086392063231841408472554923046199064463513056604142417817', 24, 6, '-1.91371782149136697991918');
  t('-589444444444444.4444444444446444444444444444444448444444444444444446444444444444444444444', 36, 1, '-83845.7318050585157528961599774820693');
  t('3788888888188888888.688888888888888888888888888848888888888888888888858888886888', 152, 6, '1558968.3196446675125585834575591738365487123411459073333941724143408075236949115581591001107762448583201246036760071357924907279302939443979626955918103');
  t('972', 57, 1, '9.90578174668388005162382985722725487054065393295548001091');
  t('-0.6225403379', 122, 6, '-0.85386490864810417446139242223704579775383669337492527468605085174671380271097345355635824581210228231438058485101414715493');
  t('-6.07065', 127, 5, '-1.824224978981950876078744611006975228341354706000078517439609660874414665770050047148302780021260654833992532777230361896997321');
  t('0.45051', 134, 2, '0.76659881777216534073261278063331624315569102370618916882741183945437994516350424573783851510247947005698846905242281453098451862075106');
  t('-499993979999999999999999.099999999999999999999999999999999999999', 51, 6, '-79369734.0586538024769891823793678472679371045448798');
  t('8339981218.707096826', 93, 4, '2027.93963898424630978731544433744810832205112815361986395554185910152571703973224610355148676');
  t('5', 74, 3, '1.7099759466766969893531088725438601098680551105430549243828617074442959205');
  t('-602836625868614277182558405998788207727682153312872078934707624064548122569796141394032876539530061726270514889140359387497332920947541211111111111111', 90, 4, '-84475974443254434761529924288837486174134195509020.6834107157860402152618681061519243519503');
  t('-3', 148, 1, '-1.442249570307408382321638310780109588391869253499350577546416194541687596829997339854755479705645256686835080854489549966425423946110259714868950157');
  t('-8305.5', 9, 2, '-20.2514097');
  t('3148072213395670.331', 3, 3, '146000');
  t('0.9256', 11, 6, '0.9745582044');
  t('583351089841025805313237803988895357243393040827171233166707013763413497333333333333333.111111111111178527451071608322745354624', 42, 2, '83555813370934767758145249193.7624714494513');
  t('1493', 11, 3, '11.429307988');
  t('-953950767673708257696753762461.09313638337401406086', 38, 5, '-9844084220.1056115483531558258864528224');
  t('-748279.7337073', 90, 0, '-90.7865113232394794259241456796182711522658456748343049158144761169947830035296263069119735');
  t('-2070899157.5228065975707908451395054941152120630664228513844285133094', 133, 3, '-1274.636401772002050657717314752437832383086022141853088094808306006793663483432239568855013588491311600599491763843352264279754946474');
  t('3.999999999999999999', 140, 2, '1.5874010519681994746194222182749583041511609062107148250883545261141091377641970723246199695031055934895113644621373651932307080132586729931');
  t('0.8276675580437422111', 34, 1, '0.9388984977568743253137928985771869');
  t('1877377777777777777777777777777777777777727777.77777777777777777777777977977777777777777777777777787', 127, 6, '1233627070690531.37219027174468903625208125660717461315316166590607838881303282413461822347802418625771570830720338588218181227');
  t('0.0000097915999105481789781896622159135386491874375271271205781225697', 61, 2, '0.02139363358422859511017173681136409752779142146004170833441572');
  t('-7.6', 13, 6, '-1.966095144983');
  t('-0.890863', 133, 2, '-0.9622109774805131071538890701864423396851866919504248974352878847507240555834153900360670999962314211252461611619498463436437127750576');
  t('-4888888880888898888.882888888888888888888888888888888888888888', 51, 2, '-1697214.45562741076524944471221069371510598655741579');
  t('-1875476291404.646832136844', 16, 6, '-12332.10440379986');
  t('-727254485018515249405829892559034000441.5581572', 129, 3, '-8992811070003.09785363150909404003381523718558248740038115359244231710186719889142766281249273505415646887606060710072429242546657');
  t('0.605961668463485', 54, 0, '0.846216944990274330726413901099441758736571064274418565');
  t('-56568700064439584479241166160181', 150, 2, '-38387697715.7523854198906842672791885366604912890047624437778218480501243903148804685567032848097401544437904474683449321729596542949416392223722674414');
  t('0.00009873058', 102, 0, '0.0462186471705215784508051074218102551821879718288256865393864407751619570492992541877802564099994363022');
  t('346858', 100, 0, '70.26147109023508041813841399831643960505935370872605241752715147861145621736918749015854852318927233');
  t('-0.969532517', 95, 0, '-0.98973924942518373070239981119004658863771135938211168400916237791955115564706399333261333688699');
  t('0.00708', 1, 6, '0.2');
  t('4655555555555555555555555555555.555155555555555555555555555', 145, 5, '16697719883.7068392237889499351444334443323963952311009317046872786920092491101459663968872704108477857499148360535526565595952008728060647519304');
  t('-2569124342973866.1163427720737029985868', 120, 4, '-136960.408098207089120457279788004667734323377016517634638119067746936282386744369370481150087791381573332097833264577443');
  t('35385740083.708858823939108', 100, 4, '3283.039397256840024527696498336356691241104231764070062160814311062350270733229631690409424293597365');
  t('0.29563729108015982489584206268848882240942368908629636696923489547', 71, 2, '0.66617204587072327740359378500886973598187033972026650520781075471467275');
  t('78303972239555678655850978934090989634259862411014628928.928566477705172255104670025105898452541121323862241995786380218', 83, 3, '4278201784839867409.2945847630151871986768589724844825559895492765087020495269553908');
  t('-35573433331441059313774361992356437929771', 95, 5, '-32888338032624.953107720835002113034883579141018670001606017591382435837700228940681206988835012');
  t('-9557294721488.3130980466242', 52, 5, '-21221.60986344088683966955692377890835442160813234567');
  t('-0.135112457700583566301292031766437426095672609984', 68, 5, '-0.51313518888533656788421986827147430603966207650106131414520723350447');
  t('-18925190.47626139942238356861967412363581848754964275829', 61, 5, '-266.4894904435214020877657157316686758749265462724433725488259');
  t('-90000000000003000000.000008059', 115, 5, '-4481404.746557214502133555004632605162762529786522668609154250725596784663397931181410599280299127604209224495097905');
  t('-0.41772586688222799756155997729786', 59, 2, '-0.74753314954295116225357074955677335387453210331659886493173');
  t('7.111557355', 136, 5, '1.923039650926229178604735256247754593379090482289527650829586749117718487773610873683873890482254374113906724364496861942397685418198872');
  t('127879775275555.481446113777777777', 49, 0, '50381.0585468395322175886584230657123015852629168');
  t('0.00000005784489216474877724561989979639', 129, 6, '0.00386742296644988497532741316068620202720835646396440160608528957386426624329112019275056570817559387824093157713075305529180174774');
  t('612420.05731611517853292423064111852736676359122511982393231524016080747310185476867732428924735662102179739733568869657281', 18, 3, '84.9212676870125308');
  t('7033333337333359.3', 62, 1, '191596.27748680803958646080181129149514694743098777723192310813');
  t('-201248950077898659', 37, 4, '-586018.339843396975945078901639875129');
  t('-883889111577924745159561125469193106', 5, 4, '-959690000000');
  t('-51656434', 19, 4, '-372.4272704575396712');
  t('-524282.914523996765880269982436231057909853765', 54, 4, '-80.6346864787950851182740363238795500759345024865021861');
  t('-85.7797', 37, 5, '-4.41023272682039443830714883303023045');
  t('7.271', 96, 3, '1.93730521801843273586335468913837992305016274981837296068606783135482582964967913973079197833799');
  t('-0.47', 45, 4, '-0.777498009734258665646121764035170090076203667');
  t('-224314369366707999500686372855555555555555555', 82, 3, '-607601771851935.1288138352126676807870310353880211539794644861488852716066486894964');
  t('-2784203113597777777', 19, 3, '-1406804.141826141932');
  t('-4815241586514362388507935013541', 85, 0, '-16886488957.88434779671164541433418860252736136440375459197633729577703958342968133086');
  t('941966530258603933850664016242078691006131295851254408955857629867', 47, 1, '9802687484019245427877.8823394662709852113836205');
  t('-0.685779765341593', 76, 1, '-0.8818503444565537962568233929300638131296378203705111385320085446958772114399');
  t('-0.7359315876619043241314664012465168621', 141, 3, '-0.902843511794380293988586129168170796563195237048852176432881679799477009402067933694342367581501520858134961361043151939911685652962074605757');
  t('-950750288811013400.867290554394854', 34, 3, '-983306.3007397972807069742121372335');
  t('648277466.9999992642307615408142285478524238939498550791', 132, 6, '865.473235875160020758450438181577138246574729364348223712625225764851480627343398500868108316898076850127545179705155303585869218657');
  t('0.13899724863018252921424361150126827626483', 69, 4, '0.518006728879787728388054527056626123614261162961699812102427752936389');
  t('1714144444844444444444444344444444449444444.4444044444444444474444444444444444144444444494', 10, 4, '119678408500000');
  t('403.446089524165034894', 154, 5, '7.38916169337692213525325525062984465850359370156151606567109623272882280360127269626674699532475329800017740188728520103899966266394616743965596895962817');
  t('5444444444446152901050228888888', 60, 6, '17592106959.6820954888762456299587087645198757486032797180848');
  t('-114444484444847444044.44', 137, 4, '-4855101.2248527808944266233514759852620665220331227122031724714903357712523262584170065900462015852363268526288830666787211628590015139633');
  t('522084998462894863541499172780283309097364914994420203969171536719406', 66, 0, '80521848857013917372799.1059024086300748342942591285333135058702099');
  t('0.435392457885124644595986403', 96, 4, '0.757926282379888888837766245000786788820013834183850049178359561809801447316489581200924188384141');
  t('-3.8935721385442976011377735', 2, 4, '-1.6');
  t('-433.33333333333333333333333333333333333333333', 94, 4, '-7.567295602164615900409134238090768259980213098093081962509532556578953403567108907302427063672');
  t('-1.96405012269067', 106, 1, '-1.252326360591893595397711200980579712115228348559464959243500935879859661668457378662606257717518884801728');
  t('-747670956.863185088818112418', 94, 2, '-907.6188429387329108680244415806856375442110616283347657548541747500891726146007590564192699135');
  t('344265231267985715960948408093', 15, 1, '7008596454.1036');
  t('-0.29299882485536763158121995771355500866627579669', 108, 0, '-0.664184331576811017917513660433896425479887817218943516305521978880908666274691992816987243677109716781859107');
  t('6666666666637812333', 56, 6, '1882072.0577593416853981327200201876305096441821945023663');
  t('200001000000006000000000000.000000000800200000000005', 36, 2, '584804522.313534015619379893393061337');
  t('0.2926446926031482613855877982925582859484772592073233338634463257761879682456993447046191', 90, 5, '0.663916635487765028294433140373294375718388458752601691378759226539360537477554105233076023');
  t('589903533444444', 39, 2, '83867.493914852236293999523978856285751');
  t('-81286379.19400304181947851', 73, 0, '-433.1841852414715507367246357434525648358138402121333520869366289535511019');
  t('88', 61, 0, '4.447960181138631042330726753444314393037398256193846111398692');
  t('-0.00000494273638171625551446228575273120497621304367539541050952672', 106, 6, '-0.01703422905257495800193994603804176592838973958683564829387222539356881219691972446128085308286725209421731');
  t('60000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 25, 5, '391486764116886359542493600000000000000000000');
  t('90741.1111111111111111111111111111111111111111117111111111111111111111111111111111119111411111111112111111111111111111111111111111111111111', 60, 5, '44.9367194678249771145760921009744496665507538881955058935052');
  t('-690013612055299432321757605873170060477735507379119560869523', 12, 3, '-88366140300900000000');
  t('-6155359169809588048082952836583473333', 73, 5, '-1832670826129.346048502765914394691508518863081252813739533233247195369593');
  t('68326884', 75, 3, '408.81849818574808060604674931535764057557028561326253164555984258595593301');
  t('244444444444461143777777777777777', 26, 0, '62525915178.898206017958449');
  t('0.8953374858973832755', 101, 2, '0.96381923499234283231898080392173958070973498995598990913380414164623135680168838251624338868561685653');
  t('8991939599999999999999994999.99999', 87, 5, '2079462663.22075815856341417336591061839524258631896714137697031952258536274872217369811');
  t('0.690462942272742676751532815625279187056129488027207856597060572', 114, 0, '0.883853171986163079694794618430212840678202515561386595786269152185653089522632477465099425387650946065070916343249');
  t('75719802103844466', 21, 1, '423061.160864046998692');
  t('10619181585951520756602944410837134489192635990.3676563978023132', 71, 1, '2198013467502479.0675875002167760176311189065640051200729560685793217186');
  t('-311918564458442017777777777777777', 24, 0, '-67818327382.2641821865449');
  t('-833491860487451793535433', 119, 1, '-94109569.700301397436730926253968101543829940911878483391728678333738416241123954120821834783478783383432026817261533984');
  t('-84977.315052550094037964368619721451214565797794275538457099748296074165', 9, 2, '-43.9643849');
  t('32222222222.22222222222222222222222222222222622222222222222222222222226', 21, 5, '3182.1342364533467581');
  t('6513297136290104286', 138, 6, '1867527.31953390182413187869514553145190147659437655264635301666610615652579452025678251588750403191904842018612528550166761824287432238142');
  t('0.00076382543928426752', 32, 4, '0.09141091149732199701483252041043');
  t('3611877777777777777777.777779406246923690656006220062412312326981716181321645947268131068895412871451499999999999999999999', 99, 6, '15343025.7980007887865807945293129830840534435140838657349910842760585080058972879970261729282255252');
  t('-40293717208', 116, 4, '-3428.3023104197063949311038816898758106276284322425058998401680222700469335037409653136807878940911364102022071656227');
  t('7787.91401671', 55, 5, '19.82167644148460566913441427583630860471151077682012287');
  t('0.47', 91, 5, '0.7774980097342586656461217640351700900762036673253896094410557276424103201171193787441229706');
  t('-0.0755225114092798589854175080724526335566076675549193431', 157, 1, '-0.4226934075405126574058117551471732838626664653081280968300635172063651833290357182498994360703339293683511900569881591878949020089371834736902061982583689309');
  t('-52360853700002000000000000700000000000600003070000000000000000000000000000000000000000030000000000000000000.00004', 64, 1, '-374112517500849738634810617252887003.0122769089266994645782461595');
  t('-65487676112272882226870846203465', 131, 4, '-40307561608.66071207368267087673714962096804645425841005626471078118206394752109345291751227242559042179768958853899636289111110833');
  t('-71.365344054605344964091', 106, 4, '-4.147908057866116970307839816829426927803562284569324359809617592982680144050308383341980153519483270689907');
  t('1528072413437.52490543586105', 98, 0, '11518.112386831491151081625172529737293403968305476389112149630983882243644157405600949461534731595');
  t('-3585453773773674929561249263341.7', 136, 2, '-15305518355.97025866756533816519371498139183709624265760795423572611255136431116966822083145342881758381943123582917972274968678371100174');
  t('0.0270100014682237', 34, 3, '0.3000370379020271231968986438612408');
  t('433333333333333333333333333333332333333333333333333333333333333333333333333333.33333333333333333333', 8, 2, '75672957000000000000000000');
  t('0.00408071517229179132246645648513478742679461980824654553958106221539505571569173079458028568702568181471355464606828018444412176203013988433587617751300363866021329442045753040442664217353227546275176299037438501539530364301425095790618411904925769266150445601007249922113237', 116, 3, '0.15980073073240546546444029747839747281045690745425228624983683436189740430747846133237165445672790038965714307566954');
  t('-1777777777794453604883612906593952160619800310548273280294745424.577037881539084548733893998014383684526884104265911540476577075592333756531062525581494636114398756777024170411222235199046307637621111111111', 288, 2, '-1211413728558547521198.69450179073369355856291028892183569317685948273034304516703144069035372867902752239872006023685229918622962960190855312625455543959610302566016895047877354579163480968524973783173157763898474946220286833079183434485887628827054438104631599932507306682666438560055753');
  t('887888881848888.8', 15, 6, '96113.9013309963');
  t('-360024535664140424577095465929855', 55, 3, '-71139482177.89278551991204798352404801953466014545497368');
  t('-80058426.142908258135063426846033379225', 75, 4, '-430.991808571496265041295982713563971189146219837491561570005359798491807846');
  t('33454023346945204444560160184778957668569113960303904328744688175729535658082509413934157504872808291397531212038349', 123, 4, '322217743452623756906112174886252855031.946808254688239220112725521310679893057921941460223211636875831319108083856685880945');
  t('-35555555555724069370063151534639549531254431617514793887088282226284020825796464214599422956284479846199433277848001814574135306733090966555860597689380879388023079954123621124801712', 86, 3, '-3288282765779155020372516703226435857444839748690356920211197.4849066166596991379758403');
  t('0.000000003264764756879930049488474521306', 111, 0, '0.00148348775026010484762083034069938772521396710542519410661383048223949598566441345947585945084126968984859333033');
  t('-0.3522023', 43, 2, '-0.7062049043177165662874070734000035068223558');
  t('1730443717314108927800680048485870977674261295403034542284164133968299008850736924839159068101619861090331647391360845388069236486618535', 2, 3, '1200000000000000000000000000000000000000000000');
  t('131513957159298235725599626962523', 307, 0, '50853862976.76304735967671698540416778083237370154188479681048919640977301011615711303941347680428831783697190428518683757106156984294328368878575466480544111677484397404812895261922881234648590818426600422253159934302108375219606666326146131593690041875558964169423188588672203882053673027953469026461598978');
  t('-9000000000000.008050030000000000000000000000000000900000000000002000000000002', 218, 4, '-20800.83823051904734705507864451021929278812803549200268410377447376473888051684412921197568029472087685397714299206865036318199163104972411243719322774348622237051889287146537267304740023519898270366470933250387436094');
  t('-0.7181450473601', 198, 3, '-0.895510584254539763374657781434810373555061829876549094787205810544356467588760961084900026110831212293180596981675572910189289378179759360118261561097999408309114956743186858050925270963549881154433');
  t('35555555555555555555565555555555555555555555555555555555555555555555555555.555555555555551355555555555555555555555555555555555155555555558', 298, 5, '3288282765773960135322456.70738207669907666573801854325780852864743502668657845052719497328747140706939285138693687926449963514014556772497533645428183463172622748156419820713284695127160297253476421473145752971015472846862150609935877693858251159545306711929510223188962535055928768890803953428233');
  t('0.000000073971254559205485932114514426056809359247093418682007433094787', 128, 4, '0.0041977927661423745080131445840206963302128642385939319165473936618581274825275702271416385708134219408305625104137086811658166637');
  t('-46469684444444444', 96, 6, '-359520.154019010572977639759399839536901885202093542370223909617130177215032720463457845645742072');
  t('-0.46246305003767003372844436278416880527636329839060410959020759881953396240244438439428199232677783586050813586353378045749416000444054388732965293729534', 312, 0, '-0.77331959182167606924776027803398205320899763023518826886307371315086947858575537431339485926163589135382749843813955142774257079427602172476310526839994744598166760643712724172027427199854203447589802533732876678327215086353621195319231606207144538726999025711880226393878454280590219952411236251644324631614085');
  t('1666.66666666666666671779827084027333998713711669787599', 276, 5, '11.8563110149668760201417618478183304347791901320135064513563363809636935223296073181689929886394840268546216467195572299874824656296542162962740359016902018511782189799386239051706052965028079046572422672425756989604132470445845360463809535053900997034148603140196261430569139');
  t('2039999999999999999999999999999999999998999999999994999999999999999999999999998999999.9999999999999599999', 91, 2, '12682651410769994658761341750.72237606614731413293617490535285825160416844839097417300206858');
  t('328920.0475353909154164892500468', 185, 3, '69.02876680061054148507206204804761116095653568607943007720565720203645272696676506381487840942193498948943894040540447693473765464447029017119014886412439605125795232946893723668619419');
  t('0.00000000936010787808', 168, 0, '0.00210746458247970297377076341509163306163094500277046623745208773927039247889139441537563112557754182846450607210421863486300585363560901915019116126181215517351244043721');
  t('6777777220962062876403386022.995', 295, 3, '1892470405.124347140274194250582376551493717876487349777348206908938947461083225663898492168085957922647305698566237421516447257464526230620630286818994833798988169366590679614208773434120243363428693045437435809826476250876454126317187953116088087721025952458984853933353609444943465669944020071');
  t('0.0357571052179229880781459997500627128209991885257634578863821050415688609507531589830598020439824324072782023164544923786117339662910355901724672464666247728721181622802029342021220936899331325873948059328274027409823424997584365863528466', 156, 2, '0.329448436503376182227542380539339830148671351877347330278129598128657584504957741009690110384526934716774195104832627977110470669844584770714636194395250813');
  t('-0.9332579448760833984704279453638248670443933188222151526366949750006917425784302143750453315762792601019', 159, 5, '-0.977238492893904824865094847273703259021881695988207428717967699663806906368087329050179890177836506826428207601134187001839174860564838105230540298120930049498');
  t('0.4', 75, 3, '0.736806299728077321155964566715961444383451623487636533851292298915447195101');
  t('552183047603813509686566028751310217018.804041214598837131361234519933478', 264, 2, '8204038500518.44773789391438055718293441898760334662984170656918899036016358823956701122250186292705560914263811039803329182597969567120054677528721729675696386711124721264474558213439260387378316551055272470484256007868511893881839180818562036223828236278832794154');
  t('-233333333333333333386069444061245584874163683787583656101103861791405369273224077720', 103, 2, '-6156382501492778048964491291.374095986336916007751157116185422186751521667000366427706292372918518538418');
  t('-9864684975759720100', 18, 5, '-2144672.94696894635');
  t('-966666666666666666666666666466666666666666666666666666661666666666.66666666662666666666666666666966666', 7, 5, '-9887631000000000000000');
  t('-6000000000000000001000000000000000000000000000000000000000008000000000000000000000000000002000000000000', 181, 1, '-18171205928321396589921629003734904.8347211383049016581155844877371008683219822310981673510859244947559018807892034763023056264860003933028638719908037626460826640855253136728310663');
  t('905596999929999999999999999.9999929999999899999999999929999919999999999', 91, 0, '967486673.71380287271265419891543812688044153309397444617426125395980611017831904796648804');
  t('1.30200511266788708694018', 4, 5, '1.092');
  t('-163779144454015040868024778652104861155107.2073', 304, 2, '-54712454616149.84418977529366614687482536072436725275516582520852664652849068949484189911831606262825626974327957549404404288539943932639651482039185391567868924097356103542857745660930295700971214740898126206714944261415055712750654570108835746686604676378368745847261462708527575345613524512987347236371');
  t('-6538917615589475.099960992838604434928057127638414468155214518645296549656781278025778633', 257, 1, '-186997.27960419976574988516161574403825660270141011185715547545414633976749369062014113721711880275748891050353830739330858788329073152031199801397123096230254112071841443373962070673095921163355098764045421726516671725134528497376952168032864987251497359909');
  t('53222222222.222292222222222222222282222220222222222222222222228222222222222222222222', 229, 6, '3761.528309180954593976538952686370247906174652720089218597698178819141201730582357187825519096220431323408596684801803306747322070164010402510920398297208694779359617695126245443805915801033262148244640700393543643046377324910934');
  t('66654713755630878750888888888888888888', 294, 1, '4054558982500.02700986820134594376840115124163436338859484486072358362206254694939867045408268059853111137541521389977958913261874740667544849998558765243764962401508022032836299546501823284546238102279106535660944025248600683928474131690499625944774392006779880972604204167008679947828112543291');
  t('-0.73445607397167371130459436773104', 306, 2, '-0.90223971959180057370319840811242973078705445774917692235720516165888631489205958335320463909466490763436288295134402799022259512420210552635494072057414939136185306611881394061367039090253834244604436819659695859666860373496003250543452929355036858720506065946733532228194955201475704495839306899938040585');
  t('0.0000099133847149042408080874', 40, 0, '0.0214819641170852795788014168824809088028');
  t('-0.3819353039', 307, 5, '-0.7255431863672597739966209179806070484597757636096318918354940359736458161971555746605317808318795846006010608924019292537852737565085161572427663554231567514594280432726072773136954892525279835020849650768498287368145308607626035353255513842333071361999678056884031345267063462855694744098863565550730843366');
  t('77777777777777777667693002.888888828836841012110751208875972662761390108377068904980123484522222222222222222', 267, 5, '426859721.662498084880747888680142039266548189927094400762036129726290797433963738730250066170964466327502281044101306960646208562564430665992429220418249028750827161989918980594343595540098229834767095235276477497105688610942305616632656935265681942805619736827501215');
  t('-0.26538273497717723393474970859231205890975045139564572526270147542920814667299600812458959335507089015350528862449061317081133992670844766919389996', 11, 2, '-0.6426249087');
  t('-26014819497210048971762456492356954992044068823083057865879544722578842492971228113486672601389030336951763149572390276212745078990608914925652120236669320', 211, 2, '-2963058816659042519814157238829288017211575281404017.164383538726684481531717577559527817991128822200740410660744185666165347869825419242671096023735646816984467570734210355339706756646314690384881626680189240567');
  t('0.40905503584930852', 200, 5, '0.74232470528406920537648009083596300397584699093446303624957811389728699671523032934447030612812035589519723228844950083739766847470591198535190724651292907369556015363896104981183942252771169615818625');
  t('-38264.0815468734', 57, 1, '-33.6974546727523211243122789757673939362173922047394205127');
  t('-0.30324153429', 115, 4, '-0.6718354176161675269050162406548851267446268974012058863513407182790818307997784132840207171517885526657507960197898');
  t('9188888888888888888888888888888888888888888688888884888888888888.8888888888888888888888288888488888884', 230, 4, '2094535216156839863174.5440227499163560225340608788020743244180314298130519339865389498196410907457431735076240331613079667362007127660241556265096642806005004307743615499688126058414327845649177701327682072316208427776028147944002');
  t('86425976362470923804433801010741211956.315746831411766746243845198', 297, 6, '4421280799056.3414701826616773547962477376739536106890518795962512157992891602684238637467753346170762016625816597483317860904665225577981143150506330622845304611262506204067228859477741306834002608582985131641005316148690121313992569747897164065569942482307035692332040914078117368813950159985495');
  t('800061641782864529412034961074380633668004313920510914417844222211532805382178', 79, 0, '92834160909444929909412852.56095831422139947981581211635565276874786289770782');
  t('6675417746231408148347290078711104234187.740620391', 28, 3, '18828952058115.50014732730936');
  t('-400.00000000000000000000000000509050000000000400000000009', 196, 1, '-7.368062997280773211559645667190870381074231072797778976891869176630866196071721850604919563305812408403182343177517484814361823474416386991818242705002731326647941956958657145436929554593320532993');
  t('-0.00078', 306, 4, '-0.0920516408251588836906790760297809389653844461547368991866295076250818988912111923270118450245386986711905421937448783083199031045447649338630700387933064266987153600184564392928652884415869346894964177870616399554863307984153648663173530615395315059569389641149984683932917922621521354195507495236834379727');
  t('88608103900', 16, 4, '4458.182209133859');
  t('84444445079100000000666666666666666666', 144, 4, '4387229587818.56821702507643434079696450272071347784645832492256279852887210775592032516453140230325818451426540760583684651910807743235319182085');
  t('-1708', 294, 3, '-11.953523934027669733633882218391380631635391658098690998649228699227634782437686286474315941472306565753697576105906047071833227833343708296817761389414161547230710512741297251588454596349403117164125836282776156582492341918414719989522710125034622526846447903431409211637676181603102993803354');
  t('-14845316421992069095411772620000000', 264, 2, '-245770537688.076561068481806295125599830706505268103427183900105872932014634046524459007960649330078412561103626541027189175837445703042495966814052069544145522635024669559953166280489770668637483956046334019987385953022140032908309690458322585628167922717720383548');
  t('84661266676665666.667966', 14, 6, '439098.12975534');
  t('4934767210', 123, 3, '1702.50693680629812170132588780973760644471652641407445973026231435570652293275922154066663071758164347992107812430383569753');
  t('0.002327080432478904379726640250882256474787656699186240247259189', 271, 0, '0.1325166549844519360815734907714400857318883989867294948852937264096238619772999344706692577288558936664366649756027205946120021276513277811835034985036318287361291818612104784372409646129942931451861346811614216483112401247415968471218096532515027861925817925063193996913');
  t('0.009010026', 299, 1, '0.20808559408693857398882367934316338695192884834048904455721493557695047551902740153035014737383537927598982046590828400741992307712468801908569375267060237398631427156054587148349105945478348258573449301331606590905574089385895933288248026075297088633609502777920723476262815221925356689810140581646');
  t('0.46696430773907542717358556620239550882408055855380662252491219094637665798', 243, 4, '0.775820460409708277616346003200918229331130858451956906671393922674232209573750842108769518926196812888371055107689994481529602372780219876028046186947301698347149344879032698719175601310898640923657414028423940585749879624286041460050569669626');
  t('199076594298191201512126633182355935542645396813196012673832446444023216527999468662', 133, 5, '5839021407248950829316868959.853373370018502256648997870426383846859183754148974732998748466193686778992915147447662254914648501350218');
  t('-0.0205602708176959315098285259766', 177, 2, '-0.27395313643298104985398916882354238259029946770167652150626959708690263320143930751204774859723606959533794293671371216528239224712876784550097963520061144227020103002184252017');
  t('7', 294, 5, '1.9129311827723891011991168395487602828624390503458757662106476404472342761792307560075254414772857099045419139587907592279446152938642120131474866957124456140398881696814713797026267454466120440611477614163918062415786739274531418927810756678716910667942296081913837582196010428021559461503007');
  t('0.1379854479842055168', 41, 1, '0.51674676041584294123788352715535738090482');
  t('-0.3', 92, 4, '-0.66943295008216952188265932463993079330341768719530115088057856058043109348253372974406850914');
  t('961', 222, 2, '9.8682724032189739274385838621973926435822525417517248546620995780382490627702437369197812592450207942813963121722788951169181917121500565928298914290465010422744626180183505632964989234189024069154333299521424554764172002');
  t('-2.25', 230, 1, '-1.3103706971044483035708306402209981351197138228618158625513869028643499095980210544142279129945367988837581041230078847725151913682975012460734926972463667246327960923914262006031851753394870717379354358958637976532500929457339882');
  t('-2230000000000000000000000000000000000000090000000000000000000000000000', 298, 5, '-130647655617245878049111.3209197321106694910620262373276958849631343152086003356335579228230956562106731008578130049525398129639022166290018592846083896305609910095540739918166591990096860567533807849647251860236960195542940764701079208660813083213426511903696307229099531648276197916809597843839964');
  t('53132858493006936241185859883194778056627710102835504478840126743104772801842227856307762081', 204, 3, '3759421842525817253068628987400.92577274501166159476109270459669059032135996796154035100023652746528314548728270405069123160995936061003028390573511210701810779876972120357727110384409883562323231927329961');
  t('914356211287430025055554', 101, 5, '97059594.628672067662582865269587888077992484540991466456287607855663528274778522707626368940398125642');
  t('0.12529522195533727004501484623610992705', 38, 0, '0.50039331979173687997858495494592131952');
  t('-0.1948791383473401686530791267473854369683635638791055239461046856605828827840768469880158091149537212544425407223464725930742442278515998696252268', 98, 6, '-0.5797691692900698707214888441221038040802120896480624344578923406854390123381805530700028542114528');
  t('-0.7355753005184995073565795303347315622405386146697302509609999465487822985253963717663507823712386', 267, 3, '-0.902697790160520006581278531313596250350151435598641898216986610717161678924560052929211893650948579023293216237285464377481499144845132068655788358307812966870451415680591581722238915991280062859569180122430337918171821124711816479454954596549259707564850817337259889');
  t('0.0468744925205262220546712095144013627869789', 13, 4, '0.3605610913952');
  t('-0.82013806535094583897602', 131, 0, '-0.93604269099627917760946677937383673063563769119936349836077216879509868732293145856168480115392665713377355872876824044744088812704');
  t('-89999999999999999999999999.99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999', 193, 2, '-448140474.6557164708747482014038579471166749997342577684417612506262725664866429358423019933461384428283704100231247064811874071864293735091395290322168962786116542962008996065385047274602169655');
  t('-3500.0000000000000700000000000300000000000000000000030000000200090000000000019', 277, 2, '-15.18294485937831269832368028842714465959207313756867259143534959451468478349826423897420518604015730149184106654585360041576526724232349351483711156344287484713901494612555022546668258538694448754817591420929107905834481260722680404464720557194520345713588128090746235046451194');
  t('-977952.93307229352832855410868523883049399695813', 238, 5, '-99.25962981674191910928604886472716933800157429491026923004151528779084058550148643566272317314256071817436094419964201979565715136972113546576779805797222420828412446343659868868777123742816877931836181888239839522321801369905201218812718');
  t('9498987716424506959783876949816518420085004047464108131810353045727121741808833.204287335991992579735898537381892193985', 48, 0, '211783656393532095865918777.884120918568324733419');
  t('-0.38', 158, 2, '-0.72431564434417407099618571419117011713663198464084323426297952597403587789967371090919857503447258159721961837966804280634387066192973408817407291979835365801');
  t('40168113.041222808387937446436240364935125', 176, 4, '342.4736351132709841167562944002966021070686376429416048911377426949833507692865953329823267728448949604888315411011673910403072669806601569712258516834149278214860402669548703');
  t('473826941974297357877986', 107, 0, '77960254.897740723560389957785238069422153613940030435572179982524597686729660316650261135733186428857321936');
  t('14444444444924323333333333333333333', 135, 0, '243538119138.123754869982000934587757399479587743779094470818073142650363794375356406631225460107649197088392087726685375997778829530842');
  t('2125348457864951221903144604471428718188355763333272919771852486898428161129518596727440228509156572680921345086136213011457.335839089', 134, 4, '128571106468780255157054093575808898945106.78902321501477421172026895124899294568097454987965820902471613201455286196657294811391928819');
  t('20000000000000000000000000000000000000000000000000000000000000000000000000000000000000.0000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000048', 206, 2, '27144176165949065715180894696.794892048051077694890969572843654428033085563287658494871973768515010449601702702662017016622108188038292129512829222822518526901294988541922245351958559869681995384170293875819');
  t('-66829636509519043102445668134981756564186551037.2607', 77, 3, '-4058102693406824.5047513770289783821373854162463798342500443333436971674695136');
  t('-3000000009327821861880259846523768460601056818253380768711892838425522465144782736049106093704984955792354502508328775951228903946964861466561639493152347423369425794650095111111111', 58, 3, '-1442249571802191388794725553821152879063475497765485623301000');
  t('-0.7517618617125084747282953800857906239', 227, 2, '-0.90927118786514121024739501215218771099690746256030674896907382684397782011911974791002831144160056142112938854311115859305334384644127403752675240288009675150238567924551804517599326719689371040491237387804180889144565821669285');
  t('0.91772157027249689587397897698089046', 12, 2, '0.971785272907');
  t('65091141111111111111111111', 122, 3, '402260412.92025581093745465305013260382563923007666892867987991960398216997573395084151229422291416923058566086159611162341');
  t('-528841445132917649295594922073404665061434461048515050569408646093118228814761676406092147646835258244915420746897430837198864.624593982751982581288943048791040449288622816700256159206109985912434973957837359646545848486706032128791922737173983428515863568670682234030811', 229, 3, '-808677130002691652166391240496264417933556.9365980462954335563064572928839547146474823861680331368926847515711092351550293048479890804812852992979899151592673221926137981308890445710778305211573135538087232890711501679915940056701');
  t('92661408659816791616467691013640855275756395498701589284496286017197284842030996435128301', 135, 4, '452514985671921546696489099984.443765863229679953606644886694376119333833853457893368185840383316593126316073887975659970000172841972698');
  t('6', 155, 4, '1.8171205928321396588912117563272605024282104631412196714813342979313097394593018656471417041264170721263449324977024075270561199313106125835528154571296702');
  t('7.61955496604', 19, 5, '1.967779969365665886');
  t('-13842028480844961657244488', 2, 0, '-250000000');
  t('0.6676378321937073265468044398601544834537303835150398403301373175671087', 152, 0, '0.87400445453698381894314480749609127272216823435004904320151622756315549371172250350373231785969028690716416274388752784174488351103212052464763083059458');
  t('688627', 250, 2, '88.30690875275330741018514988739698506972295588987183303321212932879724465718758272298200770727003404039878461994213374550486574059143260649865568068284864031778776459833353105024226868679393633320663131043363444369890524435775107727395361362233398198');
  t('-7670396176211628308685.577208733037931099394844679146104423084423572483728771539', 236, 2, '-19721469.182921695093547685482295657613468886834710373805547159986039749942573115055240312222436282849073795719780473952821406478263978841984044931351367554210384209582310518966190638965582116778015096000562528493076984081914347204934615');
  t('-30043583223902702040869083924749543605076581242871489198797576213', 56, 5, '-3108736480210792708014.9249186175420405441251283437056631');
  t('227627601111.12986', 215, 5, '6105.7868681341650906108964351431545815523086481503740994542385456748310216589718565837605265800595561048692524332812870822229132063181651102147953966576526041884945469908911640355427157660450583550251804546433919217');
  t('-0.9299', 94, 5, '-0.9760650207511089750157148578202488144876851954514878110647932151227854872920308862156446148868');
  t('-0.39316734422', 100, 3, '-0.7325868964506122421201081915055326576687848736241486498636624237850954848046015955730156526763159975');
  t('-0.0018461433322886031167759064954906148287790190688510251727333087918408280220125115484308222458313', 17, 4, '-0.12267473788045317');
  t('0.796461465332155625684', 73, 2, '0.9269470418325623587391199531978465025335120843504644060423746051132291914');
  t('62935', 47, 5, '39.776882781643413973272164444261857825120913064');
  t('-0.48524806922829530411207665826812053734423380994554551636693040129109537217672', 37, 0, '-0.7858167324037259260906640259340329526');
  t('-0.388888888888888888888888888888888888888888888888888888888888888888888888888888888', 135, 0, '-0.729919856647981544286633921895412619996667079944927408387578277188824136794624148970344925901096358665424378283400400359127349869486733');
  t('0.28017996262584712982121642622668544543536', 7, 6, '0.6543534');
  t('0.075033726214217103847126134635768727212106521410622356', 304, 3, '0.4217795360463214825376829847903764053281431267101816186808037165911128067976956908949481204575713697337470207957316693826890517472637852358476163950513589257838002033122894245839577245551228499263781554862360162498304623781781749390108404558077717549456528049576732279811898214194801066995423533854237922');
  t('0.0003787128034637382307', 247, 6, '0.07234968800513707739504113961805705648321199981494116660204093024430623836914063048928063349504375165536144047802959052254371030097364778628522446405650131801846267117965376377005316321598994237054104324194855700511490568462074787758262449212443183');
  t('-97.7', 313, 5, '-4.605726956511356623954716187591951376851856663954493538063315662507659842179748449195198676231946421787073817843658505295817001632158563070359190046483939603741616663173404916372384663816517352171419458401702340908726306243564295435097915834844597009579177807007104042960168395862169925386693025593987433187809141');
  t('0.56419083861654508122', 226, 1, '0.8263080998314925680323013818345485913485687429898530249763347967728388092192634586470298901648603868821580343900726939796079111970590362630579633727298465541508217929662343802997700130171299009129437858009107789153783896969115');
  t('-0.6714765238002548198536653029841558902595788070187587236619410359925844124725168239014168432316042399473872155443429304693966265359749903752634695419913252503594281280825731841061949892008590474376588575406476492400927900856316514379194425689', 186, 2, '-0.875676330994893751202023808387073349267769527062292991057639944646772576343285461222699693847786844272017697010774945383711874829155002993972812020798077802982353048705942882628171637162');
  t('0.07267', 317, 1, '0.41730320484852793123507319108005240926886568781439605740094935447146409280762331493005613105793969955242456852576841078204626266159253216245494381358345278733365604794548720925755752410836551425939636687875491646445528783769792687283922166441082234885309061146244599902326889195812916057663126567910226336517194133741');
  t('0.0000572498204059824709657', 319, 2, '0.03854115358934384222742693615396901248100807870959169022627064192266014905582932852411303015171708180263452241780229400568528861602519908857770882340721242022161883688143834703414779449746220418161998624614114891771849684076301850542251212044018885428461043082985367168386726575821123037911344328552060807299882494814136');
  t('-4277627.3', 302, 3, '-162.33081942829442756020452196566825717079892514106900675205838526588738834717030081423587022092675336178879546232955027767800064805306086362843051596761922802502857424442701860846305998218313182022095708367259421151436746476276668194439245825315202903071356428102880551285745234234834363303104177439879');
  t('-68201348470911845.292707373811090898088700720794056743192851794510374237096267642219522456182497', 165, 5, '-408567.973521257689158549629961676997803062456660650694513237669548748082512647308421613485867008647629249652196990829372991738712752857537649931452686228428061110139');
  t('-696465835372008', 273, 2, '-88640.7194681303904210885443328044233532263116973106844385381243238267285412422292729948589924203791649665577062183137997834992444580084277624049479134739393040086727580682518141368734147834857121202094101525496837110339612985899654578577212234651302053987884408334194892526');
  t('24080546809974110091212568679586727853670', 87, 3, '28877224429860.9946207713821984891416311006353257859468951979876155789449556704149179063');
  t('7457393.43437', 48, 5, '195.372013345928774715852763125477907351911517602');
  t('-74444444666666.55555555555544446790319162253963697844590373566045234890291543046021846846219430039385214329228347031029613672685206808392725676272019022770522222222222222', 196, 6, '-42067.24764919115316867197711242387450365338453906037731719245794050290747198502371372236627806519323406894972269389054218204432340226488571295766362585911736929336984878565823880743278542456732724');
  t('-3639999999999999999999999999999999999999999999999999999999999999999.9999999999999', 252, 5, '-15382743361962356162613.0021132319087915944575964418379586463745087217666443497482520080594073254285823736123491046243473736808376710984529662740143780506848620030102528930859164572347836903515014260287279580010137404349912625732502921556579392867902011');
  t('0.7315908337092695666375022056578076356235105221808921353709298463676232163278234426348557626044716955501818424032030314691479611123490251049543727684169468025493402106300057672072', 123, 3, '0.901064926139435647637937878571871422427966072200972650351755549126149338054359061683903027297597920397155388997536304459877');
  t('0.00171975', 36, 3, '0.119808723049174424395230402535972217');
  t('0.8343325349154400826249721238595922294563282441', 203, 3, '0.94141199253120460472023024058155924443685199594516850774136931284223482409411441594605658427934034788084067740271289155315660251591089521340801453127769583171443770207238323255961169712189082996457623635');
  t('-5721087797295844542738923039234684722864287493948759055', 207, 6, '-1788516169610944715.18707682952367134920780627420866192909334121776061417692485547420910297442163385323041050734345205971789554616105215643481705526093790107864182736757019737087107817634939148958359262241715');
  t('-100000000000000000000000000000000000000000000000000000000000000000000000000000000000', 82, 1, '-4641588833612778892410076350.919446576551349125011243637650692858684777869692844826');
  t('-0.37236022233266068271553500002086993646158754160651897964753957159130593602220337789649', 37, 5, '-0.7194287021190722121616311405030572973');
  t('48888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888.88888888888888888888888888888888888888888888888', 208, 4, '365653770162174559897292423536281591601060284117300834276689566.6516384269977803811644812244507129479898365891816831954805168121424036593483775649353090561806655778596659010235972306172338145785886414613173211');
  t('-667793248546201025693729872581641031450489332815563721803034611097988530823909195191892568658664272294856560373828579955061680117243385584153383897943999979015900156', 158, 2, '-8740722677729915506706098193894096089334228109460497215.36320291440403402698988040958239845092921025778169130427343107124941025564892122156863692040892869322');
  t('4', 127, 3, '1.587401051968199474751705639272308260391493327899853009808285761825216505624219173273544213262220957022934761681322017903497659');
  t('-388038.5295', 128, 5, '-72.938744479235808280645684722402698098678833235326365547735476495887614800836387305997026593220105967450545460498413955532426019');
  t('-17220379448017623838812498837867720774761980064226195272693422584538286', 107, 1, '-258234485497344364313052.20145503728723475026055360856855176425554392489282659925016164391227659563380302673');
  t('0.68548569054366881844538350436600672', 283, 4, '0.8817242752954566050373479417449386190506410045184817163279985405768002643562412728711739514157817522183671872731650060479549998714733543978768638889340220690017117540816721531463718913369453497340082536093436927249421591518855030205569097471861046077558767193605687919205234081488285');
  t('824534383', 153, 5, '937.712251272767564330720989875355389506771775992251837357793540930914775754552925229388040183516361780038457037560493036473826462455311691527073749476893');
  t('6777726488667649026734171389333333333', 19, 0, '1892465683340.091545');
  t('-8321917769453977062820345844488063216342975081312051', 123, 2, '-202647448527556241.358958208690563308467341811277913668723991530951808295976657502137372641290418610560429039265286217571421');
  t('0.47896563593811208608259828584665321993124730444346504262624491371683021620393759376416051', 207, 4, '0.782410707317227002290849670254815795431314607629670151046045874554338517187969867293759275996936298706233971976230522086377796650344657951872006248469108825964194144349620152477364267439716017056587355561848');
  t('37', 248, 5, '3.3322218516459532600954505051851190044096166719500623591329666509804053424388656524249155835676616728837516508195704713351611835284990355300207521054531260016847735935000107867125930902559914928427495216152339208480657457619094988857859339792612925');
  t('-7717799522690596222369727887400403511890625196212228', 287, 0, '-197620122600135870.68500471771949867081436776754195900175907153911366086255065754474457192909600850503567830766751088723891525433308961851986842047625842064024091757240783681356073580281463483543892936097654037196375880829331262526312333260113392318604917204854099658126520812219480882636');
  t('7030211111.777777111', 199, 2, '1915.679222577208459219547638018692281290140599805012211781457371521357546455570950306797458998230507361234155007678278158082496138317178737762378520222816935546284643435357655847196707199314198118361');
  t('-0.008286111', 243, 3, '-0.202356386513239687003236027126001198818178349249043461480949666892946537196577408887359805289037321972203926469266307346738119521212222023437746969337355725928724375768712300408484411524841689520072799421041328314621814038674281054735502760246');
  t('-9709711817.9257580096', 168, 3, '-2133.38275461679295783987332271203151653140396591095275913328398034729893752003357377325096814246882781342671859643235850225118855419358836423774449193411973967126514024');
  t('0.2', 46, 2, '0.5848035476425732131013574720275845557060997271');
  t('-11', 125, 3, '-2.2239800905693155211653633767221571965186991280969230556993458086604009830829759744897580544816262737484821534121261317251579');
  t('0.957879295825927826142564373360821131270801415966019238713966', 109, 5, '0.9857578905388967230426246816655261862702534477973555994356503867232804550175012371428559636272064749391546019');
  t('-274794195303195669383690179150393637278', 61, 0, '-6501334600143.956003508608845101493972662138482039189675231797');
  */
});
