/*
 * (C) Copyright 2019
* SPDX-License-Identifier:	GPL-2.0+
 * frank@allwinnertech.com
 */

#ifndef __PRIVATE_ATF__
#define __PRIVATE_ATF__

/******************************************************************************/
/*               the control information stored in file head                  */
/******************************************************************************/
struct private_atf_head {
	unsigned int  jump_instruction;	/* jumping to real code */
	unsigned char magic[8];		/* ="u-boot" */
	unsigned int  scp_base;		/* generated by PC */
	unsigned int  nboot_base;	/* align size in byte */
	unsigned int  nos_base;		/* the size of all file */
	unsigned int  secureos_base;	/* the size of uboot */
	unsigned char version[8];	/* uboot version */
	unsigned char platform[8];	/* platform information */
	int           reserved[1];	/* stamp space, 16bytes align */
	int           dram_para[32];
	unsigned long dtb_base;		/* the address of dtb */
};
#endif /* __PRIVATE_ATF__ */
