/* zutil.h -- internal interface and configuration of the compression library
 * Copyright (C) 1995-2005 Jean-loup Gailly.
* SPDX-License-Identifier:	GPL-2.0+
 * For conditions of distribution and use, see copyright notice in zlib.h
 */

/* WARNING: this file should *not* be used by applications. It is
   part of the implementation of the compression library and is
   subject to change. Applications should only use zlib.h.
 */

/* @(#) $Id$ */

#ifndef ZUTIL_H
#define ZUTIL_H

#define ZLIB_INTERNAL
#include "zlib.h"

#ifdef STDC
#ifndef _WIN32_WCE
#include <stddef.h>
#endif
#include <string.h>
#include <stdlib.h>
#endif
#ifdef NO_ERRNO_H
#ifdef _WIN32_WCE
/* The Microsoft C Run-Time Library for Windows CE doesn't have
       * errno.  We define it as a global variable to simplify porting.
       * Its value is always 0 and should not be used.  We rename it to
       * avoid conflict with other libraries that use the same workaround.
       */
#define errno z_errno
#endif
extern int errno;
#else
#ifndef _WIN32_WCE
#include <errno.h>
#endif
#endif

#ifndef local
#define local static
#endif
/* compile with -Dlocal if your debugger can't find static symbols */

typedef unsigned char uch;
typedef uch FAR uchf;
typedef unsigned short ush;
typedef ush FAR ushf;
typedef unsigned long ulg;

extern const char *const z_errmsg[10]; /* indexed by 2-zlib_error */
/* (size given to avoid silly warnings with Visual C++) */

#define ERR_MSG(err) z_errmsg[Z_NEED_DICT - (err)]

#define ERR_RETURN(strm, err) return (strm->msg = (char *)ERR_MSG(err), (err))
/* To be used only when the state is known to be valid */

/* common constants */

#ifndef DEF_WBITS
#define DEF_WBITS MAX_WBITS
#endif
/* default windowBits for decompression. MAX_WBITS is for compression only */

#if MAX_MEM_LEVEL >= 8
#define DEF_MEM_LEVEL 8
#else
#define DEF_MEM_LEVEL MAX_MEM_LEVEL
#endif
/* default memLevel */

#define STORED_BLOCK 0
#define STATIC_TREES 1
#define DYN_TREES 2
/* The three kinds of block type */

#define MIN_MATCH 3
#define MAX_MATCH 258
/* The minimum and maximum match lengths */

/* functions */
#ifdef CONFIG_GZIP_COMPRESSED
#define PRESET_DICT 0x20 /* preset dictionary flag in zlib header */
#define OS_CODE 0x03 /* assume Unix */
#endif

// #include <linux/string.h>
#define zmemcpy memcpy
#define zmemcmp memcmp
#define zmemzero(dest, len) memset(dest, 0, len)

/* Diagnostic functions */
#ifdef DEBUG
/* Not valid for U-Boot
#  include <stdio.h> */
extern int z_verbose;
extern void z_error OF((char *m));
#define Assert(cond, msg)                                                      \
	{                                                                      \
		if (!(cond))                                                   \
			z_error(msg);                                          \
	}
#define Trace(x)                                                               \
	{                                                                      \
		if (z_verbose >= 0)                                            \
			fprintf x;                                             \
	}
#define Tracev(x)                                                              \
	{                                                                      \
		if (z_verbose > 0)                                             \
			fprintf x;                                             \
	}
#define Tracevv(x)                                                             \
	{                                                                      \
		if (z_verbose > 1)                                             \
			fprintf x;                                             \
	}
#define Tracec(c, x)                                                           \
	{                                                                      \
		if (z_verbose > 0 && (c))                                      \
			fprintf x;                                             \
	}
#define Tracecv(c, x)                                                          \
	{                                                                      \
		if (z_verbose > 1 && (c))                                      \
			fprintf x;                                             \
	}
#else
#define Assert(cond, msg)
#define Trace(x)
#define Tracev(x)
#define Tracevv(x)
#define Tracec(c, x)
#define Tracecv(c, x)
#endif

voidpf zcalloc OF((voidpf opaque, unsigned items, unsigned size));
void zcfree OF((voidpf opaque, voidpf ptr, unsigned size));

#define ZALLOC(strm, items, size)                                              \
	(*((strm)->zalloc))((strm)->opaque, (items), (size))
#define ZFREE(strm, addr) (*((strm)->zfree))((strm)->opaque, (voidpf)(addr), 0)
#define TRY_FREE(s, p)                                                         \
	{                                                                      \
		if (p)                                                         \
			ZFREE(s, p);                                           \
	}

#endif /* ZUTIL_H */
