<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/slabinfo.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/slabinfo.plugin/metadata.yaml"
sidebar_label: "Linux kernel SLAB allocator statistics"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Kernel"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Linux kernel SLAB allocator statistics


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: slabinfo.plugin
Module: slabinfo.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collects metrics on kernel SLAB cache utilization to monitor the low-level performance impact of workloads in the kernel.


The plugin parses `/proc/slabinfo`

This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.

This integration requires read access to `/proc/slabinfo`, which is accessible only to the root user by default. Netdata uses Linux Capabilities to give the plugin access to this file. `CAP_DAC_READ_SEARCH` is added automatically during installation. This capability allows bypassing file read permission checks and directory read and execute permission checks. If file capabilities are not usable, then the plugin is instead installed with the SUID bit set in permissions sVko that it runs as root.


### Default Behavior

#### Auto-Detection

Due to the large number of metrics generated by this integration, it is disabled by default and must be manually enabled inside `/etc/netdata/netdata.conf`


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

SLAB cache utilization metrics for the whole system.

### Per Linux kernel SLAB allocator statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mem.slabmemory | a dimension per cache | B |
| mem.slabfilling | a dimension per cache | % |
| mem.slabwaste | a dimension per cache | B |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Minimum setup

If you installed `netdata` using a package manager, it is also necessary to install the package `netdata-plugin-slabinfo`.


### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugins]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details open><summary>The main configuration file.</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| Enable plugin | As described above plugin is disabled by default, this option is used to enable plugin. | no | yes |

</details>

#### Examples
There are no configuration examples.


