/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.xml.schema.model.impl;

import org.netbeans.modules.xml.schema.model.Pattern;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.w3c.dom.Element;

/**
 * This implements interface represents xs:pattern used to define regular expressions over
 * the lexical space.
 *
 * @author nn136682
 */
public class PatternImpl extends SchemaComponentImpl implements Pattern {

    public PatternImpl(SchemaModelImpl model) {
        this(model,createNewComponent(SchemaElements.PATTERN, model));
    }
    
    /** Creates a new instance of PatternImpl */
    public PatternImpl(SchemaModelImpl model, Element e) {
        super(model, e);
    
    }

	/**
	 *
	 *
	 */
	public Class<? extends SchemaComponent> getComponentType() {
		return Pattern.class;
	}
    
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }
    

    public String getValue() {
        return getAttribute(SchemaAttributes.VALUE);
    }
	
    public void setValue(String value) {
        setAttribute(VALUE_PROPERTY, SchemaAttributes.VALUE, value);
    }
}

