/* $Id: Auth_list.cpp 272611 2011-04-08 18:57:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'biblio.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Author.hpp>
#include <objects/general/Person_id.hpp>
#include <objects/general/Name_std.hpp>

// generated includes
#include <objects/biblio/Auth_list.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CAuth_list::~CAuth_list(void)
{
}


size_t CAuth_list::GetNameCount(void) const
{
    switch (GetNames().Which()) {
    case TNames::e_not_set:  return 0;
    case TNames::e_Std:      return GetNames().GetStd().size();
    case TNames::e_Ml:       return GetNames().GetMl().size();
    case TNames::e_Str:      return GetNames().GetStr().size();
    }
    return 0;
}


bool CAuth_list::GetLabelV1(string* label, TLabelFlags flags) const
{
    const C_Names& names = GetNames();
    switch (names.Which()) {
    case C_Names::e_not_set:
        break;
    case C_Names::e_Std:
        if (names.GetStd().size() > 0) {
            return names.GetStd().front()->GetLabel(label, flags, eLabel_V1);
        }
        break;
    case C_Names::e_Ml:
        if (names.GetMl().size() > 0) {
            *label += names.GetMl().front();
            return true;
        }
        break;
    case C_Names::e_Str:
        if (names.GetStr().size() > 0) {
            *label += names.GetStr().front();
            return true;
        }
        break;
    }

    return false;
}


bool CAuth_list::GetLabelV2(string* label, TLabelFlags flags) const
{
    const C_Names& names = GetNames();
    string         prefix;
    unsigned int   count = 0;

    switch (names.Which()) {
    case C_Names::e_not_set:
        return false;

    case C_Names::e_Std:
    {
        C_Names::TStd individuals;
        ITERATE (C_Names::TStd, it, names.GetStd()) {
            switch ((*it)->GetName().Which()) {
            case CPerson_id::e_Name:
            case CPerson_id::e_Ml:
            case CPerson_id::e_Str:
                if ((flags & fLabel_Consortia) == 0) {
                    individuals.push_back(*it);
                }
                break;
            case CPerson_id::e_Consortium:
                if ((flags & fLabel_Consortia) != 0) {
                    if ((*it)->GetLabel(label, flags, eLabel_V2)) {
                        ++count;
                    }
                    prefix = "; ";
                }
                break;
            default:
                break;
            }
        }
        
        if ((flags & fLabel_Consortia) == 0) {
            ITERATE (C_Names::TStd, it, individuals) {
                if (count > 0) {
                    if (&*it == &individuals.back()
                        &&  (flags & fLabel_FlatNCBI) != 0) {
                        prefix = " and ";
                    } else {
                        prefix = ", ";
                    }
                }
                *label += prefix;
                if ((*it)->GetLabel(label, flags, eLabel_V2)) {
                    ++count;
                } else if (NStr::EndsWith(*label, prefix)) { // It should!
                    label->resize(label->size() - prefix.size());
                }
            }
        }

        break;
    }

    case C_Names::e_Ml:
    case C_Names::e_Str:
        if ((flags & fLabel_Consortia) == 0) {
            C_Names::TMl nl = names.IsMl() ? names.GetMl() : names.GetStr();
            ITERATE (C_Names::TMl, it, nl) {
                if (count > 0) {
                    if (&*it == &nl.back() && (flags & fLabel_FlatNCBI) != 0) {
                        prefix = " and ";
                    } else {
                        prefix = ", ";
                    }
                }
                *label += prefix;
                if (CAuthor::x_GetLabelV2(label, flags, *it)) {
                    ++count;
                } else if (NStr::EndsWith(*label, prefix)) { // It should!
                    label->resize(label->size() - prefix.size());
                }
            }
        }
        break;
    }

    return count > 0;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1889, CRC32: d99a2868 */
