/* $Id: GBProject_ver2.cpp 410943 2013-08-22 20:54:31Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbproj.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/gbproj/GBProject_ver2.hpp>
#include <objects/gbproj/ProjectDescr.hpp>
#include <objects/gbproj/ProjectFolder.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


// constructor
CGBProject_ver2::CGBProject_ver2(void)
{
    SetProject_version("ver2");
}


// destructor
CGBProject_ver2::~CGBProject_ver2(void)
{
}



//void CGBProject_ver2::SetScope(CScope* scope)
//{
//    _ASSERT(m_Scope.GetPointer() == NULL);
//    m_Scope.Reset(scope);
//}
//
//
//CScope* CGBProject_ver2::GetScope()
//{
//    return m_Scope.GetPointer();
//}


void CGBProject_ver2::AddItem(CProjectItem& item, CProjectFolder& folder)
{
    // first, set the ID to the next available
    item.SetId(GetCounter());
    SetCounter(GetCounter() + 1);

    folder.AddChildItem(item);
}


const CProjectFolder& CGBProject_ver2::GetData() const
{
    return Tparent::GetData();
}


CProjectFolder& CGBProject_ver2::SetData()
{
    if ( !IsSetData()  ||
         !GetData().IsSetInfo()  ||
         !GetData().GetInfo().IsSetTitle() ) {

        CFolderInfo& info = Tparent::SetData().SetInfo();
        info.SetTitle("Data");
        info.SetComment("Default folder for Project Items");
        info.SetCreateDate(CTime(CTime::eCurrent));
    }
    return Tparent::SetData();
}


/// retrieve the descriptor set for this project
bool CGBProject_ver2::IsSetDescr() const
{
    return Tparent::IsSetDescr();
}


const CProjectDescr& CGBProject_ver2::GetDescr() const
{
    return Tparent::GetDescr();
}


CProjectDescr& CGBProject_ver2::SetDescr()
{
    return Tparent::SetDescr();
}


void CGBProject_ver2::SetDescr(CProjectDescr& desc)
{
    Tparent::SetDescr(desc);
}


/// retrieve the descriptor set for this project
bool CGBProject_ver2::IsSetAnnot() const
{
    return Tparent::IsSetAnnot();
}


const IGBProject::TAnnot& CGBProject_ver2::GetAnnot() const
{
    return Tparent::GetAnnot();
}


IGBProject::TAnnot& CGBProject_ver2::SetAnnot()
{
    return Tparent::SetAnnot();
}


bool CGBProject_ver2::IsSetDataLoaders() const
{
    return Tparent::IsSetLoaders();
}


const CGBProject_ver2::TDataLoaders& CGBProject_ver2::GetDataLoaders() const
{
    return Tparent::GetLoaders();
}


IGBProject::TDataLoaders& CGBProject_ver2::SetDataLoaders()
{
    return Tparent::SetLoaders();
}


/// retrieve the view descriptor set for this project
bool CGBProject_ver2::IsSetViews() const
{
    return Tparent::IsSetViews();
}


const IGBProject::TViews& CGBProject_ver2::GetViews() const
{
    return Tparent::GetViews();
}


IGBProject::TViews& CGBProject_ver2::SetViews()
{
    return Tparent::SetViews();
}


bool CGBProject_ver2::IsSetViewSettings() const
{
    return Tparent::IsSetView_settings();
}


const IGBProject::TViewSettings& CGBProject_ver2::GetViewSettings() const
{
    return Tparent::GetView_settings();
}


IGBProject::TViewSettings& CGBProject_ver2::SetViewSettings()
{
    return Tparent::SetView_settings();
}


void CGBProject_ver2::SetCreateDate(const CDate& date)
{
    SetDescr().SetCreateDate(date);
    SetDirtyFlag(true);
}


void CGBProject_ver2::SetModifiedDate(const CDate& date)
{
    SetDescr().SetModifiedDate(date);
    SetDirtyFlag(true);
}


void CGBProject_ver2::SetDirtyFlag(bool dirty)
{
    m_Dirty = dirty;

    if (m_Dirty) {
        CTime time;
        time.SetCurrent();
        SetDescr().SetModified_date().SetToTime(time);
    }
}


bool CGBProject_ver2::GetDirtyFlag() const
{
    return m_Dirty;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1737, CRC32: f0c41394 */
