/* SettingsDialog.c generated by valac 0.28.1, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBox* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* deviceModel;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;

GType moserial_settings_dialog_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
moserialSettingsDialog* moserial_settings_dialog_new (void);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void moserial_settings_dialog_finalize (GObject* obj);

extern const gchar* SETTINGS_BaudRateItems[16];
extern const gchar* SETTINGS_DataBitItems[4];
extern const gchar* SETTINGS_StopBitItems[2];
extern const gchar* SETTINGS_ParityModeStrings[5];
extern const gchar* SETTINGS_AccessModeStrings[3];

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeIter iter = {0};
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	_tmp0_ = g_strdup ("/dev/ttyS");
	deviceTypes = g_list_append (deviceTypes, _tmp0_);
	_tmp1_ = g_strdup ("/dev/ttyUSB");
	deviceTypes = g_list_append (deviceTypes, _tmp1_);
	_tmp2_ = g_strdup ("/dev/ttyACM");
	deviceTypes = g_list_append (deviceTypes, _tmp2_);
	_tmp3_ = g_strdup ("/dev/rfcomm");
	deviceTypes = g_list_append (deviceTypes, _tmp3_);
	_tmp4_ = g_strdup ("/dev/cuaU");
	deviceTypes = g_list_append (deviceTypes, _tmp4_);
	_tmp5_ = g_strdup ("/dev/cua");
	deviceTypes = g_list_append (deviceTypes, _tmp5_);
	_tmp6_ = self->priv->deviceModel;
	gtk_list_store_clear (_tmp6_);
	_tmp7_ = deviceTypes;
	{
		GList* devType_collection = NULL;
		GList* devType_it = NULL;
		devType_collection = _tmp7_;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			gchar* _tmp8_ = NULL;
			gchar* devType = NULL;
			_tmp8_ = g_strdup ((const gchar*) devType_it->data);
			devType = _tmp8_;
			{
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							gchar* dev = NULL;
							const gchar* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gchar* _tmp14_ = NULL;
							const gchar* _tmp15_ = NULL;
							gboolean _tmp16_ = FALSE;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = i;
								i = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = i;
							if (!(_tmp11_ < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							_tmp12_ = devType;
							_tmp13_ = i;
							_tmp14_ = g_strdup_printf ("%s%d", _tmp12_, _tmp13_);
							dev = _tmp14_;
							_tmp15_ = dev;
							_tmp16_ = g_file_test (_tmp15_, G_FILE_TEST_EXISTS);
							if (_tmp16_) {
								GtkListStore* _tmp17_ = NULL;
								GtkTreeIter _tmp18_ = {0};
								GtkListStore* _tmp19_ = NULL;
								GtkTreeIter _tmp20_ = {0};
								const gchar* _tmp21_ = NULL;
								_tmp17_ = self->priv->deviceModel;
								gtk_list_store_append (_tmp17_, &_tmp18_);
								iter = _tmp18_;
								_tmp19_ = self->priv->deviceModel;
								_tmp20_ = iter;
								_tmp21_ = dev;
								gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp21_, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	__g_list_free__g_free0_0 (deviceTypes);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp0_ = NULL;
	Settings* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp1_;
	moserial_settings_dialog_loadSettings (self);
	_tmp2_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
}


void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t = NULL;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkComboBox* _tmp18_ = NULL;
	GtkTreeModel* _tmp19_ = NULL;
	GtkTreeModel* _tmp20_ = NULL;
	GtkTreeModel* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	gboolean _tmp23_ = FALSE;
	GtkComboBox* _tmp39_ = NULL;
	GtkTreeModel* _tmp40_ = NULL;
	GtkTreeModel* _tmp41_ = NULL;
	GtkTreeModel* _tmp42_ = NULL;
	GtkTreeIter _tmp43_ = {0};
	gboolean _tmp44_ = FALSE;
	GtkComboBox* _tmp60_ = NULL;
	GtkTreeModel* _tmp61_ = NULL;
	GtkTreeModel* _tmp62_ = NULL;
	GtkTreeModel* _tmp63_ = NULL;
	GtkTreeIter _tmp64_ = {0};
	gboolean _tmp65_ = FALSE;
	GtkComboBox* _tmp81_ = NULL;
	Settings* _tmp82_ = NULL;
	SettingsParity _tmp83_ = 0;
	SettingsParity _tmp84_ = 0;
	GtkComboBox* _tmp85_ = NULL;
	Settings* _tmp86_ = NULL;
	SettingsAccessMode _tmp87_ = 0;
	SettingsAccessMode _tmp88_ = 0;
	GtkCheckButton* _tmp89_ = NULL;
	GtkCheckButton* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	Settings* _tmp92_ = NULL;
	SettingsHandshake _tmp93_ = 0;
	SettingsHandshake _tmp94_ = 0;
	gboolean _tmp99_ = FALSE;
	Settings* _tmp100_ = NULL;
	SettingsHandshake _tmp101_ = 0;
	SettingsHandshake _tmp102_ = 0;
	Settings* _tmp107_ = NULL;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	ti = _tmp4_;
	success = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		GValue str_data = {0};
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		GValue _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
		Settings* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp6_ = success;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = t;
		_tmp8_ = ti;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = self->priv->currentSettings;
		_tmp12_ = settings_get_device (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
			GtkComboBox* _tmp14_ = NULL;
			GtkTreeIter _tmp15_ = {0};
			_tmp14_ = self->priv->deviceCombo;
			_tmp15_ = ti;
			gtk_combo_box_set_active_iter (_tmp14_, &_tmp15_);
		}
		_tmp16_ = t;
		_tmp17_ = gtk_tree_model_iter_next (_tmp16_, &ti);
		success = _tmp17_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp18_ = self->priv->baudRateCombo;
	_tmp19_ = gtk_combo_box_get_model (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (t);
	t = _tmp20_;
	_tmp21_ = t;
	_tmp23_ = gtk_tree_model_get_iter_first (_tmp21_, &_tmp22_);
	ti = _tmp22_;
	success = _tmp23_;
	while (TRUE) {
		gboolean _tmp24_ = FALSE;
		GValue str_data = {0};
		GtkTreeModel* _tmp25_ = NULL;
		GtkTreeIter _tmp26_ = {0};
		GValue _tmp27_ = {0};
		const gchar* _tmp28_ = NULL;
		Settings* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		GtkTreeModel* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		_tmp24_ = success;
		if (!_tmp24_) {
			break;
		}
		_tmp25_ = t;
		_tmp26_ = ti;
		gtk_tree_model_get_value (_tmp25_, &_tmp26_, 0, &_tmp27_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp27_;
		_tmp28_ = g_value_get_string (&str_data);
		_tmp29_ = self->priv->currentSettings;
		_tmp30_ = settings_get_baudRate (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strcmp0 (_tmp28_, _tmp33_) == 0;
		_g_free0 (_tmp33_);
		if (_tmp34_) {
			GtkComboBox* _tmp35_ = NULL;
			GtkTreeIter _tmp36_ = {0};
			_tmp35_ = self->priv->baudRateCombo;
			_tmp36_ = ti;
			gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
		}
		_tmp37_ = t;
		_tmp38_ = gtk_tree_model_iter_next (_tmp37_, &ti);
		success = _tmp38_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp39_ = self->priv->dataBitsCombo;
	_tmp40_ = gtk_combo_box_get_model (_tmp39_);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (t);
	t = _tmp41_;
	_tmp42_ = t;
	_tmp44_ = gtk_tree_model_get_iter_first (_tmp42_, &_tmp43_);
	ti = _tmp43_;
	success = _tmp44_;
	while (TRUE) {
		gboolean _tmp45_ = FALSE;
		GValue str_data = {0};
		GtkTreeModel* _tmp46_ = NULL;
		GtkTreeIter _tmp47_ = {0};
		GValue _tmp48_ = {0};
		const gchar* _tmp49_ = NULL;
		Settings* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gboolean _tmp55_ = FALSE;
		GtkTreeModel* _tmp58_ = NULL;
		gboolean _tmp59_ = FALSE;
		_tmp45_ = success;
		if (!_tmp45_) {
			break;
		}
		_tmp46_ = t;
		_tmp47_ = ti;
		gtk_tree_model_get_value (_tmp46_, &_tmp47_, 0, &_tmp48_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp48_;
		_tmp49_ = g_value_get_string (&str_data);
		_tmp50_ = self->priv->currentSettings;
		_tmp51_ = settings_get_dataBits (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf ("%i", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strcmp0 (_tmp49_, _tmp54_) == 0;
		_g_free0 (_tmp54_);
		if (_tmp55_) {
			GtkComboBox* _tmp56_ = NULL;
			GtkTreeIter _tmp57_ = {0};
			_tmp56_ = self->priv->dataBitsCombo;
			_tmp57_ = ti;
			gtk_combo_box_set_active_iter (_tmp56_, &_tmp57_);
		}
		_tmp58_ = t;
		_tmp59_ = gtk_tree_model_iter_next (_tmp58_, &ti);
		success = _tmp59_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp60_ = self->priv->stopBitsCombo;
	_tmp61_ = gtk_combo_box_get_model (_tmp60_);
	_tmp62_ = _g_object_ref0 (_tmp61_);
	_g_object_unref0 (t);
	t = _tmp62_;
	_tmp63_ = t;
	_tmp65_ = gtk_tree_model_get_iter_first (_tmp63_, &_tmp64_);
	ti = _tmp64_;
	success = _tmp65_;
	while (TRUE) {
		gboolean _tmp66_ = FALSE;
		GValue str_data = {0};
		GtkTreeModel* _tmp67_ = NULL;
		GtkTreeIter _tmp68_ = {0};
		GValue _tmp69_ = {0};
		const gchar* _tmp70_ = NULL;
		Settings* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gboolean _tmp76_ = FALSE;
		GtkTreeModel* _tmp79_ = NULL;
		gboolean _tmp80_ = FALSE;
		_tmp66_ = success;
		if (!_tmp66_) {
			break;
		}
		_tmp67_ = t;
		_tmp68_ = ti;
		gtk_tree_model_get_value (_tmp67_, &_tmp68_, 0, &_tmp69_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp69_;
		_tmp70_ = g_value_get_string (&str_data);
		_tmp71_ = self->priv->currentSettings;
		_tmp72_ = settings_get_stopBits (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf ("%i", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strcmp0 (_tmp70_, _tmp75_) == 0;
		_g_free0 (_tmp75_);
		if (_tmp76_) {
			GtkComboBox* _tmp77_ = NULL;
			GtkTreeIter _tmp78_ = {0};
			_tmp77_ = self->priv->stopBitsCombo;
			_tmp78_ = ti;
			gtk_combo_box_set_active_iter (_tmp77_, &_tmp78_);
		}
		_tmp79_ = t;
		_tmp80_ = gtk_tree_model_iter_next (_tmp79_, &ti);
		success = _tmp80_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp81_ = self->priv->parityCombo;
	_tmp82_ = self->priv->currentSettings;
	_tmp83_ = settings_get_parity (_tmp82_);
	_tmp84_ = _tmp83_;
	gtk_combo_box_set_active (_tmp81_, (gint) _tmp84_);
	_tmp85_ = self->priv->accessModeCombo;
	_tmp86_ = self->priv->currentSettings;
	_tmp87_ = settings_get_accessMode (_tmp86_);
	_tmp88_ = _tmp87_;
	gtk_combo_box_set_active (_tmp85_, (gint) _tmp88_);
	_tmp89_ = self->priv->hardwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp89_, FALSE);
	_tmp90_ = self->priv->softwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp90_, FALSE);
	_tmp92_ = self->priv->currentSettings;
	_tmp93_ = settings_get_handshake (_tmp92_);
	_tmp94_ = _tmp93_;
	if (_tmp94_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp91_ = TRUE;
	} else {
		Settings* _tmp95_ = NULL;
		SettingsHandshake _tmp96_ = 0;
		SettingsHandshake _tmp97_ = 0;
		_tmp95_ = self->priv->currentSettings;
		_tmp96_ = settings_get_handshake (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp91_) {
		GtkCheckButton* _tmp98_ = NULL;
		_tmp98_ = self->priv->hardwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp98_, TRUE);
	}
	_tmp100_ = self->priv->currentSettings;
	_tmp101_ = settings_get_handshake (_tmp100_);
	_tmp102_ = _tmp101_;
	if (_tmp102_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp99_ = TRUE;
	} else {
		Settings* _tmp103_ = NULL;
		SettingsHandshake _tmp104_ = 0;
		SettingsHandshake _tmp105_ = 0;
		_tmp103_ = self->priv->currentSettings;
		_tmp104_ = settings_get_handshake (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp99_ = _tmp105_ == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp99_) {
		GtkCheckButton* _tmp106_ = NULL;
		_tmp106_ = self->priv->softwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp106_, TRUE);
	}
	_tmp107_ = self->priv->currentSettings;
	_tmp108_ = settings_get_localEcho (_tmp107_);
	_tmp109_ = _tmp108_;
	if (_tmp109_) {
		GtkCheckButton* _tmp110_ = NULL;
		_tmp110_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, TRUE);
	} else {
		GtkCheckButton* _tmp111_ = NULL;
		_tmp111_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, FALSE);
	}
	_g_object_unref0 (t);
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = NULL;
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	gchar* device = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	GtkTreeModel* t = NULL;
	GtkTreeIter iter = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkComboBox* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkComboBox* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GtkComboBox* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	const gchar* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GtkComboBox* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GtkComboBox* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	GtkCheckButton* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	GtkCheckButton* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	SettingsParity _tmp45_ = 0;
	SettingsHandshake _tmp46_ = 0;
	SettingsAccessMode _tmp47_ = 0;
	Settings* _tmp48_ = NULL;
	Settings* _tmp49_ = NULL;
	Settings* _tmp50_ = NULL;
	Settings* _tmp51_ = NULL;
	GtkDialog* _tmp52_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = self->priv->deviceCombo;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	success = _tmp5_;
	_tmp6_ = success;
	if (_tmp6_) {
		GValue str_data = {0};
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		GValue _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp7_ = t;
		_tmp8_ = iter;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (device);
		device = _tmp11_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	} else {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = settings_DEFAULT_DEVICEFILE;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (device);
		device = _tmp13_;
	}
	_tmp14_ = self->priv->baudRateCombo;
	_tmp15_ = gtk_combo_box_get_active (_tmp14_);
	_tmp16_ = SETTINGS_BaudRateItems[_tmp15_];
	_tmp17_ = atoi (_tmp16_);
	baudRate = _tmp17_;
	_tmp18_ = self->priv->dataBitsCombo;
	_tmp19_ = gtk_combo_box_get_active (_tmp18_);
	_tmp20_ = SETTINGS_DataBitItems[_tmp19_];
	_tmp21_ = atoi (_tmp20_);
	dataBits = _tmp21_;
	_tmp22_ = self->priv->stopBitsCombo;
	_tmp23_ = gtk_combo_box_get_active (_tmp22_);
	_tmp24_ = SETTINGS_StopBitItems[_tmp23_];
	_tmp25_ = atoi (_tmp24_);
	stopBits = _tmp25_;
	_tmp26_ = self->priv->parityCombo;
	_tmp27_ = gtk_combo_box_get_active (_tmp26_);
	parity = (SettingsParity) _tmp27_;
	_tmp28_ = self->priv->accessModeCombo;
	_tmp29_ = gtk_combo_box_get_active (_tmp28_);
	accessMode = (SettingsAccessMode) _tmp29_;
	_tmp31_ = self->priv->hardwareHandshake;
	_tmp32_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_);
	if (_tmp32_) {
		GtkCheckButton* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		_tmp33_ = self->priv->softwareHandshake;
		_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
		_tmp30_ = _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		GtkCheckButton* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		_tmp35_ = self->priv->hardwareHandshake;
		_tmp36_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp35_);
		if (_tmp36_) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			GtkCheckButton* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			_tmp37_ = self->priv->softwareHandshake;
			_tmp38_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp37_);
			if (_tmp38_) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	_tmp39_ = self->priv->localEcho;
	_tmp40_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp39_);
	pLocalEcho = _tmp40_;
	_tmp41_ = device;
	_tmp42_ = baudRate;
	_tmp43_ = dataBits;
	_tmp44_ = stopBits;
	_tmp45_ = parity;
	_tmp46_ = handshake;
	_tmp47_ = accessMode;
	_tmp48_ = settings_new (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, pLocalEcho);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp48_;
	_tmp49_ = self->priv->settings;
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp50_;
	_tmp51_ = self->priv->currentSettings;
	g_signal_emit_by_name (self, "update-settings", _tmp51_);
	_tmp52_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp52_);
	_g_object_unref0 (t);
	_g_free0 (device);
}


moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type) {
	moserialSettingsDialog * self = NULL;
	self = (moserialSettingsDialog*) g_object_new (object_type, NULL);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (void) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG);
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = moserial_settings_dialog_hide ((moserialSettingsDialog*) self);
	return result;
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel ((moserialSettingsDialog*) self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok ((moserialSettingsDialog*) self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkComboBox* _tmp13_ = NULL;
	GtkComboBox* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkComboBox* _tmp18_ = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkComboBox* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkCheckButton* _tmp29_ = NULL;
	GtkCheckButton* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkCheckButton* _tmp34_ = NULL;
	GtkCheckButton* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GtkBuilder* _tmp37_ = NULL;
	GObject* _tmp38_ = NULL;
	GtkComboBox* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	GtkBuilder* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkCheckButton* _tmp43_ = NULL;
	GtkCheckButton* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	GtkDialog* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	GtkButton* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkComboBox* _tmp51_ = NULL;
	GtkListStore* _tmp52_ = NULL;
	GtkComboBox* _tmp53_ = NULL;
	GtkListStore* _tmp54_ = NULL;
	GtkCellRenderer* deviceCell = NULL;
	GtkCellRendererText* _tmp55_ = NULL;
	GtkComboBox* _tmp56_ = NULL;
	GtkCellRenderer* _tmp57_ = NULL;
	GtkComboBox* _tmp58_ = NULL;
	GtkCellRenderer* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_settings_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = builder;
	gtk_builder_add_from_resource (_tmp1_, UIROOT "settings_dialog.ui", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp2_ = builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "settings_dialog");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp4_;
	_tmp5_ = builder;
	_tmp6_ = gtk_builder_get_object (_tmp5_, "settings_cancel_button");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->cancelButton);
	self->priv->cancelButton = _tmp7_;
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "settings_ok_button");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->okButton);
	self->priv->okButton = _tmp10_;
	_tmp11_ = builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "settings_baud_rate");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->baudRateCombo);
	self->priv->baudRateCombo = _tmp13_;
	_tmp14_ = self->priv->baudRateCombo;
	mo_utils_populateComboBox (_tmp14_, SETTINGS_BaudRateItems, G_N_ELEMENTS (SETTINGS_BaudRateItems));
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "settings_data_bits");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->dataBitsCombo);
	self->priv->dataBitsCombo = _tmp17_;
	_tmp18_ = self->priv->dataBitsCombo;
	mo_utils_populateComboBox (_tmp18_, SETTINGS_DataBitItems, G_N_ELEMENTS (SETTINGS_DataBitItems));
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "settings_stop_bits");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->stopBitsCombo);
	self->priv->stopBitsCombo = _tmp21_;
	_tmp22_ = self->priv->stopBitsCombo;
	mo_utils_populateComboBox (_tmp22_, SETTINGS_StopBitItems, G_N_ELEMENTS (SETTINGS_StopBitItems));
	_tmp23_ = builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "settings_parity");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->parityCombo);
	self->priv->parityCombo = _tmp25_;
	_tmp26_ = self->priv->parityCombo;
	mo_utils_populateComboBox (_tmp26_, SETTINGS_ParityModeStrings, G_N_ELEMENTS (SETTINGS_ParityModeStrings));
	_tmp27_ = builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "settings_hardware_handshake");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->hardwareHandshake);
	self->priv->hardwareHandshake = _tmp29_;
	_tmp30_ = self->priv->hardwareHandshake;
	_tmp31_ = _ ("Also known as RTS/CTS handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _tmp31_);
	_tmp32_ = builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "settings_software_handshake");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->softwareHandshake);
	self->priv->softwareHandshake = _tmp34_;
	_tmp35_ = self->priv->softwareHandshake;
	_tmp36_ = _ ("Also known as XON/XOFF handshaking");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp36_);
	_tmp37_ = builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "settings_open_for");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->accessModeCombo);
	self->priv->accessModeCombo = _tmp39_;
	_tmp40_ = self->priv->accessModeCombo;
	mo_utils_populateComboBox (_tmp40_, SETTINGS_AccessModeStrings, G_N_ELEMENTS (SETTINGS_AccessModeStrings));
	_tmp41_ = builder;
	_tmp42_ = gtk_builder_get_object (_tmp41_, "settings_local_echo");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->localEcho);
	self->priv->localEcho = _tmp43_;
	_tmp44_ = self->priv->localEcho;
	_tmp45_ = _ ("Normally disabled");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp44_, _tmp45_);
	_tmp46_ = self->priv->dialog;
	g_signal_connect_object ((GtkWidget*) _tmp46_, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
	_tmp47_ = self->priv->cancelButton;
	g_signal_connect_object (_tmp47_, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
	_tmp48_ = self->priv->okButton;
	g_signal_connect_object (_tmp48_, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
	_tmp49_ = builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "settings_device");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->deviceCombo);
	self->priv->deviceCombo = _tmp51_;
	_tmp52_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->deviceModel);
	self->priv->deviceModel = _tmp52_;
	_tmp53_ = self->priv->deviceCombo;
	_tmp54_ = self->priv->deviceModel;
	gtk_combo_box_set_model (_tmp53_, (GtkTreeModel*) _tmp54_);
	_tmp55_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp55_);
	deviceCell = (GtkCellRenderer*) _tmp55_;
	_tmp56_ = self->priv->deviceCombo;
	_tmp57_ = deviceCell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp56_, _tmp57_, FALSE);
	_tmp58_ = self->priv->deviceCombo;
	_tmp59_ = deviceCell;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp58_, _tmp59_, "text", 0, NULL);
	_g_object_unref0 (deviceCell);
	_g_object_unref0 (builder);
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->deviceModel);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}



