/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.ThisExpression;
import sharpen.core.CSharpBuilder;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSField;
import sharpen.core.csharp.ast.CSInfixExpression;
import sharpen.core.csharp.ast.CSMemberReferenceExpression;
import sharpen.core.csharp.ast.CSReferenceExpression;
import sharpen.core.csharp.ast.CSThisExpression;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeReference;
import sharpen.core.csharp.ast.CSharpCode;

public abstract class AbstractNestedClassBuilder
extends CSharpBuilder {
    private boolean _usesEnclosingMember;

    public AbstractNestedClassBuilder(CSharpBuilder other) {
        super(other);
    }

    protected abstract ITypeBinding nestedTypeBinding();

    @Override
    protected CSExpression mapMethodTargetExpression(MethodInvocation node) {
        if (node.getExpression() == null) {
            return this.createEnclosingTargetReferences(node.getName());
        }
        return super.mapMethodTargetExpression(node);
    }

    @Override
    public boolean visit(ThisExpression node) {
        if (node.getQualifier() == null) {
            return super.visit(node);
        }
        this.pushExpression(this.createEnclosingThisReference(node.getQualifier().resolveTypeBinding(), true));
        return false;
    }

    @Override
    public boolean visit(SimpleName name) {
        if (this.isInstanceFieldReference(name)) {
            this.pushExpression(this.createEnclosingReferences(name));
            return false;
        }
        return super.visit(name);
    }

    private boolean isInstanceFieldReference(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (3 != binding.getKind()) {
            return false;
        }
        return ((IVariableBinding)binding).isField();
    }

    private CSExpression createEnclosingReferences(SimpleName name) {
        CSExpression target = this.createEnclosingTargetReferences(name);
        return new CSMemberReferenceExpression(target, this.mappedName(name));
    }

    private CSExpression createEnclosingTargetReferences(SimpleName name) {
        ITypeBinding enclosingClassBinding = this.getDeclaringClass((Name)name);
        CSExpression target = this.isStaticMember(name) ? this.createTypeReference(enclosingClassBinding) : this.createEnclosingThisReference(enclosingClassBinding);
        return target;
    }

    private CSExpression createEnclosingThisReference(ITypeBinding enclosingClassBinding) {
        return this.createEnclosingThisReference(enclosingClassBinding, false);
    }

    private CSExpression createEnclosingThisReference(ITypeBinding enclosingClassBinding, boolean ignoreSuperclass) {
        CSExpression enclosing = new CSThisExpression();
        ITypeBinding binding = this.nestedTypeBinding();
        ITypeBinding to = enclosingClassBinding;
        while (binding != to && (ignoreSuperclass || !this.isSuperclass(binding, to))) {
            this.requireEnclosingReference();
            enclosing = new CSMemberReferenceExpression(enclosing, "_enclosing");
            binding = binding.getDeclaringClass();
            if (binding == null) break;
        }
        return enclosing;
    }

    protected boolean isEnclosingReferenceRequired() {
        return this._usesEnclosingMember;
    }

    protected void requireEnclosingReference() {
        this._usesEnclosingMember = true;
    }

    private String mappedName(SimpleName name) {
        IBinding binding = name.resolveBinding();
        return binding instanceof IMethodBinding ? this.mappedMethodName((IMethodBinding)binding) : this.identifier(name);
    }

    private boolean isStaticMember(SimpleName name) {
        return Modifier.isStatic((int)name.resolveBinding().getModifiers());
    }

    private boolean isSuperclass(ITypeBinding type, ITypeBinding candidate) {
        ITypeBinding superClass = type.getSuperclass().getTypeDeclaration();
        candidate = candidate.getTypeDeclaration();
        while (superClass != null) {
            if (superClass == candidate) {
                return true;
            }
            superClass = superClass.getSuperclass();
        }
        return false;
    }

    private ITypeBinding getDeclaringClass(Name reference) {
        IBinding binding = reference.resolveBinding();
        switch (binding.getKind()) {
            case 4: {
                return ((IMethodBinding)binding).getDeclaringClass().getTypeDeclaration();
            }
            case 3: {
                IVariableBinding variable = (IVariableBinding)binding;
                return variable.getDeclaringClass().getTypeDeclaration();
            }
        }
        return null;
    }

    protected CSField createEnclosingField() {
        return CSharpCode.newPrivateReadonlyField("_enclosing", this.enclosingTypeReference());
    }

    private CSTypeReference enclosingTypeReference() {
        CSTypeReference tr = new CSTypeReference(this._currentType.name());
        for (CSTypeParameter tp : this._currentType.typeParameters()) {
            tr.addTypeArgument(new CSTypeReference(tp.name()));
        }
        return tr;
    }

    protected CSInfixExpression createFieldAssignment(String fieldName, String rvalue) {
        return this.createFieldAssignment(fieldName, new CSReferenceExpression(rvalue));
    }

    protected CSInfixExpression createFieldAssignment(String fieldName, CSExpression fieldValue) {
        CSMemberReferenceExpression fieldReference = new CSMemberReferenceExpression(new CSThisExpression(), fieldName);
        return new CSInfixExpression("=", fieldReference, fieldValue);
    }
}

