"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Damascus"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Damascus", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Damascus", { abbr: true }),

	"1919" : helpers.makeTestYear("Asia/Damascus", [
		["1919-12-31T21:34:48+00:00", "23:34:48", "EET", -120]
	]),

	"1920" : helpers.makeTestYear("Asia/Damascus", [
		["1920-04-17T23:59:59+00:00", "01:59:59", "EET", -120],
		["1920-04-18T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1920-10-02T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1920-10-02T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1921" : helpers.makeTestYear("Asia/Damascus", [
		["1921-04-16T23:59:59+00:00", "01:59:59", "EET", -120],
		["1921-04-17T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1921-10-01T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1921-10-01T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1922" : helpers.makeTestYear("Asia/Damascus", [
		["1922-04-15T23:59:59+00:00", "01:59:59", "EET", -120],
		["1922-04-16T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1922-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1922-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1923" : helpers.makeTestYear("Asia/Damascus", [
		["1923-04-14T23:59:59+00:00", "01:59:59", "EET", -120],
		["1923-04-15T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1923-10-06T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1923-10-06T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1962" : helpers.makeTestYear("Asia/Damascus", [
		["1962-04-28T23:59:59+00:00", "01:59:59", "EET", -120],
		["1962-04-29T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1962-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1962-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1963" : helpers.makeTestYear("Asia/Damascus", [
		["1963-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1963-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1963-09-29T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1963-09-29T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1964" : helpers.makeTestYear("Asia/Damascus", [
		["1964-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1964-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1964-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1964-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1965" : helpers.makeTestYear("Asia/Damascus", [
		["1965-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1965-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1965-09-29T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1965-09-29T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1966" : helpers.makeTestYear("Asia/Damascus", [
		["1966-04-23T23:59:59+00:00", "01:59:59", "EET", -120],
		["1966-04-24T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1966-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1966-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1967" : helpers.makeTestYear("Asia/Damascus", [
		["1967-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1967-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1967-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1967-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1968" : helpers.makeTestYear("Asia/Damascus", [
		["1968-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1968-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1968-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1968-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1969" : helpers.makeTestYear("Asia/Damascus", [
		["1969-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1969-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1969-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1969-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1970" : helpers.makeTestYear("Asia/Damascus", [
		["1970-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1970-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1970-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1970-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1971" : helpers.makeTestYear("Asia/Damascus", [
		["1971-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1971-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1971-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1971-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1972" : helpers.makeTestYear("Asia/Damascus", [
		["1972-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1972-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1972-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1972-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1973" : helpers.makeTestYear("Asia/Damascus", [
		["1973-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1973-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1973-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1973-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1974" : helpers.makeTestYear("Asia/Damascus", [
		["1974-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1974-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1974-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1974-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1975" : helpers.makeTestYear("Asia/Damascus", [
		["1975-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1975-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1975-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1975-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1976" : helpers.makeTestYear("Asia/Damascus", [
		["1976-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1976-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1976-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1976-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1977" : helpers.makeTestYear("Asia/Damascus", [
		["1977-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1977-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1977-08-31T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1977-08-31T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1978" : helpers.makeTestYear("Asia/Damascus", [
		["1978-04-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1978-05-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1978-08-31T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1978-08-31T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1983" : helpers.makeTestYear("Asia/Damascus", [
		["1983-04-08T23:59:59+00:00", "01:59:59", "EET", -120],
		["1983-04-09T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1983-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1983-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1984" : helpers.makeTestYear("Asia/Damascus", [
		["1984-04-08T23:59:59+00:00", "01:59:59", "EET", -120],
		["1984-04-09T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1984-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1984-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1986" : helpers.makeTestYear("Asia/Damascus", [
		["1986-02-15T23:59:59+00:00", "01:59:59", "EET", -120],
		["1986-02-16T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1986-10-08T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1986-10-08T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1987" : helpers.makeTestYear("Asia/Damascus", [
		["1987-02-28T23:59:59+00:00", "01:59:59", "EET", -120],
		["1987-03-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1987-10-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1987-10-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1988" : helpers.makeTestYear("Asia/Damascus", [
		["1988-03-14T23:59:59+00:00", "01:59:59", "EET", -120],
		["1988-03-15T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1988-10-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1988-10-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1989" : helpers.makeTestYear("Asia/Damascus", [
		["1989-03-30T23:59:59+00:00", "01:59:59", "EET", -120],
		["1989-03-31T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1989-09-30T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1989-09-30T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1990" : helpers.makeTestYear("Asia/Damascus", [
		["1990-03-31T23:59:59+00:00", "01:59:59", "EET", -120],
		["1990-04-01T00:00:00+00:00", "03:00:00", "EEST", -180],
		["1990-09-29T22:59:59+00:00", "01:59:59", "EEST", -180],
		["1990-09-29T23:00:00+00:00", "01:00:00", "EET", -120]
	]),

	"1991" : helpers.makeTestYear("Asia/Damascus", [
		["1991-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1991-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1991-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1991-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("Asia/Damascus", [
		["1992-04-07T21:59:59+00:00", "23:59:59", "EET", -120],
		["1992-04-07T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1992-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1992-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1993" : helpers.makeTestYear("Asia/Damascus", [
		["1993-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["1993-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1993-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1993-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1994" : helpers.makeTestYear("Asia/Damascus", [
		["1994-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1994-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1994-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1994-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1995" : helpers.makeTestYear("Asia/Damascus", [
		["1995-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1995-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1995-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1995-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1996" : helpers.makeTestYear("Asia/Damascus", [
		["1996-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1996-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1996-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1996-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1997" : helpers.makeTestYear("Asia/Damascus", [
		["1997-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1997-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1997-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1997-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1998" : helpers.makeTestYear("Asia/Damascus", [
		["1998-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1998-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1998-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1998-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1999" : helpers.makeTestYear("Asia/Damascus", [
		["1999-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1999-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1999-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1999-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2000" : helpers.makeTestYear("Asia/Damascus", [
		["2000-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2000-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2000-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2000-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2001" : helpers.makeTestYear("Asia/Damascus", [
		["2001-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2001-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2001-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2001-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2002" : helpers.makeTestYear("Asia/Damascus", [
		["2002-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2002-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2002-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2002-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2003" : helpers.makeTestYear("Asia/Damascus", [
		["2003-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2003-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2003-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2003-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2004" : helpers.makeTestYear("Asia/Damascus", [
		["2004-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2004-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2004-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2004-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2005" : helpers.makeTestYear("Asia/Damascus", [
		["2005-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2005-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2005-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2005-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2006" : helpers.makeTestYear("Asia/Damascus", [
		["2006-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2006-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2006-09-21T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2006-09-21T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2007" : helpers.makeTestYear("Asia/Damascus", [
		["2007-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2007-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2007-11-01T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2007-11-01T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2008" : helpers.makeTestYear("Asia/Damascus", [
		["2008-04-03T21:59:59+00:00", "23:59:59", "EET", -120],
		["2008-04-03T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2008-10-31T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2008-10-31T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2009" : helpers.makeTestYear("Asia/Damascus", [
		["2009-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2009-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2009-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2009-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2010" : helpers.makeTestYear("Asia/Damascus", [
		["2010-04-01T21:59:59+00:00", "23:59:59", "EET", -120],
		["2010-04-01T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2010-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2010-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2011" : helpers.makeTestYear("Asia/Damascus", [
		["2011-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2011-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2011-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2011-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2012" : helpers.makeTestYear("Asia/Damascus", [
		["2012-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2012-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2012-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2012-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2013" : helpers.makeTestYear("Asia/Damascus", [
		["2013-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2013-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2013-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2013-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2014" : helpers.makeTestYear("Asia/Damascus", [
		["2014-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2014-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2014-10-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2014-10-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2015" : helpers.makeTestYear("Asia/Damascus", [
		["2015-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2015-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2015-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2015-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2016" : helpers.makeTestYear("Asia/Damascus", [
		["2016-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2016-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2016-10-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2016-10-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2017" : helpers.makeTestYear("Asia/Damascus", [
		["2017-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2017-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2017-10-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2017-10-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2018" : helpers.makeTestYear("Asia/Damascus", [
		["2018-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2018-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2018-10-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2018-10-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2019" : helpers.makeTestYear("Asia/Damascus", [
		["2019-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2019-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2019-10-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2019-10-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2020" : helpers.makeTestYear("Asia/Damascus", [
		["2020-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2020-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2020-10-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2020-10-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2021" : helpers.makeTestYear("Asia/Damascus", [
		["2021-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2021-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2021-10-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2021-10-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2022" : helpers.makeTestYear("Asia/Damascus", [
		["2022-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["2022-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2022-10-27T20:59:59+00:00", "23:59:59", "EEST", -180]
	])
};