mlpack is a fast, flexible machine learning library, written in C++, that aims
to provide fast, extensible implementations of cutting-edge machine learning
algorithms.  mlpack provides these algorithms as standalone Python functions,
which wrap the fast C++ implementations of the algorithms.

mlpack's techniques fall into a handful of categories:

 * _Classification_: logistic regression, perceptrons, random forests, linear
   SVMs, AdaBoost, etc.

 * _Regression_: linear regression, least angle regression, etc.

 * _Clustering_: Gaussian mixture models, k-means, mean shift, DBSCAN, etc.

 * _Geometry_: k-nearest-neighbor search, max-kernel search, locality sensitive
   hashing (LSH), etc.

 * _Preprocessing_: dataset splitting, binarization, scaling, one hot encoding,
   etc.

 * _Misc. / Other_: collaborative filtering, density estimation trees, Hidden
   Markov Models, kernel density estimation (KDE), etc.

 * _Transformations_: kernel PCA, sparse coding, large margin nearest neighbors,
   PCA, etc.

For more documentation on each individual function that mlpack provides, see the
[Python binding
documentation](https://www.mlpack.org/doc/stable/python_documentation.html).
