(* Handling of all individual accounts within the current set of accounts. *)

open Account

module AccountsMap : Map.S with type key = string

val add_account : string -> account -> unit
val update_account : string -> account -> unit
val lookup_account : string -> string -> account
val lookup_account_nofail : string -> (account option)
val add_txn : string -> txn -> string -> unit
val add_txn_negated : string -> txn -> string -> unit
val add_global_txn : txn -> unit
val filter_and_fold_accounts :
  (account -> bool) -> ('a -> account -> 'a) -> 'a -> 'a
val sum_integer_variable : string -> int
val load_initial_files : unit -> unit
val lookup_creditor : string -> string -> string
val iter : (account -> unit) -> unit
val group : string -> account list AccountsMap.t

