/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QColor>
#include <QLayout>
#include <QTextBrowser>

#include "LogHandler.h"
#include "MvQLogBrowser.h"


MvQLogBrowser::MvQLogBrowser(QLayout* layout)
{
	browser_=new QTextBrowser;
	layout->addWidget(browser_);

	oriBgColour_=new QColor(browser_->palette().color(QPalette::Base));
	errorBgColour_= new QColor(255,79,102);

}

MvQLogBrowser::~MvQLogBrowser()
{

}

void MvQLogBrowser::clear() 
{
	browser_->clear();
}

void MvQLogBrowser::update()
{
	for(vector<LogItem*>::const_iterator it = LogHandler::instance()->item().begin(); 
	     it != LogHandler::instance()->item().end(); it++)
	{
		LogItem *log=*it;

		/*if(log->errorStatus()) 
		{
			setBgColour(errorBgColour_);
		}
		else
		{
			setBgColour(oriBgColour_);
		}*/

		string buf;

		buf="<br><b>Task: </b>" + log->description() + "<br>";
		browser_->moveCursor(QTextCursor::End);
		browser_->insertHtml(QString(buf.c_str()));

		if(log->command().size() > 0)
		{
	           	buf="<b>Command: </b>" + log->command() + "<br>";
			browser_->moveCursor(QTextCursor::End);
			browser_->insertHtml(QString(buf.c_str()));
		}
		if(log->method().size() > 0)
		{
	           	buf="<b>Method: </b>" + log->method() + "<br>";
			browser_->moveCursor(QTextCursor::End);
			browser_->insertHtml(QString(buf.c_str()));
		}
		if(log->request().size() > 0)
		{
	           	buf="<b>Request: </b>" + log->request() + "<br>";
			browser_->moveCursor(QTextCursor::End);
			browser_->insertHtml(QString(buf.c_str()));
		}
		if(log->status().size() >0)
		{			 
			buf="<b>Status: </b>" + log->status() + "<br>";
			browser_->moveCursor(QTextCursor::End);
			browser_->insertHtml(QString(buf.c_str()));
		}
		else
		{
			if(log->errorStatus()) 
			{
				//buf="<b>Status: </b><font color=black style=\"BACKGROUND-COLOR: #FF6666\">Error/warning</font><br><b>Message: </b><br>";
				buf="<b>Status: </b><font color=red>Error/warning</font><br><b>Message: </b><br>";
				browser_->moveCursor(QTextCursor::End);
				browser_->insertHtml(QString(buf.c_str()));

				buf=log->log();
				browser_->moveCursor(QTextCursor::End);
				browser_->insertPlainText(QString(buf.c_str()) + "\n");
			}
			else
			{
				buf="<b>Status: </b><font color=green>OK</font><br>";
				browser_->moveCursor(QTextCursor::End);
				browser_->insertHtml(QString(buf.c_str()));
			}
		}

		//buf="<br>";
		browser_->moveCursor(QTextCursor::End);
		//logBrowser_->insertHtml(QString(buf.c_str()));
	}

	LogHandler::instance()->clear();
}

void MvQLogBrowser::setBgColour(QColor *col)
{
	QPalette palette = browser_->palette();
	if(palette.color(QPalette::Base) != *col)
	{
		palette.setColor(QPalette::Base,*col);
		browser_->setPalette(palette);
	}
}
