//***************************************************************************
//
//  Copyright (c) 1999 - 2006 Intel Corporation
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//***************************************************************************

/**
	@file	IFXTextureErrors.h
*/

#ifndef __IFXTEXTURE_ERRORS_H__
#define __IFXTEXTURE_ERRORS_H__



// texture subsystem error codes...
#define IFX_TEXTURE_MANAGER_INIT_FAILURE	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0001)
#define IFX_TEXTURE_MANAGER_RELEASE_FAILURE	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0002)

#define IFX_TEXTURE_CREATE_OBJECT_FAILURE	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0011)
#define IFX_TEXTURE_OBJECT_NOT_FOUND		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0012)
#define IFX_TEXTURE_OBJECT_NOT_INITIALIZED	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0013)

#define IFX_TEXTURE_INVALID_INDEX			MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0020)
#define IFX_TEXTURE_INVALID_NULL_PARAMETER	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0021)

#define IFX_TEXTURE_MAP_NOT_ALLOCATED		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0030)
#define IFX_TEXTURE_MAP_INVALID_SIZE		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0031)
#define IFX_TEXTURE_MAP_INVALID_FORMAT		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0032)

#define IFX_TEXTURE_GRAPHICS_SUBSYSTEM_ERR	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0040)
#define IFX_TEXTURE_NONE_SELECTED			MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0041)

#define IFX_TEXTURE_COMPRESSION_FAILURE		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0050)
#define IFX_TEXTURE_ERROR_ENCODING_JPEG		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0051)
#define IFX_TEXTURE_COMPRESSION_UNSUPPORTED	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0052)

#define IFX_TEXTURE_ERROR_DECODING_JPEG		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0060)
#define IFX_TEXTURE_DECOMPRESSION_FAILURE	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0062)

#define IFX_TEXTURE_CODEC_PLUGIN_NOT_FOUND	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0070)

#define IFX_TEXTURE_SUBSYSTEM_OBJECT_UNINIT MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0090)
#define IFX_TEXTURE_CLASSID_NOT_FOUND		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0091)
#define IFX_TEXTURE_CREATE_STREAM_FAILURE	MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0092)
#define IFX_TEXTURE_REFORMAT_FAILURE		MAKE_IFXRESULT_FAIL( IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0093)

#define IFX_E_INVALID_CONT_IMAGE_COUNT      MAKE_IFXRESULT_FAIL(IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0094)
#define IFX_E_INVALID_COMPRESSION_TYPE		MAKE_IFXRESULT_FAIL(IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0095)
#define IFX_E_INVALID_FILE_NAME				MAKE_IFXRESULT_FAIL(IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0096)
#define IFX_E_INVALID_CHANNEL_FLAG			MAKE_IFXRESULT_FAIL(IFXRESULT_COMPONENT_TEXTURE_MANAGER, 0x0097)

#endif
