/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class Soundex
implements StringEncoder {
    public static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    private char[] soundexMapping;
    private int maxLength = 4;

    public Soundex() {
        this(US_ENGLISH_MAPPING);
    }

    public Soundex(char[] cArray) {
        this.soundexMapping = cArray;
    }

    public String soundex(String string) {
        char c;
        if (null == string || string.length() == 0) {
            return string;
        }
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n = 1;
        int n2 = 1;
        cArray[0] = Character.toUpperCase(string.charAt(0));
        char c2 = this.getMappingCode(string.charAt(0));
        while (n < string.length() && (c = this.getMappingCode(string.charAt(n++))) != '\u0000' && n2 < this.maxLength) {
            if (c != '0' && c != c2) {
                cArray[n2++] = c;
            }
            c2 = c;
        }
        return new String(cArray);
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        String string = this.soundex((String)object);
        return string;
    }

    public String encode(String string) throws EncoderException {
        return this.soundex(string);
    }

    private char getMappingCode(char c) {
        if (!Character.isLetter(c)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase(c) - 65];
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }
}

