/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoInternalException;
import java.util.HashMap;
import java.util.Map;

public abstract class IndexMap {
    static IndexMap create() {
        return new RangeBased();
    }

    static IndexMap create(int startIndex, int count) {
        return new RangeBased(startIndex, count);
    }

    abstract IndexMap add(int var1, int var2);

    abstract int map(int var1);

    private static class RangeBased
    extends IndexMap {
        private int startIndex;
        private int count;

        public RangeBased() {
        }

        public RangeBased(int startIndex, int count) {
            if (startIndex < 0) {
                throw new IllegalArgumentException("startIndex must be more than 0");
            }
            if (count < 0) {
                throw new IllegalArgumentException("count must be more than 0");
            }
            this.startIndex = startIndex;
            this.count = count;
        }

        public IndexMap add(int index, int originalIndex) {
            if (this.count == 0) {
                this.startIndex = originalIndex;
                this.count = 1;
                return this;
            }
            if (originalIndex == this.startIndex + this.count) {
                ++this.count;
                return this;
            }
            HashBased hashBasedMap = new HashBased(this.startIndex, this.count);
            ((IndexMap)hashBasedMap).add(index, originalIndex);
            return hashBasedMap;
        }

        public int map(int index) {
            if (index < 0) {
                throw new MongoInternalException("no mapping found for index " + index);
            }
            if (index >= this.count) {
                throw new MongoInternalException("index should not be greater than or equal to count");
            }
            return this.startIndex + index;
        }
    }

    private static class HashBased
    extends IndexMap {
        private final Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();

        public HashBased(int startIndex, int count) {
            for (int i = startIndex; i < startIndex + count; ++i) {
                this.indexMap.put(i - startIndex, i);
            }
        }

        public IndexMap add(int index, int originalIndex) {
            this.indexMap.put(index, originalIndex);
            return this;
        }

        public int map(int index) {
            Integer originalIndex = this.indexMap.get(index);
            if (originalIndex == null) {
                throw new MongoInternalException("no mapping found for index " + index);
            }
            return originalIndex;
        }
    }
}

