/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Mongo3Interface {
    boolean DEBUG = false;
    String Errmsg = "No error";
    String bvalName = null;
    Set<String> Colnames = null;
    MongoClient client = null;
    MongoDatabase db = null;
    MongoCollection<BsonDocument> coll = null;
    FindIterable<BsonDocument> finditer = null;
    AggregateIterable<BsonDocument> aggiter = null;
    MongoCursor<BsonDocument> cursor = null;
    BsonDocument doc = null;
    BsonDocument util = null;
    BsonNull bsonull = new BsonNull();

    public Mongo3Interface() {
        this(false);
    }

    public Mongo3Interface(boolean b) {
        this.DEBUG = b;
    }

    protected void SetErrmsg(String str) {
        if (this.DEBUG) {
            System.out.println(str);
        }
        this.Errmsg = str;
    }

    protected void SetErrmsg(Exception e) {
        if (this.DEBUG) {
            System.out.println(e.getMessage());
        }
        this.Errmsg = e.toString();
    }

    public String GetErrmsg() {
        String err = this.Errmsg;
        this.Errmsg = "No error";
        return err;
    }

    public int MongoConnect(String[] parms) {
        int rc = 0;
        if (this.DEBUG) {
            System.out.println("Mongo3: URI=" + parms[0] + " DB=" + parms[1]);
        }
        try {
            MongoClientURI uri = new MongoClientURI(parms[0]);
            this.client = new MongoClient(uri);
            if (this.DEBUG) {
                System.out.println("Connection " + this.client.toString() + " established");
            }
            this.db = this.client.getDatabase(parms[1]);
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            rc = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -3;
        }
        return rc;
    }

    public int MongoDisconnect() {
        int rc = 0;
        try {
            if (this.cursor != null) {
                if (this.DEBUG) {
                    System.out.println("Closing cursor");
                }
                this.cursor.close();
                this.cursor = null;
            }
            if (this.client != null) {
                if (this.DEBUG) {
                    System.out.println("Closing connection");
                }
                this.client.close();
                this.client = null;
            }
        }
        catch (MongoException se) {
            this.SetErrmsg(se);
            rc += 8;
        }
        return rc;
    }

    public boolean GetCollection(String name) {
        if (this.DEBUG) {
            System.out.println("GetCollection: name=" + name);
        }
        try {
            this.coll = this.db.getCollection(name).withDocumentClass(BsonDocument.class);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            return true;
        }
        return false;
    }

    public long GetCollSize() {
        return this.coll != null ? this.coll.count() : 0L;
    }

    public boolean FindColl(String query, String fields) {
        if (this.DEBUG) {
            System.out.println("FindColl: query=" + query + " fields=" + fields);
        }
        try {
            if (query != null) {
                Document dbq = Document.parse(query);
                this.finditer = this.coll.find(dbq);
            } else {
                this.finditer = this.coll.find();
            }
            if (fields != null) {
                BsonDocument dbf = BsonDocument.parse(fields);
                this.finditer = this.finditer.projection(dbf);
            }
            this.cursor = this.finditer.iterator();
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            return true;
        }
        return false;
    }

    public boolean AggregateColl(String pipeline) {
        if (this.DEBUG) {
            System.out.println("AggregateColl: pipeline=" + pipeline);
        }
        try {
            Document pipe = Document.parse(pipeline);
            ArrayList pip = (ArrayList)pipe.get("pipeline");
            this.aggiter = this.coll.aggregate(pip);
            this.cursor = this.aggiter.iterator();
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        return false;
    }

    public boolean Rewind() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.finditer != null) {
            this.cursor = this.finditer.iterator();
        } else if (this.aggiter != null) {
            this.cursor = this.aggiter.iterator();
        }
        return this.cursor == null;
    }

    public int ReadNext() {
        try {
            if (this.cursor.hasNext()) {
                this.doc = this.cursor.next();
                if (this.DEBUG) {
                    System.out.println("Class doc = " + this.doc.getClass());
                }
                this.Colnames = this.doc.keySet();
                return this.Colnames.size();
            }
            return 0;
        }
        catch (MongoException mx) {
            this.SetErrmsg(mx);
            return -1;
        }
    }

    public boolean Fetch(int row) {
        if (this.cursor.hasNext()) {
            this.doc = this.cursor.next();
            this.Colnames = this.doc.keySet();
            return true;
        }
        return false;
    }

    public String GetDoc() {
        return this.doc != null ? this.doc.toJson() : null;
    }

    public Set<String> GetColumns() {
        if (this.doc != null) {
            return this.doc.keySet();
        }
        return null;
    }

    public String ColumnName(int n) {
        if (n < this.Colnames.size()) {
            return (String)this.Colnames.toArray()[n];
        }
        return null;
    }

    public int ColumnType(int n, String name) {
        return 666;
    }

    public Object ColumnDesc(Object obj, int n, int[] val, int lvl) {
        BsonValue ret = null;
        BsonValue bval = (BsonValue)(obj != null ? obj : this.doc);
        BsonDocument dob = bval instanceof BsonDocument ? (BsonDocument)bval : null;
        BsonArray ary = bval instanceof BsonArray ? (BsonArray)bval : null;
        try {
            if (ary != null) {
                bval = ary.get(n);
                this.bvalName = Integer.toString(n);
            } else if (dob != null) {
                Object[] k = dob.keySet().toArray();
                bval = dob.get(k[n]);
                this.bvalName = (String)k[n];
            } else {
                this.bvalName = "x" + Integer.toString(n);
            }
            val[0] = 0;
            val[1] = 0;
            val[2] = 0;
            val[3] = 0;
            val[4] = 0;
            if (bval.isString()) {
                val[0] = 1;
                val[1] = bval.asString().getValue().length();
            } else if (bval.isInt32()) {
                val[0] = 7;
                val[1] = Integer.toString(bval.asInt32().getValue()).length();
            } else if (bval.isInt64()) {
                val[0] = 5;
                val[1] = Long.toString(bval.asInt64().getValue()).length();
            } else if (bval.isObjectId()) {
                val[0] = 1;
                val[1] = bval.asObjectId().getValue().toString().length();
            } else if (bval.isDateTime()) {
                Long TS = bval.asDateTime().getValue() / 1000L;
                val[0] = 8;
                val[1] = TS.toString().length();
            } else if (bval.isDouble()) {
                String d = Double.toString(bval.asDouble().getValue());
                int i = d.indexOf(46) + 1;
                val[0] = 2;
                val[1] = d.length();
                val[2] = i > 0 ? val[1] - i : 0;
            } else if (bval.isBoolean()) {
                val[0] = 4;
                val[1] = 1;
            } else if (bval.isDocument()) {
                if (lvl > 0) {
                    ret = bval;
                    val[0] = 1;
                    val[4] = bval.asDocument().keySet().size();
                } else if (lvl == 0) {
                    val[0] = 1;
                    val[1] = bval.asDocument().toJson().length();
                }
            } else if (bval.isArray()) {
                if (lvl > 0) {
                    ret = bval;
                    val[0] = 2;
                    val[4] = bval.asArray().size();
                } else if (lvl == 0) {
                    val[0] = 1;
                    this.util = new BsonDocument("arr", bval.asArray());
                    String s = this.util.toJson();
                    int i1 = s.indexOf(91);
                    int i2 = s.lastIndexOf(93);
                    val[1] = i2 - i1 + 1;
                }
            } else if (bval.isDecimal128()) {
                val[0] = 9;
                val[1] = bval.asDecimal128().toString().length();
            } else if (bval.isNull()) {
                val[0] = 0;
                val[3] = 1;
            } else {
                this.SetErrmsg("Type " + (Object)((Object)bval.getBsonType()) + " of " + this.bvalName + " not supported");
                val[0] = -1;
            }
            return ret;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            val[0] = -1;
            return null;
        }
    }

    public String ColDescName() {
        return this.bvalName;
    }

    protected BsonValue GetFieldObject(String path) {
        BsonValue o = this.doc;
        BsonDocument dob = null;
        BsonArray ary = null;
        String[] names = null;
        if (path == null || path.equals("") || path.equals("*")) {
            return this.doc;
        }
        if (o instanceof BsonDocument) {
            dob = this.doc;
        } else if (o instanceof BsonArray) {
            ary = (BsonArray)o;
        } else {
            return this.doc;
        }
        try {
            String[] stringArray = names = path.split("\\.");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                o = ary != null ? ary.get(Integer.parseInt(name)) : dob.get(name);
                if (o == null) break;
                if (this.DEBUG) {
                    System.out.println("Class o = " + o.getClass());
                }
                if (o instanceof BsonDocument) {
                    dob = o;
                    ary = null;
                } else {
                    if (!(o instanceof BsonArray)) break;
                    ary = (BsonArray)o;
                }
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException x) {
            o = null;
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            o = null;
        }
        return o;
    }

    public String GetField(String path) {
        BsonValue o = this.GetFieldObject(path);
        if (o != null) {
            if (o.isString()) {
                return o.asString().getValue();
            }
            if (o.isInt32()) {
                return Integer.toString(o.asInt32().getValue());
            }
            if (o.isInt64()) {
                return Long.toString(o.asInt64().getValue());
            }
            if (o.isObjectId()) {
                return o.asObjectId().getValue().toString();
            }
            if (o.isDateTime()) {
                Integer TS = (int)(o.asDateTime().getValue() / 1000L);
                return TS.toString();
            }
            if (o.isDouble()) {
                return Double.toString(o.asDouble().getValue());
            }
            if (o.isBoolean()) {
                return o.asBoolean().getValue() ? "1" : "0";
            }
            if (o.isDocument()) {
                return o.asDocument().toJson();
            }
            if (o.isArray()) {
                this.util = new BsonDocument("arr", o.asArray());
                String s = this.util.toJson();
                int i1 = s.indexOf(91);
                int i2 = s.lastIndexOf(93);
                return s.substring(i1, i2 + 1);
            }
            if (o.isDecimal128()) {
                return o.asDecimal128().toString();
            }
            if (o.isNull()) {
                return null;
            }
            return o.toString();
        }
        return null;
    }

    public Object MakeBson(String s, int json) {
        BsonValue bval = json == 1 ? BsonDocument.parse(s) : (json == 2 ? BsonArray.parse(s) : null);
        return bval;
    }

    protected BsonValue ObjToBson(Object val, int json) {
        BsonValue bval = null;
        if (val == null) {
            bval = this.bsonull;
        } else if (val.getClass() == String.class) {
            bval = json == 1 ? BsonDocument.parse((String)val) : (json == 2 ? BsonArray.parse((String)val) : new BsonString((String)val));
        } else if (val.getClass() == Integer.class) {
            bval = new BsonInt32((Integer)val);
        } else if (val.getClass() == Double.class) {
            bval = new BsonDouble((Double)val);
        } else if (val.getClass() == BigInteger.class) {
            bval = new BsonInt64((Long)val);
        } else if (val.getClass() == Boolean.class) {
            bval = new BsonBoolean((Boolean)val);
        } else if (val.getClass() == Date.class) {
            bval = new BsonDateTime(((Date)val).getTime() * 1000L);
        } else if (val.getClass() == BsonDocument.class) {
            bval = (BsonDocument)val;
        } else if (val.getClass() == BsonArray.class) {
            bval = (BsonArray)val;
        }
        return bval;
    }

    public Object MakeDocument() {
        return new BsonDocument();
    }

    public boolean DocAdd(Object bdc, String key, Object val, int json) {
        try {
            ((BsonDocument)bdc).append(key, this.ObjToBson(val, json));
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        return false;
    }

    public Object MakeArray() {
        return new BsonArray();
    }

    public boolean ArrayAdd(Object bar, int n, Object val, int json) {
        try {
            int i = ((BsonArray)bar).size();
            while (i < n) {
                ((BsonArray)bar).add(this.bsonull);
                ++i;
            }
            ((BsonArray)bar).add(this.ObjToBson(val, json));
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            return true;
        }
        return false;
    }

    public boolean CollInsert(Object dob) {
        try {
            this.coll.insertOne((BsonDocument)dob);
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
            return true;
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
            return true;
        }
        return false;
    }

    public long CollUpdate(Object upd) {
        long n = -1L;
        if (this.DEBUG) {
            System.out.println("upd: " + upd.toString());
        }
        try {
            UpdateResult res = this.coll.updateOne(Filters.eq("_id", this.doc.get("_id")), (Bson)upd);
            if (this.DEBUG) {
                System.out.println("CollUpdate: " + res.toString());
            }
            n = res.getModifiedCount();
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
        }
        return n;
    }

    public long CollDelete(boolean all) {
        long n = -1L;
        try {
            DeleteResult res = all ? this.coll.deleteMany(new Document()) : this.coll.deleteOne(Filters.eq("_id", this.doc.get("_id")));
            if (this.DEBUG) {
                System.out.println("CollDelete: " + res.toString());
            }
            n = res.getDeletedCount();
        }
        catch (MongoException me) {
            this.SetErrmsg(me);
        }
        catch (Exception ex) {
            this.SetErrmsg(ex);
        }
        return n;
    }
}

