CREATE TABLE t1 (a TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NULL);
SHOW CREATE TABLE t1;
DROP TABLE t1;

CREATE TABLE t1 (a TIMESTAMP DEFAULT NULL);
INSERT t1 () VALUES ();
SHOW CREATE TABLE t1;
DROP TABLE t1;

CREATE TABLE t1 (a TIMESTAMP DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP DEFAULT '2001-01-01 10:20:30');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP NULL DEFAULT NULL);
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NULL DEFAULT '2001-01-01 10:20:30');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NOT NULL DEFAULT '2001-01-01 10:20:30');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NOT NULL);
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NULL);
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00');
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;
CREATE TABLE t1 (a TIMESTAMP,b TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP);
SHOW CREATE TABLE t1;
DROP TABLE t1;


CREATE TABLE t1 (a TIMESTAMP) AS SELECT 1 AS i;
SHOW CREATE TABLE t1;
CREATE TABLE t2 (b TIMESTAMP) AS SELECT a FROM t1;
SHOW CREATE TABLE t2;
DROP TABLE t2;
DROP TABLE t1;


CREATE TABLE t1 (a INT);
ALTER TABLE t1 ADD b TIMESTAMP;
SHOW CREATE TABLE t1;
DROP TABLE t1;

--echo #
--echo # MDEV-10802 TIMESTAMP NOT NULL field with explicit_defaults_for_timestamp and NO_ZERO_DATE shouldn't throw error
--echo #

SET timestamp=UNIX_TIMESTAMP('2001-01-01 10:20:30');
SET sql_mode='ANSI,NO_ZERO_DATE';
CREATE TABLE t1 (a TIMESTAMP NOT NULL);
INSERT INTO t1 VALUES ();
SELECT * FROM t1;
DROP TABLE t1;
SET sql_mode=DEFAULT;
SET timestamp=DEFAULT;

--echo #
--echo # MDEV-29075 Changing explicit_defaults_for_timestamp within stored procedure works inconsistently
--echo #
set statement explicit_defaults_for_timestamp=1-@@explicit_defaults_for_timestamp for create table t1 (ts timestamp);
show create table t1;
drop table t1;

--delimiter $
create procedure pr()
begin
  set explicit_defaults_for_timestamp= 1-@@explicit_defaults_for_timestamp;
  create table t1 (ts timestamp);
end $
--delimiter ;

call pr();
show create table t1;
drop procedure pr;
drop table t1;

prepare stmt from 'create or replace table t1 (a timestamp)';
execute stmt;
show create table t1;
set explicit_defaults_for_timestamp=1-@@explicit_defaults_for_timestamp;
execute stmt;
show create table t1;
set explicit_defaults_for_timestamp=1-@@explicit_defaults_for_timestamp;
execute stmt;
show create table t1;
drop table t1;
