#!/bin/bash
#
# Copyright (C) 2020 Susi Lehtola
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

cat > xc-dimensions.c <<EOF
/*
 Copyright (C) 2020 Susi Lehtola

 This Source Code Form is subject to the terms of the Mozilla Public
 License, v. 2.0. If a copy of the MPL was not distributed with this
 file, You can obtain one at http://mozilla.org/MPL/2.0/.

 ** THIS FILE IS AUTOGENERATED BY gen-xc-dimensions.sh **
 **           DO NOT MODIFY THIS FILE!                 **
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include <xc.h>
#include "util.h"

int main(int argc, char **argv)
{
  int nspin;
  xc_dimensions dim;

  if(argc!=2) {
    printf("Usage: %s nspin\n", argv[0]);
    return 1;
  }

  nspin=atoi(argv[1]);
  internal_counters_set_mgga(nspin, &dim);

  /* Energy */
  printf("double zk;\n");

  /* Derivatives */
EOF

ingr=(rho sigma lapl tau)

max=4

for((ord=1;ord<=max;ord++)); do
    for((tau=0;tau<=max;tau++)); do
        for((lapl=0;lapl<=max-tau;lapl++)); do
            for((sigma=0;sigma<=max-tau-lapl;sigma++)); do
                for((rho=0;rho<=max-tau-lapl-sigma;rho++)); do
                    let tot=rho+sigma+lapl+tau
                    if(( tot != ord )); then
                        continue
                    fi

                    if(( ord == 1 )); then
                        name="v"
                    else
                        name=$(printf "v%i" $ord)
                    fi

                    if(( rho )); then
                        if(( rho == 1 )); then
                            name=$(printf "%srho" $name)
                        else
                            name=$(printf "%srho%i" $name $rho)
                        fi
                    fi
                    if(( sigma )); then
                        if(( sigma == 1 )); then
                            name=$(printf "%ssigma" $name)
                        else
                            name=$(printf "%ssigma%i" $name $sigma)
                        fi
                    fi
                    if(( lapl )); then
                        if(( lapl == 1 )); then
                            name=$(printf "%slapl" $name)
                        else
                            name=$(printf "%slapl%i" $name $lapl)
                        fi
                    fi
                    if(( tau )); then
                        if(( tau == 1 )); then
                            name=$(printf "%stau" $name)
                        else
                            name=$(printf "%stau%i" $name $tau)
                        fi
                    fi
                    

                    printf "  printf(\"double %s[%%i];\\\n\", dim.%s);\n" $name $name >> xc-dimensions.c
                done
            done
        done
    done
done

cat >> xc-dimensions.c <<EOF

  return 0;
}
EOF
