# Simple DirectMedia Layer

https://www.libsdl.org/

Simple DirectMedia Layer is a cross-platform development library designed
to provide low level access to audio, keyboard, mouse, joystick, and graphics
hardware. It is used by video playback software, emulators, and popular games
including Valve's award winning catalog and many Humble Bundle games.

SDL officially supports Windows, macOS, Linux, iOS, Android, Xbox, PlayStation 4/5, Nintendo Switch, and many other platforms.

SDL is written in C, works natively with C++, and there are bindings 
available for several other languages, including C# and Python.

This library is distributed under the zlib license, which can be found
in the file "LICENSE.txt".

Information on building SDL with CMake is available in [README-cmake.md](README-cmake.md)

The best way to learn how to use SDL is to check out the header files in
the "include" subdirectory and the programs in the "examples" subdirectory.
The header files and test programs are well commented and always up to date.

Information on reporting bugs and contributing is available in [README-contributing.md](README-contributing.md)

More documentation and FAQs are available online at the [wiki](http://wiki.libsdl.org/)

- [Migrating from SDL 2.0](README-migration.md)
- [main()](README-main-functions.md)
- [High DPI Support](README-highdpi.md)
- [Touch](README-touch.md)
- [Supported platforms](README-platforms.md)
- [Porting information](README-porting.md)

If you need help with the library, or just want to discuss SDL related
issues, you can join the [SDL Discourse](https://discourse.libsdl.org/),
which can be used as a web forum or a mailing list, at your preference.

If you want to report bugs or contribute patches, please submit them to
[our bug tracker](https://github.com/libsdl-org/SDL/issues)

Enjoy!


Sam Lantinga <mailto:slouken@libsdl.org>
