// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIEntity.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIEntityPrivate {
    friend class OAIEntity;

     QString id;
     bool id_isSet;
     bool id_isValid;
};

OAIEntity::OAIEntity()
    : d_ptr()
{
}

OAIEntity::OAIEntity(const OAIEntity& other)
    : d_ptr(other.d_ptr)
{
}

OAIEntity::OAIEntity(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIEntity::~OAIEntity() = default;

void OAIEntity::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIEntityPrivate{});

        Q_D(OAIEntity);


        d->id_isSet = false;
        d->id_isValid = false;
    }
}

void OAIEntity::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIEntity::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIEntity);

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;
}

QString OAIEntity::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIEntity::asJsonObject() const {
    Q_D(const OAIEntity);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    return obj;
}

QString OAIEntity::getId() const {
    Q_D(const OAIEntity);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIEntity::setId(const QString &id) {
    Q_D(OAIEntity);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIEntity::is_id_Set() const{
    Q_D(const OAIEntity);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIEntity::is_id_Valid() const{
    Q_D(const OAIEntity);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

bool OAIEntity::isSet() const {
    Q_D(const OAIEntity);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIEntity::isValid() const {
    Q_D(const OAIEntity);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
