#include "osl/enter_king/enterKing.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::enter_king;

class EnterKingTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(EnterKingTest);

  CPPUNIT_TEST(testBeginning);
  CPPUNIT_TEST(testBlackWin);
  CPPUNIT_TEST(testWhiteWin);
  CPPUNIT_TEST(testBlackLessPiece);
  CPPUNIT_TEST(testWhiteLessPiece);
  CPPUNIT_TEST(testBlackLessPoint);
  CPPUNIT_TEST(testWhiteLessPoint);
  CPPUNIT_TEST(testDropsBlackWin);
  CPPUNIT_TEST(testDropsWhiteWin);
  CPPUNIT_TEST(testDropsBlackLessPiece);
  CPPUNIT_TEST(testDropsWhiteLessPiece);
  CPPUNIT_TEST(testDropsBlackLessPoint);
  CPPUNIT_TEST(testDropsWhiteLessPoint);
  // CPPUNIT_TEST(testXXX);

  CPPUNIT_TEST_SUITE_END();
public:
  void testBeginning();
  void testBlackWin();
  void testWhiteWin();
  void testBlackLessPiece();
  void testWhiteLessPiece();
  void testBlackLessPoint();
  void testWhiteLessPoint();
  void testDropsBlackWin();
  void testDropsWhiteWin();
  void testDropsBlackLessPiece();
  void testDropsWhiteLessPiece();
  void testDropsBlackLessPoint();
  void testDropsWhiteLessPoint();
  // void testXXX() { CPPUNIT_ASSERT(1+1 == 2); }
};

CPPUNIT_TEST_SUITE_REGISTRATION(EnterKingTest);

void EnterKingTest::testBeginning()
{
  const NumEffectState state((SimpleState(HIRATE)));
  EnterKing Enter;
  CPPUNIT_ASSERT( !Enter.canDeclareWin(state) );
}

void EnterKingTest::testBlackWin()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+UM+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU+FU-GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7 *  *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00FU00KY00KE00KE\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( Enter.canDeclareWin(state) );
}

void EnterKingTest::testWhiteWin()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3 *  *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU-FU+GI+GI *  * \n"
					"P8-OU-TO-UM-UM-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P-00FU00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( Enter.canDeclareWin(state) );
}

void EnterKingTest::testBlackLessPiece()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+UM+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU * -GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7 *  *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00FU00KY00KE00KE\n"
				       "P-00FU\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( !Enter.canDeclareWin(state) );
}
void EnterKingTest::testWhiteLessPiece()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3 *  *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU * +GI+GI *  * \n"
					"P8-OU-TO-UM-UM-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P+00FU\n"
					"P-00FU00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( !Enter.canDeclareWin(state) );
}
void EnterKingTest::testBlackLessPoint()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+TO+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU+FU-GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7+UM *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00KY00KE00KE\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( !Enter.canDeclareWin(state) );
}
void EnterKingTest::testWhiteLessPoint()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3-UM *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU-FU+GI+GI *  * \n"
					"P8-OU-TO-UM-TO-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P-00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  CPPUNIT_ASSERT( !Enter.canDeclareWin(state) );
}

void EnterKingTest::testDropsBlackWin()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+UM+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU+FU-GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7 *  *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00FU00KY00KE00KE\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(kachi);
  CPPUNIT_ASSERT(drops == 0);
}

void EnterKingTest::testDropsWhiteWin()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3 *  *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU-FU+GI+GI *  * \n"
					"P8-OU-TO-UM-UM-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P-00FU00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(kachi);
  CPPUNIT_ASSERT(drops == 0);
}

void EnterKingTest::testDropsBlackLessPiece()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+UM+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU * -GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7 *  *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00FU00KY00KE00KE\n"
				       "P-00FU\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(!kachi);
  CPPUNIT_ASSERT(drops == 1);
}
void EnterKingTest::testDropsWhiteLessPiece()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3 *  *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU * +GI+GI *  * \n"
					"P8-OU-TO-UM-UM-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P+00FU\n"
					"P-00FU00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(!kachi);
  CPPUNIT_ASSERT(drops == 1);
}

void EnterKingTest::testDropsBlackLessPoint()
{
  const NumEffectState state(CsaString(
				       "P1 *  * +RY *  * +KI * -KE * \n"
				       "P2+OU+TO+UM+TO+TO * -KI-OU * \n"
				       "P3-FU+FU+FU+FU+FU-GI-GI *  * \n"
				       "P4 *  *  *  * -FU-FU-FU-FU * \n"
				       "P5 *  * -RY-NY-GI *  *  *  * \n"
				       "P6 *  *  *  *  * +FU+FU+FU * \n"
				       "P7+UM *  *  *  * +KI+KE * -NY\n"
				       "P8 *  *  *  *  * +KI+GI *  * \n"
				       "P9 *  *  *  * -NY *  *  *  * \n"
				       "P+00FU00FU00FU00KY00KE00KE\n"
				       "+\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(!kachi);
  CPPUNIT_ASSERT(drops == 41);
}
void EnterKingTest::testDropsWhiteLessPoint()
{
  const NumEffectState state(CsaString(
					"P1 *  *  *  * +NY *  *  *  * \n"
					"P2 *  *  *  *  * -KI-GI *  * \n"
					"P3-UM *  *  *  * -KI-KE * +NY\n"
					"P4 *  *  *  *  * -FU-FU-FU * \n"
					"P5 *  * +RY+NY+GI *  *  *  * \n"
					"P6 *  *  *  * +FU+FU+FU+FU * \n"
					"P7+FU-FU-FU-FU-FU+GI+GI *  * \n"
					"P8-OU-TO-UM-TO-TO * +KI+OU * \n"
					"P9 *  * -RY *  * -KI * +KE * \n"
					"P-00FU00FU00FU00KY00KE00KE\n"
					"-\n").getInitialState());
  EnterKing Enter;
  int drops;
  bool kachi = Enter.canDeclareWin(state, drops);
  CPPUNIT_ASSERT(!kachi);
  CPPUNIT_ASSERT(drops == 41);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
