#include "osl/piece.h"
#include "osl/ptypeTraits.h"
#include <boost/static_assert.hpp>
#include <iostream>
#include <stdexcept>

namespace osl
{
  BOOST_STATIC_ASSERT(sizeof(Piece) == 4);
} // namespace osl

std::ostream& osl::operator<<(std::ostream& os,const Piece piece)
{
  if (piece.isPiece())
    os << "Piece(" << piece.owner() << "," << piece.ptype() 
	       << ",num=" << piece.number() 
	       << "," << piece.square() << ')';
  else if (piece == Piece::EMPTY())
    os << "PIECE_EMPTY";
  else if (piece == Piece::EDGE())
    os << "PIECE_EDGE";
  else
    os << "unkown piece?!";
  return os;
}

const osl::Piece osl::Piece::makeKing(Player owner, Square position)
{
  const int number = ((owner == BLACK)
		      ? (int)KingTraits<BLACK>::index
		      : (int)KingTraits<WHITE>::index);
  return Piece(owner, KING, number, position);
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
