/* ----- encode/857x3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_857x3_checksums[] = {
  "743e5116e742b3998cbce11a5e58019bdb9b81cf0d5df538d1ceb897c9804c6b",
  "2d4dcd2e56605c0e00dde04746a1199c739d1e7dd3e928a117533f0937270469",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_857x3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_857x3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_857x3_ITEMBYTES

static void *storage_encode_857x3_s;
static unsigned char *test_encode_857x3_s;
static void *storage_encode_857x3_x;
static unsigned char *test_encode_857x3_x;
static void *storage_encode_857x3_s2;
static unsigned char *test_encode_857x3_s2;
static void *storage_encode_857x3_x2;
static unsigned char *test_encode_857x3_x2;

#define precomputed_encode_857x3_NUM 4

static const unsigned char precomputed_encode_857x3_s[precomputed_encode_857x3_NUM][crypto_encode_STRBYTES] = {
  {228,78,117,7,7,13,127,223,106,62,129,14,86,24,153,68,93,148,140,220,42,207,149,142,57,16,45,253,99,71,168,75,160,166,186,56,70,95,79,211,113,77,156,142,96,208,77,113,138,240,38,48,235,128,44,136,125,75,99,174,5,254,164,17,16,111,90,112,31,97,251,67,68,171,252,223,58,241,171,107,143,194,57,87,45,213,107,213,68,181,95,14,126,84,225,117,157,99,83,180,194,140,48,180,180,167,204,213,127,193,212,114,46,91,197,88,203,144,100,154,92,201,1,144,104,213,213,162,193,44,85,220,248,195,79,44,70,215,217,11,18,22,13,9,139,8,225,129,223,231,161,166,216,115,104,154,173,2,148,84,138,208,151,12,127,67,59,194,177,44,201,145,137,236,69,22,91,233,182,252,3,32,132,185,108,129,93,212,79,74,111,213,184,100,89,160,98,169,5,119,150,167,134,165,197,102,163,78,152,184,193,23,146,246,19},
  {9,44,166,19,235,254,160,135,215,143,89,128,184,161,188,202,70,192,58,30,29,39,173,31,148,109,121,193,188,172,39,178,173,94,132,81,44,127,52,1,109,186,254,162,60,120,229,64,144,232,204,116,157,73,94,103,247,19,242,171,179,212,200,45,223,30,33,28,3,241,117,255,5,105,10,207,174,26,154,166,40,63,168,114,183,133,191,146,142,197,82,84,216,17,105,97,77,217,228,165,70,44,218,96,64,216,208,128,41,222,207,79,65,101,84,159,103,219,232,52,224,158,121,14,194,140,175,204,132,176,176,75,57,220,236,57,204,150,97,114,33,110,230,26,131,60,104,246,15,146,10,145,81,232,26,98,160,189,52,175,8,223,92,25,125,87,140,229,199,170,190,14,68,115,82,83,91,228,41,143,220,65,182,38,246,168,229,70,254,233,229,132,233,54,217,98,167,179,193,212,22,92,18,44,94,95,136,198,145,242,13,94,233,112,64},
  {91,89,139,131,65,249,32,65,69,127,71,20,144,75,196,246,42,136,186,92,82,221,247,59,188,201,214,233,61,191,117,240,143,41,76,196,208,203,5,200,170,196,55,120,227,251,115,65,156,88,55,206,0,74,94,250,197,41,124,144,79,196,15,184,74,133,254,33,51,216,3,39,14,187,100,55,143,197,130,182,80,80,79,88,154,147,216,2,89,109,65,106,32,106,2,15,192,0,230,181,164,70,25,2,208,35,20,17,114,203,199,70,195,79,32,26,206,42,225,173,142,152,21,158,20,148,189,193,20,199,251,99,132,69,216,17,218,144,105,254,20,92,14,48,164,210,75,83,36,4,173,237,66,32,93,51,255,33,101,87,138,8,83,162,174,230,197,8,46,52,175,180,182,101,139,107,106,147,206,44,236,59,174,147,223,186,50,92,204,50,216,26,192,202,129,194,114,28,83,89,129,197,64,241,160,143,75,177,19,195,147,86,193,20,247},
  {125,215,130,89,120,122,243,9,134,226,25,250,6,68,74,40,167,206,190,218,143,28,143,32,24,76,112,241,154,180,43,254,138,255,15,140,255,176,252,171,26,198,5,153,226,4,130,19,75,46,243,140,40,71,46,59,235,18,53,94,141,156,14,112,200,106,114,55,26,138,32,196,47,131,47,39,83,100,152,90,124,91,167,39,145,140,159,215,236,226,25,226,3,176,133,0,10,138,73,190,128,1,33,120,200,164,242,253,191,1,123,51,102,157,130,89,75,210,169,37,32,59,123,151,31,182,95,30,39,154,223,183,63,57,165,126,199,62,54,132,40,210,77,105,42,242,57,6,232,253,79,171,79,174,250,213,113,66,1,75,178,228,234,117,210,78,10,47,128,251,219,84,245,167,33,125,227,58,84,183,125,97,40,108,238,98,45,53,242,34,119,40,133,104,121,231,9,226,19,158,23,1,195,223,158,125,26,8,208,132,132,156,19,211,210},
} ;

static const unsigned char precomputed_encode_857x3_x[precomputed_encode_857x3_NUM][crypto_encode_ITEMS] = {
  {203,153,26,171,89,244,185,45,88,170,114,148,162,164,204,95,254,109,24,146,44,119,55,21,66,130,18,111,106,208,194,31,249,91,215,237,141,79,214,75,36,194,136,26,233,36,88,99,1,232,50,33,203,186,109,45,236,158,90,65,59,165,98,192,20,109,196,168,31,220,7,21,131,157,176,253,103,196,101,135,253,250,47,12,202,36,14,241,28,1,18,232,201,192,163,73,4,196,13,204,115,166,119,13,32,174,24,110,80,10,255,185,186,173,242,182,158,189,254,110,15,237,193,14,46,182,159,212,151,61,52,82,101,83,38,169,45,10,201,6,247,79,11,152,109,237,201,217,174,59,119,60,10,108,64,69,194,187,121,185,220,208,72,86,172,235,154,80,3,93,85,170,193,134,186,35,135,161,212,203,119,117,143,217,96,38,68,167,64,151,104,12,205,2,50,33,75,240,117,129,57,186,147,58,27,156,105,107,182,192,10,1,43,36,11,223,215,204,213,186,107,238,209,4,228,49,56,164,174,74,114,40,214,218,169,109,101,41,125,238,60,85,46,133,117,241,43,55,123,65,121,213,212,66,18,155,87,1,78,194,106,16,7,168,193,45,161,250,203,152,239,104,58,108,26,245,160,127,187,139,38,100,7,162,166,206,221,201,159,48,105,8,194,241,25,137,103,160,200,241,2,62,145,142,177,29,144,127,164,110,152,123,30,130,163,244,54,212,213,245,86,89,48,98,133,190,227,143,156,134,107,22,234,226,9,4,64,14,102,12,220,13,99,1,34,101,42,11,208,20,206,162,27,29,174,118,76,201,223,164,122,64,57,116,165,109,130,45,229,177,168,84,195,255,204,122,180,246,104,62,224,84,71,18,12,187,97,17,166,242,174,107,250,93,205,39,23,218,130,91,233,141,173,198,251,115,131,57,19,170,106,106,151,110,245,203,87,218,110,111,146,96,52,84,35,69,224,121,224,20,73,135,78,195,73,25,216,61,54,109,87,234,164,61,73,97,233,159,109,211,146,196,82,229,34,152,132,151,157,163,71,223,192,201,218,75,83,141,7,45,140,51,47,200,168,125,201,107,105,205,179,157,162,23,132,64,35,127,108,132,87,47,203,212,178,80,91,142,196,177,204,173,12,97,212,71,109,115,61,96,197,137,216,121,235,144,43,91,180,232,56,50,228,127,55,92,118,66,183,235,84,228,166,126,41,29,6,93,140,127,183,156,3,74,173,229,119,37,130,8,174,164,188,94,41,75,254,18,179,49,245,2,60,148,245,167,3,224,120,4,219,114,20,92,215,111,170,227,192,216,75,58,44,127,124,200,123,149,16,243,229,48,66,202,138,166,206,121,118,22,8,45,193,42,221,133,134,44,47,229,92,32,14,44,210,85,123,182,140,92,145,161,207,53,88,120,210,176,17,135,208,70,67,63,184,190,63,116,239,60,9,71,241,40,119,89,250,24,86,147,158,103,71,176,19,190,218,40,103,245,90,225,145,84,162,133,95,53,5,6,249,183,44,32,171,184,123,7,176,121,28,26,111,160,52,246,119,7,64,5,230,178,159,118,146,68,108,97,0,60,37,51,125,236,22,56,29,101,20,144,68,16,189,121,40,137,83,145,157,41,194,151,53,129,43,192,134,133,211,243,137,36,20,224,141,76,219,59,1,93,240,203,89,138,200,44,197,13,95,172,143,130,78,175,111,140,165,72,11,118,206,19,36,155,188,185,134,62,175,53,222,184,183,242,189,63,52,248,3,127,115,166,192,153,29,60,28,197,248,207,214,183,64,188,0,158,114,196,246,173,37,171,131,45,122,46,178,68,5,195,214,251,104,10,84,246,8,218,212,251,157,105,89,157,166,58,132,182,189,11,85,115,19,16,175,80,75,198,240,156,228,90,54,195,194,212,11,236,129,111,12,117,233,154,241,21,18},
  {212,28,239,126,3,189,134,130,125,101,128,165,130,83,167,42,66,25,231,114,213,37,240,117,231,161,66,239,182,135,206,246,190,73,78,239,194,238,148,150,196,200,134,179,67,186,92,21,243,60,0,142,4,206,65,224,243,33,159,156,149,28,51,89,245,155,209,238,83,214,204,12,185,191,31,173,173,171,39,156,8,200,134,209,222,185,1,228,4,177,253,239,186,40,11,67,167,110,218,13,100,129,215,193,56,127,151,210,212,246,4,130,127,150,169,192,139,3,100,134,206,153,222,71,165,198,46,179,180,193,146,26,153,44,20,206,155,249,75,176,8,97,203,131,11,207,113,230,102,61,233,81,107,161,107,9,0,3,150,229,132,225,41,14,41,131,87,123,73,124,91,127,193,11,54,240,231,124,21,131,143,89,179,4,84,27,117,86,83,26,219,2,135,61,132,250,251,34,117,171,191,230,202,226,199,170,75,248,128,42,114,212,140,10,144,245,65,226,24,219,166,59,52,137,226,224,128,181,74,57,9,88,121,153,56,249,154,163,83,36,46,172,84,125,223,0,146,90,79,189,27,58,248,184,168,10,210,178,251,189,1,46,93,117,216,233,169,139,123,187,178,185,90,133,0,253,244,78,27,235,96,52,151,138,150,129,185,18,164,155,174,31,8,127,225,132,249,155,173,66,78,119,173,50,33,254,40,135,193,49,240,81,89,83,18,254,41,106,120,148,67,132,244,181,54,165,146,140,111,17,114,10,57,197,89,25,90,62,205,137,128,248,201,193,34,26,70,246,41,249,131,88,221,203,151,171,156,193,73,129,237,36,48,14,187,85,223,228,235,254,50,118,160,51,41,167,64,173,82,12,132,210,68,80,12,163,58,27,148,36,202,43,99,111,167,0,236,1,238,82,145,68,145,189,127,118,120,100,13,74,157,34,151,77,212,96,203,60,35,128,75,146,255,40,75,44,20,29,187,120,225,38,172,130,210,212,109,103,136,144,238,95,157,177,114,34,16,204,108,40,122,245,204,245,139,111,207,100,30,35,94,55,189,93,110,9,228,1,126,94,129,170,147,200,214,90,59,57,232,181,211,66,55,25,189,15,69,172,148,188,114,118,13,107,240,220,221,116,124,72,255,142,80,180,174,131,250,12,143,214,173,123,203,225,90,217,63,167,4,57,63,187,203,66,250,147,71,1,100,212,63,225,79,242,55,172,211,173,65,136,128,73,100,84,223,166,8,50,233,106,27,120,148,254,188,115,45,136,205,240,232,37,41,219,109,95,7,255,25,62,72,116,141,210,175,124,70,250,144,188,39,220,93,34,71,63,221,104,105,34,31,71,66,90,89,146,105,145,253,15,157,102,244,5,24,129,78,217,124,132,103,100,239,169,52,43,145,181,214,124,213,18,231,214,67,118,59,78,28,199,83,248,95,84,203,118,138,204,154,176,203,118,73,70,174,203,47,7,27,3,226,195,100,156,87,122,244,65,19,100,150,183,141,87,31,118,224,141,192,184,63,244,190,5,178,162,221,74,145,193,77,59,47,1,97,102,180,94,211,39,172,39,238,96,131,26,213,226,202,176,178,131,200,103,14,218,77,159,55,182,48,162,8,199,23,153,102,17,193,194,67,141,113,32,4,234,60,106,217,214,23,171,249,130,229,250,121,198,209,220,183,67,101,225,96,224,255,147,81,144,50,77,81,74,67,28,232,235,96,184,40,2,118,244,23,146,81,127,52,152,24,38,25,138,238,7,236,218,55,207,33,19,210,246,170,138,40,72,158,212,247,84,164,126,5,6,79,84,26,81,149,107,220,43,59,135,131,138,121,65,64,53,111,206,191,73,153,124,104,208,206,199,90,234,15,249,48,189,101,151,95,31,128,11,141,87,21,186,130,10,244,217,142,178,181,157,94,248,64,69,60,138,135,53,32,15,63},
  {58,251,194,23,16,37,242,1,62,70,206,212,154,81,85,52,160,239,161,210,148,248,103,107,43,208,142,82,188,92,104,145,224,116,96,9,90,152,115,73,214,127,70,71,103,206,222,37,231,41,111,183,106,191,69,189,99,83,220,124,41,106,229,50,5,16,205,151,147,200,44,95,41,51,127,194,139,255,180,113,233,57,7,159,148,149,174,191,122,6,41,58,154,183,79,70,31,242,224,90,120,171,117,76,197,223,228,232,180,36,121,103,104,196,19,97,26,160,237,156,200,14,186,166,255,147,85,80,22,37,89,76,132,72,159,149,63,58,37,102,167,202,242,50,195,50,119,230,78,10,44,229,192,80,151,133,19,64,70,124,105,223,171,43,203,189,59,128,178,168,41,220,111,45,168,202,18,15,116,76,186,75,116,206,126,176,126,144,8,81,66,186,47,18,169,89,139,158,104,170,74,38,12,245,185,56,126,188,187,80,123,76,169,187,118,176,145,6,34,241,161,73,42,209,188,53,78,64,172,158,179,78,155,111,101,18,63,255,200,98,182,89,234,93,3,151,121,102,246,133,255,27,187,246,117,118,217,191,34,84,52,119,158,37,61,123,200,132,204,0,220,201,42,109,92,197,91,58,108,78,170,97,208,62,246,79,98,146,93,31,142,128,38,204,169,174,207,100,87,65,94,17,40,187,94,19,249,184,84,43,123,7,225,171,190,171,245,203,168,215,83,174,127,176,91,244,153,25,222,171,155,191,247,243,180,112,125,106,246,103,2,155,101,138,51,68,164,64,161,35,12,43,200,199,66,192,64,182,164,147,24,29,70,120,149,120,150,17,167,125,211,164,169,11,168,95,105,157,133,126,18,70,41,124,47,151,22,14,123,8,185,126,145,52,107,226,104,94,56,128,111,64,134,118,213,127,42,6,224,13,59,188,57,189,24,128,59,28,33,195,58,77,190,214,155,81,82,67,128,123,77,70,245,46,219,19,222,6,12,175,66,252,236,50,185,222,72,233,190,72,117,173,250,156,221,227,195,194,76,77,125,34,192,235,209,146,118,184,89,199,34,149,144,71,94,112,84,113,212,232,173,227,88,198,239,137,219,10,92,97,122,121,49,138,135,194,63,148,15,49,103,218,83,245,204,147,117,104,204,72,240,106,131,191,196,128,94,181,216,39,138,95,18,58,10,5,219,133,239,12,177,244,156,77,254,77,235,122,143,119,60,144,120,167,9,251,177,38,15,139,36,47,192,169,115,78,49,150,138,114,195,31,116,177,23,88,1,114,145,62,95,77,139,36,228,202,159,16,43,223,61,236,49,30,106,139,98,165,114,231,119,62,63,248,71,37,199,210,50,102,32,150,206,216,124,127,170,70,117,158,112,128,47,179,217,21,216,248,141,54,250,121,116,47,34,94,185,146,80,11,77,54,4,243,208,105,158,61,195,217,205,218,180,171,127,37,194,246,242,191,221,105,253,0,245,192,13,15,193,124,25,42,253,108,160,96,153,251,219,10,247,217,201,212,8,13,91,17,92,110,2,90,19,35,203,153,243,168,221,45,157,192,252,221,14,203,230,116,172,195,14,206,149,234,205,118,35,173,142,72,137,24,201,72,181,105,147,89,62,8,203,11,250,8,174,238,128,246,65,74,107,21,234,141,114,192,30,163,214,162,181,120,69,234,65,91,163,216,63,174,21,211,163,189,198,26,209,183,219,158,47,141,6,127,77,150,74,138,99,90,82,194,17,181,117,169,136,133,149,185,137,221,191,190,77,168,175,129,255,110,53,223,170,173,218,44,132,120,194,182,68,18,130,2,56,150,210,167,191,143,35,183,216,229,3,100,3,30,169,177,130,146,31,14,122,119,218,80,48,211,250,169,102,206,126,181,54,230,18,110,66,59,229,95,165,99,69,210,232,201,110,226,11,161,139,42,246},
  {240,254,8,155,170,126,94,20,189,104,137,209,36,168,164,60,155,50,76,124,65,61,31,164,114,103,205,19,4,52,62,4,1,144,83,207,9,189,97,122,252,58,222,160,153,219,14,251,105,50,112,2,55,166,190,73,245,0,44,157,27,74,121,20,194,220,182,235,141,227,110,98,53,221,180,218,209,121,245,54,186,56,34,2,59,183,27,76,142,51,250,221,127,171,194,2,191,101,111,82,227,181,212,8,43,32,243,165,60,88,112,44,217,147,254,81,247,130,10,211,210,209,240,219,93,27,182,58,153,27,179,196,22,157,98,96,178,146,240,87,119,104,122,142,122,132,214,71,239,91,132,115,23,20,52,156,182,84,69,8,141,34,51,146,89,66,153,10,112,180,87,100,92,14,87,113,45,232,24,233,243,23,142,98,197,66,66,205,138,241,231,168,86,28,95,121,213,161,212,213,194,211,145,90,3,173,168,164,139,66,76,246,54,31,28,254,85,245,171,216,174,42,45,135,106,255,7,155,137,65,59,90,184,82,118,22,109,11,187,199,48,230,159,154,99,137,196,66,1,122,125,188,223,123,13,218,179,220,65,193,161,173,36,122,89,181,59,221,202,242,49,161,29,122,140,228,161,93,146,48,31,135,169,60,239,212,7,27,122,192,74,79,238,80,40,174,170,120,113,213,34,176,195,243,194,71,222,25,67,103,87,155,51,68,156,25,205,26,57,121,231,216,226,159,118,156,2,148,194,8,67,193,6,3,136,61,224,175,150,197,187,143,100,84,154,168,129,44,58,142,193,204,35,249,253,31,225,7,141,139,56,27,186,134,73,197,207,77,170,197,83,35,199,5,192,234,220,221,238,4,31,247,187,52,125,126,16,157,217,123,175,166,104,203,2,197,101,181,51,168,63,223,11,31,80,139,75,30,104,97,26,93,251,34,42,232,207,225,134,107,231,182,9,36,141,168,131,205,24,220,82,44,122,140,40,229,224,39,99,116,82,197,156,136,162,43,145,70,61,237,90,106,140,127,212,194,1,63,99,120,204,226,47,51,42,99,196,152,233,233,215,46,60,10,95,152,96,76,228,180,7,169,26,30,222,210,4,54,82,5,80,91,210,172,96,171,30,167,249,150,33,64,208,57,10,244,159,253,145,206,240,60,82,16,184,43,217,19,42,126,166,13,67,238,190,245,253,172,194,170,160,178,184,111,99,117,180,71,92,127,53,217,33,198,70,23,141,4,201,64,142,185,21,179,16,4,15,224,6,5,27,10,145,114,65,179,63,102,196,189,220,178,44,186,216,22,97,249,77,211,81,243,68,177,56,115,142,132,141,21,165,78,255,53,156,0,164,37,131,181,34,78,74,104,46,98,130,38,78,75,160,2,41,220,240,191,205,110,218,158,152,166,81,65,92,220,197,52,125,24,245,163,8,253,39,69,226,89,15,119,97,107,197,156,123,221,106,144,73,59,94,238,132,3,9,184,173,24,67,1,97,86,108,62,197,200,217,109,58,160,102,43,183,145,123,90,114,133,186,254,42,67,173,202,87,78,143,10,116,199,149,179,78,185,186,162,124,12,118,175,220,15,201,190,122,249,207,205,85,0,93,3,7,154,197,109,98,16,232,125,216,252,130,105,212,42,249,156,171,198,49,60,255,170,199,148,85,37,135,29,177,83,197,47,68,105,27,65,0,32,22,140,93,192,24,183,113,187,35,205,250,154,8,65,71,7,111,130,36,39,83,149,95,137,129,186,0,245,213,128,30,241,111,163,188,58,237,13,25,113,171,24,34,223,6,195,21,145,211,183,146,104,125,43,180,22,222,247,226,159,241,128,198,145,208,138,241,74,231,183,112,118,174,128,233,219,3,249,243,72,146,226,155,8,120,241,139,133,13,191,227,219,246,18,155,123,176,231,134,198,182,15,18,155,196,15,209},
} ;

static void test_encode_857x3_impl(long long impl)
{
  unsigned char *s = test_encode_857x3_s;
  unsigned char *x = test_encode_857x3_x;
  unsigned char *s2 = test_encode_857x3_s2;
  unsigned char *x2 = test_encode_857x3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_857x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_857x3(impl);
    printf("encode_857x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x3_implementation(impl),ntruprime_dispatch_encode_857x3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_857x3;
    printf("encode_857x3 selected implementation %s compiler %s\n",ntruprime_encode_857x3_implementation(),ntruprime_encode_857x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_857x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_857x3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_857x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_857x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_857x3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_857x3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_857x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x3")) return;
  storage_encode_857x3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_857x3_s = aligned(storage_encode_857x3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_857x3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_857x3_x = aligned(storage_encode_857x3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_857x3_s2 = callocplus(maxalloc);
  test_encode_857x3_s2 = aligned(storage_encode_857x3_s2,crypto_encode_STRBYTES);
  storage_encode_857x3_x2 = callocplus(maxalloc);
  test_encode_857x3_x2 = aligned(storage_encode_857x3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_857x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_857x3();++impl)
      forked(test_encode_857x3_impl,impl);
    ++test_encode_857x3_s;
    ++test_encode_857x3_x;
    ++test_encode_857x3_s2;
    ++test_encode_857x3_x2;
  }
  free(storage_encode_857x3_x2);
  free(storage_encode_857x3_s2);
  free(storage_encode_857x3_x);
  free(storage_encode_857x3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

