/* ----- core/scale3sntrup953, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup953_checksums[] = {
  "8314ddeee37405ec4052b6a273321eadef8a41e2037942e57799265898c5d69a",
  "0e9ac7e49118ea8c87983e80587ad9b42cb117dab2e807d78f8589c447c44fdb",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup953_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup953_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup953_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup953_CONSTBYTES

static void *storage_core_scale3sntrup953_h;
static unsigned char *test_core_scale3sntrup953_h;
static void *storage_core_scale3sntrup953_n;
static unsigned char *test_core_scale3sntrup953_n;
static void *storage_core_scale3sntrup953_k;
static unsigned char *test_core_scale3sntrup953_k;
static void *storage_core_scale3sntrup953_c;
static unsigned char *test_core_scale3sntrup953_c;
static void *storage_core_scale3sntrup953_h2;
static unsigned char *test_core_scale3sntrup953_h2;
static void *storage_core_scale3sntrup953_n2;
static unsigned char *test_core_scale3sntrup953_n2;
static void *storage_core_scale3sntrup953_k2;
static unsigned char *test_core_scale3sntrup953_k2;
static void *storage_core_scale3sntrup953_c2;
static unsigned char *test_core_scale3sntrup953_c2;

#define precomputed_core_scale3sntrup953_NUM 4

static const unsigned char precomputed_core_scale3sntrup953_h[precomputed_core_scale3sntrup953_NUM][crypto_core_OUTPUTBYTES] = {
  {181,207,215,253,239,185,150,82,217,9,136,40,40,187,12,211,84,58,151,179,162,31,65,109,247,253,136,24,117,47,77,112,20,21,157,215,37,246,122,9,23,113,216,57,174,105,146,63,133,200,12,219,220,201,102,235,72,230,46,234,0,232,21,169,109,50,154,72,247,168,136,5,160,253,20,86,17,219,25,80,143,94,172,1,2,59,51,249,77,209,111,237,180,9,211,230,224,19,46,6,138,31,167,60,73,101,18,235,200,83,175,215,201,53,10,69,36,0,34,245,71,70,38,6,208,222,12,1,88,194,163,247,26,0,69,255,116,185,52,246,150,194,48,5,43,202,109,178,104,31,15,22,196,5,109,11,238,223,178,29,157,9,126,234,210,20,83,6,139,254,17,187,195,211,218,7,59,185,151,39,39,5,222,172,34,252,72,12,245,185,59,200,199,188,246,222,116,87,152,0,148,208,219,60,114,173,242,234,237,192,105,50,250,113,222,87,212,62,14,223,194,75,225,247,224,33,69,6,233,100,9,248,54,102,12,174,173,243,236,39,33,52,147,183,64,249,157,193,162,233,222,250,114,208,215,169,98,227,40,214,228,75,33,28,137,45,249,108,241,177,203,185,24,177,195,181,151,237,247,244,144,190,117,113,211,204,163,112,221,24,61,255,217,11,149,60,29,197,179,81,55,1,11,10,14,45,35,89,100,255,165,91,48,99,99,52,40,252,157,234,13,182,27,100,16,71,19,64,15,10,144,2,180,8,221,223,119,225,5,4,73,177,100,47,65,2,198,242,124,68,199,47,83,18,189,233,117,201,150,194,60,40,176,186,111,191,151,2,120,252,109,245,227,103,199,221,177,178,83,75,60,1,178,44,249,2,66,21,177,243,231,104,48,205,63,203,223,203,140,82,170,45,104,218,96,205,226,229,58,240,197,177,5,219,171,171,221,247,161,9,255,181,53,223,121,254,20,71,53,246,33,99,89,100,8,16,139,204,159,187,52,112,236,245,162,240,237,181,24,88,132,213,131,230,192,243,34,18,59,65,47,54,151,248,205,33,118,111,42,114,174,195,41,55,149,7,157,168,243,185,213,210,10,177,65,224,201,11,38,81,120,224,90,110,138,98,249,104,246,10,159,101,216,229,13,1,90,0,182,208,219,16,17,0,26,219,119,55,183,251,214,255,15,175,105,207,133,95,58,76,238,220,37,246,149,247,21,27,114,30,5,51,69,30,73,12,157,64,136,5,137,115,27,66,174,26,6,100,152,32,60,165,166,27,59,18,31,248,58,105,111,93,187,198,20,173,168,216,209,169,24,47,106,7,117,25,68,4,178,1,106,29,132,229,49,6,18,253,2,245,26,241,106,52,65,79,111,197,61,165,124,250,190,1,101,8,230,73,159,5,22,79,45,215,144,190,208,85,51,181,53,239,232,243,206,7,210,11,111,82,193,219,75,249,255,254,94,8,38,92,36,255,184,193,57,243,156,0,62,94,138,223,150,113,100,101,172,105,145,57,56,51,129,59,133,240,38,241,76,5,51,252,204,30,247,47,67,221,182,171,21,5,213,109,125,65,49,90,199,227,237,2,133,77,227,243,193,60,165,12,94,210,224,80,218,254,43,114,45,236,95,110,100,244,159,226,188,86,232,244,219,245,13,183,118,242,52,105,99,252,142,1,68,109,165,249,100,0,120,254,242,219,14,12,206,167,225,3,106,218,107,248,53,167,32,1,132,206,60,171,111,58,139,3,126,6,117,8,32,48,169,65,144,211,47,176,143,18,174,4,228,250,196,0,188,207,38,8,17,43,234,5,126,93,74,21,51,215,43,220,51,215,180,17,193,235,202,182,238,40,204,2,51,205,38,203,208,250,121,42,188,253,56,42,228,173,21,36,154,181,226,105,110,192,15,8,150,204,175,4,37,0,133,223,255,230,144,243,2,98,107,6,205,240,96,63,113,245,8,200,254,95,153,246,86,18,136,44,163,110,4,74,16,111,223,30,240,217,83,11,37,172,173,248,173,5,43,10,65,243,127,16,151,246,5,177,38,173,189,32,166,171,69,200,46,59,136,33,127,110,179,105,55,1,68,166,43,252,13,8,254,10,100,254,68,44,50,1,66,174,128,85,45,17,16,92,111,233,17,114,66,99,8,241,145,11,197,86,75,28,219,246,9,16,151,61,103,245,103,224,12,81,7,110,169,62,8,1,61,176,17,207,228,243,166,82,253,46,75,234,255,101,230,0,61,183,231,0,70,37,130,109,3,16,137,1,53,85,137,11,211,18,24,88,140,101,41,181,46,7,242,173,199,222,176,78,11,251,88,201,25,24,82,94,111,7,1,39,24,188,220,49,161,75,15,97,55,114,15,35,41,252,117,220,17,1,39,176,251,6,23,248,229,1,16,7,182,193,235,214,232,23,160,99,114,247,235,34,118,194,208,103,86,74,209,252,73,167,213,62,63,79,197,245,111,245,14,198,251,6,230,74,218,168,98,167,82,215,41,78,181,220,101,187,109,91,234,11,173,187,195,247,20,247,101,213,76,32,217,245,218,23,178,222,79,12,63,186,154,253,215,21,90,103,80,250,224,249,55,91,88,214,42,5,113,42,244,9,55,184,227,1,11,115,38,91,103,27,37,74,17,249,238,42,79,9,86,242,128,11,3,3,78,18,174,250,85,6,61,115,177,182,23,49,209,43,55,48,52,4,135,193,235,114,170,236,45,180,174,29,234,251,156,248,154,86,99,252,75,185,37,4,37,0,104,114,162,255,87,8,161,49,85,33,84,0,176,245,62,204,35,174,1,246,181,91,3,52,152,58,99,245,140,15,122,196,57,12,14,182,244,248,195,78,101,90,185,76,199,4,8,5,36,255,35,182,63,11,64,248,5,50,33,78,251,40,9,251,223,5,73,38,20,250,152,250,2,115,101,234,29,249,187,182,172,47,39,46,242,191,247,97,0,4,131,252,129,224,21,249,57,28,228,11,70,87,91,207,82,233,95,209,231,73,250,233,245,233,214,205,184,71,141,254,31,218,152,113,244,2,47,57,83,84,32,8,4,107,45,247,132,95,99,170,150,222,113,239,9,12,248,243,130,16,79,237,44,105,240,229,229,49,175,111,209,51,103,52,253,111,91,44,20,9,150,213,43,227,200,39,51,177,24,169,63,64,56,79,224,108,0,233,129,58,218,225,102,5,40,171,181,5,30,87,164,78,32,64,104,97,81,208,89,0,13,220,113,201,213,244,145,246,62,57,216,95,177,218,195,15,82,101,49,48,49,185,152,245,63,29,99,21,219,243,191,45,21,166,173,187,61,14,254,38,95,178,222,166,55,33,228,21,174,247,224,0,210,56,157,54,32,99,131,244,17,193,231,11,19,4,150,188,214,47,195,41,196,166,251,185,233,175,166,4,21,112,59,11,144,253,173,44,97,168,94,250,107,176,86,9,153,3,97,5,39,4,42,220,14,73,57,114,207,165,231,244,124,65,28,247,82,53,58,174,217,91,198,255,181,198,144,0,5,51,117,48,4,247,95,192,212,10,235,234,71,223,156,198,181,187,81,45,215,200,9,65,186,96,44,105,121,82,123,178,208,12,115,1,210,186,88,199,42,76,160,169,153,202,64,11,215,197,212,39,32,44,6,42,61,82,20,35,27,3,62,99,146,236,12,53,29,203,214,253,97,252,171,75,45,178,139,5,89,98,240,111,125,225,163,253,140,252,157,106,161,52,174,8,158,198,19,60,187,93,164,67,208,82,86,6,116,59,165,252,120,252,123,12,247,35,184,9,48,203,7,201,173,237,130,43,15,8,86,255,141,29,235,42,120,109,247,8,50,166,167,70,32,100,1,39,85,11,140,222,221,108,81,244,123,253,69,254,141,61,37,179,129,111,122,3,9,168,145,167,38,40,125,3,86,251,48,250,61,231,201,57,212,56,148,68,56,102,191,11,222,34,61,205,155,197,93,243,71,85,243,250,244,6,126,103,31,243,107,102,210,9,199,203,165,7,222,250,64,87,11,197,244,181,164,114,115,21,161,21,56,41,208,243,183,41,251,247,153,4,72,252,167,249,247,66,111,245,122,1,39,109,143,80,113,30,146,171,223,60,179,167,137,215,23,172,183,175,151,26,235,78,187,188,166,93,138,230,162,39,27,10,96,216,241,1,114,9,223,83,144,87,123,242,181,28,148,217,128,13,218,31,187,9,137,4,239,177,99,169,52,218,50,198,229,4,236,6,170,177,8,47,217,225,137,245,186,0,65,184,167,252,72,115,107,197,203,247,151,253,82,113},
  {101,202,208,196,195,6,232,231,237,7,159,243,169,103,243,102,96,254,122,3,0,209,214,93,134,251,201,168,55,218,179,0,169,211,46,7,222,245,176,192,244,0,133,246,78,97,84,199,213,94,209,209,123,251,77,76,164,107,146,3,100,38,140,211,182,9,192,204,180,40,77,34,32,245,143,249,223,67,143,28,126,253,211,82,9,3,141,6,82,99,79,9,148,76,172,10,171,49,199,21,251,111,84,72,251,73,84,248,46,35,52,3,123,107,213,66,165,254,127,78,135,248,194,242,204,57,18,249,203,86,72,1,151,96,152,176,111,219,71,180,70,102,254,207,142,252,224,80,45,232,26,247,115,48,61,38,205,11,4,105,94,102,217,201,118,23,76,6,77,81,197,93,238,58,120,96,5,239,168,113,119,166,191,51,144,80,255,201,236,68,145,11,99,198,115,250,174,101,54,203,137,3,155,236,217,47,136,88,49,112,71,233,2,218,15,45,105,205,5,1,216,23,192,78,252,44,147,3,179,5,220,2,169,74,71,41,166,11,109,49,3,81,185,112,144,14,239,74,255,50,14,254,163,181,167,82,119,169,6,98,252,94,199,8,127,83,4,62,174,5,134,254,198,7,114,114,110,94,118,91,212,254,173,197,131,207,53,89,9,11,60,16,32,26,18,224,15,12,245,96,106,222,152,20,164,173,205,96,203,249,26,85,28,88,215,12,185,26,23,95,159,7,134,223,74,244,41,253,86,253,234,214,178,216,52,45,137,252,247,58,32,10,246,186,109,59,7,35,70,6,231,101,31,70,162,36,136,231,57,65,82,167,57,204,55,25,166,251,230,182,58,113,151,173,64,204,169,245,2,61,228,106,52,31,171,21,52,203,28,209,224,249,204,101,194,222,137,53,154,232,249,55,67,11,144,197,69,6,2,4,175,241,241,214,90,195,198,183,60,210,148,57,189,195,170,102,44,254,18,216,169,183,218,218,182,253,251,12,33,7,145,9,184,0,232,8,12,78,38,62,15,191,204,75,191,40,49,16,14,101,122,66,123,170,133,180,34,209,194,50,172,2,121,36,77,168,126,113,134,254,87,1,127,80,140,93,45,3,157,96,126,200,244,36,81,182,252,27,255,255,138,11,193,46,195,28,119,97,134,102,27,21,59,220,5,204,248,248,241,39,46,240,162,88,194,76,80,2,92,38,228,187,145,246,64,209,132,0,176,47,159,70,148,244,179,60,65,22,1,221,233,254,182,23,68,253,238,247,33,108,129,9,73,227,236,1,183,181,88,213,154,182,118,221,182,190,182,7,1,248,88,247,249,37,187,6,208,242,115,44,234,206,2,239,59,217,222,247,29,186,115,104,18,249,34,25,31,111,1,61,64,214,104,45,202,109,89,87,110,186,135,4,69,188,85,228,23,88,50,175,196,253,110,212,70,192,27,99,64,30,54,251,45,40,125,71,29,254,169,23,133,20,242,225,214,39,175,245,66,47,189,168,80,20,141,105,18,255,120,185,84,210,198,167,29,82,220,86,242,18,115,72,239,16,109,228,12,201,216,251,181,56,224,182,219,101,105,31,217,10,108,0,151,246,245,104,2,251,240,90,59,81,45,41,138,15,101,104,157,255,119,179,180,2,0,5,131,32,247,7,191,254,19,110,76,236,166,255,19,249,35,192,223,113,196,231,12,78,154,205,57,252,195,201,122,39,109,64,41,75,45,227,69,229,248,254,107,180,94,241,105,175,187,63,232,229,91,248,210,99,226,27,46,1,73,12,152,100,85,250,240,20,102,8,38,34,162,10,127,244,180,174,137,80,12,236,79,87,101,28,59,15,146,248,40,33,67,38,19,29,121,248,159,15,19,86,64,63,49,101,206,88,130,84,68,244,148,10,123,196,249,56,234,62,8,252,181,243,240,10,63,21,185,112,49,209,145,176,97,95,150,115,186,16,45,87,109,200,150,77,203,209,206,100,4,110,118,115,194,9,168,2,26,84,95,176,237,61,175,108,201,5,68,67,190,69,95,10,180,254,170,10,225,34,209,176,90,10,66,53,236,244,214,191,209,217,71,115,120,87,239,72,223,243,86,6,107,6,140,4,222,20,139,81,22,37,14,167,14,80,53,179,182,227,221,35,75,239,107,1,174,109,93,24,7,0,115,254,100,65,144,114,85,77,79,92,214,223,218,253,168,249,174,255,242,192,13,8,41,191,192,104,25,90,26,223,49,7,201,234,48,237,202,255,81,85,140,246,135,82,249,243,170,226,13,63,88,167,149,16,19,189,55,1,182,234,234,62,19,12,171,215,98,199,188,196,242,26,255,188,57,213,8,39,252,61,22,184,75,173,78,192,210,203,190,70,144,109,137,3,130,69,9,8,202,0,115,36,43,6,69,220,71,236,43,217,134,234,31,109,163,113,58,107,5,246,22,182,166,33,69,25,48,25,59,225,227,107,155,113,163,5,125,18,75,39,88,46,171,97,157,199,88,188,62,193,235,68,131,234,41,205,57,244,131,245,21,255,5,208,67,53,124,186,107,76,59,30,131,239,238,221,73,28,119,8,188,218,143,52,154,9,202,45,91,181,93,3,113,244,209,91,148,16,70,167,166,3,113,95,106,172,83,210,182,181,22,204,232,240,140,199,169,94,157,60,148,214,17,1,137,35,151,103,41,18,91,27,33,35,7,5,118,232,115,4,230,172,79,95,239,215,190,250,185,9,201,252,172,9,212,211,81,26,29,81,232,206,180,85,226,251,215,75,213,57,116,218,37,53,173,26,53,203,10,58,117,226,30,6,173,107,208,238,215,72,113,198,120,88,154,207,22,49,230,197,210,85,92,17,184,14,136,220,180,97,196,173,152,202,219,6,240,74,151,69,73,240,31,37,161,244,192,59,154,34,61,7,22,232,32,3,202,10,221,213,7,34,215,97,46,240,126,8,110,230,65,171,54,226,120,7,234,238,215,41,214,48,59,249,47,95,176,244,102,72,57,238,6,14,203,179,218,91,55,88,197,250,107,83,191,226,122,104,195,0,58,248,131,205,93,185,177,180,209,7,191,244,85,255,40,254,231,255,205,66,219,166,123,107,136,109,111,232,111,62,196,60,233,11,152,32,58,114,28,25,154,222,206,196,32,39,53,46,255,11,221,68,65,61,77,226,63,193,71,254,28,6,139,73,111,28,135,13,229,20,202,3,43,55,167,201,152,78,32,4,179,8,66,115,93,254,207,202,92,71,67,40,39,237,207,52,162,89,234,249,51,9,234,57,195,80,126,36,224,191,192,40,28,199,18,57,71,240,38,49,41,232,158,21,17,46,38,172,42,252,55,104,40,255,62,165,133,35,148,253,153,18,199,212,212,14,214,8,177,106,182,198,150,253,29,221,34,86,67,51,237,250,108,226,98,8,231,249,133,61,101,246,92,253,100,227,92,61,206,99,174,96,20,54,159,61,22,171,45,11,211,79,40,174,83,43,55,0,45,17,125,7,87,33,229,193,190,46,180,245,60,188,97,246,248,246,47,1,184,91,222,60,92,197,6,12,58,45,82,37,126,57,144,67,115,205,124,25,42,220,88,72,249,224,255,191,1,86,218,248,247,199,79,186,116,2,77,63,113,61,83,74,120,105,83,59,167,248,135,213,7,5,28,12,248,255,67,250,31,221,222,105,221,224,71,179,68,48,226,3,153,8,67,237,237,52,171,20,220,192,10,55,240,74,17,191,3,54,30,250,162,246,135,48,4,252,185,174,196,34,80,183,31,83,117,196,166,13,28,252,58,220,60,115,84,6,83,85,46,172,175,176,166,39,222,5,144,195,79,178,124,253,27,6,251,4,234,84,73,64,47,1,50,37,206,12,159,169,173,243,166,1,109,33,209,221,159,247,69,0,31,47,86,193,228,255,208,21,224,241,103,188,120,172,74,26,91,181,175,166,202,209,219,10,113,84,48,8,223,197,190,7,23,237,164,255,74,14,68,12,84,108,104,172,210,201,137,65,99,19,101,173,12,178,96,89,24,253,84,175,237,214,183,34,153,241,155,235,214,233,126,68,174,229,29,250,64,33,217,245,121,233,176,106,216,190,227,87,121,236,116,47,57,246,192,254,187,207,209,7,96,86,225,178,91,214,98,240,85,248,115,185,112,97,4,181,40,12,184,19,70,178,244,18,169,251,220,245,120,76,250,208,126,3,232,249,140,2,177,229,167,25,57,0,221,11,30,114,150,11,22,1,3,225,208,25,231,235,201,246,12,10,56,11,96,108,145,104,10,11,149,34,29,197,62,68,76,64,15,169},
  {34,249,25,3,217,15,174,11,182,75,10,28,174,4,205,3,172,66,132,14,113,11,126,62,122,222,24,253,228,113,185,54,20,181,129,5,145,215,218,88,17,253,49,86,233,188,171,30,121,249,141,202,227,44,118,50,92,2,140,99,113,97,209,2,99,255,130,100,188,74,180,45,25,2,214,95,176,229,224,55,170,19,161,246,252,54,102,249,165,14,192,218,37,242,118,226,163,41,31,5,250,32,211,85,230,63,57,194,125,50,214,252,167,217,102,0,230,177,187,244,111,193,50,226,138,200,202,104,35,247,184,0,86,9,164,54,50,247,52,235,192,100,15,226,196,84,131,244,62,255,92,96,203,17,145,37,123,16,103,217,226,39,100,193,188,2,208,20,201,25,171,214,247,52,52,6,59,183,4,254,69,109,211,247,11,6,21,72,145,170,255,11,236,2,184,11,251,29,218,3,13,204,149,5,162,231,204,173,75,229,92,88,53,215,159,13,202,244,220,202,62,93,235,180,138,248,84,18,214,8,11,105,128,67,193,18,77,252,160,0,170,250,21,172,117,51,214,43,234,95,30,253,188,44,2,43,172,20,2,208,233,233,48,207,77,233,254,110,249,10,125,71,34,85,167,22,92,66,140,255,158,101,86,0,102,41,236,103,138,44,22,249,81,89,131,222,86,208,69,25,176,181,181,11,184,0,54,239,165,200,254,2,163,223,201,35,148,15,244,5,44,54,197,240,14,246,104,251,25,11,57,19,195,55,201,234,189,7,202,84,123,235,79,249,166,168,161,74,218,104,144,34,205,237,159,203,247,52,91,90,217,210,87,10,39,57,40,1,227,193,231,4,155,84,168,179,111,5,119,4,229,46,116,208,152,78,29,174,243,189,125,21,246,225,39,47,194,98,226,26,220,252,242,184,1,197,74,12,63,193,67,11,78,58,91,95,81,212,201,91,58,1,161,212,11,9,63,234,166,248,113,29,222,1,230,212,128,38,137,78,215,234,230,46,166,176,255,73,125,176,233,251,68,0,4,186,160,245,145,82,4,42,15,191,182,194,31,210,145,10,45,245,216,218,54,213,6,180,6,82,238,75,195,60,72,40,167,206,111,246,25,79,222,252,3,12,157,15,14,5,231,72,91,94,232,20,117,215,151,4,27,74,53,107,179,219,74,204,113,250,22,254,204,5,162,209,106,11,116,185,141,0,68,255,193,9,16,83,165,172,117,211,13,12,210,205,29,47,214,101,186,9,32,0,145,96,150,210,60,8,98,85,179,11,253,106,58,29,115,11,176,1,173,68,182,5,21,240,115,186,238,240,13,76,164,113,205,6,56,58,172,199,102,40,24,82,138,255,195,4,198,71,217,213,153,19,113,9,28,9,155,37,177,25,125,251,180,247,176,18,170,15,209,219,170,48,138,39,183,94,227,186,169,244,161,111,182,79,72,244,226,251,27,84,244,5,54,180,109,37,180,51,169,205,105,60,145,198,205,96,25,13,45,48,14,241,125,52,246,233,236,7,193,11,86,22,233,185,29,31,166,244,104,8,242,245,143,223,34,94,101,86,79,55,27,207,39,48,193,253,149,255,115,1,89,174,242,90,94,6,0,177,152,241,165,249,212,41,187,2,208,92,51,74,10,177,228,240,145,174,153,103,98,1,244,186,144,53,254,177,176,73,205,11,169,5,174,214,186,253,24,60,17,255,211,1,43,246,206,238,33,252,54,14,109,100,42,51,197,245,129,191,73,11,168,10,104,249,19,110,92,76,66,194,36,245,111,28,87,8,222,108,90,5,164,195,23,226,184,33,82,108,3,20,79,114,115,115,236,247,137,229,245,91,209,224,137,5,26,111,54,101,60,75,99,83,208,94,69,40,177,220,127,20,123,21,60,233,46,224,181,202,134,107,186,253,245,86,138,45,224,255,31,20,111,9,183,31,79,40,137,9,226,114,250,88,79,61,11,34,231,25,57,255,221,88,248,94,65,210,122,47,44,0,40,83,173,239,127,216,14,21,226,10,80,196,22,10,78,14,73,33,84,3,71,51,30,207,172,243,197,177,54,202,155,249,79,90,36,41,177,10,109,25,84,1,61,171,56,9,66,225,233,64,190,11,49,8,196,96,217,21,224,200,87,234,154,228,211,183,191,98,189,108,186,2,25,230,219,248,206,167,120,192,41,94,13,68,92,53,28,7,209,85,45,85,98,238,72,69,74,165,149,187,124,46,46,237,17,251,25,66,60,246,216,36,176,36,72,247,50,110,26,97,114,22,102,181,250,0,146,74,137,199,59,25,37,187,245,53,112,46,60,203,173,0,133,247,205,113,62,15,207,1,166,83,207,4,160,246,54,249,100,246,27,44,255,69,181,198,129,11,177,93,63,243,77,49,41,9,184,76,136,243,176,35,115,9,191,180,255,17,21,77,228,1,24,1,157,175,47,225,199,191,128,254,19,0,169,171,119,45,42,3,255,193,125,11,165,235,26,29,66,94,47,206,166,36,119,84,55,245,65,239,123,182,146,1,14,8,172,186,59,14,156,244,25,4,86,223,188,245,109,252,127,7,215,166,192,247,84,209,157,99,15,81,125,108,238,212,83,106,137,222,181,206,1,48,209,0,54,250,148,7,246,71,130,4,0,252,194,240,189,238,244,32,204,79,196,79,9,56,145,252,241,193,196,95,177,214,127,41,229,0,10,248,145,197,156,85,139,184,147,10,225,72,182,93,1,196,62,251,130,250,93,2,60,249,224,57,232,5,156,165,69,15,221,52,159,223,134,214,82,96,197,250,98,225,146,12,74,57,88,245,185,76,8,231,50,11,19,77,66,27,137,3,165,236,168,254,203,5,201,191,110,169,27,166,72,186,156,85,154,85,8,224,60,0,145,254,120,167,65,252,156,203,178,108,254,178,17,102,28,247,36,218,251,76,178,205,215,248,141,250,115,39,126,178,172,181,200,0,182,5,203,231,139,248,125,98,232,61,107,205,60,51,252,6,61,227,209,73,89,210,159,55,253,63,94,191,239,211,180,255,174,99,153,235,203,201,195,114,26,51,29,189,184,89,34,85,102,45,250,232,116,219,99,184,199,244,251,204,58,66,148,245,252,58,31,220,233,254,71,203,67,235,221,230,86,193,143,88,134,225,212,58,214,0,169,103,113,170,130,64,147,85,241,252,118,74,35,90,250,253,122,101,177,88,248,84,177,181,74,70,54,60,10,255,16,211,239,252,59,58,26,52,198,13,22,56,0,32,64,236,20,71,51,67,180,8,218,75,225,46,132,225,243,233,72,91,112,40,139,67,244,201,115,170,152,57,157,27,83,48,19,53,208,108,39,254,105,244,255,80,174,247,93,51,150,196,119,45,199,193,112,200,179,210,37,0,249,181,204,108,81,70,71,254,75,193,183,253,250,51,219,206,8,251,158,244,215,191,4,253,19,2,39,109,185,31,139,10,201,171,203,4,69,42,133,194,224,34,186,252,24,209,171,229,20,18,251,93,233,246,82,251,182,80,84,186,67,78,185,64,208,213,196,110,248,186,229,250,106,1,238,85,59,215,152,91,25,85,60,178,97,10,219,99,48,232,127,250,162,14,168,53,32,26,148,50,169,245,140,1,72,65,4,6,144,236,9,198,102,214,114,36,41,253,246,179,188,186,137,4,228,61,168,246,240,216,67,43,206,239,210,237,29,9,100,1,242,2,50,230,123,190,165,194,97,245,194,77,255,4,91,247,186,251,117,179,29,169,64,0,249,112,104,99,206,177,165,7,34,15,108,232,137,55,87,194,182,5,243,165,6,179,11,183,177,108,103,92,64,103,32,166,125,43,111,27,130,5,194,18,204,178,15,232,62,56,134,53,217,51,149,85,163,54,76,244,35,234,176,76,231,71,22,242,55,188,5,95,191,110,5,194,59,191,114,27,155,72,199,174,65,10,131,99,14,212,77,249,226,11,234,36,186,247,36,198,170,226,42,59,62,254,155,237,154,48,222,32,255,43,67,58,170,6,37,67,226,194,241,206,184,78,243,222,131,40,189,40,66,192,1,248,180,201,228,214,83,103,80,251,71,86,203,2,74,247,55,53,16,5,235,41,197,14,32,246,8,19,225,10,176,59,71,10,125,40,114,109,174,38,95,206,183,219,224,69,43,247,0,231,131,45,42,241,104,241,149,52,45,224,7,244,151,6,96,213,217,219,57,217,195,103,228,173,182,102,247,10,127,9,192,243,21,242,232,180,231,2,198,105,160,183,40,200,253,98,169,89,76,107,12,214,121,248,222,57,180,70,230,249,68,233},
  {205,191,187,232,177,12,225,1,17,236,36,214,118,197,172,0,205,105,8,1,152,2,229,56,243,210,14,204,241,36,99,14,60,245,81,30,6,15,0,42,166,252,245,248,64,1,147,226,14,87,158,103,168,225,49,4,70,104,5,16,165,0,2,247,39,100,217,5,146,226,190,172,2,252,183,36,95,43,41,83,25,17,69,72,246,254,238,216,69,206,235,228,141,14,231,218,58,107,51,81,0,207,151,37,36,212,83,253,245,246,36,255,170,30,45,244,224,195,132,84,59,51,185,208,216,3,47,232,13,93,247,10,191,101,183,231,224,233,10,95,63,15,148,108,9,106,113,171,157,11,204,35,229,101,2,180,127,78,126,255,90,190,248,247,151,110,23,53,161,84,61,207,189,176,96,91,157,182,7,8,26,221,187,230,200,243,10,203,215,3,225,243,252,203,104,27,51,34,247,54,21,85,184,102,73,12,154,54,104,6,143,112,172,247,54,229,160,11,142,250,47,185,248,252,78,238,77,1,114,247,29,253,56,248,236,254,140,45,219,8,148,51,60,27,182,245,140,230,166,60,162,195,162,68,92,216,25,115,105,234,7,244,50,235,134,1,59,7,210,246,122,224,191,247,23,24,178,81,40,215,159,65,129,237,43,75,237,211,147,60,245,61,145,173,182,252,235,73,223,31,59,191,210,175,126,78,212,33,155,210,97,84,157,11,188,201,128,97,11,64,149,244,9,61,84,247,56,6,56,41,234,114,12,178,80,245,29,2,142,32,218,70,45,239,239,245,209,83,254,170,31,9,73,190,150,26,59,224,74,251,202,9,220,8,138,74,78,113,124,68,124,70,44,81,201,56,192,192,215,101,132,5,45,20,117,237,142,6,185,216,168,86,30,0,117,184,15,1,216,2,164,181,62,17,44,19,208,108,175,94,124,111,199,12,9,248,160,186,178,251,195,111,135,248,50,17,129,7,226,67,97,1,168,48,186,214,230,77,56,226,38,251,124,95,183,3,103,103,23,4,223,173,177,6,155,246,164,0,248,51,17,232,173,47,26,203,19,249,228,56,13,229,96,2,109,54,95,44,249,3,212,102,239,2,127,22,235,11,95,251,203,112,155,32,198,47,152,82,170,174,86,255,78,253,55,11,133,32,139,88,189,76,44,97,146,203,177,177,241,33,145,246,185,109,73,11,98,209,179,74,135,88,146,17,137,199,246,245,193,54,113,243,168,10,210,13,253,243,219,188,118,244,97,32,145,248,195,188,163,80,4,218,52,72,11,20,122,11,160,243,165,209,80,251,77,10,240,54,40,67,202,228,42,238,199,229,63,48,66,254,116,182,34,187,212,0,24,45,130,92,76,239,132,247,187,200,218,73,128,48,175,4,93,165,72,184,99,12,180,234,250,251,23,6,88,111,143,5,123,63,42,115,62,108,97,105,58,6,130,210,2,4,3,183,204,30,163,79,237,104,167,8,201,9,82,240,221,80,218,39,9,65,214,248,87,238,41,178,30,115,196,223,217,86,153,8,115,179,147,168,3,3,28,71,23,8,236,252,253,95,142,8,106,8,5,113,163,78,153,37,111,247,196,49,135,165,82,171,29,226,2,66,145,83,58,4,26,175,0,254,3,84,84,60,88,57,174,45,253,98,224,207,145,0,103,36,177,222,109,199,226,252,235,10,79,48,237,255,80,108,242,246,211,60,119,171,117,14,179,103,125,0,43,18,119,45,6,59,18,231,57,16,166,233,240,252,189,214,166,94,121,18,90,26,93,36,15,244,65,191,192,177,114,221,253,253,180,12,227,39,239,252,34,30,23,86,226,74,192,15,222,214,70,246,164,254,140,242,76,175,7,37,131,16,126,233,12,229,168,56,47,79,97,101,31,46,116,4,35,12,255,46,17,42,78,5,160,199,249,101,141,108,65,245,27,82,212,174,101,42,233,25,221,54,196,202,98,167,114,0,203,27,105,233,10,36,28,1,174,250,9,8,74,216,102,52,111,34,82,3,131,233,227,112,63,0,216,11,181,246,117,7,47,87,240,45,191,8,48,30,239,254,187,198,20,225,67,212,106,38,69,0,64,249,163,250,209,203,20,92,86,112,21,109,31,86,229,26,193,220,146,2,80,33,12,221,163,97,75,183,235,107,17,80,212,1,186,23,17,205,55,237,147,247,202,229,124,4,215,85,192,77,26,106,32,51,50,245,234,89,144,167,6,22,170,1,150,187,144,25,218,80,181,67,104,38,18,214,192,52,143,5,43,31,27,211,196,47,120,208,156,53,21,39,13,21,99,76,3,1,175,114,53,245,244,70,105,4,182,46,101,7,179,185,41,95,172,58,61,106,12,227,57,48,188,114,117,192,194,37,88,8,33,60,124,38,69,194,140,232,154,97,196,40,101,245,79,203,30,9,35,86,143,204,143,255,68,213,181,228,80,13,81,238,69,255,211,239,211,250,172,8,164,200,3,252,231,209,24,191,34,249,186,254,124,0,70,97,229,99,33,218,95,101,229,10,84,23,250,247,29,236,7,66,11,71,127,222,227,208,201,171,43,228,207,246,81,245,170,191,172,6,36,115,135,255,250,247,201,44,205,170,45,95,190,205,182,228,24,61,30,188,52,63,170,244,61,3,66,188,94,69,219,37,33,219,209,246,229,255,198,225,184,252,100,102,44,192,121,7,250,202,173,219,200,245,168,38,74,2,193,102,210,193,188,177,9,248,180,27,233,82,65,246,122,249,84,12,130,7,189,254,25,86,49,190,93,181,28,8,195,240,143,191,87,115,79,42,189,93,151,14,144,201,36,54,231,187,85,172,88,168,207,241,225,190,188,242,69,195,28,0,45,165,99,7,159,241,152,255,4,64,50,34,151,6,80,5,79,238,70,255,135,203,67,251,155,28,54,100,4,103,49,175,219,52,99,252,1,5,179,203,151,210,252,52,243,1,214,109,14,40,16,245,203,253,105,179,209,104,46,91,147,184,66,231,15,78,86,37,87,187,14,0,162,101,16,113,162,250,106,83,19,99,243,252,71,95,187,227,187,100,242,244,78,57,217,97,145,17,204,6,90,12,8,8,187,173,204,83,254,229,245,7,100,34,116,179,99,255,176,172,99,246,96,233,21,17,163,113,252,208,40,48,56,247,141,245,46,40,19,250,4,171,214,65,144,93,95,249,201,88,82,74,57,170,19,111,221,7,150,5,104,212,181,248,255,10,219,210,28,112,55,45,123,99,18,30,227,52,152,7,85,77,198,243,128,62,110,171,177,198,139,101,234,232,120,203,14,213,5,101,39,3,231,23,42,25,200,83,40,45,17,38,119,11,174,66,97,205,62,223,94,16,226,11,25,248,215,0,212,10,138,204,34,92,2,112,223,29,15,176,230,187,7,245,145,234,7,167,186,252,241,65,255,6,255,2,234,20,158,199,157,8,33,79,82,95,143,209,173,23,147,9,22,221,44,37,224,229,134,247,154,35,7,191,158,44,87,209,128,216,71,28,234,227,180,19,166,87,226,235,107,103,33,243,190,234,75,100,28,223,90,105,142,83,179,192,223,97,245,55,100,107,128,109,79,210,188,11,33,254,106,12,54,236,21,254,196,9,230,230,34,167,26,12,155,244,62,23,206,11,183,245,17,99,59,199,15,2,250,249,190,37,210,254,84,85,237,1,240,74,57,92,170,173,136,86,252,218,155,37,16,103,31,41,115,11,210,64,135,2,49,1,171,5,126,59,60,193,184,243,156,26,26,223,170,54,206,193,141,7,247,196,49,110,138,179,234,68,235,248,44,181,180,110,218,107,123,99,181,40,43,61,116,255,80,12,117,107,154,104,135,253,138,5,39,237,101,80,106,6,216,59,242,56,132,172,40,200,39,8,162,15,119,181,101,0,88,244,244,247,22,7,21,171,237,58,185,243,181,187,134,187,237,202,194,239,77,247,229,64,145,98,133,13,74,231,124,106,138,254,35,245,70,8,112,79,165,87,144,107,186,193,54,42,127,87,57,65,121,92,30,18,194,203,209,240,203,14,217,48,155,190,202,247,190,40,233,16,13,218,105,81,21,14,176,112,174,20,140,253,102,110,135,167,163,248,153,245,23,188,40,173,87,0,15,44,10,92,198,70,144,245,134,171,122,217,145,111,126,251,247,232,46,255,246,25,48,244,6,210,126,11,55,181,45,181,22,72,138,21,129,198,94,5,231,248,2,29,193,3,87,3,10,253,166,91,165,247,64,244,127,11,186,64,235,254,126,217,192,195,150,31,97,10,183,93,43,206,82,253,81,102,19,10},
} ;

static const unsigned char precomputed_core_scale3sntrup953_n[precomputed_core_scale3sntrup953_NUM][crypto_core_INPUTBYTES] = {
  {250,60,176,161,184,53,31,121,6,251,197,21,203,224,23,62,9,113,240,136,35,104,88,215,253,169,197,101,20,24,92,216,73,15,242,148,164,175,145,165,74,131,53,198,39,214,115,29,234,143,23,150,7,59,53,70,43,239,205,69,19,69,26,48,188,195,203,117,16,48,197,180,205,92,73,122,110,235,160,205,114,210,209,8,67,113,17,83,130,61,56,156,79,80,4,154,141,185,205,249,27,104,122,28,176,212,25,70,133,121,248,148,48,26,155,116,249,178,201,158,90,202,79,10,3,66,23,248,219,141,244,244,113,162,4,8,143,53,207,73,69,227,35,164,204,229,226,221,101,189,242,100,236,1,207,3,13,237,211,188,204,96,61,155,51,15,132,164,236,161,110,139,84,62,177,79,124,53,202,106,13,87,93,49,182,254,24,4,186,53,124,58,0,140,101,151,105,37,136,85,239,231,54,199,57,220,185,240,98,141,16,25,235,216,55,208,137,114,109,151,131,33,94,74,141,19,23,2,144,212,240,90,255,212,23,135,143,166,145,21,248,110,68,138,173,176,242,226,73,240,55,177,57,61,176,133,137,67,203,233,57,204,248,102,112,23,64,215,14,51,172,53,27,136,84,52,240,70,234,89,67,55,20,46,4,60,206,45,140,16,210,76,243,3,116,28,114,57,126,35,189,85,70,182,71,23,78,123,185,178,36,124,253,211,14,111,165,177,242,69,194,137,246,126,157,202,158,29,5,174,48,86,60,88,178,151,144,237,106,78,214,50,185,194,126,248,85,243,193,201,218,194,94,14,82,240,58,144,69,227,1,107,163,224,56,226,202,179,21,7,226,158,142,213,0,151,78,51,94,33,1,94,211,193,102,163,3,186,78,158,58,43,35,60,40,230,8,145,113,206,123,23,139,64,51,60,9,239,209,71,170,221,106,235,76,134,159,82,139,88,104,52,122,151,192,7,73,117,122,244,248,211,96,212,69,184,236,59,72,54,169,45,183,73,73,157,98,52,245,122,63,148,148,68,64,81,163,99,86,115,82,26,221,82,220,104,191,130,251,216,77,142,80,197,135,2,242,47,100,224,90,147,193,50,126,66,67,89,79,35,59,237,11,45,27,41,64,43,82,174,34,42,91,68,156,8,30,0,165,146,54,99,72,8,113,235,106,197,80,246,223,178,24,50,54,146,196,210,171,33,13,236,183,252,135,82,244,187,19,189,68,25,4,189,195,174,204,29,216,1,112,217,246,200,39,17,239,126,117,104,39,132,207,102,86,14,181,82,171,128,18,210,252,57,111,49,75,149,174,133,245,23,225,164,20,102,108,1,249,162,187,188,63,68,206,249,243,177,86,252,113,157,187,25,88,205,56,228,210,46,212,168,234,85,119,173,143,203,72,164,159,34,34,234,67,55,221,36,36,52,122,71,11,73,135,181,51,12,18,121,254,64,44,160,104,247,221,79,79,124,12,85,251,226,38,158,52,0,87,210,65,66,31,46,185,212,209,128,200,112,85,25,24,28,234,71,117,157,177,180,254,6,49,189,234,194,212,150,165,219,7,87,52,130,108,115,168,123,0,153,79,86,196,204,180,243,216,113,36,183,221,61,141,120,158,255,166,131,34,241,98,130,185,89,72,67,129,122,229,89,73,167,194,52,229,157,169,128,52,161,237,162,89,215,55,83,204,170,59,247,185,235,90,89,173,47,56,180,225,149,140,74,122,47,115,77,63,231,39,134,18,113,217,171,23,181,20,11,77,24,208,200,67,62,120,50,114,14,58,172,95,75,236,170,167,231,117,250,72,193,59,10,23,210,91,15,36,234,204,235,36,234,41,14,254,240,1,138,231,21,49,9,36,60,117,59,3,246,192,107,148,84,85,22,95,220,244,190,241,222,227,128,141,226,242,10,69,145,248,163,164,93,234,236,104,239,67,158,67,126,121,87,2,72,13,200,142,73,107,58,151,125,70,159,95,14,197,193,206,215,153,203,157,130,226,103,99,64,94,97,202,219,143,253,124,95,166,11,126,243,194,13,221,252,106,221,117,49,44,19,245,48,42,229,167,198,197,104,194,215,126,43,170,8,127,132,166,177,175,2,151,182,204,84,89,108,83,179,41,135,109,207,252,13,157,209,56,240,72,46,3,212,107,157,200,182,132,122,6,103,73,82,240,98,202,28,205,81,224,151,241,205,154,215,208,199,69,179,210,135,110,231,57,4,207,35,236,23,44,155,66,42,143,8,210,52,58,179,175,20,195,44,238,98,131,0,84,207,150,251,222,99,245,122,113,127,118,137,186,87,185,49,0,66,125,34,108,75,219,58,160,101,179,39,18,96,152,106,27,225,225,24,120,33,242,125,170,131,242,19,80,92,58,65,72,179,32,221,188,164,93,253,247,85,176,87,165,141,12,234,229,186,205,126,57,74,230,19,229,141,221,42,95,118,155,169,214,132,52,29,2,120,151,252,37,167,109,228,188,164,143,118,177,218,137,47,217,148,80,34,250,235,138,139,188,38,97,166,162,139,84,74,92,82,138,233,177,189,243,81,139,101,249,65,178,97,40,139,241,246,138,15,11,128,112,83,141,91,170,38,219,233,251,9,104,22,252,173,208,223,142,179,70,217,79,209,186,102,164,203,91,168,231,107,178,96,133,72,147,251,20,78,7,185,39,177,218,249,172,46,78,223,74,195,136,193,170,109,188,86,64,56,230,131,161,70,34,137,39,18,78,169,33,91,203,207,14,7,44,224,202,163,183,170,101,46,54,85,29,88,120,195,180,104,47,77,125,175,125,230,116,220,171,252,212,38,238,110,117,198,52,244,113,13,145,142,19,4,109,52,252,82,46,205,100,38,128,204,0,164,88,172,31,162,116,52,40,166,173,5,68,110,248,204,150,192,22,246,245,1,176,191,92,83,117,6,67,217,138,240,76,91,252,137,209,194,250,108,185,55,234,40,0,172,148,246,62,237,244,5,0,103,57,12,175,122,220,60,217,154,136,61,58,118,17,155,186,69,5,231,213,202,28,93,200,149,117,131,252,0,82,27,94,36,96,173,153,214,252,175,25,40,52,219,69,151,142,71,240,182,168,166,195,13,216,70,81,43,99,68,228,24,210,130,136,25,186,25,236,130,182,193,73,11,69,148,204,152,133,21,36,136,27,48,2,115,85,205,141,44,19,240,24,113,177,237,15,10,203,48,212,180,247,207,121,34,77,200,101,211,46,61,134,162,194,235,142,229,90,73,219,252,87,27,53,40,78,235,46,184,179,212,168,109,206,138,117,175,2,18,14,186,73,81,130,23,26,47,162,139,172,183,151,106,136,136,93,47,170,104,57,186,58,253,141,8,51,27,204,111,77,41,148,158,110,141,96,166,158,9,69,225,223,194,46,22,255,217,188,53,182,135,207,9,244,130,124,251,29,178,124,108,222,47,221,245,140,50,133,165,51,1,222,78,250,94,33,65,71,203,0,217,88,132,77,252,193,200,161,90,179,196,209,49,224,38,47,8,250,57,67,77,68,25,20,195,191,244,136,226,156,3,12,70,128,151,71,143,250,224,8,194,176,58,240,29,43,211,81,43,192,35,60,51,221,97,190,8,89,139,219,228,251,118,243,218,70,59,192,3,176,57,137,21,77,108,239,192,172,35,73,105,246,179,87,41,153,70,241,25,114,59,223,92,222,75,38,204,34,51,198,180,96,126,61,216,146,237,206,92,151,246,204,43,120,196,39,11,157,228,158,113,214,124,121,201,221,35,114,87,105,113,55,84,40,84,22,183,234,190,232,173,35,230,192,58,162,241,195,22,242,10,133,247,28,18,230,107,21,130,16,80,121,132,122,202,77,212,152,106,218,80,151,236,140,44,8,175,22,178,4,93,28,114,202,136,24,216,126,86,22,133,238,132,79,192,127,86,95,177,35,75,210,68,48,198,137,112,201,201,85,42,168,251,55,105,210,230,156,57,50,158,90,207,100,75,252,172,23,128,200,72,102,42,51,182,0,145,74,250,74,254,173,122,108,57,15,223,121,46,190,100,120,15,85,107,3,73,42,22,188,159,51,172,43,161,122,91,234,115,18,90,145,77,250,129,114,120,104,18,153,219,226,113,164,47,150,63,112,134,80,50,202,187,230,119,252,139,207,124,65,239,35,192,9,174,51,149,232,8,57,80,226,206,29,208,60,243,212,17,239,234,109,183,139,189,233,173,112,180,184,221,52,48,207,149,121,228,247,86,145,10,161,221,69,109,6,67,150,73,62,0,126,138,122,92,5,132,140,57,153,82,202,92,179,216},
  {138,144,3,228,46,181,11,69,98,250,72,158,208,42,62,213,51,247,145,163,19,232,223,124,111,177,86,133,208,149,164,162,246,232,186,87,55,90,163,226,252,170,215,252,7,126,47,58,52,125,174,61,41,169,92,204,121,129,115,9,185,191,151,147,165,165,83,145,41,107,92,190,77,175,152,245,226,30,114,188,61,76,222,35,240,179,47,2,179,126,216,250,201,33,209,11,38,110,218,100,150,45,9,203,150,203,9,91,167,190,207,248,22,44,52,201,74,247,194,119,64,245,169,72,49,198,6,83,134,122,5,94,202,125,155,50,56,150,128,222,175,127,189,231,237,75,141,120,34,69,113,159,190,109,172,191,239,3,153,128,183,127,6,59,191,186,196,172,92,35,132,39,231,27,21,211,106,71,37,46,144,132,130,25,29,35,104,144,145,116,219,3,52,143,228,245,39,42,37,230,150,163,156,70,224,194,197,37,168,45,128,69,105,64,242,193,54,60,87,0,53,16,45,205,65,23,49,1,145,172,244,0,208,203,90,107,245,80,188,24,238,205,128,216,29,13,146,118,66,25,71,178,244,222,122,206,144,133,239,40,65,125,237,2,194,206,153,199,39,10,130,255,85,250,19,217,103,210,191,38,137,178,162,57,148,231,84,123,240,11,1,99,77,102,25,237,242,182,148,40,225,65,117,100,159,49,220,125,153,168,75,207,161,37,138,12,128,102,74,125,34,96,149,151,91,4,99,84,133,161,97,63,249,63,169,108,150,246,234,27,77,182,101,139,188,198,154,190,194,172,58,42,162,31,35,191,235,68,0,30,217,132,38,145,170,16,245,160,181,52,171,216,240,134,211,59,208,4,67,199,57,129,169,18,38,186,207,144,199,146,141,91,49,42,169,236,112,111,241,239,64,112,174,182,67,228,4,181,86,1,248,242,14,234,49,142,85,138,39,147,201,112,82,142,123,42,81,178,25,149,246,52,177,64,165,161,150,12,30,250,219,173,251,247,229,181,241,204,79,114,24,226,49,204,130,192,168,13,71,127,107,30,60,219,234,51,201,146,131,110,209,179,192,105,130,218,23,46,111,178,29,171,194,205,113,39,34,78,204,125,61,229,233,105,46,223,65,188,66,8,46,89,216,23,46,103,106,211,111,42,246,185,124,150,106,230,187,74,232,106,205,71,35,123,131,204,112,171,97,106,95,54,219,252,211,146,63,77,125,109,34,117,201,89,126,28,88,186,190,150,182,76,127,101,127,161,231,90,248,214,43,3,214,152,183,77,80,52,219,62,241,137,229,150,165,140,146,2,171,82,181,90,64,106,252,249,3,158,190,193,97,231,105,71,124,149,93,74,114,224,190,213,6,83,163,16,162,130,152,28,211,233,101,23,219,44,96,37,141,224,45,172,42,225,218,67,74,208,121,135,217,92,141,62,213,55,246,211,173,103,255,91,252,106,108,117,76,178,208,186,196,185,185,237,223,106,210,4,3,24,82,133,93,100,28,214,6,85,59,224,47,147,85,218,76,206,225,207,147,14,190,117,146,184,226,67,23,144,72,169,212,197,179,52,54,42,16,104,243,88,17,179,202,175,148,128,86,254,61,209,86,35,252,21,27,184,100,128,223,255,144,51,60,86,19,164,110,104,253,87,130,178,158,215,215,155,226,255,158,176,116,226,226,216,255,68,241,204,241,230,19,84,84,144,107,21,188,29,80,33,34,238,42,68,187,76,140,222,221,242,54,50,214,114,11,239,220,159,51,212,227,102,167,8,214,251,117,212,218,245,61,15,53,165,79,190,35,97,213,166,79,135,112,120,23,241,178,122,100,188,86,13,115,176,165,104,174,191,158,188,211,82,34,184,158,207,173,114,168,212,135,208,195,121,108,81,201,11,60,57,64,27,59,29,69,92,212,174,61,97,2,186,128,216,206,146,238,135,184,210,31,132,43,99,252,207,226,143,31,34,172,61,135,212,153,215,191,46,131,11,37,9,75,36,136,50,60,114,210,129,67,87,89,201,215,116,117,3,60,170,161,80,56,105,174,50,49,251,3,26,145,4,5,141,174,149,90,217,21,208,146,32,226,174,114,87,121,87,132,1,55,15,198,120,159,20,109,47,71,120,122,51,165,67,140,105,44,242,140,77,39,130,12,187,173,170,209,84,185,200,29,217,180,204,178,209,5,237,158,84,56,83,77,162,185,226,194,79,118,55,45,43,160,123,113,151,168,10,86,155,35,156,219,178,8,122,132,167,26,121,64,4,161,152,156,114,219,132,116,184,196,54,208,162,165,240,59,29,158,97,76,234,137,143,167,142,147,102,104,225,38,148,69,21,65,114,197,223,44,220,45,141,89,230,215,31,29,130,112,9,195,116,22,165,1,248,190,105,185,172,42,65,128,70,204,234,149,240,162,44,206,216,171,214,68,90,197,137,207,104,4,102,253,101,124,237,142,129,118,131,225,1,108,14,6,192,181,23,38,126,242,228,219,139,125,141,230,201,148,240,118,145,19,252,129,252,7,85,106,146,174,196,231,53,102,204,86,18,148,71,13,151,176,17,125,173,167,64,114,196,203,96,219,108,220,222,50,78,123,81,136,209,201,13,213,132,245,248,104,125,225,219,132,232,165,137,197,59,11,72,151,143,208,39,204,113,239,233,72,179,112,105,202,42,80,14,182,102,248,19,192,78,229,239,209,86,181,134,178,210,184,63,215,91,147,88,48,7,209,96,175,147,8,17,76,35,11,146,41,122,227,6,138,33,52,198,143,64,164,196,124,102,122,59,155,27,58,67,29,79,124,129,3,242,138,32,142,228,21,123,241,60,159,24,181,57,51,122,97,99,213,183,235,235,41,126,255,134,155,144,73,2,61,33,202,116,214,71,162,20,158,158,45,28,203,19,172,10,197,239,115,163,219,11,178,233,154,19,138,211,205,71,42,88,141,68,126,219,37,67,21,96,97,71,138,107,223,109,105,168,82,125,125,4,15,203,38,71,239,12,172,51,139,209,170,37,170,160,102,121,168,152,107,128,65,0,209,159,148,145,50,224,78,137,174,79,168,158,218,76,165,7,96,162,220,115,92,47,22,44,197,44,56,69,18,29,217,113,144,97,117,104,171,131,161,16,241,65,173,142,77,21,84,194,66,12,140,116,88,199,130,152,40,56,128,76,180,172,198,32,18,103,26,98,228,185,1,249,166,26,160,229,117,34,96,1,145,173,3,132,50,247,88,59,97,117,174,21,32,156,50,111,35,38,59,6,36,80,59,198,46,35,23,191,179,55,45,107,199,228,243,197,128,242,79,195,118,154,119,15,72,194,117,134,251,6,170,213,184,255,125,217,196,190,239,246,32,185,0,148,137,98,5,80,40,129,165,228,31,178,114,65,163,207,174,110,98,75,55,67,137,250,96,160,196,28,100,90,135,161,223,152,97,199,135,41,39,211,73,26,34,114,197,48,15,89,222,34,203,49,94,193,208,247,252,13,108,181,10,190,10,227,215,23,60,167,39,225,203,252,149,90,101,0,213,38,55,199,135,57,2,4,171,108,179,20,23,198,29,116,228,230,193,16,33,65,181,117,102,237,104,226,152,207,158,253,16,229,216,53,105,94,92,29,104,199,94,118,21,214,94,113,122,176,64,148,192,78,199,251,168,170,193,168,200,150,55,214,178,66,128,51,89,24,227,94,32,11,212,70,60,111,38,15,7,56,155,26,61,33,110,55,238,196,29,75,73,159,26,195,153,177,166,220,217,19,131,223,162,206,58,57,207,12,180,254,209,235,1,132,47,79,94,207,205,219,248,135,207,106,55,10,67,142,216,221,193,92,246,180,188,78,59,207,176,29,120,77,83,191,135,12,72,48,143,166,245,162,188,104,174,65,53,253,42,77,162,194,133,141,76,85,221,100,179,157,224,139,59,49,91,102,220,222,248,217,1,147,54,97,104,36,16,88,8,143,234,87,112,241,121,93,91,98,127,166,9,215,139,134,89,144,112,115,14,100,138,49,23,51,13,38,8,255,47,50,98,63,42,105,70,72,156,155,5,155,23,31,77,68,95,83,173,104,6,159,230,154,125,214,91,55,142,37,230,155,105,109,0,5,83,247,252,60,136,181,13,37,94,51,220,233,137,242,218,159,228,138,189,40,191,222,165,97,213,14,213,221,233,99,227,83,225,4,21,119,17,232,61,78,229,176,151,248,78,68,122,187,0,179,159,174,247,216,69,166,178,85,20,152,221,16,96,70,86,159,23,251,85,97,13,215,200,213,174,3,116,190,114,57,87,116,177,29,24,48},
  {163,176,179,171,224,98,77,166,127,33,155,17,77,249,2,249,209,115,25,13,123,174,23,29,145,236,27,76,57,46,128,26,111,137,62,164,238,148,139,208,72,7,168,207,182,54,38,189,230,74,66,59,142,108,191,195,135,248,113,41,104,211,136,94,52,162,195,41,129,118,41,194,179,0,223,210,163,153,141,197,123,185,120,90,65,197,34,83,36,13,83,235,202,157,229,237,206,192,181,1,235,189,222,36,143,29,38,227,108,110,5,76,160,149,15,179,181,221,233,166,56,56,121,152,65,229,219,213,97,82,213,93,95,11,121,26,121,159,207,240,45,127,24,67,217,121,110,4,106,170,97,40,134,99,200,20,22,99,224,234,227,106,223,226,167,248,221,185,48,102,76,63,234,25,188,172,124,223,172,84,4,130,241,167,108,164,244,202,238,133,104,166,183,248,251,80,150,103,177,163,194,59,135,172,73,154,87,220,44,68,97,208,122,63,34,98,219,89,7,230,87,39,12,52,65,245,9,185,5,80,70,43,109,201,216,99,92,92,224,170,123,6,26,49,20,196,223,22,59,40,10,255,129,108,67,193,209,185,105,146,182,69,35,146,130,69,151,130,102,251,108,117,163,36,122,186,97,30,132,170,119,127,95,8,15,22,145,213,27,23,178,253,8,38,148,236,133,146,4,102,163,137,250,80,251,247,37,242,74,229,151,94,244,236,48,20,201,98,233,180,81,26,170,242,71,90,139,75,179,3,0,100,46,112,86,155,82,250,219,121,60,70,178,176,245,47,120,118,139,128,29,105,2,71,72,230,234,25,182,123,6,62,48,251,250,197,165,8,180,141,77,172,118,36,75,222,56,164,106,180,228,23,143,146,117,34,114,220,100,140,108,15,101,152,250,23,131,126,227,187,244,254,185,138,190,142,110,89,40,56,193,3,7,113,182,210,46,233,48,124,190,85,158,62,70,11,40,155,207,5,104,103,74,171,181,62,109,106,112,34,176,240,143,194,245,135,66,118,146,50,163,254,89,8,191,53,205,4,200,35,153,107,24,226,165,56,200,61,200,11,34,244,91,235,37,148,21,137,239,120,231,118,46,199,5,107,160,60,18,5,160,34,93,161,20,81,204,98,109,249,58,203,182,39,229,185,58,234,240,163,246,32,84,129,164,235,129,230,123,83,178,84,68,87,73,232,206,3,143,53,47,0,89,93,235,173,157,206,74,49,58,62,156,97,89,60,76,109,223,212,62,3,115,162,200,125,69,147,39,165,99,207,126,97,236,43,171,188,209,3,125,179,124,116,165,249,26,157,228,53,13,72,156,33,121,131,2,250,85,198,247,228,15,107,245,120,27,8,65,172,47,32,6,63,32,100,123,88,180,173,118,191,40,102,146,75,60,253,125,14,123,13,174,235,123,24,27,192,42,125,180,224,246,243,120,45,127,205,5,175,246,83,246,206,15,79,37,137,188,20,41,196,246,230,16,199,238,57,220,125,160,12,252,194,109,157,108,196,101,240,164,2,235,3,95,186,182,53,76,189,207,89,139,250,166,252,152,151,163,39,100,122,178,26,28,146,250,194,254,246,154,247,209,85,134,220,147,38,221,249,19,136,155,157,55,83,137,107,214,179,221,209,254,32,193,50,95,157,238,49,32,128,118,0,15,54,29,26,189,221,125,203,2,81,208,180,77,63,62,255,245,198,72,93,222,8,166,175,173,156,248,6,255,12,188,41,251,195,132,175,62,226,195,3,37,97,139,245,158,215,97,204,41,227,249,89,18,103,10,11,55,215,49,164,159,227,112,152,213,104,179,129,238,14,178,131,190,46,164,82,150,153,148,209,174,66,131,172,75,45,255,41,1,204,14,36,221,39,4,107,78,65,194,185,22,186,39,240,205,151,250,229,111,129,62,255,148,122,27,194,160,170,162,185,56,80,42,104,178,21,150,165,227,131,235,37,178,28,70,190,58,102,0,8,140,208,149,210,126,232,107,109,100,85,165,206,162,71,232,63,71,15,9,166,131,142,197,165,7,13,176,104,47,78,90,25,29,146,228,251,170,221,37,59,118,91,178,123,249,21,40,97,188,16,47,248,210,48,123,165,41,152,144,200,234,3,168,181,217,125,224,100,179,58,48,155,241,67,4,53,130,126,44,215,62,86,198,153,92,245,173,47,59,141,80,210,156,201,97,111,199,164,136,207,252,121,137,156,5,202,129,217,154,139,193,23,205,70,72,177,160,115,20,82,53,191,125,20,43,74,83,130,75,211,19,101,53,52,254,170,115,118,150,143,86,187,202,224,148,111,189,23,39,230,124,8,215,167,220,216,87,13,69,171,207,206,50,95,224,252,37,160,185,175,246,22,66,202,250,57,43,89,40,210,40,158,92,195,118,165,213,33,235,72,125,105,228,250,168,222,66,14,244,33,57,94,8,171,242,220,120,237,0,141,128,255,177,170,246,48,106,23,14,1,104,56,108,97,74,70,75,103,3,125,120,60,207,105,106,36,170,4,126,71,60,223,134,0,109,250,247,53,86,98,33,175,160,9,133,151,129,175,226,75,194,10,176,132,64,253,47,232,204,126,242,205,108,44,13,148,94,214,150,236,250,145,152,109,174,162,255,176,201,10,63,32,214,86,0,84,169,242,82,71,233,189,49,120,217,34,240,26,238,75,14,227,217,210,78,63,194,192,228,93,174,82,238,142,33,122,236,223,68,251,56,203,127,39,190,227,125,75,195,91,50,163,1,6,141,27,11,79,71,132,4,184,140,196,72,66,149,148,179,125,170,160,137,237,115,12,91,27,219,158,128,204,107,239,121,251,158,204,3,188,131,86,74,241,75,247,153,172,86,226,141,133,28,47,43,139,33,122,203,36,107,66,20,0,238,161,59,218,126,246,71,230,211,129,189,136,72,42,180,167,31,235,150,204,249,230,176,74,28,177,190,106,61,51,247,222,171,162,127,95,172,239,236,159,108,126,229,28,140,145,1,196,65,181,210,152,136,203,134,232,34,112,236,114,221,140,184,147,41,8,39,212,70,70,172,229,46,217,75,25,114,225,213,208,163,36,15,194,17,240,143,235,52,53,218,89,188,230,171,115,220,81,65,113,200,235,144,178,128,59,212,240,178,68,133,141,114,208,149,237,137,198,242,170,208,42,142,48,195,29,30,122,232,177,191,203,78,38,254,169,107,127,40,123,149,36,78,52,91,202,255,198,193,76,195,232,184,246,86,198,75,196,47,98,159,197,237,18,211,155,73,117,254,115,79,165,139,33,56,109,63,152,100,240,5,124,189,21,198,30,15,59,228,133,117,27,204,102,94,24,158,196,221,129,13,170,16,175,66,35,77,74,12,196,69,57,106,23,0,227,227,143,164,232,183,170,102,52,49,215,8,117,90,178,44,56,42,178,235,110,92,231,107,75,138,81,176,55,172,169,177,0,250,129,128,189,236,165,86,134,172,78,4,193,234,141,141,190,81,161,27,232,76,68,73,14,150,39,163,167,217,160,127,120,47,139,174,119,128,200,3,63,217,215,187,224,10,246,187,8,231,36,124,63,117,209,160,36,39,51,184,11,54,212,35,69,213,168,35,13,37,26,77,102,201,195,246,158,113,179,5,30,191,249,67,241,22,143,53,63,19,191,99,84,101,222,167,224,150,78,57,114,37,5,99,149,174,22,173,71,89,156,114,165,204,85,185,248,121,68,60,55,74,227,222,158,131,119,104,249,201,167,43,92,58,222,114,133,173,93,64,131,101,41,173,221,55,173,163,98,55,69,112,197,48,227,127,95,100,132,21,222,108,223,40,215,186,209,173,42,115,132,108,193,18,188,195,180,131,14,87,51,24,69,87,112,111,111,224,110,116,207,206,111,196,166,116,240,125,204,58,32,197,157,208,139,68,125,130,130,106,56,124,55,19,188,118,32,0,50,88,182,110,41,109,62,92,91,246,3,59,191,62,253,31,143,161,152,251,27,106,255,156,241,203,109,55,19,66,108,174,27,142,87,164,30,9,142,14,146,213,119,100,151,110,192,44,107,41,141,152,5,79,144,95,63,94,213,112,254,90,122,134,94,129,159,170,196,195,78,230,192,132,98,96,167,69,185,56,97,125,113,90,182,108,192,19,130,39,21,136,60,80,150,141,31,204,244,19,154,110,23,33,72,139,157,116,196,34,237,173,166,240,249,51,148,6,65,38,64,46,128,95,220,127,42,234,11,194,96,45,4,26,243,11,52,58,9,47,214,243,52,203,143,236,211,208,208,177,214,23,63,230,159,55,198,41,117,143,91,127,69},
  {2,141,252,239,40,183,75,171,110,70,31,63,229,142,228,170,220,128,107,77,136,171,228,197,100,147,109,230,232,105,14,13,39,244,8,189,239,183,237,192,226,254,148,176,211,162,68,67,71,37,119,213,75,152,206,163,175,213,68,184,74,77,67,5,250,126,6,79,153,152,253,219,86,169,42,191,98,193,80,121,160,184,4,203,82,170,13,64,42,231,12,68,28,13,96,235,171,214,254,205,19,146,202,20,31,233,113,84,148,90,249,7,123,18,252,174,179,227,25,207,86,25,166,146,72,1,120,154,156,124,253,88,130,127,80,154,179,69,155,210,2,184,201,129,240,128,142,219,204,182,49,20,228,212,105,222,194,119,61,162,49,55,168,82,202,215,74,111,120,36,210,60,82,221,13,124,242,137,192,79,113,65,252,153,133,89,193,144,138,9,94,158,103,230,101,17,254,104,234,111,244,121,213,127,176,97,203,111,139,164,114,216,247,244,37,68,224,3,237,245,120,53,187,246,45,71,130,77,57,74,95,84,123,74,145,178,113,23,54,11,201,110,1,188,146,252,151,68,207,113,73,142,35,31,135,234,160,46,54,155,173,166,121,155,130,0,86,181,70,82,145,66,130,5,74,16,211,120,203,148,34,30,62,156,166,118,98,62,30,199,148,199,238,134,165,246,230,32,226,18,124,55,89,50,23,205,137,19,156,232,184,121,242,80,167,229,109,211,70,200,116,4,240,113,9,176,104,87,85,107,59,217,23,51,131,73,95,171,199,189,139,202,34,242,184,73,136,121,189,48,162,96,214,225,31,17,124,66,129,75,238,173,7,80,27,33,7,46,193,201,193,31,81,35,48,27,83,141,138,127,63,164,252,14,58,156,237,249,166,234,37,37,10,0,58,53,24,248,53,9,159,137,87,99,81,185,221,129,210,39,193,130,218,97,240,90,243,53,249,160,46,216,64,245,83,99,62,250,227,30,203,85,37,195,81,63,143,119,123,152,79,177,193,210,42,180,186,42,74,180,8,135,59,2,137,167,140,85,149,25,110,154,124,109,113,59,177,253,57,27,194,238,32,86,188,111,98,108,64,180,137,42,146,94,194,15,249,3,136,75,134,216,118,104,47,24,117,206,161,220,133,247,26,255,189,3,196,189,198,37,44,119,81,211,153,59,78,136,232,104,238,73,128,215,195,3,137,61,126,118,26,123,115,99,150,143,63,90,216,111,142,243,75,251,51,98,255,251,92,225,191,89,184,189,238,159,84,225,206,205,191,149,169,117,70,100,145,251,205,174,74,232,112,254,92,182,61,197,165,30,1,68,33,71,0,239,2,195,22,170,143,52,201,224,137,8,245,193,195,209,215,156,63,74,252,143,139,203,109,24,248,163,50,132,43,53,52,81,79,155,17,161,74,10,181,130,152,249,22,200,251,131,87,44,184,128,190,172,233,61,86,1,20,138,49,189,206,34,60,43,141,173,67,3,217,71,140,120,139,21,240,29,5,160,48,71,118,136,247,131,255,236,224,207,70,165,228,136,68,133,1,1,161,202,93,173,145,92,236,210,237,79,187,181,68,131,206,119,32,106,18,176,217,24,64,132,217,48,114,152,67,30,200,206,209,163,113,135,0,170,238,206,9,199,181,112,39,194,236,211,179,231,200,93,186,105,78,151,226,228,9,76,230,11,178,109,98,162,93,44,147,90,222,113,144,219,20,13,126,213,127,85,166,99,106,23,239,27,25,154,0,99,245,154,99,161,82,63,207,39,192,99,11,17,12,191,24,73,126,55,83,136,57,236,236,92,41,183,142,21,184,246,163,103,74,122,227,203,45,184,93,63,194,252,121,178,151,72,215,220,154,20,110,184,61,240,23,68,37,27,82,205,184,212,162,23,124,1,78,12,66,109,72,22,45,164,243,228,64,42,28,215,107,252,246,120,175,220,100,22,144,187,140,26,255,229,137,47,38,0,134,17,54,240,155,105,161,8,39,177,240,10,129,234,15,111,18,105,198,171,148,69,142,216,40,77,91,166,250,73,39,173,82,37,61,194,149,173,253,188,165,255,252,57,111,237,212,147,187,191,42,77,211,74,206,91,174,59,73,124,95,216,244,129,162,207,228,187,254,235,115,94,93,19,23,236,206,40,44,138,230,214,72,120,137,179,43,16,110,145,208,70,30,176,1,239,231,163,138,207,45,34,75,214,77,25,83,175,59,38,67,218,239,100,123,179,69,54,29,102,139,120,212,30,101,106,25,63,45,111,133,172,166,18,28,62,217,194,59,61,33,26,244,191,156,100,14,119,238,93,210,131,84,175,233,31,54,249,127,194,100,181,164,53,80,125,209,27,172,43,23,238,0,195,129,46,58,141,131,191,200,2,248,198,193,191,42,227,151,154,203,40,217,21,100,175,216,144,10,3,78,122,152,230,133,170,127,233,250,67,93,183,46,71,42,162,4,157,241,168,247,79,159,58,1,84,96,232,27,226,182,253,43,93,231,247,175,40,228,126,30,235,98,127,247,88,9,16,17,245,114,70,154,115,70,117,232,65,180,146,86,134,204,67,69,82,27,167,161,55,247,249,249,131,64,162,235,90,48,23,2,134,252,39,253,230,165,238,245,113,29,225,169,114,161,158,191,171,41,225,183,116,54,106,30,150,136,90,228,178,85,152,213,177,185,127,119,226,230,164,17,230,162,235,133,175,37,21,129,248,216,127,89,56,167,221,22,245,41,188,144,206,107,167,145,245,28,4,195,10,44,93,160,207,206,225,50,52,180,2,84,157,152,55,10,132,178,107,44,210,202,183,67,144,249,196,96,54,218,219,219,47,88,72,94,55,167,72,42,142,161,93,34,132,33,173,72,72,155,247,153,29,83,190,240,249,131,249,216,241,175,178,64,230,193,83,118,188,255,126,153,42,206,220,54,111,52,161,171,1,164,59,240,61,65,111,81,171,223,44,71,192,157,4,134,7,54,222,136,128,167,38,68,53,41,154,242,204,95,191,48,54,71,8,35,42,157,216,73,75,187,206,158,126,81,84,90,125,252,152,214,41,147,4,7,198,224,40,200,184,87,79,30,4,107,250,252,134,49,36,189,153,167,2,185,19,143,51,33,85,163,134,33,82,51,240,244,13,206,216,103,61,165,109,104,82,28,90,167,21,177,168,191,48,223,200,29,210,136,245,48,123,179,203,38,219,158,130,140,181,50,87,139,62,231,82,66,97,92,147,161,45,170,108,22,212,243,188,142,196,155,79,180,204,85,158,109,114,141,219,78,143,198,212,97,69,59,230,109,233,68,127,13,1,58,16,251,101,133,121,165,108,72,106,125,174,39,201,222,230,125,151,183,13,246,3,179,82,157,85,175,80,65,145,163,209,67,216,226,188,24,221,181,139,192,158,238,69,192,132,43,7,232,200,85,2,104,163,59,15,157,143,242,79,248,119,179,210,152,61,124,101,30,182,197,150,81,191,179,153,111,5,203,190,192,140,119,108,48,232,147,234,90,188,97,238,41,100,207,122,9,241,102,213,30,158,253,69,6,127,199,236,11,214,199,206,164,226,226,40,148,197,185,214,109,215,216,61,167,251,30,247,187,97,37,241,244,92,217,96,181,68,201,132,113,166,118,4,87,101,154,174,61,167,72,41,124,143,242,8,254,253,215,20,70,170,9,122,98,248,61,33,0,39,161,49,197,207,103,235,118,191,157,42,162,192,209,3,51,115,64,163,187,85,76,164,23,28,39,56,232,251,33,17,113,151,123,26,173,141,66,250,16,228,168,215,65,222,59,31,12,160,119,137,41,45,139,129,22,212,212,21,166,28,143,247,93,12,20,44,203,213,45,255,46,87,32,156,100,120,187,95,53,28,147,112,63,49,203,143,32,165,35,184,144,137,100,8,181,89,15,245,178,87,26,134,60,113,166,243,250,224,149,139,98,59,169,71,130,159,228,29,200,211,196,12,129,239,193,43,65,247,78,175,175,181,189,34,36,208,29,44,81,56,255,192,194,122,0,30,192,209,247,184,169,59,174,242,134,98,224,109,156,140,219,90,215,21,144,184,194,149,16,206,244,12,125,216,39,15,151,161,15,45,64,218,206,5,70,244,112,54,203,134,10,179,242,22,155,209,47,117,67,244,149,219,145,149,200,130,42,169,16,240,205,76,63,102,16,252,21,147,42,89,208,222,34,52,159,117,27,186,62,143,221,78,77,168,67,103,254,248,10,180,174,169,207,38,36,176,192,166,213,3,43,115,249,84,61,64,83,142,31,104,203,88,42,210,204,145,179,92,8,213,177,88},
} ;

static const unsigned char precomputed_core_scale3sntrup953_k[precomputed_core_scale3sntrup953_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup953_c[precomputed_core_scale3sntrup953_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup953_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup953_h;
  unsigned char *n = test_core_scale3sntrup953_n;
  unsigned char *k = test_core_scale3sntrup953_k;
  unsigned char *c = test_core_scale3sntrup953_c;
  unsigned char *h2 = test_core_scale3sntrup953_h2;
  unsigned char *n2 = test_core_scale3sntrup953_n2;
  unsigned char *k2 = test_core_scale3sntrup953_k2;
  unsigned char *c2 = test_core_scale3sntrup953_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup953_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup953(impl);
    printf("core_scale3sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup953_implementation(impl),ntruprime_dispatch_core_scale3sntrup953_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup953;
    printf("core_scale3sntrup953 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup953_implementation(),ntruprime_core_scale3sntrup953_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup953_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup953_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup953_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup953_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup953_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup953_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup953_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup953_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup953_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup953_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup953(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup953")) return;
  storage_core_scale3sntrup953_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup953_h = aligned(storage_core_scale3sntrup953_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup953_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup953_n = aligned(storage_core_scale3sntrup953_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup953_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup953_k = aligned(storage_core_scale3sntrup953_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup953_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup953_c = aligned(storage_core_scale3sntrup953_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup953_h2 = callocplus(maxalloc);
  test_core_scale3sntrup953_h2 = aligned(storage_core_scale3sntrup953_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup953_n2 = callocplus(maxalloc);
  test_core_scale3sntrup953_n2 = aligned(storage_core_scale3sntrup953_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup953_k2 = callocplus(maxalloc);
  test_core_scale3sntrup953_k2 = aligned(storage_core_scale3sntrup953_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup953_c2 = callocplus(maxalloc);
  test_core_scale3sntrup953_c2 = aligned(storage_core_scale3sntrup953_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup953 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup953();++impl)
      forked(test_core_scale3sntrup953_impl,impl);
    ++test_core_scale3sntrup953_h;
    ++test_core_scale3sntrup953_n;
    ++test_core_scale3sntrup953_k;
    ++test_core_scale3sntrup953_c;
    ++test_core_scale3sntrup953_h2;
    ++test_core_scale3sntrup953_n2;
    ++test_core_scale3sntrup953_k2;
    ++test_core_scale3sntrup953_c2;
  }
  free(storage_core_scale3sntrup953_c2);
  free(storage_core_scale3sntrup953_k2);
  free(storage_core_scale3sntrup953_n2);
  free(storage_core_scale3sntrup953_h2);
  free(storage_core_scale3sntrup953_c);
  free(storage_core_scale3sntrup953_k);
  free(storage_core_scale3sntrup953_n);
  free(storage_core_scale3sntrup953_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

