#!/bin/bash
#
# Copyright (C) 2014 - 2019, Stephan Mueller <smueller@chronox.de>
#
# License: see LICENSE file in root directory
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
# WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#

DIRNAME="$(dirname "$0")"
. "$DIRNAME/libtest.sh"

KCAPI="$KCAPI_TEST_BIN_DIR/kcapi"
find_platform $KCAPI

HASH_name_1="cmac(des3_ede)"
HASH_key_1="7a9bcde63b52f8ae1aa8672668c731986773519b3d51dad9"
HASH_msg_1="00"
HASH_exp_1="b183f27c"

HASH_name_2="sha1"
HASH_msg_2="8c899bba"
HASH_exp_2="ac6d8c4851beacf61c175aed0699053d8f632df8"

HASH_name_3="hmac(sha1)"
HASH_key_3="b0639ce84db2715d52b869997027f990d940f11d0e51f7a4f17c34f622b94d74881e95782e5f81f051915c4cb7333b9b426e34f0c49ccb0b1508ad3563f4a16c"
HASH_msg_3="f14b8a17042ecfba01c699eff28acd1094cec326a2f2abb856d929e12e9c43a5ec807d85e02642516902863eba0eaa39dac0a07aee394f5bbbbf396b676d5bbe7f2954883fd7caea0dcc0a0c4686ee6c3d9a047681edec545f270207a8653eb7b52f5847a7a92f2df30d6b811f586153c6443842e2774a4a4bfacdde7aecb337"
HASH_exp_3="167e06cc682c4dec439fb68620801baccfe10caf"

HASH_name_4="sha256"
HASH_msg_4="6a3787"
HASH_exp_4="eaa566834797ac4f9313bd40c614e3cd40ded480bf08857d707da1639d0f3b14"

HASH_name_5="sha384"
HASH_msg_5="fc7cb451"
HASH_exp_5="0f8832f9e468d41f94e7ecde129f0438a8b1628084a1d9e201a3f5d0963fbbbaf1df518b193cba6eb3b90306aa1895f6"

HASH_name_6="sha512"
HASH_msg_6="3fd989f37133e8c9578a0740b5"
HASH_exp_6="3e9a1ddacd38ff9a302f1f86225db9fe38f279c8bb86e76190dcebec6b52060f7ad3485e8e598f433428845c1eb76ce645ab743e62bba8e4f69c40eaa9601741"

HASH_name_7="sha512"
HASH_msg_7="00"
HASH_exp_7="cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e"

HASH_name_8="sha512"
HASH_msg_8="1e71b3ef200f2dc129b43cdb4d372aebcfdbfe6e8924fd238ee972bf0fa9abe27b23444aea20a847bc94d46e7de55e920c8bb6f0fdd9adaa3b1a3377f2e06598ac99c70eba63cd0ad522a1a505cf20d1c213258f59140b63928f6d059027305af8fcc4a25680a6f3bc862ae6ac9c7790379bd3b4677c2136db6da7d3b1241510a974c370861e3beab8e9f79a39f56cb7b54c47c5edbaf60c5ddf6a481c821ba205284ddf14e592d81273912a7581052e824d092cb47592cb610b3dcc9be74bf85541e957c67fb5a3134b7ffc28e94cdde6c7a14f8456fe5d2f19a8c7f4fcabfbe0e620406691ac35009a497a19d449ad2be29898250541a80f3233a1f0684691f0407903bac67d742487780b12eb038497c5746e5e296396497e67c357d321a3cb777c068bc3324ac63b9316d9d6824c7499c038f86a6d0e2424cb93f1e7461abab2b1b2a033d39e2ddd2205383cceeb08850160bc7266f7e94ce87a8649bcdc0519a16fc3bc6657a296ad3ff4c5f04b9cb2c14d6fe6563be12044e1dda48bd3f4d5d3a6ba06f55f6d8ebd2cd81aef5277488767dc7145c151c5692ebf9ebce5cf0ecfbd4eba879dd6ecd934abe3d3eae36edc16cab93c718466dfcbf4df55fcddeb1e1e478025f925d98abf34c7a4fa264c47c200664233c1292c1e441061ff6795472f6dffd65ba17c57353c6f6b69890b50d3472160ef4f36da9177d9e5d6b534d25a88e0a2ab93fec8fe8b83302154d37fb167929d8d77b6718a54e1eb690fef48065fca91d143866582e9aaf909cfcb5dc4286001f581d17773a4d17aa0bdee309abb66acb6f93db72a1e8cd009421c717552339410b5ae76b32f509b63065a1280645cfa40fd4a455cf1d2bc09f4ed432aacb55fc45a76f5b2bd07559a345b761f2253835896d697812c24c6f12e675c4cff8c69faba507dd8169eb02d8d18e5dfbdf450e70e0936029529f4a938b243441360ba9b1b65958d01bcb4045abae728fce668d3ab0aa945f58a501a5af58079b0da5b8dc6ddc53948096a07e2680262a8d1d406b60278b413efe22adc599c529ea153ba03df9544b12fd91f6f4bc0f5895f9a6676182cb6b9feb1c205051e39a45eaa081a938e1605d30932478ba84a6736c4dd35754cb2ad62c5cb1e218e958c"
HASH_exp_8="4c46d3d0527db2c5d66eeca506fffed6541e8cf7b082346d2eb0142f7461e9e5a162265315c7246e08f07a621a3d37a7c63f9c400fb77ff9a8c2fa1cc6191615"

HASH_name_9="hmac(sha512)"
HASH_msg_9="276bf25576a22092ad7d5acd83a03d7caac922e660125086417071b05f804377948390cd17a660ec4e886df5e3f6d7d71af9197362123cfe2ac44ba6f5530678b1ccda81444511336966470bba281d710ddd31e004714d46e0efdeae9646a81c254eb9b826069b2fa520ce572fbf75122c7f507470b6ea280cf9140f6ae2912b"
HASH_key_9="1b74ebf0d5b80531a9b8cfafd29579310de2d789f2ab57bc83b635630608f25110ab0276e3afc503f96fb8cfe116edfa4a61b8d05ea6acf05115c5ad393ee7b420d387ef57afa8aa0e180af522419e4936133c6e052d989bf62a73e0f2220ec17273e424dcc1986d0f3b2de73c20"
HASH_exp_9="fc2f77e781adbc88a9238dda70cfabf28ccd6d019fccf2fb706d14b91f2278ba180344474baf8b70dfc0ecb1f0f5924a6929272b8f1dff913961c307646148eb"

############################################################################
############################################################################
############################################################################

SYM_name_1="cbc(aes)"
SYM_enc_1="1"
SYM_msg_1="4e0c74c8d67862a9732604f62f4ad316"
SYM_key_1="790afba9cfbc095b682666a6999a38ed"
SYM_iv_1="fb1f88c0f23d6aa6dde475c018d7f482"
SYM_exp_1="7f7454245af4e67cd2296341f21dcba9"

SYM_name_2="cbc(aes)"
SYM_enc_2="1"
SYM_msg_2="1b077a6af4b7f98229de786d7516b639"
SYM_key_2="000000000000000000000000000000000000000000000000"
SYM_iv_2="00000000000000000000000000000000"
SYM_exp_2="275cfc0413d8ccb70513c3859b1d0f72"

SYM_name_3="ecb(aes)"
SYM_enc_3="1"
SYM_msg_3="5ec0fd4db8131af11948b3bd2bf062f6"
SYM_key_3="10617fe4a8f00fbdc2f0611229d6a798"
SYM_exp_3="2a64d2e5ca43c2ce0fe9da7a380c5c8d"

SYM_name_4="cbc(des3_ede)"
SYM_enc_4="1"
SYM_msg_4="1676deb8e94cad96"
SYM_key_4="1089d6bcc7dcb5d01089d6bcc7dcb5d01089d6bcc7dcb5d0"
SYM_iv_4="14f3b34933e23de3"
SYM_exp_4="23e8bf421b9b0982"

SYM_name_5="cbc(des3_ede)"
SYM_enc_5="0"
SYM_msg_5="3a6b67343dc5720c"
SYM_key_5="f1c7fb2c61d30ba1f1c7fb2c61d30ba1f1c7fb2c61d30ba1"
SYM_iv_5="cc0d49cd0f8e330e"
SYM_exp_5="f638910516485e63"

SYM_name_6="cbc(des3_ede)"
SYM_enc_6="1"
SYM_msg_6="95f8a5e5dd31d900"
SYM_key_6="010101010101010101010101010101010101010101010101"
SYM_iv_6="0000000000000000"
SYM_exp_6="8000000000000000"

SYM_name_7="ecb(des3_ede)"
SYM_enc_7="1"
SYM_msg_7="83c882e7698058a998d2020d8dda7a30b9cf6e1fcc359fa533538762dfe83e1d"
SYM_key_7="4089c1587f34c2794089c1587f34c2794089c1587f34c279"
SYM_exp_7="08c4fd965ac65f4cf90845b5b749d8baebe430b676aee67dd777bfb0a1b3b384"

SYM_name_8="xts(aes)"
SYM_enc_8="1"
SYM_msg_8="9ed71d672cb5c2899a18de6667892818"
SYM_key_8="03d996ab0a1c9f08065d780b93bd96fc7fb104a5bd4c86d42d2ff5800ef66c7f"
SYM_iv_8="cc9b5156043bc4a15b07800131e49db8"
SYM_exp_8="4f8ef2d05910b4173bc8f7c3fffcaa6d"

SYM_name_9="xts(aes)"
SYM_enc_9="0"
SYM_msg_9="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"
SYM_key_9="b155ce5fa2ad67556fa0d12ab5666d6c791d2da8d8094cb103b265b68e67b251"
SYM_iv_9="aa3c751a9020239bacd095b1e9aeb501"
SYM_exp_9="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"

SYM_name_10="xts(aes)"
SYM_enc_10="1"
SYM_msg_10="b26bb5a7599c26ea4899b410221ca765d9a26504a74e15a4a5ef5f576de44e44c582a89c7eab056bc862be5b037eeb1b9334da7d2d4c5c108b0600d85857967a"
SYM_key_10="3bdc4d1cdfe701c6781f886f2fd3fa53e3fc8c65362a0e4536c4e11191486d050586ba8808770447192f7e420e7b4653c95d4810f57bc824b2cb8ae1e15da56d"
SYM_iv_10="e6f2d9764112b980b711ce6ac768bd84"
SYM_exp_10="b896df41f5dfb7dc199a62dc1f873e48c386a8d2555e19c89f6018d674dd0b6a63a2ae1ce75268f0f786db34c6cdbdd932fac81d9a068617ff89ea3d3ed6d58a"

SYM_name_11="xts(aes)"
SYM_enc_11="0"
SYM_msg_11="ae3418756443392a2c231f3fccf1b867"
SYM_key_11="5d7e73c6b505927b9e1e1297b0a91a8a9015446eead7ab43f93792f8a144baadbc48dfe8a7b7e505ccd373c7dbe8334c94c067f79450ad0a219de8cdefaf048f"
SYM_iv_11="9bcd9ec09ae7640de77f78db3c219201"
SYM_exp_11="9b4313fc9af1ed18f96fedc0d7c8be17"

SYM_name_12="xts(aes)"
SYM_enc_12="1"
SYM_msg_12="$(printf "%*s" 81920 | tr " " "e")"
SYM_key_12="8d7dd9b0170ce0b5f2f8e1aa768e01e91da8bfc67fd486d081b28254c99eb423"
SYM_iv_12="7fbc02ebf5b93322329df9bfccb635af"
SYM_exp_12="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"

###########################################################################
###########################################################################
###########################################################################

AEAD_name_1="gcm(aes)"
AEAD_enc_1="0"
AEAD_msg_1="d127b39d365d16246d2866b2ebabd201"
AEAD_key_1="38bd9eb2cb29cc42ac38d6cdbe116760"
AEAD_iv_1="aac774c39e399e7d6371ec1d"
AEAD_tag_1="34a21cc3562f0ba141d73242e5a3b666"
AEAD_taglen_1="16"
AEAD_assoc_1="5dbb2884f3fe93664613e863c3bd2572855cf808765880ef1fa5787ceef8c793"
AEAD_exp_1="8f9ec088580c23fc6f5fc011d52f061b"

AEAD_name_2="gcm(aes)"
AEAD_enc_2="0"
AEAD_msg_2="b03692f86d1b8b39baf2abb255197c98"
AEAD_key_2="ea38ac0c9b9998c80e28fb496a2b88d9"
AEAD_iv_2="7815d4b06ae50c9c56e87bd7"
AEAD_tag_2="c4ce58985b7203094be1d134c1b8ab0b"
AEAD_taglen_2="16"
AEAD_assoc_2="853f98a750098bec1aa7497e979e78098155c877879556bb51ddeb6374cbaefc"
AEAD_exp_2="EBADMSG"

AEAD_name_3="gcm(aes)"
AEAD_enc_3="0"
AEAD_msg_3="b92bc4c24b5e7daef79b4320740cd723"
AEAD_key_3="8f7711dcf34ca5c91f238e1411e0ec0e30b2bd19b5b342ad6ec0449e34bbca5c"
AEAD_iv_3="2f312886bd03aec6bf99de96"
AEAD_tag_3="9969c9ef933e2acbb745e7ee6da653"
AEAD_taglen_3="15"
AEAD_assoc_3="af25918702f7e409de376a0fe6c8807e"
AEAD_exp_3="548f2fd6b783f3d04b604babc219f61c"

AEAD_name_4="gcm(aes)"
AEAD_enc_4="0"
AEAD_msg_4="1a4806f15d242092b60c87ec4cc33118"
AEAD_key_4="a0a6a964ca7994c40ca731b1a23168156f280d73f939fb8f"
AEAD_iv_4="fc0e641b1dedebc39eb4054c"
AEAD_tag_4="4acf97a771d6bb52291fd99b26c445"
AEAD_taglen_4="15"
AEAD_assoc_4="3a42524f811b02ed0cbdf44e17e45ae7"
AEAD_exp_4="8637f2c1b48ec482b4d8ca9cd9c22236"

AEAD_name_5="gcm(aes)"
AEAD_enc_5="0"
AEAD_msg_5="ae02f4b43b6b541f3f1eb80f7590974a"
AEAD_key_5="77a46a920b2dd790e7ff5ac24a9b840ae07c4a4f26e63220"
AEAD_iv_5="3e3a9909fcdb86cb476dba03"
AEAD_tag_5="8b08909d14dcd3ba268954225d6cb6"
AEAD_taglen_5="15"
AEAD_assoc_5="b99ef3a7748a9f32bd316d25998116e7"
AEAD_exp_5="EBADMSG"

AEAD_name_6="gcm(aes)"
AEAD_enc_6="0"
AEAD_msg_6="828081c7748d67aa6b86f68daad2ee86211944d510b79d5a4181fec6088fac"
AEAD_key_6="af34f8ac90f66ef716905bac392fb5867306da84f28c582269b6df678db00e44"
AEAD_iv_6="29a2e3aa8ca196decfa01ec6"
AEAD_tag_6="bf1f6d7a"
AEAD_taglen_6="4"
AEAD_assoc_6="08c332b0748855b294eb7a35d1302063f3c2b0fd439403591e15184ac7106d"
AEAD_exp_6="EBADMSG"

AEAD_name_7="gcm(aes)"
AEAD_enc_7="1"
AEAD_msg_7="507937f393b2de0fa218d0a9713262f4"
AEAD_key_7="5aa3d01e7242d7a64f5fd4ad25505390"
AEAD_iv_7="94af90b40cc541173d201250"
AEAD_tag_7="ac767d2d44412252eed41a220f31"
AEAD_taglen_7="14"
AEAD_assoc_7="0f7479e28c53d120fcf57a525e0b36a0"
AEAD_exp_7="e80e074e70b089c160c6d3863e8d2b75"

AEAD_name_8="gcm(aes)"
AEAD_enc_8="1"
AEAD_msg_8="dd1eb52a8004cb37a3fdb97b4d9c25cb7dcbc1be2bcb64d46e45ba3e0522aa"
AEAD_key_8="aad6675ba3c43114cae540505ffa37db7bd6a03b77ebfd09"
AEAD_iv_8="64fbe283c0c5c83452758d80"
AEAD_tag_8="529d9417"
AEAD_taglen_8="4"
AEAD_assoc_8="6ccadafb382dbcfdf2f3d0dc861a03a883d99a3115ff9ce4d4b23a3419f906"
AEAD_exp_8="37f4f79209eaa619972c8454f1b042d70eaa774789998289d4c274336b644d"

AEAD_name_9="gcm(aes)"
AEAD_enc_9="1"
AEAD_msg_9="b05fbd403c2fa41a8cc702a7474ed9ba6c50fcc6c19732a7d300f1113862bc"
AEAD_key_9="87c91a8b63f66934dd3703415b2538461fbfef55ce7a9ca9bb9425499f4cd1d6"
AEAD_iv_9="16c4b4bd1198f39f4ae817b7"
AEAD_tag_9="6d2756d6"
AEAD_taglen_9="4"
AEAD_assoc_9="303bb57e4534b08a4d5f001a84b3052c9d0d58ee03eda5211a540950e819dc"
AEAD_exp_9="9bea5263e7b365d5a06cb3ccab0d43cb9a1ca967dfb7b1a6955b3c493018af"


AEAD_name_10="ccm(aes)"
AEAD_enc_10="0"
AEAD_msg_10="db5fce3f4ba0ac878b8f18733d7f1a6a1c8c8396667c5235c307e874f5783087"
AEAD_key_10="2861fd0253705d7875c95ba8a53171b4"
AEAD_nonce_10="99a789af090798"
AEAD_tag_10="38a263cd"
AEAD_taglen_10="4"
AEAD_assoc_10="34b7ab892c3f06e0305693ffc5ff9d1238e57241e091c584a3df51b9bbb3bff4"
AEAD_exp_10="EBADMSG"

AEAD_name_11="ccm(aes)"
AEAD_enc_11="0"
AEAD_msg_11="4edb58e8d5eb6bc711c43a6f3693daebde2e5524f1b55297abb29f003236e43d"
AEAD_key_11="2861fd0253705d7875c95ba8a53171b4"
AEAD_nonce_11="674742abd0f5ba"
AEAD_tag_11="a7877c99"
AEAD_taglen_11="4"
AEAD_assoc_11="fb7bc304a3909e66e2e0c5ef952712dd884ce3e7324171369f2c5db1adc48c7d"
AEAD_exp_11="8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723"

AEAD_name_12="ccm(aes)"
AEAD_enc_12="1"
AEAD_msg_12="d1379152575e355c96c8bcb5fd80185a2404d9674aef46da01d5ad9a286ff7b8"
AEAD_key_12="7d914f16eb64be52ddd3dee96d62b229"
AEAD_nonce_12="964c1a8f87cce2"
AEAD_taglen_12="16"
AEAD_assoc_12="2a809be85a67c605636ba009e47fde2068d1858c3c505e487e6ca3eb771cffce"
AEAD_exp_12="85ae7dde17be19dbd126ac77a4a4d3689129ac7de57397a23e66b682308a90d2b103d7659f49e47d57bd3f4297c13ff8"

AEAD_name_13="gcm(aes)"
AEAD_enc_13="1"
AEAD_msg_13=""
AEAD_key_13="593ca25cb6e7d4dc754781ef898259be"
AEAD_iv_13="34427393d6a50fb5d73d7ba5"
AEAD_tag_13="e99834b370b6774b25abe7b3f09b08"
AEAD_taglen_13="15"
AEAD_assoc_13="8ec635f54062411e73c7824fe2399721"
AEAD_exp_13=""

AEAD_name_14="rfc4106(gcm(aes))"
AEAD_enc_14="1"
AEAD_msg_14="c5f4aac0ff202c4d292fa9732506607f"
AEAD_key_14="b7369a3ab0e4f219baaf747f650e029f8aeb7394"
AEAD_iv_14="c4edb5723d2a4029"
AEAD_tag_14="40d75ea68c8ccfefdde5cfb4"
AEAD_taglen_14="12"
AEAD_assoc_14="44c9efe4b0a7b98d"
AEAD_exp_14="ada6f4f78913d4bc62a8d546bec17036"

AEAD_name_15="rfc4106(gcm(aes))"
AEAD_enc_15="0"
AEAD_msg_15="989c4c091c73265ef5bf8a2a32ec642d"
AEAD_key_15="c53f008512c48a0d6bccf798ffd5b5fbb9e99835"
AEAD_iv_15="d5f216491cc28e88"
AEAD_tag_15="52b086ea34e1ee94b32457d7"
AEAD_taglen_15="12"
AEAD_assoc_15="1e6e275ca7c93f6d"
AEAD_exp_15="36303126cc98c832399ae827a853c6a9"

AEAD_name_16="gcm(aes)"
AEAD_enc_16="1"
AEAD_msg_16=""
AEAD_key_16="d04f54e831ebb8ce19793e2619e7d279"
AEAD_iv_16="421b8b72834f5003cfab19d9"
AEAD_tag_16="b031d2fa2aa91c31d88c824bca8064a7"
AEAD_taglen_16="16"
AEAD_assoc_16=""
AEAD_exp_16=""

AEAD_name_17="gcm(aes)"
AEAD_enc_17="0"
AEAD_msg_17=""
AEAD_key_17="f4a6a5e5f2066f6dd9ec6fc5169c29043560ef595c9e81e76f42d29212cc581c"
AEAD_iv_17="0d92aa861746b324f20ee6b7"
AEAD_tag_17="5f24c68cbe6f32c29652442bf5d483ad"
AEAD_taglen_17="16"
AEAD_assoc_17=""
AEAD_exp_17="EBADMSG"

###########################################################################
###########################################################################
###########################################################################

ASYM_name_1="rsa"
ASYM_enc_1="0" #0 == enc, 1 == dec, 2 == sign, 3 == verify
ASYM_key_1="3082021F02010102820100DB101AC2A3F1DCFF136BED44DFF0026D13C788DA706B54F1E827DCC30F996AFAC667FF1D1E3C1DC1B55F6CC0B2073A6D41E42599ACFCD20F02D3D154061A5177BDB6BFEAA75C06A95D698445D7F505BA47F01BD72B24ECCB9B1B108D81A0BEB18C33E436B843EB192A818DDE810A9948B6F6BCCD49343A8F2694E328821A7C8F599F45E85D1A4576045605A1D01B8C776DAF53FA71E267E09AFE03A985D2C9AABA2ABCF4A008F51398135DF0D933342A61C38955F0AE1A9C22EE19058D32FEEC9C84BAB7F96C3A4F07FC45EB12E57BFD55E62969D1C2E8B97859F67910C64EEB6A5EB99AC7C45B63DAA33F5E927A815ED6B0E2628F7426C20CD39A1747E68EAB0203010001028201005241F4DA7BB75955CAD42F0F3ACBA40D936CCC9DC1B2FBFDAE4031AC69522192B327DFEAEE2C82BBF74032D514C49412ECB81FCA59E3C178F385D847A5D7021A6579970D24F4F0676E752DBF103DA87DEF7F60E4E60582895DDFC6D26C0791339842F002002538C585698A7D2F956C439AB881E2D00735AA0541C91EAFE4043B19B873A2AC4B1E6648D8721FACF6CBBC9009CAEC0CDCF92CD7EBAEA3A447D7332F8ACABC5EF077E4979897C710917D2AA6FF468397DEE9E217030614E2D7B11D77AF51275B5E69B881E611C54323810462FFE946B8D844DBA5CC315434CE3E82D6BF7A0B64216D887E5B45121E638D49A71DD91E06CDE8BA2C8C6932EABE6071020100020100020100020100020100"
ASYM_pubkey_1=""
ASYM_msg_1="54859b342c49ea2a"
ASYM_exp_1="b29776b4ae3e383c7e641fcca27ff6becf49bc48d36c8f0a0ec173bd7b5579360ea18788b92c90a6535ee9efc4e24dddf7a669823f56a47bfb62e0aeb8d304b3ac5a152ae3199b039a0b41da64ec0a69fcf21092f3c1bf847ffd2caec8b5f64170c547038af8ff6f3fd26f09b422f330bea985cb9c8df98feb3291a225848ff5dcc7069c2de5112c09098709a9f6337390f160f265dd30a566ce627bd0f82d3d198277e30a5f752f8eb1e5e891351b3b33b76692d1f28e6fe5750cad36fb4ed06661bd49fef41aa22b49fe034c74478d9a66b249464d77ea334d6b3cb4494ac67d3db5b9564115670f943c936527e0215d59c362d5a6da3826225e341c94af98"

ASYM_name_2="rsa"
ASYM_enc_2="0" #0 == enc, 1 == dec, 2 == sign, 3 == verify
ASYM_key_2=""
ASYM_pubkey_2="3082010902820100DB101AC2A3F1DCFF136BED44DFF0026D13C788DA706B54F1E827DCC30F996AFAC667FF1D1E3C1DC1B55F6CC0B2073A6D41E42599ACFCD20F02D3D154061A5177BDB6BFEAA75C06A95D698445D7F505BA47F01BD72B24ECCB9B1B108D81A0BEB18C33E436B843EB192A818DDE810A9948B6F6BCCD49343A8F2694E328821A7C8F599F45E85D1A4576045605A1D01B8C776DAF53FA71E267E09AFE03A985D2C9AABA2ABCF4A008F51398135DF0D933342A61C38955F0AE1A9C22EE19058D32FEEC9C84BAB7F96C3A4F07FC45EB12E57BFD55E62969D1C2E8B97859F67910C64EEB6A5EB99AC7C45B63DAA33F5E927A815ED6B0E2628F7426C20CD39A1747E68EAB0203010001"
ASYM_msg_2="54859b342c49ea2a"
ASYM_exp_2="b29776b4ae3e383c7e641fcca27ff6becf49bc48d36c8f0a0ec173bd7b5579360ea18788b92c90a6535ee9efc4e24dddf7a669823f56a47bfb62e0aeb8d304b3ac5a152ae3199b039a0b41da64ec0a69fcf21092f3c1bf847ffd2caec8b5f64170c547038af8ff6f3fd26f09b422f330bea985cb9c8df98feb3291a225848ff5dcc7069c2de5112c09098709a9f6337390f160f265dd30a566ce627bd0f82d3d198277e30a5f752f8eb1e5e891351b3b33b76692d1f28e6fe5750cad36fb4ed06661bd49fef41aa22b49fe034c74478d9a66b249464d77ea334d6b3cb4494ac67d3db5b9564115670f943c936527e0215d59c362d5a6da3826225e341c94af98"

ASYM_name_3="rsa"
ASYM_enc_3="1" #0 == enc, 1 == dec, 2 == sign, 3 == verify
ASYM_key_3="3082021F02010102820100DB101AC2A3F1DCFF136BED44DFF0026D13C788DA706B54F1E827DCC30F996AFAC667FF1D1E3C1DC1B55F6CC0B2073A6D41E42599ACFCD20F02D3D154061A5177BDB6BFEAA75C06A95D698445D7F505BA47F01BD72B24ECCB9B1B108D81A0BEB18C33E436B843EB192A818DDE810A9948B6F6BCCD49343A8F2694E328821A7C8F599F45E85D1A4576045605A1D01B8C776DAF53FA71E267E09AFE03A985D2C9AABA2ABCF4A008F51398135DF0D933342A61C38955F0AE1A9C22EE19058D32FEEC9C84BAB7F96C3A4F07FC45EB12E57BFD55E62969D1C2E8B97859F67910C64EEB6A5EB99AC7C45B63DAA33F5E927A815ED6B0E2628F7426C20CD39A1747E68EAB0203010001028201005241F4DA7BB75955CAD42F0F3ACBA40D936CCC9DC1B2FBFDAE4031AC69522192B327DFEAEE2C82BBF74032D514C49412ECB81FCA59E3C178F385D847A5D7021A6579970D24F4F0676E752DBF103DA87DEF7F60E4E60582895DDFC6D26C0791339842F002002538C585698A7D2F956C439AB881E2D00735AA0541C91EAFE4043B19B873A2AC4B1E6648D8721FACF6CBBC9009CAEC0CDCF92CD7EBAEA3A447D7332F8ACABC5EF077E4979897C710917D2AA6FF468397DEE9E217030614E2D7B11D77AF51275B5E69B881E611C54323810462FFE946B8D844DBA5CC315434CE3E82D6BF7A0B64216D887E5B45121E638D49A71DD91E06CDE8BA2C8C6932EABE6071020100020100020100020100020100"
ASYM_pubkey_3=""
ASYM_msg_3="b29776b4ae3e383c7e641fcca27ff6becf49bc48d36c8f0a0ec173bd7b5579360ea18788b92c90a6535ee9efc4e24dddf7a669823f56a47bfb62e0aeb8d304b3ac5a152ae3199b039a0b41da64ec0a69fcf21092f3c1bf847ffd2caec8b5f64170c547038af8ff6f3fd26f09b422f330bea985cb9c8df98feb3291a225848ff5dcc7069c2de5112c09098709a9f6337390f160f265dd30a566ce627bd0f82d3d198277e30a5f752f8eb1e5e891351b3b33b76692d1f28e6fe5750cad36fb4ed06661bd49fef41aa22b49fe034c74478d9a66b249464d77ea334d6b3cb4494ac67d3db5b9564115670f943c936527e0215d59c362d5a6da3826225e341c94af98"
ASYM_exp_3="000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000054859b342c49ea2a"

# CAVS test with parameters of:
#        "SIGGEN1-2048" => {
#                name => "pkcs1pad(rsa-generic,sha256)",
#                msg => "4941be0a0cc9f63551e4275613714bd0369284891bf8564a726114694f5e98a5805a37511fd8f5b563fcf4b1bb4d33a31eb9758b9cda7e6d3a7785f7fc4ee764431019a059aee0ad4bd3c445f7b1c2c1650141395b4547ed2b51ede3d00910d2396c4a3fe5d220e6b0717d5bed2660f1b473d1db7dc41991eef63276f2197db7",
#                rsa_n => "00d71e77828c9231e76902a2d55c78dea20c8ffe285931df409c606106b92f62408076cb674ab55956691707faf94cbd6c377a467d70a76722b34d7a94c3ba4b7c4ba9327cb738954564a405a89f127c4ec6c82d400630f460a691bb9bca0479111375f0aed35189c574b9aa3fb683e4786bcdf95c4c85ea523b5193fc146b335d3070fa501b1b3881138df7a50cc08ef96352184ea9f9f85c5dcd7a0dd48e7bee917bad7db492d5ab163b0a8ace8ede471a1701867bab99f14b0c3a0d8247c1918cbb2e229e49636e02c1c93a9ba5221b0795d6100250fdfdd19bbeabc2c074d7ec00fb1171cb7adc81799f86684663824db7f1e6166f4263f494a0ca33cc7513",
#                rsa_e => "10001",
#                rsa_d => "62b560314f3f6616c160ac472aff6b69004ab25ce150b91874a8e4dca8eccd30bbc1c6e3c6ac202a3e5e8b12e6820809380bab7cb3cc9cce9767ddef95404e92e244e91dc114fda9b1dc719c4621bd58886e221556c1efe0c98de5803eda7e930f52f6f5c191909e42494f8d9cba3883e933c2504fecc2f0a8b76e2825566b6267fe08f156e56f0e99f1e5957befeb0a2c92975723333607ddfbaef1b1d833b796714236c5a4a9194b1b524c506991f00efa80374bb5d02fb7440dd4f8398dab71675905883deb484833884efef8271bd655605e48b76d9aa837f97ade1bcd5d1a30d4e99e5b3c15f89c1fdad1864855ce83ee8e51c7de3212477d46b835df41",
#                exp => "c7a398eb43d108c23d78450470c901eef885377c0bf919705c457b2f3a0bb78bc40d7b3a640b0fdb78a90bfd8d82a48639bf21b884c4ce9fc2e8b6614617b94e0b5705b44ff99c932d9bd5481d8012ef3a777fbcb58e2b6b7cfc9f8c9da2c485b087e9179bb62362d2a99f57e8f70445243a45ebeb6a088eafc8a084bc5d1338f5178ca3969ba9388df035ad328a725bdf21ab4b0ea829bb6154bf05db8484dedd163631daf3426d7a90229b1129a6f83061dad38b541e42d1471d6fd1cd420bd1e415857e08d659644c0134919226e8b0258cf8f4fa8bc931337672fb64929fda628de12a71914340613c5abe86fc5be6f9a916311faf256dc24a236e6302a2",
#        },
ASYM_name_4="pkcs1pad(rsa-generic,sha256)"
ASYM_enc_4="2" #siggen
ASYM_key_4="308202200201100282010100d71e77828c9231e76902a2d55c78dea20c8ffe285931df409c606106b92f62408076cb674ab55956691707faf94cbd6c377a467d70a76722b34d7a94c3ba4b7c4ba9327cb738954564a405a89f127c4ec6c82d400630f460a691bb9bca0479111375f0aed35189c574b9aa3fb683e4786bcdf95c4c85ea523b5193fc146b335d3070fa501b1b3881138df7a50cc08ef96352184ea9f9f85c5dcd7a0dd48e7bee917bad7db492d5ab163b0a8ace8ede471a1701867bab99f14b0c3a0d8247c1918cbb2e229e49636e02c1c93a9ba5221b0795d6100250fdfdd19bbeabc2c074d7ec00fb1171cb7adc81799f86684663824db7f1e6166f4263f494a0ca33cc751302031000100282010062b560314f3f6616c160ac472aff6b69004ab25ce150b91874a8e4dca8eccd30bbc1c6e3c6ac202a3e5e8b12e6820809380bab7cb3cc9cce9767ddef95404e92e244e91dc114fda9b1dc719c4621bd58886e221556c1efe0c98de5803eda7e930f52f6f5c191909e42494f8d9cba3883e933c2504fecc2f0a8b76e2825566b6267fe08f156e56f0e99f1e5957befeb0a2c92975723333607ddfbaef1b1d833b796714236c5a4a9194b1b524c506991f00efa80374bb5d02fb7440dd4f8398dab71675905883deb484833884efef8271bd655605e48b76d9aa837f97ade1bcd5d1a30d4e99e5b3c15f89c1fdad1864855ce83ee8e51c7de3212477d46b835df41020130020130020130020130020130" # ASN.1 BER key of n, e, d
ASYM_pubkey_4=""
ASYM_msg_4="3ec8a12620544452480de566f3b3f504be10a84894222dddba7ab4768d799889" # SHA256 hash of message
ASYM_exp_4="c7a398eb43d108c23d78450470c901eef885377c0bf919705c457b2f3a0bb78bc40d7b3a640b0fdb78a90bfd8d82a48639bf21b884c4ce9fc2e8b6614617b94e0b5705b44ff99c932d9bd5481d8012ef3a777fbcb58e2b6b7cfc9f8c9da2c485b087e9179bb62362d2a99f57e8f70445243a45ebeb6a088eafc8a084bc5d1338f5178ca3969ba9388df035ad328a725bdf21ab4b0ea829bb6154bf05db8484dedd163631daf3426d7a90229b1129a6f83061dad38b541e42d1471d6fd1cd420bd1e415857e08d659644c0134919226e8b0258cf8f4fa8bc931337672fb64929fda628de12a71914340613c5abe86fc5be6f9a916311faf256dc24a236e6302a2"

# CAVS test with parameters of:
#        "SIGVER-PASS0" => {
#                name => "pkcs1pad(rsa-generic,sha256)",
#                type => "0x00000020",
#                msg => "99649579d45fdb3d09836be068cc9878811e0f0f06eebaf6d23fe55d2bd1a021449564e50663f96410ef9605fdfa4bb1e5c59ce126cb6ffb64af28dece7412bba3ec0128f573356faedd822cd0acae1701861b1e46e7a5b70f14ce74745019d7be51b36929f55806e832757b6a4b8a53dc4ad3edefaa27d2db542046a4cd7c1d",
#                rsa_sig => "3db2f89b6acd0b0eb0df5d18818145d87241b774da4e20aa97bf412a94c4e0c5ef923657a81c4ae4669970060c494d21f7cef5de40e755d85e54377f6e2ada35275b7c8ec184a585fe2ee665d96f6e086f738b49ce1eb381d96e6817d80347f29df50aaeebc4a48c67cd28d37c312d2cc80b9469cb402e28bfea5387bab6311bb214955992f3063cd9687e1a9f3ff4426209b9e1eb47bafa364a9f71ee0c0d8affc945d708497303a2164e8f93dec94dd7303b43828721c0786d1bc4004486ed0de53b075b8f82e2ba007f516659ab129e0fcf616a9066d3de391fd7c93ac5136075c0ebb9b936e76c6014b27c7fc963eafca11d6ec9b050d211fd18a661db3a",
#                rsa_n => "965f0f7526036bf956960324250b5cfd383631e17a447c9997b654ae38b11c730bd4c70f7434ab8d440267d7b08c743394ae2bd1160d3dba07190cee213f841a182a4d36a2e14d3551882c0f9a3ff12ddb048f88f1ff8c7e43db8f902c83683f72bd2fe62fc3de611dc78329618c0fb029ad1d5d573eb6c95f115eb7ce598274b98edad641e42c7da6751e7ebaac45e33cac14490300ae2cefb788a7a69312304f190f6fed53a8b7deefc96056c85237efa2d2a94baf85358d21c14f82692e04774980b798a89a1d419a25ac2602a5e990bfce0bc975c7dbc6f3aab5463d56725d839ff05f0fff6eef5b6549f129534e45ecc752509ea7cf4814a155e39348ff",
#                rsa_e => "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e16f83",
#        },
ASYM_name_5="pkcs1pad(rsa-generic,sha256)"
ASYM_enc_5="3" #sigver
ASYM_key_5=""
ASYM_pubkey_5="3082020802820100965f0f7526036bf956960324250b5cfd383631e17a447c9997b654ae38b11c730bd4c70f7434ab8d440267d7b08c743394ae2bd1160d3dba07190cee213f841a182a4d36a2e14d3551882c0f9a3ff12ddb048f88f1ff8c7e43db8f902c83683f72bd2fe62fc3de611dc78329618c0fb029ad1d5d573eb6c95f115eb7ce598274b98edad641e42c7da6751e7ebaac45e33cac14490300ae2cefb788a7a69312304f190f6fed53a8b7deefc96056c85237efa2d2a94baf85358d21c14f82692e04774980b798a89a1d419a25ac2602a5e990bfce0bc975c7dbc6f3aab5463d56725d839ff05f0fff6eef5b6549f129534e45ecc752509ea7cf4814a155e39348ff0282010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e16f83" # ASN.1 BER encoding of n and e
ASYM_msg_5="3db2f89b6acd0b0eb0df5d18818145d87241b774da4e20aa97bf412a94c4e0c5ef923657a81c4ae4669970060c494d21f7cef5de40e755d85e54377f6e2ada35275b7c8ec184a585fe2ee665d96f6e086f738b49ce1eb381d96e6817d80347f29df50aaeebc4a48c67cd28d37c312d2cc80b9469cb402e28bfea5387bab6311bb214955992f3063cd9687e1a9f3ff4426209b9e1eb47bafa364a9f71ee0c0d8affc945d708497303a2164e8f93dec94dd7303b43828721c0786d1bc4004486ed0de53b075b8f82e2ba007f516659ab129e0fcf616a9066d3de391fd7c93ac5136075c0ebb9b936e76c6014b27c7fc963eafca11d6ec9b050d211fd18a661db3a" # signature
ASYM_exp_5="d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825" # SHA256 hash of message

###########################################################################
###########################################################################
###########################################################################

KDF_name_1="hmac(sha256)"
KDF_type_1=5 #5 CTR KDF, 6 FB KDF, 7 DPI KDF
KDF_key_1="dd1d91b7d90b2bd3138533ce92b272fbf8a369316aefe242e659cc0ae238afe0"
KDF_msg_1="01322b96b30acd197979444e468e1c5c6859bf1b1cf951b7e725303e237e46b864a145fab25e517b08f8683d0315bb2911d80a0e8aba17f3b413faac"
KDF_exp_1="10621342bfb0fd40046c0e29f2cfdbf0"

KDF_name_2="hmac(sha256)"
KDF_type_2=6 #5 CTR KDF, 6 FB KDF, 7 DPI KDF
KDF_key_2="93f698e842eed75394d629d957e2e89c6e741f810b623c8b901e38376d068e7b"
KDF_msg_2="9f575d9059d3e0c0803f08112f8a806de3c3471912cdf42b095388b14b33508e53b89c18690e2057a1d167822e636de50be0018532c431f7f5e37f77139220d5e042599ebe266af5767ee18cd2c5c19a1f0f80"
KDF_exp_2="bd1476f43a4e315747cf5918e0ea5bc0d98769457477c3ab18b742def0e079a933b756365afb5541f253fee43c6fd788a44041038509e9eeb68f7d65ffbb5f95"

KDF_name_3="hmac(sha256)"
KDF_type_3=7 #5 CTR KDF, 6 FB KDF, 7 DPI KDF
KDF_key_3="02d36fa021c20ddbdee469f0579468bae5cb13b548b6c61cdf9d3ec419111de2"
KDF_msg_3="85abe38bf265fbdc6445ae5c71159f1548c73b7d526a623104904a0f8792070b3df9902b9669490425a385eadb0f9c76e46f0f"
KDF_exp_3="d69f74f518c9f64f90a0beebab69f689b73b5c13eb0f860a95cad7d9814f8c506eb7b179a5c5b4466a9ec154c3bf1c13efd6ec0d82b02c29af2c690299edc453"

###########################################################################
###########################################################################
###########################################################################

PBKDF_name_1="hmac(sha1)"
PBKDF_salt_1="73616c74"
PBKDF_pw_1="70617373776f7264"
PBKDF_count_1=1
PBKDF_exp_1="0c60c80f961f0e71f3a9b524af6012062fe037a6"	# RFC 6070

PBKDF_name_2="hmac(sha1)"
PBKDF_salt_2="73616c74"
PBKDF_pw_2="70617373776f7264"
PBKDF_count_2=2
PBKDF_exp_2="ea6c014dc72d6f8ccd1ed92ace1d41f0d8de8957"	# RFC 6070

PBKDF_name_3="hmac(sha1)"
PBKDF_salt_3="73616c74"
PBKDF_pw_3="70617373776f7264"
PBKDF_count_3=4096
PBKDF_exp_3="4b007901b765489abead49d926f721d065a429c1"	# RFC 6070

PBKDF_name_4="hmac(sha1)"
PBKDF_salt_4="73616c74"
PBKDF_pw_4="70617373776f7264"
PBKDF_count_4=16777216
PBKDF_exp_4="eefe3d61cd4da4e4e9945b3d6ba2158c2634e984"	# RFC 6070

PBKDF_name_5="hmac(sha1)"
PBKDF_salt_5="73616c7453414c5473616c7453414c5473616c7453414c5473616c7453414c5473616c74"
PBKDF_pw_5="70617373776f726450415353574f524470617373776f7264"
PBKDF_count_5=4096
PBKDF_exp_5="3d2eec4fe41c849b80c8d83662c0e44a8b291a964cf2f07038" # RFC 6070

PBKDF_name_6="hmac(sha1)"
PBKDF_salt_6="7361006c74"
PBKDF_pw_6="7061737300776f7264"
PBKDF_count_6=4096
PBKDF_exp_6="56fa6aa75548099dcc37d7f03425e0c3"		# RFC 6070

PBKDF_name_7="hmac(sha1)"
PBKDF_salt_7="73616c74"
PBKDF_pw_7=""
PBKDF_count_7=2
PBKDF_exp_7="133a4ce837b4d2521ee2bf03e11c71ca794e0797"

PBKDF_name_8="hmac(sha256)"
PBKDF_salt_8="73616c74"
PBKDF_pw_8="70617373776f7264"
PBKDF_count_8=4096
PBKDF_exp_8="c5e478d59288c841aa530db6845c4c8d962893a0"

PBKDF_name_9="hmac(sha224)"
PBKDF_salt_9="73616c74"
PBKDF_pw_9="70617373776f7264"
PBKDF_count_9=4096
PBKDF_exp_9="218c453bf90635bd0a21a75d172703ff6108ef60"

PBKDF_name_10="hmac(sha384)"
PBKDF_salt_10="73616c74"
PBKDF_pw_10="70617373776f7264"
PBKDF_count_10=4096
PBKDF_exp_10="559726be38db125bc85ed7895f6e3cf574c7a01c"

PBKDF_name_11="hmac(sha512)"
PBKDF_salt_11="73616c74"
PBKDF_pw_11="70617373776f7264"
PBKDF_count_11=4096
PBKDF_exp_11="d197b1b33db0143e018b12f3d1d1479e6cdebdcc"

PBKDF_name_12="cmac(aes)"
PBKDF_salt_12="73616c74"
PBKDF_pw_12="70617373776f726470617373776f7264"
PBKDF_count_12=4096
PBKDF_exp_12="c4c112c6e1e3b8757640603dec78825ff87605a7"

PBKDF_name_13="hmac(sha512)"
PBKDF_salt_13="73616c74"
PBKDF_pw_13="70617373776f7264"
PBKDF_count_13=4096
PBKDF_exp_13="d197b1b33db0143e018b12f3d1d1479e6cdebdcc97c5c0f87f6902e072f457b5143f30602641b3d55cd335988cb36b84376060ecd532e039b742a239434af2d5d6883f0be4c24d363b638f4c2f8d917533cd4158937d0b490697a64adadb07f180c323080a7368033eeadf9e612b2e"

###########################################################################
###########################################################################
###########################################################################

#RFC 5869 Appendix A vectors
HKDF_name_1="hmac(sha256)"
HKDF_ikm_1="0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b"
HKDF_salt_1="000102030405060708090a0b0c"
HKDF_info_1="f0f1f2f3f4f5f6f7f8f9"
HKDF_exp_1="3cb25f25faacd57a90434f64d0362f2a2d2d0a90cf1a5a4c5db02d56ecc4c5bf34007208d5b887185865"

HKDF_name_2="hmac(sha256)"
HKDF_ikm_2="000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f"
HKDF_salt_2="606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf"
HKDF_info_2="b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff"
HKDF_exp_2="b11e398dc80327a1c8e7f78c596a49344f012eda2d4efad8a050cc4c19afa97c59045a99cac7827271cb41c65e590e09da3275600c2f09b8367793a9aca3db71cc30c58179ec3e87c14c01d5c1f3434f1d87"

HKDF_name_3="hmac(sha256)"
HKDF_ikm_3="0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b"
HKDF_salt_3=""
HKDF_info_3=""
HKDF_exp_3="8da4e775a563c18f715f802a063c5a31b8a11f5c5ee1879ec3454e5f3c738d2d9d201395faa4b61a96c8"

HKDF_name_4="hmac(sha1)"
HKDF_ikm_4="0b0b0b0b0b0b0b0b0b0b0b"
HKDF_salt_4="000102030405060708090a0b0c"
HKDF_info_4="f0f1f2f3f4f5f6f7f8f9"
HKDF_exp_4="085a01ea1b10f36933068b56efa5ad81a4f14b822f5b091568a9cdd4f155fda2c22e422478d305f3f896"

HKDF_name_5="hmac(sha1)"
HKDF_ikm_5="000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f"
HKDF_salt_5="606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf"
HKDF_info_5="b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff"
HKDF_exp_5="0bd770a74d1160f7c9f12cd5912a06ebff6adcae899d92191fe4305673ba2ffe8fa3f1a4e5ad79f3f334b3b202b2173c486ea37ce3d397ed034c7f9dfeb15c5e927336d0441f4c4300e2cff0d0900b52d3b4"

HKDF_name_6="hmac(sha1)"
HKDF_ikm_6="0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b"
HKDF_salt_6=""
HKDF_info_6=""
HKDF_exp_6="0ac1af7002b3d761d1e55298da9d0506b9ae52057220a306e07b6b87e8df21d0ea00033de03984d34918"

HKDF_name_7="hmac(sha1)"
HKDF_ikm_7="0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c"
HKDF_salt_7=""
HKDF_info_7=""
HKDF_exp_7="2c91117204d745f3500d636a62f64f0ab3bae548aa53d423b0d1f27ebba6f5e5673a081d70cce7acfc48"

###########################################################################
###########################################################################
###########################################################################

# Test: generate public key
KPP_name_1="dh"
KPP_param_1="308201080282010100e0ea4b21b76a0761f6d55ddbc8c5108a3e73f1580c29ba419b6baa4a9130cc17d8d945dd1cc92c9a0a690fe52a184d2021dc039e6a9d54e15a4fc040d5db392e6bcad7926eb384793cb253a76d250b6cccd5523ca75c85942c2a5502be36c113f9afd97399c5ba6d8cc4a407eee82bf7b9d76a7ba6a2560ff17f4fbdb2861a5d4401e1848177aeae5fa93ecb1b1ad8880c85e059f8ea3909ab7f23f7606129e55280e8cc53741a6465399fd6e93bff68d52d715138111d94432462140834162f1a5e3cd230ccf82e2c2df62865d1753bf83001abb2260d2ad457441baabc023d91413668a2a3603c6ed775d15c9d9ecb36fbd285c1aec03fb9673af9b933c453020102"
KPP_curve_1=""
KPP_privkey_1="537df84c6ce223486cbdda3aef2b819a57a74bfcab09c63d1ca14327b327e8d5d7642174f4110822878eb2eedd6d378eff3b1ad27e9197bc1ad8a08bf6f28f5b4b5f8e03f73321f7850f107f68e5ad3bad97e44e797a79895be9bcf91586dbe9aeb47096c82135d87ccbd5aad1957fbf9d91700140849dc5116f91bd02de01105b61bcabd68c55fa317b6dd24b8cc979417ca480a5c21709c432a0b9b4549a78fbf038cfd967b1034d6897bc1a37c5c5703d152ae6f6b92cf99c4cb4b277a423f0b263f4ed64ce8ac7d2628d5cd5ae24a03d3a5e1037ebdd242fb9953ad2b6a3da4b2095400161a4d20c5eb99bd671087004e70ebd7b835b56c6a4c7cf3a5444"
KPP_peerkey_1=""
KPP_exp_1="ab3bf89a2c175b34762a8476cafad361b677b0025caa7738c6816f8e1af284134ef86ce9e37bf759c911e6aef3085e84859b0d07ef5fcd81c4f424ebb458ea9689b58db57506eb2e93f0f09305f33e01d6f0f3fd2d15e059f48836566ba340aa245b11369a5fbda21cd6bce32d00b38c09f0bab89b0d5ba9941bc011c2ed48dfada542fea76b6add5efc7d0896c9e27d0c03d8882beee54282034c75cf7a3c5aba2d1e8c0ee1c8472c0752da2bb869d18dddf1a342eae81f0354a7f8973bfb6d5304a0f6b5256f70b84d8c21e680c38d3f2fe90da74899d897ae13c37e4f1efc67153b46cefd0d7edadaac1f84a7d043279527956b5ae64cefc00f9e48a4a83a"

# Test: generate shared secret
KPP_name_2="dh"
KPP_param_2="308201080282010100e0ea4b21b76a0761f6d55ddbc8c5108a3e73f1580c29ba419b6baa4a9130cc17d8d945dd1cc92c9a0a690fe52a184d2021dc039e6a9d54e15a4fc040d5db392e6bcad7926eb384793cb253a76d250b6cccd5523ca75c85942c2a5502be36c113f9afd97399c5ba6d8cc4a407eee82bf7b9d76a7ba6a2560ff17f4fbdb2861a5d4401e1848177aeae5fa93ecb1b1ad8880c85e059f8ea3909ab7f23f7606129e55280e8cc53741a6465399fd6e93bff68d52d715138111d94432462140834162f1a5e3cd230ccf82e2c2df62865d1753bf83001abb2260d2ad457441baabc023d91413668a2a3603c6ed775d15c9d9ecb36fbd285c1aec03fb9673af9b933c453020102"
KPP_curve_2=""
KPP_privkey_2="537df84c6ce223486cbdda3aef2b819a57a74bfcab09c63d1ca14327b327e8d5d7642174f4110822878eb2eedd6d378eff3b1ad27e9197bc1ad8a08bf6f28f5b4b5f8e03f73321f7850f107f68e5ad3bad97e44e797a79895be9bcf91586dbe9aeb47096c82135d87ccbd5aad1957fbf9d91700140849dc5116f91bd02de01105b61bcabd68c55fa317b6dd24b8cc979417ca480a5c21709c432a0b9b4549a78fbf038cfd967b1034d6897bc1a37c5c5703d152ae6f6b92cf99c4cb4b277a423f0b263f4ed64ce8ac7d2628d5cd5ae24a03d3a5e1037ebdd242fb9953ad2b6a3da4b2095400161a4d20c5eb99bd671087004e70ebd7b835b56c6a4c7cf3a5444"
KPP_peerkey_2="00ab3bf89a2c175b34762a8476cafad361b677b0025caa7738c6816f8e1af284134ef86ce9e37bf759c911e6aef3085e84859b0d07ef5fcd81c4f424ebb458ea9689b58db57506eb2e93f0f09305f33e01d6f0f3fd2d15e059f48836566ba340aa245b11369a5fbda21cd6bce32d00b38c09f0bab89b0d5ba9941bc011c2ed48dfada542fea76b6add5efc7d0896c9e27d0c03d8882beee54282034c75cf7a3c5aba2d1e8c0ee1c8472c0752da2bb869d18dddf1a342eae81f0354a7f8973bfb6d5304a0f6b5256f70b84d8c21e680c38d3f2fe90da74899d897ae13c37e4f1efc67153b46cefd0d7edadaac1f84a7d043279527956b5ae64cefc00f9e48a4a83a"
KPP_exp_2="78fbd4d1ed7ea6fc8f1e1a6f8a5c750845401589ad3c135088b4ec78f54c57b436d1a7a25ef3f807f72b71387f6f3624b008024fa655cf902daf11e487181ab0f59aa46ff5d0ea41574a524cc07d6d8510dcef4d550718b042fb140fb166ade62669305380377f3958f0d91c81deda0c9c5fddea4f8dd4792629407dfc2c45622099a5fa4facd78adea5c4dc32daff9fc37e3b0248576376d2e5884a7b0f7af8d7a1d308dbcbf95fee99cc336be9e5dd9ea3874806a1b3fb390a737caf37dc884f6c0a61d3ab5a420ecb9ca34069a36264cb418d4d4520ba12170b849762f6bc2f31cbfbfe6eadac3c3739daa49d2a96fd76b553e7e1198837df41c59f9b7f54"

###########################################################################
###########################################################################
###########################################################################

# Test required for test with multiple IOVECs on i686
check_memory() {
	if [ $(cat /proc/sys/net/core/optmem_max) -lt $1 ]
	then
		echo "Socket memory size too small for test, set to 20480" 1>&2
		echo "echo 20480 > /proc/sys/net/core/optmem_max" 1>&2
		return 1
	fi
}

check_memory_hard() {
	check_memory 20480
}

check_memory_soft() {
	check_memory 10240
}

hashfunc()
{
	stream=$1
	HASHEXEC="1 2 3 4 5 6 7 8 9"
	for i in $HASHEXEC
	do
		eval HASH_name=\$HASH_name_$i
		eval HASH_key=\$HASH_key_$i
		eval HASH_msg=\$HASH_msg_$i
		eval HASH_exp=\$HASH_exp_$i

		explen=$(echo -n $HASH_exp | wc -c)
		key=""
		if [ -n "$HASH_key" ]
		then
			key="-k $HASH_key"
		fi

		if [ "$HASH_msg" = '00' ]
		then
			HASH_msg="-"
		fi
		cmd="$KCAPI -x 3 $stream -c ${HASH_name} ${key} -p ${HASH_msg}"
		result=$($cmd 2>/dev/null)

		outlen=$(echo -n $result | wc -c)

		if [ "$outlen" -ne "$explen" ]
		then
			result=$(echo $result | cut -b -$explen)
		fi

		sout="one shot"
		if [ -n "$stream" ]
		then
			sout="stream"
		fi
		if [ x"$result" = x"$HASH_exp" ]
		then
			echo_pass "Hash $sout test $i"
		else
			echo_fail "Hash $sout test $i"
			echo "($cmd)"
			echo " Exp $HASH_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

symfunc()
{
	impl=$1
	stream=$2
	aligned=$3
	aiofallback=$4

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi
	if [ x"$aligned" = x"X" ]
	then
		aligned=""
	fi

	if [ $impl -eq 9 ]
	then
		impl_type="asynchronous"
	else
		impl_type="synchronous"
	fi

	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	elif [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	elif [ x"$stream" = x"-j" ] || [ x"$stream" = x"-s -j" ]
	then
		sout="multithreaded"
		stream="-s -j"
	else
		sout="one shot"
	fi

	if [ x"$aligned" = x"-m" ]
	then
		aout="aligned"
	else
		aout="non-aligned"
	fi

	if [ x"$sout" = x"stream" ] && ! check_memory_hard; then
		echo_deact "Symmetric $impl_type $sout $aout tests"
		return 0
	fi

	SYMEXEC="1 2 3 4 5 6 7 8 9 10 11 12"
	for i in $SYMEXEC
	do
		eval SYM_name=\$SYM_name_$i
		eval SYM_enc=\$SYM_enc_$i
		eval SYM_key=\$SYM_key_$i
		eval SYM_iv=\$SYM_iv_$i
		eval SYM_msg=\$SYM_msg_$i
		eval SYM_exp=\$SYM_exp_$i

		iv=""
		if [ -n "$SYM_iv" ]
		then
			iv="-i $SYM_iv"
		fi
		if [ "$SYM_enc" = 1  ]
		then
			cmd="$KCAPI $aiofallback -x $impl $stream $aligned -e -c $SYM_name $iv -k $SYM_key -p $SYM_msg"
		else
			cmd="$KCAPI $aiofallback -x $impl $stream $aligned -c $SYM_name $iv -k $SYM_key -q $SYM_msg"
		fi
		result=$($cmd 2>/dev/null)

		if [ x"$result" = x"$SYM_exp" ]
		then
			echo_pass "Symmetric $impl_type $sout $aout test $i"
		else
			echo_fail "Symmetric $impl_type $sout $aout test $i"
			echo "($cmd)"
			echo " Exp $SYM_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

asymfunc()
{
	impl=$1
	stream=$2
	aligned=$3
	aiofallback=$4

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi
	if [ x"$aligned" = x"X" ]
	then
		aligned=""
	fi

	if [ $impl -eq 11 ]
	then
		impl_type="asynchronous"
	else
		impl_type="synchronous"
	fi

	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	elif [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	else
		sout="one shot"
	fi

	if [ x"$aligned" = x"-m" ]
	then
		aout="aligned"
	else
		aout="non-aligned"
	fi

	if [ x"$sout" = x"stream" ] && ! check_memory_hard; then
		echo_deact "Asymmetric $impl_type $sout $aout tests"
		return 0
	fi

	ASYMEXEC="1 2 3 4 5"
	for i in $ASYMEXEC
	do
		eval ASYM_name=\$ASYM_name_$i
		eval ASYM_enc=\$ASYM_enc_$i
		eval ASYM_key=\$ASYM_key_$i
		eval ASYM_pubkey=\$ASYM_pubkey_$i
		eval ASYM_msg=\$ASYM_msg_$i
		eval ASYM_exp=\$ASYM_exp_$i

		keyopt=""
		if [ -n "$ASYM_key" ]
		then
			keyopt="-k $ASYM_key"
		fi
		if [ -n "$ASYM_pubkey" ]
		then
			keyopt="-r $ASYM_pubkey"
		fi

		enc="-o $ASYM_enc"

		cmd="$KCAPI $aioaligned -x $impl $stream $aligned $enc -c $ASYM_name $keyopt -p $ASYM_msg"
		result=$($cmd 2>/dev/null)

		if [ x"$result" = x"$ASYM_exp" ]
		then
			echo_pass "Asymmetric $impl_type $sout $aout test $i"
		else
			echo_fail "Asymmetric $impl_type $sout $aout test $i"
			echo "($cmd)"
			echo " Exp $ASYM_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

kppfunc()
{
	impl=$1
	stream=$2
	aligned=$3
	aiofallback=$4

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi
	if [ x"$aligned" = x"X" ]
	then
		aligned=""
	fi

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi
	if [ x"$aligned" = x"X" ]
	then
		aligned=""
	fi

	if [ $impl -eq 14 ]
	then
		impl_type="asynchronous"
	else
		impl_type="synchronous"
	fi

	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	elif [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	else
		sout="one shot"
	fi

	if [ x"$aligned" = x"-m" ]
	then
		aout="aligned"
	else
		aout="non-aligned"
	fi

	if [ x"$sout" = x"stream" ] && ! check_memory_hard; then
		echo_deact "KPP $impl_type $sout $aout tests"
		return 0
	fi

	KPPEXEC="1 2"
	for i in $KPPEXEC
	do
		eval KPP_name=\$KPP_name_$i
		eval KPP_param=\$KPP_param_$i
		eval KPP_curve=\$KPP_curve_$i
		eval KPP_privkey=\$KPP_privkey_$i
		eval KPP_peerkey=\$KPP_peerkey_$i
		eval KPP_exp=\$KPP_exp_$i

		opt=""
		if [ -n "$KPP_param" ]
		then
			opt="-i $KPP_param"
		fi
		if [ -n "$KPP_curve" ]
		then
			opt="$opt -l $KPP_curve"
		fi
		if [ -n "$KPP_privkey" ]
		then
			opt="$opt -k $KPP_privkey"
		fi
		if [ -n "$KPP_peerkey" ]
		then
			opt="$opt -p $KPP_peerkey"
		fi

		cmd="$KCAPI -x $impl $stream $aligned -c $KPP_name $opt"
		result=$($cmd 2>/dev/null)

		if [ x"$result" = x"$KPP_exp" ]
		then
			echo_pass "KPP $impl_type $sout $aout test $i"
		else
			echo_fail "KPP $impl_type $sout $aout test $i"
			echo "($cmd)"
			echo " Exp $KPP_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

rfc4106_aad_iv() {
	assoc=$1
	iv=$2

	# New name with 4.2
	echo -n "$assoc"
	if check_min_kernelver 4 2; then
		echo -n "$iv"
	fi
}

aeadfunc()
{
	impl=$1
	stream=$2
	aligned=$3
	aiofallback=$4
	printaad=$5

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi
	if [ x"$aligned" = x"X" ]
	then
		aligned=""
	fi
	if [ x"$aiofallback" = x"X" ]
	then
		aiofallback=""
	fi

	if [ $impl -eq 10 ]
	then
		impl_type="asynchronous"
	else
		impl_type="synchronous"
	fi

	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	elif [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	else
		sout="one shot"
	fi

	if [ x"$aligned" = x"-m" ]
	then
		aout="aligned"
	else
		aout="non-aligned"
	fi

	if [ x"$printaad" != x"" ]
	then
		impl_type="$impl_type (AAD copy)"
	fi

	if [ x"$sout" = x"stream" ] && ! check_memory_hard; then
		echo_deact "AEAD $impl_type $sout $aout tests"
		return 0
	fi

	AEADEXEC="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17"
	for i in $AEADEXEC
	do
		eval AEAD_name=\$AEAD_name_$i
		eval AEAD_enc=\$AEAD_enc_$i
		eval AEAD_key=\$AEAD_key_$i
		eval AEAD_assoc=\$AEAD_assoc_$i
		eval AEAD_tag=\$AEAD_tag_$i
		eval AEAD_taglen=\$AEAD_taglen_$i
		eval AEAD_iv=\$AEAD_iv_$i
		eval AEAD_nonce=\$AEAD_nonce_$i
		eval AEAD_msg=\$AEAD_msg_$i
		eval AEAD_exp=\$AEAD_exp_$i

		# append IV to AAD in case of RFC4106 on newer kernels
		if [ "$AEAD_name" != "${AEAD_name##rfc4106}" ]
		then
			AEAD_assoc=$(rfc4106_aad_iv "$AEAD_assoc" "$AEAD_iv")
		fi

		iv="-i $AEAD_iv"
		if [ -z "$AEAD_iv" ]
		then
			iv="-n $AEAD_nonce"
		fi

		expected=""
		if [ "$AEAD_enc" = 1  ]
		then
			result=$($KCAPI $printaad $aiofallback -x $impl $stream $aligned -e -c $AEAD_name $iv -k $AEAD_key -a "$AEAD_assoc" -p "$AEAD_msg" -l $AEAD_taglen 2>/dev/null)
			cmd="$KCAPI $printaad $aiofallback -x $impl $stream $aligned -e -c \"$AEAD_name\" $iv -k $AEAD_key -a \"$AEAD_assoc\" -p \"$AEAD_msg\" -l $AEAD_taglen"
			expected1="${AEAD_exp}${AEAD_tag}"
			#expected1="${AEAD_assoc}${AEAD_exp}${AEAD_tag}"
			#expected2="invalid"
		else
			result=$($KCAPI $printaad $aiofallback -x $impl $stream $aligned -c $AEAD_name $iv -k $AEAD_key -a "$AEAD_assoc" -t "$AEAD_tag" -q "$AEAD_msg" 2>/dev/null)
			cmd="$KCAPI $printaad $aiofallback -x $impl $stream $aligned -c \"$AEAD_name\" $iv -k $AEAD_key -a \"$AEAD_assoc\" -t \"$AEAD_tag\" -q
			\"$AEAD_msg\""
			expected1="${AEAD_exp}"
			#expected1="${AEAD_assoc}${AEAD_exp}"
			#null_assoc=printf "%0.s0" $(seq 1 ${#AEAD_assoc})
			#expected2="${null_assoc}${AEAD_exp}"
		fi

		if [ x"$printaad" != x"" ] && [ x"$expected1" != x"EBADMSG" ]
		then
			expected1="${AEAD_assoc}${expected1}"
		fi

		if [ x"$result" = x"$expected1" ]
		then
			echo_pass "AEAD ${impl_type} ${sout} ${aout} test $i"
		else
			echo_fail "AEAD ${impl_type} ${sout} ${aout} test $i"
			echo "($cmd)"
			echo " Exp $expected1"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done

	# Do not test long message AAD
	if [ x"$printaad" != x"" ]
	then
		return
	fi

	# AEAD long test only supported for aligned data
	if [ x"$aligned" != x"-m" ]
	then
		return
	fi

	# AEAD long message test (AAD is not printed by test program)
	expectedlong="5b77260fcfd3ac8a714a7a6fe3795ed39d6abeda3b199c0de8e64b57569d75874d85cb992b7e7aeab81ba7cf77285969"
	expectedshort="5b77260fcfd3ac8a714a7a6fe3795ed39d6abeda3b199c0de8e64b57569d75874da5e05a23b8902677480ee92c7ff6bc"
	expectedsmall="5b77260fcfd3ac8a714a7a6fe3795ed39d6abeda3b199c0de8e64b57569d7587fa431e683949010ded4a091fa7b5bf0b"

	# vmsplice does not take long strings
	if [ x"$stream" = x"-s" ]
	then
		expected=$expectedsmall
	else
		expected=$expectedshort
	fi
	cmd="$KCAPI -y $stream"
	result=$($cmd 2>/dev/null)
	if [ x"$result" = x"$expected" ]
	then
		echo_pass "AEAD $sout long AAD test"
	else
		echo_fail "AEAD $sout long AAD test"
		echo "($cmd)"
		echo "Exp $exoected"
		echo "Got $result"
		failures=$(($failures+1))
	fi
}

auxtest()
{
	if ! check_memory_hard; then
		echo_deact "Auxiliary test deactivated"
	fi

	$KCAPI -z > /dev/null
	if [ $? -ne 0 ]
	then
		echo_fail "Auxiliary test failure detected"
		failures=$(($failures+1))
	else
		echo_pass "Auxiliary test"
	fi
	
}

kdftest()
{
	aligned=$1

	KDFEXEC="1 2 3"
	for i in $KDFEXEC
	do
		eval KDF_name=\$KDF_name_$i
		eval KDF_type=\$KDF_type_$i
		eval KDF_key=\$KDF_key_$i
		eval KDF_msg=\$KDF_msg_$i
		eval KDF_exp=\$KDF_exp_$i

		explen=$(echo -n $KDF_exp | wc -c)
		explen=$(($explen/2))

		cmd="$KCAPI $aligned -x $KDF_type -c $KDF_name -k $KDF_key -p $KDF_msg -b $explen"
		result=$($cmd 2>/dev/null)

		aout="non-aligned"
		if [ x"$aligned" = x"-m" ]
		then
			aout="aligned"
		fi

		type="CTR"
		if [ $KDF_type -eq 6 ]
		then
			type="FB"
		fi
		if [ $KDF_type -eq 7 ]
		then
			type="DPI"
		fi

		if [ x"$result" = x"$KDF_exp" ]
		then
			echo_pass "KDF $type $aout test $i"
		else
			echo_fail "KDF $type $aout test $i"
			echo "($cmd)"
			echo " Exp $KDF_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

pbkdftest()
{
	aligned=$1

	PBKDFEXEC="1 2 3 4 5 6 7 8 9 10 11 12 13"
	for i in $PBKDFEXEC
	do
		eval PBKDF_name=\$PBKDF_name_$i
		eval PBKDF_salt=\$PBKDF_salt_$i
		eval PBKDF_pw=\$PBKDF_pw_$i
		eval PBKDF_count=\$PBKDF_count_$i
		eval PBKDF_exp=\$PBKDF_exp_$i

		explen=$(echo -n $PBKDF_exp | wc -c)
		explen=$(($explen/2))

		result=$($KCAPI $aligned -x 8 -c $PBKDF_name -k $PBKDF_salt -p "$PBKDF_pw" -d $PBKDF_count -b $explen)

		aout="non-aligned"
		if [ x"$aligned" = x"-m" ]
		then
			aout="aligned"
		fi

		if [ x"$result" = x"$PBKDF_exp" ]
		then
			echo_pass "PBKDF $aout test $i"
		else
			echo_fail "PBKDF $aout test $i"
			echo "($KCAPI $aligned -x 8 -c $PBKDF_name -k $PBKDF_salt -p \"$PBKDF_pw\" -d $PBKDF_count -b $explen)"
			echo " Exp $PBKDF_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

hkdftest()
{
	aligned=$1

	HKDFEXEC="1 2 3 4 5 6 7"
	for i in $HKDFEXEC
	do
		eval HKDF_name=\$HKDF_name_$i
		eval HKDF_salt=\$HKDF_salt_$i
		eval HKDF_ikm=\$HKDF_ikm_$i
		eval HKDF_info=\$HKDF_info_$i
		eval HKDF_exp=\$HKDF_exp_$i

		explen=$(echo -n $HKDF_exp | wc -c)
		explen=$(($explen/2))

		result=$($KCAPI $aligned -x 12 -c $HKDF_name -k $HKDF_ikm -i "$HKDF_salt" -p "$HKDF_info" -b $explen)

		aout="non-aligned"
		if [ x"$aligned" = x"-m" ]
		then
			aout="aligned"
		fi

		if [ x"$result" = x"$HKDF_exp" ]
		then
			echo_pass "HKDF $aout test $i"
		else
			echo_fail "HKDF $aout test $i"
			echo "($KCAPI $aligned -x 8 -c $HKDF_name -k $HKDF_salt -p \"$HKDF_pw\" -d $HKDF_count -b $explen)"
			echo " Exp $HKDF_exp"
			echo " Got $result"
			failures=$(($failures+1))
		fi
	done
}

multipletest_sym() {
	symimpl=$1
	stream=$2
	aiofallback=$3

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi

	if [ x"$aiofallback" = x"X" ]
	then
		aiofallback=""
	fi

	sout="one shot"
	impl_type="synchronous"
	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	fi
	if [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	fi
	if [ $symimpl -eq 9 ]
	then
		impl_type="asynchronous"
	fi
	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	cmd="$KCAPI $stream -d 2 -x $symimpl $aiofallback -e -c cbc(aes) -k 8d7dd9b0170ce0b5f2f8e1aa768e01e91da8bfc67fd486d081b28254c99eb423 -i 7fbc02ebf5b93322329df9bfccb635af -p 48981da18e4bb9ef7e2e3162d16b1910"
	result=$($cmd 2>/dev/null)
	if [ $symimpl -eq 9 ]
	then
		#block chaining
		expected="8b19050f66582cb7f7e4b6c873819b7108afa0eaa7de29bac7d903576b674c32"
	elif [ x"$stream" = x"-s" ]
	then
		#block chaining
		expected="8b19050f66582cb7f7e4b6c873819b71
08afa0eaa7de29bac7d903576b674c32"
	else
		expected="8b19050f66582cb7f7e4b6c873819b71
8b19050f66582cb7f7e4b6c873819b71"
	fi
	if [ x"$expected" = x"$result" ]
	then
		echo_pass "Symmetric $impl_type cipher $sout multiple test"
	else
		echo_fail "Symmetric $impl_type cipher $sout multiple test"
		echo "($cmd)"
		echo "Exp $expected"
		echo "Got $result"
		failures=$(($failures+1))
	fi
}

multipletest_aead() {
	impl=$1
	stream=$2
	aiofallback=$3
	printaad=$4

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi

	sout="one shot"
	impl_type="synchronous"
	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	fi
	if [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	fi
	if [ $impl -eq 10 ]
	then
		impl_type="asynchronous"
		if ! $(check_min_kernelver 4 9); then
			echo_deact "AEAD $impl_type $sout multiple test"
			return
		fi
	fi
	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi
	if [ x"$printaad" != x"" ]
	then
		impl_type="$impl_type (AAD copy)"
	fi

	if [ x"$printaad" != x"" ]
	then
		printaad_expected="fb7bc304a3909e66e2e0c5ef952712dd884ce3e7324171369f2c5db1adc48c7d"
	fi

	cmd="$KCAPI $stream -d 4 -x $impl $aiofallback $printaad -c ccm(aes) -q 4edb58e8d5eb6bc711c43a6f3693daebde2e5524f1b55297abb29f003236e43d -t a7877c99 -n 674742abd0f5ba -k 2861fd0253705d7875c95ba8a53171b4 -a fb7bc304a3909e66e2e0c5ef952712dd884ce3e7324171369f2c5db1adc48c7d"
	result=$($cmd 2>/dev/null)
	# there is no block chaining effect here, because GCM/CCM initialize the
	# counter part for each encryption operation to 1
	if [ $impl -eq 10 ]
	then
		expected="${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723"
	else
		expected="${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723
${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723
${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723
${printaad_expected}8dd351509dcf1df9c33987fb31cd708dd60d65d3d4e1baa53581d891d994d723"
	fi

	if [ x"$expected" = x"$result" ]
	then
		echo_pass "AEAD $impl_type $sout multiple test"
	else
		echo_fail "AEAD $impl_type $sout multiple test"
		echo "($cmd)"
		echo "Exp $expected"
		echo "Got $result"
		failures=$(($failures+1))
	fi
}

multipletest_hash() {
	impl=$1
	stream=$2

	sout="one shot"
	impl_type="synchronous"
	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	fi
	if [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	fi
	if [ $impl -eq 9 ]
	then
		impl_type="asynchronous"
	fi

	cmd="$KCAPI -d 8 -x $impl -c hmac(sha1) -k 6e77ebd479da794707bc6cde3694f552ea892dab -p  31b62a797adbff6b8a358d2b5206e01fee079de8cdfc4695138bba163b4efbf30127343e7fd4fbc696c3d38d8f27f57c024b5056f726ceeb4c31d98e57751ec8cbe8904ee0f9b031ae6a0c55da5e062475b3d7832191d4057643ef5fa446801d59a04693e573a8159cd2416b7bd39c7f0fe63c599365e04d596c05736beaab58"
	result=$($cmd 2>/dev/null)
	expected="7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85
7f204ea665666f5bd2b370e546d1b408005e4d85"
	if [ x"$expected" = x"$result" ]
	then
		echo_pass "Hash $sout multiple test"
	else
		echo_fail "Hash $sout multiple test"
		echo "($cmd)"
		echo "Exp $exoected"
		echo "Got $result"
		failures=$(($failures+1))
	fi
}

multipletest_asym() {
	impl=$1
	stream=$2
	aiofallback=$3

	if [ x"$stream" = x"X" ]
	then
		stream=""
	fi

	sout="one shot"
	impl_type="synchronous"
	if [ x"$stream" = x"-s" ]
	then
		sout="stream"
	fi
	if [ x"$stream" = x"-v" ]
	then
		sout="vmsplice"
	fi
	if [ $impl -eq 11 ]
	then
		impl_type="asynchronous"
	fi
	if [ -n "$aiofallback" ]
	then
		impl_type="$impl_type (AIO fallback)"
	fi

	cmd="$KCAPI -d 10 -x $impl $aiofallback -o 3 -c pkcs1pad(rsa-generic,sha256) -r 3082020802820100965f0f7526036bf956960324250b5cfd383631e17a447c9997b654ae38b11c730bd4c70f7434ab8d440267d7b08c743394ae2bd1160d3dba07190cee213f841a182a4d36a2e14d3551882c0f9a3ff12ddb048f88f1ff8c7e43db8f902c83683f72bd2fe62fc3de611dc78329618c0fb029ad1d5d573eb6c95f115eb7ce598274b98edad641e42c7da6751e7ebaac45e33cac14490300ae2cefb788a7a69312304f190f6fed53a8b7deefc96056c85237efa2d2a94baf85358d21c14f82692e04774980b798a89a1d419a25ac2602a5e990bfce0bc975c7dbc6f3aab5463d56725d839ff05f0fff6eef5b6549f129534e45ecc752509ea7cf4814a155e39348ff0282010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e16f83 -p 3db2f89b6acd0b0eb0df5d18818145d87241b774da4e20aa97bf412a94c4e0c5ef923657a81c4ae4669970060c494d21f7cef5de40e755d85e54377f6e2ada35275b7c8ec184a585fe2ee665d96f6e086f738b49ce1eb381d96e6817d80347f29df50aaeebc4a48c67cd28d37c312d2cc80b9469cb402e28bfea5387bab6311bb214955992f3063cd9687e1a9f3ff4426209b9e1eb47bafa364a9f71ee0c0d8affc945d708497303a2164e8f93dec94dd7303b43828721c0786d1bc4004486ed0de53b075b8f82e2ba007f516659ab129e0fcf616a9066d3de391fd7c93ac5136075c0ebb9b936e76c6014b27c7fc963eafca11d6ec9b050d211fd18a661db3a"
	result=$($cmd 2>/dev/null)
	expected="d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825
d780ec569fe689a0f7778eab625bd0ccb13d7e3f63e19083c739ddcbd4b1a825"
	if [ x"$expected" = x"$result" ]
	then
		echo_pass "Asymmetric $impl_type $sout multiple test"
	else
		echo_fail "Asymmetric $impl_type $sout multiple test"
		echo "($cmd)"
		echo "Exp $expected"
		echo "Got $result"
		failures=$(($failures+1))
	fi
}

check_memory_soft || exit 1

hashfunc
hashfunc -s
multipletest_hash 3		# sync, no splice, one shot sendmsg
multipletest_hash 3 -s		# sync, no splice, stream sendmsg
multipletest_hash 3 -v		# sync, splice

symfunc 1
symfunc 1 -s
symfunc 1 -v
symfunc 1 -j
symfunc 9 X X -g
symfunc 9 -s X -g
symfunc 9 -v X -g

symfunc 1 X -m
symfunc 1 -s -m
symfunc 1 -v -m
symfunc 9 X -m -g
symfunc 9 -s -m -g
symfunc 9 -v -m -g

auxtest
multipletest_sym 1		# sync, no splice, one shot sendmsg
multipletest_sym 1 -s		# sync, no splice, stream sendmsg
multipletest_sym 1 -v		# sync, splice
multipletest_sym 9 X -g		# async, AIO fallback, no splice, one shot sendmsg
multipletest_sym 9 -s -g	# async, AIO fallback, no splice, stream sendmsg
multipletest_sym 9 -v -g	# async, AIO fallback, splice

if $(check_min_kernelver 4 14); then
	symfunc 9
	symfunc 9 -s
	symfunc 9 -v
	symfunc 9 X -m
	symfunc 9 -s -m
	symfunc 9 -v -m
	multipletest_sym 9
	multipletest_sym 9 -s
	multipletest_sym 9 -v
else
	echo_deact "Symmetric AIO tests deactivated"
fi

if $(check_min_kernelver 4 1); then
	aeadfunc 2
	aeadfunc 2 -s
	aeadfunc 2 -v
	aeadfunc 10 X X -g
	aeadfunc 10 -s X -g
	aeadfunc 10 -v X -g
	aeadfunc 2 X -m
	aeadfunc 2 -s -m
	aeadfunc 2 -v -m
	aeadfunc 10 -s -m -g
	aeadfunc 10 X -m -g
	aeadfunc 10 -v -m -g
	multipletest_aead 2		# sync, no splice, one shot sendmsg
	multipletest_aead 2 -s		# sync, no splice, stream sendmsg
	multipletest_aead 2 -v		# sync, splice
	multipletest_aead 10 X -g	# async, AIO fallback, no splice, one shot sendmsg
	multipletest_aead 10 -s	-g	# async, AIO fallback, no splice, stream sendmsg
	multipletest_aead 10 -v	-g	# async AIO fallback, splice
	if $(check_min_kernelver 4 14); then
		aeadfunc 10
		aeadfunc 10 -s
		aeadfunc 10 -v
		aeadfunc 10 -s -m
		aeadfunc 10 X -m
		aeadfunc 10 -v -m
		multipletest_aead 10
		multipletest_aead 10 -s
		multipletest_aead 10 -v
	else
		echo_deact "AEAD AIO tests deactivated"
	fi
else
	echo_deact "All AEAD tests deactivated"
fi

if $(check_min_kernelver 4 14) && check_memory_hard; then
	aeadfunc 2 X X X -u
	aeadfunc 2 -s X X -u
	aeadfunc 2 -v X X -u
	aeadfunc 10 X X X -u
	aeadfunc 10 -s X X -u
	aeadfunc 10 -v X X -u
	aeadfunc 10 X X -g -u
	aeadfunc 10 -s X -g -u
	aeadfunc 10 -v X -g -u
	aeadfunc 2 X -m X -u
	aeadfunc 2 -s -m X -u
	aeadfunc 2 -v -m X -u
	aeadfunc 10 -s -m X -u
	aeadfunc 10 X -m X -u
	aeadfunc 10 -v -m X -u
	aeadfunc 10 -s -m -g -u
	aeadfunc 10 X -m -g -u
	aeadfunc 10 -v -m -g -u
	multipletest_aead 2 X X -u	# sync, no splice, one shot sendmsg
	multipletest_aead 2 -s X -u	# sync, no splice, stream sendmsg
	multipletest_aead 2 -v X -u	# sync, splice
	multipletest_aead 10 X -g -u	# async, AIO fallback, no splice, one shot sendmsg
	multipletest_aead 10 -s	-g -u	# async, AIO fallback, no splice, stream sendmsg
	multipletest_aead 10 -v	-g -u	# async AIO fallback, splice
else
	echo_deact "AEAD tests of copied AAD deactivated"
fi

if $(check_min_kernelver 5 99); then
	asymfunc 4
	asymfunc 4 -s
	asymfunc 4 -v
	asymfunc 11
	asymfunc 11 -s
	asymfunc 11 -v
	asymfunc 4 X -m
	asymfunc 4 -s -m
	asymfunc 4 -v -m
	asymfunc 11 X -m
	asymfunc 11 -s -m
	asymfunc 11 -v -m
	multipletest_asym 4		# sync, no splice, one shot sendmsg
	multipletest_asym 4 -s		# sync, no splice, stream sendmsg
	multipletest_asym 4 -v		# sync, splice
	multipletest_asym 11		# async, no splice, one shot sendmsg
	multipletest_asym 11 -s		# async, no splice, stream sendmsg
	multipletest_asym 11 -v		# async, splice
else
	echo_deact "All asymmetric tests deactivated"
fi

if $(check_min_kernelver 5 99); then
	kppfunc 13
	kppfunc 13 X -m
	kppfunc 13 -v
	kppfunc 13 -v -m
	kppfunc 14
	kppfunc 14 X -m
	kppfunc 14 -v
	kppfunc 14 -v -m
else
	echo_deact "All KPP tests deactivated"
fi

kdftest
kdftest -m
pbkdftest
pbkdftest -m
hkdftest
hkdftest -m

exit $failures
