#if   !defined(__MEMENTOS_HPP)
#define __MEMENTOS_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <corelinux/Vector.hpp>
#endif

#if   !defined(__MEMENTO_HPP)
#include <corelinux/Memento.hpp>
#endif

DECLARE_CLASS( ChangedListMemento );

CORELINUX_VECTOR(  string ,  ListEntries );

/**
ChangedListMemento captures the state of the ListColleague
*/

class ChangedListMemento : public CORELINUX( Memento )
{
public:
                     /**
                     Default Constructor 
                     @param ListEntries reference to vector of strings
                     */

                     ChangedListMemento( ListEntriesRef aList )
                        :
                        CORELINUX(Memento)(),
                        theCurrentList( aList )
                     {
                        ;  // do nothing
                     }

                     /**
                     Copy Constructor 
                     @param ChangedListMemento reference
                     */

                     ChangedListMemento( ChangedListMementoCref aMemento )
                        :
                        CORELINUX(Memento)(aMemento),
                        theCurrentList( aMemento.theCurrentList )
                     {
                        ;  // do nothing
                     }

                     /// Destructor

   virtual           ~ChangedListMemento( void )
                     {
                        theCurrentList.clear();
                     }

   //
   // Operator overloads
   //

            /// Assignment operator

            ChangedListMementoRef   operator=( ChangedListMementoCref aMemento )
            {
               if( *this == aMemento )
               {
                  ;  // do nothing
               }
               else
               {
                  CORELINUX(Memento)::operator=( aMemento );
                  theCurrentList.clear();
                  theCurrentList = aMemento.theCurrentList;
               }
               return ( *this );
            }

            /// Equality test

            bool operator==( ChangedListMementoCref aMemento ) const
            {
               return CORELINUX(Memento)::operator==( aMemento );
            }

   //
   // Accessors
   //

            /// Retrieve the list for inspection, etc.

   inline   ListEntriesRef    getList( void )
            {
               return theCurrentList;
            }

protected:


private:
            /// The list

            ListEntries    theCurrentList;

};

DECLARE_CLASS( SelectionMemento );

/**
SelectionMemento captures the state of SelectColleague. That
is which string was selected from the list
*/

class SelectionMemento : public CORELINUX( Memento )
{
public:

                     SelectionMemento( string aSelection )
                        :
                        CORELINUX(Memento)(),
                        theSelection( aSelection )
                     {
                        ;  // do nothing
                     }

                     SelectionMemento( SelectionMementoCref aMemento )
                        :
                        CORELINUX(Memento)(aMemento),
                        theSelection( aMemento.theSelection )
                     {
                        ;  // do nothing
                     }

   virtual           ~SelectionMemento( void )
                     {
                        ;  // do nothing
                     }

   //
   // Operator overloads
   //

            SelectionMementoRef   operator=( SelectionMementoCref aMemento )
            {
               if( *this == aMemento )
               {
                  ;  // do nothing
               }
               else
               {
                  CORELINUX(Memento)::operator=( aMemento );
                  theSelection =  aMemento.theSelection ;
               }
               return ( *this );
            }

            bool operator==( SelectionMementoCref aMemento ) const
            {
               return CORELINUX(Memento)::operator==( aMemento );
            }

   //
   // Accessors
   //

   inline   string &getSelected( void )
            {
               return theSelection;
            }

protected:


private:

            string      theSelection;

};

DECLARE_CLASS( EditSelectionMemento );

/**
EditSelectionMemento captures the state of EditColleague. That
is the original string, and the intended replacement
*/

class EditSelectionMemento : public CORELINUX( Memento )
{
public:

                     EditSelectionMemento( string aSelection, string aChange )
                        :
                        CORELINUX(Memento)(),
                        theSelection( aSelection ),
                        theChange( aChange )
                     {
                        ;  // do nothing
                     }

                     EditSelectionMemento( EditSelectionMementoCref aMemento )
                        :
                        CORELINUX(Memento)(aMemento),
                        theSelection( aMemento.theSelection ),
                        theChange( aMemento.theChange )
                     {
                        ;  // do nothing
                     }

   virtual           ~EditSelectionMemento( void )
                     {
                        ;  // do nothing
                     }

   //
   // Operator overloads
   //

            EditSelectionMementoRef   operator=( EditSelectionMementoCref aMemento )
            {
               if( *this == aMemento )
               {
                  ;  // do nothing
               }
               else
               {
                  CORELINUX(Memento)::operator=( aMemento );
                  theSelection =  aMemento.theSelection ;
                  theChange = aMemento.theChange;
               }
               return ( *this );
            }

            bool operator==( EditSelectionMementoCref aMemento ) const
            {
               return CORELINUX(Memento)::operator==( aMemento );
            }


   //
   // Accessors
   //

   inline   string &getSelected( void )
   {
      return theSelection;
   }

   inline   string &getChange( void )
   {
      return theChange;
   }

protected:


private:

            string      theSelection;
            string      theChange;

};



#endif

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/


