/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__HELPREQUEST_HPP)
#include <HelpRequest.hpp>
#endif

using namespace corelinux;

// Default constructor

HelpRequest::HelpRequest( HelpTopicCref aTopic )
   :
   Request(),
   theHandledFlag( false ),
   theRequestType( aTopic )
{
   ;  // do nothing
}

// Copy constructor

HelpRequest::HelpRequest( HelpRequestCref aRequest )
   :
   Request(aRequest),
   theHandledFlag( false ),
   theRequestType( aRequest )
{
   ;  // do nothing
}

// Default should not be accessed

HelpRequest::HelpRequest( void ) throw ( Assertion )
   :
   Request(),
   theHandledFlag( false ),
   theRequestType( UNKNOWN_HELP )
{
   NEVER_GET_HERE;
}

// Destructor cleans slate

HelpRequest::~HelpRequest( void )
{
   theHandledFlag =  false;
   theRequestType =  UNKNOWN_HELP;
}

// Assignment operator

HelpRequestRef   HelpRequest::operator=( HelpRequestCref aRequest )
{
   Request::operator=( aRequest );
   theHandledFlag = aRequest.wasHandled();
   theRequestType = aRequest;
   return  (*this);
}

// Calls topic comparison

bool  HelpRequest::operator==( HelpRequestCref aRequest ) const
{
   return ( (*this) == HelpTopicCref(aRequest) );
}

// Topic comparison

bool  HelpRequest::operator==( HelpTopicCref aTopic ) const
{
   return (theRequestType == aTopic );
}

// Mark as serviced

void  HelpRequest::setHandled( void )
{
   theHandledFlag = true;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/


