/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace   corelinux
{
   //
   // Methods which are called to provide debug assistance
   //

   Long assertionFailed( AssertionCref aAssertion )
   {
      throw aAssertion;
      return 0;
   }

   void assertLoopDebugFunction( void )
   {
       return;
   } 

   //
   // Default constructor which passes through
   // to exception and preserves the type assertion
   //

   Assertion::Assertion
      (
         Assertion::Type aType,
         CharPtr         aReason,
         CharPtr         aFile,
         LineNum         aLine
      )
      :
      Exception(aReason,aFile,aLine,Exception::PROCESSTERMINATE),
      theType( aType )
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   Assertion::Assertion(AssertionCref rAssertion)
      :
      Exception(rAssertion),
      theType( rAssertion.getType() )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   Assertion::~Assertion( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   AssertionRef Assertion::operator=( AssertionCref aAssertion )
   {
      if( this != &aAssertion )
      {
         IGNORE_RETURN Exception::operator=( aAssertion );
         theType = aAssertion.getType();
      }
      else
      {
         ;  // do nothing
      }
      return *this;
   }

   //
   // Retrieve the assertion type
   //

   Assertion::Type Assertion::getType( void ) const
   {
      return theType;
   }

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 1999/12/04 01:52:53 $
   $Locker:  $
*/

