#if !defined(__ALLOCATOR_HPP)
#define  __ALLOCATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__STRATEGY_HPP)
#include <Strategy.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( Allocator );

   /**
   Allocator is a Strategy class used by AbstractAllocator and
   AbstractFactory.Each Allocator instance tracks allocates 
   and deallocates 
   @see Strategy, AbstractAllocator, AbstractFactory
   */

   class Allocator : public Strategy
   {
   public:

      //
      // Constructors and destructor
      //

                        /// Default constructor
                        
                        Allocator( void );

                        /**
                        Copy constructor
                        @param Allocator const reference
                        */

                        Allocator( AllocatorCref );

                        /// Virtual destructor

      virtual           ~Allocator( void );

      //
      // Operator overloads
      //

               /**
               Assingment operator overload
               @param Allocator const reference
               @return Allocator reference to self
               */

               Allocator & operator=( AllocatorCref );

               /**
               Equality operator overload
               @param Allocator const reference
               @return true if same identity
               */

               bool  operator==( AllocatorCref ) const;

      //
      // Accessors
      //

               /**
               Retrieves the number of allocations by
               this Allocator
               @return Count - number of allocates
               */

      virtual  CountCref   getAllocateCount( void ) const;

               /**
               Retrieves the number of deallocations by
               this Allocator
               @return Count - number of deallocates
               */

      virtual  CountCref   getDeallocateCount( void ) const;

      //
      // Mutators
      //

               /// Increment the allocates

      virtual  void        incrementAllocates( void );

               /// Decrement the allocates

      virtual  void        decrementAllocates( void );

               /// Increment the deallocates

      virtual  void        incrementDeallocates( void );

               /// Decrement the deallocates

      virtual  void        decrementDeallocates( void );
                  
   protected:


   private:

               /// The number of allocations

               Count          theAllocates;

               /// The number of deallocations

               Count          theDeallocates;

   };


}


#endif   // if !defined(__ALLOCATOR_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/13 12:32:21 $
   $Locker:  $
*/


