#if   !defined(__FOOBARCLASSADAPTER_HPP)
#define __FOOBARCLASSADAPTER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__ADAPTER_HPP)
#include <Adapter.hpp>
#endif

#if   !defined(__FOO_HPP)
#include <Foo.hpp>
#endif

#if   !defined(__BAR_HPP)
#include <Bar.hpp>
#endif

/**
FooBarClassAdapter provides the Foo (Target) interface by adapting 
Bar (Adaptee) through class inheritence. 

Class Adapters:

Pro: Lets Adapter override some of the Adaptee's behavior, since
Adapter is a subclass of Adaptee.

Pro: Introduces only one object, and no additional pointer indirection
is needed to get to the adaptee.

Con: Adapts Adaptee to Target by commiting to a concrete Adapter class.
As a consequence, a class adapter won't work when we want to adapt a class
and all its subclasses.


As you can see, this inteface is mainly concerned with emulating
Foo. It does not realize the Bar interface
*/
      
DECLARE_CLASS(FooBarClassAdapter);

class FooBarClassAdapter : public CORELINUX(Adapter), public Foo, private Bar
{

public:

                        /// Default constructor

                        FooBarClassAdapter( void );

                        /// Constructor with coordinates

                        FooBarClassAdapter( CORELINUX(Int) aX, CORELINUX(Int) aY ) 
                           throw(CORELINUX(Exception));

                        /// Copy constructor

                        FooBarClassAdapter( FooBarClassAdapterCref );

                        /// Destructor

   virtual              ~FooBarClassAdapter( void );

   //
   // Operator overloads
   //

            /// Assignment operator
         
            FooBarClassAdapterRef   operator=( FooBarClassAdapterCref );
         
            /// Equality operator
         
            bool     operator==( FooBarClassAdapterCref );

   //
   // Accessors
   //
   
            /// Get the Y coordinate

   virtual  CORELINUX(IntCref) getVerticalPosition(void) const;

            /// Get the X coordinate

   virtual  CORELINUX(IntCref) getHorizontalPosition(void) const;

   //
   // Mutators
   //
            /// Sets the Y coordinate
   
   virtual  void setVerticalPosition(CORELINUX(Int)) 
                  throw(CORELINUX(Exception));

            /// Sets the X coordinate
   
   virtual  void setHorizontalPosition(CORELINUX(Int)) 
                  throw(CORELINUX(Exception));

};

#endif // if !defined __FOOBARCLASSADAPTER_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/02/10 14:32:20 $
   $Locker:  $
*/

