#if   !defined(__ABSTRACTCOMMAND_HPP)
#define  __ABSTRACTCOMMAND_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( AbstractCommand );

   /**
   AbstractCommand captures the semantics of the
   capabilities of commands, which is basically
   to provide a execution context
   */

   class AbstractCommand : public Synchronized
   {

   public:

      //
      // Constructors and destructor
      //
                        /// Default Constructor

                        AbstractCommand( void );

                        /// Copy constructor

                        AbstractCommand( AbstractCommandCref );

                        /// Virtual Destructor

      virtual           ~AbstractCommand( void );      

      //
      // Operator overloads
      //

               /// Assignment operator

               AbstractCommandRef   operator=( AbstractCommandCref );

               /// Equality operator

               bool  operator==( AbstractCommandCref ) const;

      //
      // Abstract methods
      //

               /// Execute the command 

      virtual  void  execute( void ) = 0;

               /// Execute the reverse command

      virtual  void  executeReverse( void ) = 0;

   protected:

   private:

   };
}

#endif // if !defined(__ABSTRACTCOMMAND_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/03 03:56:47 $
   $Locker:  $
*/

