/*
 * Windows Media Voice (WMAVoice) tables.
 * Copyright (c) 2009 Ronald S. Bultje
 *
 * This file is part of Libav.
 *
 * Libav is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Libav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Libav; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * @brief Windows Media Voice (WMAVoice) tables
 * @author Ronald S. Bultje <rsbultje@gmail.com>
 */

#ifndef AVCODEC_WMAVOICE_DATA_H
#define AVCODEC_WMAVOICE_DATA_H

#include <stdint.h>

static const uint8_t wmavoice_dq_lsp10i[0xf00] = {
    125, 109,  84,  55,  34,  51, 109, 112, 118, 132,
    122, 102,  78,  80, 132, 119, 132, 132, 125, 131,
    109,  91, 131, 131, 136, 136, 137, 137, 140, 145,
    140, 143, 117, 136, 122, 106, 109,  91, 115, 119,
    133, 117, 103,  80,  55, 117, 123, 102,  93,  80,
    139, 116,  70,  39,  95,  89, 103, 113, 112, 122,
    135, 244, 229, 215, 199, 181, 163, 150, 146, 144,
    143, 173, 171, 154, 155, 154, 151, 148, 145, 143,
    132, 138, 116,  85, 117,  94, 108, 117, 107, 116,
    132, 118, 123, 119,  88,  67,  49,  95,  84,  95,
    121, 103,  74,  70, 179, 164, 141, 126, 107, 112,
    119,  95, 103, 149, 139, 148, 144, 147, 148, 141,
    151, 133, 142, 129, 111, 131, 108, 128, 122, 108,
    121,  96, 115, 138, 116,  93, 105, 115, 115, 123,
    129, 106, 136, 180, 147, 130, 108, 141, 131, 118,
    136, 155, 176, 156, 135, 129, 140, 146, 142, 134,
    141, 130, 109,  80,  52,  38,  18,  47, 118, 134,
    155, 141, 100,  78,  72,  89,  79,  96,  92,  98,
    133, 111,  83,  91,  72,  58, 105, 115, 112, 120,
    145, 127, 135, 113, 113, 105, 105,  85,  69,  61,
    115,  96, 116, 145, 159, 170, 175, 175, 168, 155,
    140, 120,  84,  52,  80, 145, 125, 127, 116, 126,
    128, 108, 101, 198, 227, 200, 178, 159, 147, 148,
    121,  88,  46, 109, 124, 126, 126, 137, 147, 147,
    129, 107, 164, 148, 127, 117, 134, 120, 111, 116,
    120, 103,  98,  73,  66,  61,  70, 115, 116, 125,
    126, 100,  77, 188, 162, 140, 114, 128, 139, 123,
    145, 165, 164, 134, 109, 100, 108, 118, 127, 130,
    156, 182, 190, 173, 167, 165, 162, 157, 152, 147,
    150, 164, 179, 183, 173, 155, 140, 136, 134, 135,
    122,  92,  69, 140, 132, 118, 108, 128, 138, 132,
    123, 127, 148, 137, 150, 149, 139, 127, 124, 130,
    136, 138, 112,  70,  41,  37, 132, 140, 129, 125,
    130, 111,  78,  33,  51, 161, 141, 136, 120, 122,
    126, 110,  87, 106,  85,  68,  48,  81, 112, 113,
    135, 125,  98,  85, 102,  80, 100,  87,  86, 116,
    142, 133, 110,  66,  48, 152, 139, 135, 136, 123,
    128, 116,  89, 102, 128,  99,  83,  61, 105, 124,
    120,  94,  73,  83,  78, 100, 122, 124, 128, 132,
    144, 137, 116, 102,  75, 144, 136, 127, 140, 127,
    154, 144, 118,  99,  90,  90,  89,  75,  68,  83,
    123, 103,  89, 198, 180, 154, 138, 122, 136, 120,
    138, 118, 121, 136, 110, 105,  85, 111, 101, 104,
    121, 126, 139, 115,  99, 101, 107, 110, 123, 126,
    127, 115,  88, 109, 164, 134, 138, 138, 120, 121,
    130, 202, 195, 202, 199, 201, 181, 164, 159, 148,
    120, 116, 194, 199, 186, 171, 154, 142, 137, 133,
    137, 129, 112, 149, 134, 112, 149, 138, 120, 134,
    119, 102, 107,  83,  79, 114, 119, 127, 128, 128,
    144, 148, 165, 155, 161, 150, 135, 122, 116, 115,
    120,  99,  80, 120, 123, 124, 111,  89,  70, 108,
    118,  95,  66,  53, 105, 126, 125, 105,  83, 111,
    129, 197, 191, 197, 206, 213, 216, 208, 196, 169,
    133, 109, 127, 164, 134, 121,  99,  92,  82,  71,
    131, 121,  93,  91, 136, 105, 115, 140, 120, 110,
    150, 164, 139, 108,  87,  81,  93,  92, 104, 116,
    133, 114, 125, 126, 111, 136, 110, 156, 147, 133,
    113,  94, 118, 120, 115, 125, 124, 126, 127, 134,
    116, 131, 161, 158, 166, 157, 150, 150, 144, 141,
    125, 185, 169, 142, 140, 143, 139, 131, 134, 138,
    179, 188, 170, 150, 134, 140, 144, 133, 127, 127,
    150, 177, 204, 184, 192, 194, 190, 193, 177, 158,
    114, 113, 138, 116, 137, 135, 132, 131, 127, 134,
    120, 147, 163, 135, 133, 137, 136, 136, 133, 135,
    137, 120,  95,  73,  46,  48, 111,  97,  97, 123,
    139, 130, 109,  76,  52,  72,  61,  61, 125, 127,
    132, 119, 119,  90,  66,  41,  64, 156, 143, 129,
    131, 106,  58,  25,  99, 115, 122, 136, 129, 132,
    134, 123,  97,  53,  27, 114, 125, 114, 120, 123,
    122, 107,  93,  57,  47, 133, 128, 138, 141, 131,
    145, 132, 122, 110,  79,  57,  30,  73, 153, 144,
    150, 132,  85,  59, 133, 125, 130, 115, 100,  96,
    148, 127, 111,  86,  61,  38, 110, 121, 108,  99,
    157, 143, 105,  77, 116, 118, 115, 131, 122, 122,
    133, 119, 134, 108,  86,  61, 129, 165, 143, 127,
    125, 105,  89, 111,  97,  85, 113,  99,  98, 117,
    149, 131, 101, 106,  88,  95,  79, 119, 123, 120,
    125, 109,  81, 100, 201, 183, 156, 138, 115, 116,
    141, 119, 129, 105,  76,  60, 110,  99,  92,  82,
    150, 156, 129,  95,  69, 115, 115, 113, 134, 125,
    118,  97,  67,  96, 203, 197, 171, 151, 133, 125,
    143, 131, 120, 134, 105,  80,  51,  60, 139, 134,
    129, 160, 223, 219, 219, 212, 197, 173, 157, 146,
    132, 112, 164, 144, 119, 102,  92,  76,  73,  94,
    132, 112, 124, 114,  93,  92,  83,  73,  69,  99,
    129, 103, 188, 163, 142, 132, 127, 101,  82,  59,
    140, 141, 111,  74,  46, 105, 113,  99, 127, 122,
    125,  94,  63, 112, 116, 101,  81, 120, 136, 134,
    133, 190, 224, 193, 179, 158, 146, 143, 140, 136,
    152, 161, 132, 120, 112,  94, 114, 102,  92, 116,
    129, 194, 196, 202, 211, 212, 210, 190, 169, 152,
    166, 166, 145, 111,  91, 132, 133, 128, 136, 130,
    118,  94,  72,  74,  92,  86,  89,  92, 106, 123,
    126, 100,  86, 137, 117,  92,  76, 104, 106, 114,
    133, 109, 204, 192, 166, 148, 138, 128, 111,  81,
    118,  99,  79, 146, 169, 141, 123, 102, 131, 120,
    127, 105, 136, 204, 170, 154, 131, 145, 135, 119,
    117,  95,  64,  83, 141, 136, 118,  96,  99, 126,
    115,  93,  98, 102,  95, 105, 106, 114, 119, 128,
    131, 121,  98, 139, 149, 119, 109,  86, 105, 129,
    134, 119, 104, 169, 185, 155, 141, 122, 107, 127,
    136, 115,  85, 108,  87, 126, 102, 128, 136, 129,
    125,  99, 126, 158, 133, 139, 132, 113,  91, 107,
    141, 122, 128, 161, 130, 127, 105, 120, 118, 106,
    122, 140, 161, 168, 187, 184, 176, 158, 144, 140,
    127, 111,  89, 130, 132, 105, 134, 121, 100, 122,
    129, 110, 128, 115, 129, 116, 132, 118, 114, 119,
    138, 133, 132, 188, 183, 159, 161, 147, 134, 140,
    132, 113,  84, 167, 147, 132, 124, 109, 133, 121,
    132, 128, 116, 121,  98, 101, 145, 129, 128, 129,
    124, 112, 152, 158, 136, 161, 139, 165, 158, 142,
    139, 138, 110, 127, 148, 117, 126, 118, 101, 116,
    155, 168, 154, 128, 120, 152, 150, 141, 140, 135,
    127, 111, 109, 134, 104, 133, 110, 112, 132, 114,
    111,  87,  68,  89, 107, 121, 121, 126, 126, 129,
    120, 148, 169, 163, 173, 178, 185, 188, 178, 163,
    122,  97,  86, 117, 101, 138, 118, 142, 155, 139,
    125, 114, 131, 138, 153, 149, 163, 150, 143, 141,
    157, 161, 138, 152, 134, 121, 122, 109, 110, 124,
    151, 171, 196, 168, 145, 139, 147, 151, 146, 139,
    134, 169, 179, 170, 175, 178, 177, 173, 165, 154,
    120, 151, 118, 107, 125, 129, 133, 133, 136, 139,
    119, 141, 159, 151, 160, 165, 168, 169, 162, 152,
    115, 111, 119,  94, 117, 121, 127, 127, 132, 136,
    134, 153, 147, 142, 142, 147, 159, 159, 154, 147,
    110, 106, 139, 135, 143, 142, 147, 146, 147, 147,
    115, 133, 151, 133, 141, 142, 151, 152, 147, 144,
    115, 132, 144, 131, 125, 126, 128, 130, 131, 136,
    138, 118,  96,  71,  48,  26,  43, 130, 125, 125,
    134, 122,  98,  54,  28,  84,  77,  73, 109, 125,
    133, 112,  67,  48, 141, 129, 126, 113, 112, 118,
    143, 123,  89,  54,  71,  73,  75, 131, 123, 123,
    126, 109,  81,  31,  15,  94, 110, 109, 119, 128,
    132, 122,  97,  92,  73,  50,  27,  22, 104, 133,
    133, 119,  94,  48,  34, 168, 160, 154, 151, 130,
    147, 133,  90,  54,  71, 123, 106, 105,  93, 117,
    143, 132, 107,  69,  45,  78, 178, 169, 150, 139,
    138, 123, 116,  96,  69,  49,  32, 113, 103, 112,
    154, 151, 125,  79,  60, 152, 160, 154, 155, 137,
    142, 151, 124,  88,  66,  59,  94,  87,  95, 119,
    166, 154, 122,  92, 138, 132, 124, 114,  97,  97,
    122,  99,  98, 219, 191, 176, 165, 159, 153, 131,
    130, 119,  91,  51,  24,  41, 144, 156, 147, 139,
    139, 122,  81,  65, 124, 111, 104,  90,  94,  98,
    138, 120, 112,  91,  63,  65,  89,  75,  78, 106,
    126, 107,  91,  85,  69,  95,  90,  84, 108, 120,
    155, 139, 100,  78, 120, 110, 109,  91,  77,  73,
    144, 130, 135, 112,  88,  65,  62, 142, 129, 126,
    170, 154, 150, 131, 121, 116, 100,  92,  83,  86,
    131, 122,  98, 107, 102,  75,  54,  38, 117, 130,
    146, 139, 117, 107,  86,  66,  44,  30,  97, 128,
    129, 116, 100,  59, 108, 127, 119, 139, 129, 129,
    124, 106,  79,  49, 154, 190, 166, 152, 133, 123,
    141, 149, 123,  89,  61,  70, 143, 132, 125, 126,
    136, 113, 177, 166, 141, 123, 109, 108, 105,  93,
    137, 117, 147, 123,  99,  85, 109,  98,  91,  75,
    129, 121, 102,  78,  53,  90, 149, 136, 134, 135,
    144, 136, 126,  90, 114, 152, 137, 152, 138, 128,
    133, 115, 107, 129,  99,  78,  60, 129, 125, 118,
    147, 141, 119, 124, 110,  91,  79,  64, 106, 117,
    134, 111, 164, 143, 123, 113, 116,  95,  76,  56,
    147, 159, 140, 109,  83,  84, 140, 135, 127, 129,
    123, 104, 116,  99,  91,  87,  80, 110, 113, 121,
    124, 106, 174, 174, 152, 141, 132, 134, 126, 124,
    140, 190, 240, 215, 212, 189, 173, 158, 144, 137,
    123,  97,  79, 102, 110, 111,  90,  75, 126, 124,
    134, 121, 104, 145, 127, 100,  77,  65, 120, 118,
    123, 106,  87,  41,  68, 119, 106, 115, 109, 119,
    137, 232, 241, 225, 217, 202, 183, 169, 156, 145,
    161, 146, 127, 110,  97, 107,  88, 114, 108, 106,
    141, 244, 216, 192, 172, 163, 148, 143, 144, 144,
    128, 127, 109,  89,  77,  68, 124, 120, 121, 125,
    125,  94,  48,  71, 116, 113, 104, 120, 142, 137,
    133, 129, 115,  82,  68, 120,  99, 133, 134, 124,
    130, 106, 108, 160, 130, 111,  89, 129, 124, 119,
    134, 120, 149, 143, 116,  95,  87, 142, 132, 122,
    126, 114, 108, 107,  80, 141, 133, 123, 137, 124,
    117,  95,  69,  43,  62,  98, 114, 116, 112, 120,
    122,  99,  87, 164, 145, 123,  99,  95, 118, 105,
    126, 101, 102, 120, 113, 110,  92, 139, 134, 126,
    148, 194, 241, 219, 221, 215, 200, 193, 174, 151,
    127, 104, 122, 136, 113, 106, 110,  95,  78, 106,
    131, 163, 217, 199, 194, 175, 164, 155, 142, 138,
    139, 124,  88,  57, 161, 161, 145, 139, 124, 116,
    127, 110,  91,  98, 126, 104, 113,  98,  94,  94,
    145, 138, 114,  90,  75, 130, 117, 107,  99,  90,
    119,  98,  86, 101, 148, 133, 103,  83, 124, 131,
    143, 168, 169, 133, 110, 117, 139, 149, 147, 137,
    124, 106,  80, 138, 194, 163, 142, 119, 106, 130,
    136, 125, 105, 114,  87, 113, 101,  89, 108, 102,
    114,  90,  53,  46, 105, 116, 126, 122, 118, 122,
    124, 102,  92, 195, 167, 160, 144, 154, 154, 132,
    118,  97,  88,  72,  98, 120, 112,  98,  79, 117,
    114, 107, 185, 191, 191, 188, 175, 165, 153, 143,
    119,  97,  90,  89, 120, 151, 136, 113,  99, 112,
    141, 121, 144, 122, 125, 113, 133, 111,  92,  69,
    120,  98,  78, 109, 151, 145, 157, 157, 151, 143,
    130, 110, 120, 188, 159, 141, 119, 112, 109,  98,
    126, 112,  83, 110, 169, 139, 127, 105,  93, 123,
    141, 145, 117, 106,  91,  78, 123, 107, 101, 125,
    117,  95,  71, 147, 176, 153, 148, 133, 135, 127,
    124, 106,  79,  64, 115,  96, 108, 115, 106, 105,
    127, 115,  90,  98, 105,  81, 144, 135, 117, 125,
    126, 104,  98, 165, 138, 136, 112, 149, 148, 131,
    119, 144, 186, 185, 204, 202, 209, 200, 182, 161,
    123, 153, 190, 189, 199, 194, 191, 176, 157, 147,
    121, 103, 119,  98, 100, 120, 106,  97,  95, 126,
    137, 130, 102, 117, 117,  92, 126, 114, 101, 118,
    131, 219, 190, 167, 153, 151, 144, 140, 142, 143,
    114, 102, 151, 152, 132, 120, 112, 120, 127, 131,
    138, 122,  91, 143, 118, 120, 114, 104, 124, 117,
    148, 142, 117, 126,  97, 125, 108, 116, 142, 125,
    126, 106,  91, 169, 208, 178, 158, 138, 127, 135,
    133, 126, 101,  83, 147, 130, 125, 117, 114, 117,
    120, 103,  94, 149, 136, 129, 139, 118, 133, 133,
    147, 152, 126, 132, 119,  97, 132, 129, 114, 126,
    112, 107, 148, 125, 112, 114, 124, 125, 129, 135,
    139, 121, 157, 151, 131, 140, 118, 147, 136, 121,
    115, 105, 159, 167, 185, 191, 196, 190, 176, 160,
    124, 106, 104, 122, 130, 114, 152, 144, 134, 136,
    136, 152, 159, 153, 131, 114, 116, 126, 129, 129,
    124, 109,  87, 131, 107, 115, 130, 107, 144, 131,
    126, 162, 176, 175, 180, 176, 160, 141, 134, 134,
    136, 127, 108, 161, 162, 133, 141, 124, 112, 128,
    130, 115, 110, 140, 107, 155, 134, 131, 156, 137,
    122, 106, 116, 127, 118, 161, 150, 170, 167, 152,
    139, 177, 203, 176, 155, 139, 130, 128, 129, 132,
    137, 119, 125, 103, 110, 123, 107, 120, 108, 101,
    113, 107, 160, 154, 160, 166, 169, 176, 168, 156,
    115,  90,  65, 115, 115, 104, 120, 112, 109, 124,
    131, 123, 100, 109, 185, 158, 141, 132, 116, 119,
    139, 130, 119, 156, 124, 138, 127, 116, 141, 128,
    133, 118, 115, 180, 149, 151, 135, 130, 147, 129,
    117,  90,  80, 119, 124, 128, 132, 130, 128, 135,
    112,  97, 142, 161, 167, 165, 154, 142, 136, 135,
    118, 141, 193, 172, 157, 152, 148, 145, 146, 141,
    125, 147, 165, 166, 149, 133, 123, 122, 128, 131,
    128, 193, 177, 174, 182, 186, 197, 193, 191, 173,
    124, 144, 162, 133, 113, 113, 123, 128, 129, 130,
    117,  98, 121, 122, 137, 132, 110,  97, 111, 130,
    128, 176, 151, 125, 126, 134, 130, 121, 127, 130,
    122, 151, 142, 111, 106, 121, 126, 126, 130, 134,
    148, 167, 186, 153, 129, 122, 124, 128, 130, 128,
    148, 172, 206, 178, 171, 182, 169, 180, 172, 156,
    133, 164, 174, 160, 155, 163, 163, 172, 169, 158,
    132, 150, 147, 142, 152, 140, 140, 140, 134, 135,
    137, 158, 167, 172, 163, 153, 169, 158, 146, 147,
    150, 161, 162, 172, 153, 133, 140, 144, 136, 135,
    109,  84, 101, 120, 129, 134, 133, 136, 137, 143,
    112, 114, 157, 147, 141, 136, 135, 133, 135, 138,
    121, 154, 161, 150, 149, 154, 151, 144, 146, 144,
    111, 117, 125, 125, 130, 131, 135, 137, 143, 148,
    121, 141, 146, 131, 138, 126, 118, 111, 119, 130,
    120, 135, 145, 121, 140, 134, 138, 137, 131, 134,
    115, 137, 132, 137, 139, 138, 138, 139, 145, 149,
    131, 149, 147, 133, 132, 126, 131, 134, 130, 133,
    110,  98,  84, 141, 107, 169, 169, 123, 125, 126,
    118, 210,  98, 126, 132, 138, 128, 139, 156, 157,
    140, 142, 129,  95, 192, 178, 182, 186, 183, 159,
    135, 134, 144, 124, 100, 228, 203, 161, 122, 104,
    139, 159, 134, 161, 121, 126, 192, 152, 218, 180,
    132, 132, 119,  99,  96,  97,  80,  53, 134, 143,
    102, 114, 133, 114, 127,  83,  77, 126,  85, 107,
    110, 114, 194, 186, 139, 116, 147, 104, 129, 138,
    126, 133, 109, 144, 115,  45, 130,  97, 159, 155,
    157, 162, 189, 185, 168, 163, 151, 151, 142, 135,
    144, 147, 120,  74, 192, 186, 149, 118,  71,  84,
    143, 156, 133, 178, 168, 107, 119, 149, 105, 112,
    182, 184, 158, 118, 118, 148, 128, 177, 171, 152,
    139, 135, 126, 209, 171, 150, 123, 100, 190, 158,
    166,  97, 136, 123, 136, 139, 128, 138, 126, 121,
    132, 131, 128,  95,  60, 168, 127, 140, 208, 161,
    109, 102, 119, 162, 150, 137, 107, 200, 156, 136,
    136, 128, 103,  95,  74,  91, 220, 173, 152, 138,
    139, 129, 140, 136, 122,  82, 180, 115,  53,  90,
    121, 107,  99, 148, 116, 139, 100,  63, 191, 155,
    130, 129, 163, 155,  98, 175,  95, 151, 127, 107,
    124, 124, 116,  88,  71, 164, 148,  96,  57,  89,
    125, 117,  77,  63, 162, 144, 113, 109, 137, 134,
    134, 130, 149, 174, 158, 158, 130,  81,  28,  67,
    142, 139, 129, 100, 194, 134,  68, 175, 131, 103,
    136, 132, 122,  96, 119,  82, 115, 249, 215, 168,
    125, 139, 199,  96, 146, 123, 136, 179, 142, 137,
    181, 166, 106,  86, 122, 106, 123, 131, 106, 119,
    129, 189, 188, 147, 126, 110, 101, 114, 147, 136,
    132, 106,  72, 175, 148,  99, 130, 153, 125, 136,
    123, 119, 147, 170, 157, 126, 209, 188, 158, 152,
    101,  89, 142, 131, 161, 150, 148, 124,  89, 119,
    141, 137, 131, 103,  81,  85,  64, 175, 129, 121,
    137, 144, 142, 145, 119, 205, 148,  80, 165, 138,
    143, 137, 167, 165, 148, 149, 110, 234, 217, 170,
    167, 152,  75, 140, 155, 155, 175, 129, 136, 134,
    136, 152, 161, 131, 140, 121,  91,  79, 255, 209,
    132, 147, 120, 114, 177, 128, 110,  61,  89, 131,
    125, 127,  93,  87, 167, 115, 186, 162, 107, 106,
    134, 162, 151, 100,  79,  67, 151, 116, 130, 142,
    162, 153, 155, 143, 122,  85, 202, 187, 135, 125,
    158, 155, 103, 129,  74, 149, 130,  98, 129, 126,
    148, 152, 153, 133, 118,  94,  80,  70,  47,  90,
    124, 118, 143, 184, 158, 126,  70,  82, 111, 113,
    126, 135, 175, 141, 203, 166, 123, 123, 134, 133,
    113, 111, 128,  76, 128, 177, 151, 178, 134, 125,
    120, 120, 193, 106,  98, 134, 101,  86, 101, 114,
    136, 127, 134, 196,  86, 105, 145, 128, 119, 137,
    138, 126, 230, 161, 141, 128, 129, 136,  88,  83,
    103, 118, 178, 123,  89, 101, 161, 173, 165, 147,
    130, 123, 171, 158, 131,  81,  50, 177, 162, 136,
    125, 115,  82, 173, 195, 168, 130, 112, 112, 121,
    152, 148, 167,  87,  82, 161, 142, 147,  98,  89,
    168, 138,  97, 157, 132, 114,  74, 126, 161, 141,
    135, 123,  68, 137, 124, 118, 112,  92,  65,  96,
    191, 181, 161, 151, 141, 145, 129, 102,  97, 111,
    144, 128,  55, 128, 115, 155, 129, 184, 167, 147,
    131, 141, 125,  33, 127, 111, 127, 131, 125, 130,
    137, 130, 121, 195, 172, 177, 176, 149,  98,  97,
    126, 106, 168, 159, 144, 185, 156, 151, 182, 158,
    123,  93, 110, 116,  98,  99, 125, 136, 139, 148,
     79, 112, 149, 128, 147, 136, 118, 105, 166, 152,
    117, 115,  92, 128, 148, 132, 170, 143, 226, 190,
    122, 192, 165, 121, 143, 144, 174, 124, 113, 124,
    122, 135,  34,  93, 118, 111, 111, 136, 123, 116,
     99, 195, 139,  99, 114, 102,  96, 108, 111, 112,
    113, 129, 172, 137, 105, 139, 154,  86, 113, 108,
    132,  79,  63, 120,  93, 162,  90, 103,  94,  95,
    117, 127, 104, 100, 142, 129,  93,  27, 196, 153,
    113,  91, 101,  90,  84,  68, 138,  38, 118, 148,
     87, 103, 125, 109,  96, 152, 100,  56,  31,  62,
    176, 129, 124, 115, 103,  92, 100, 121, 130, 125,
    128,  71,  82,  71, 152,  85, 107, 116, 138, 133,
    103, 116, 139, 144,  72,  37, 118, 141, 109,  95,
     86,  92, 121, 167, 156, 104,  92,  91, 122, 114,
     89,  61, 172, 128,  95, 103,  84, 101,  88,  84,
    116, 125, 108,  62,  74, 108, 160, 143, 189, 164,
     91, 115, 144,  43, 116,  79, 106, 108,  74,  83,
     87,  90,  61,  71,  76,  76,  95, 130,  89,  94,
    114, 107, 101, 145, 161, 147, 143, 163, 147, 129,
    101,  73, 111, 108,  93, 104, 186, 141,  99,  89,
    112, 126, 111, 113, 152,  41, 159, 115, 131, 124,
    117, 101, 115, 130, 124,  87,  59, 177,  63,  85,
    109, 116, 103,  68, 145, 132,  29, 119,  96,  89,
    117,  90, 181, 103, 101, 111,  97,  96, 199, 171,
    113, 120,  93, 119, 101,  64,  56,  55,  63,  90,
    105, 101,  86,  45, 136, 179, 142, 102, 115, 114,
    113, 108, 121,  84,  23, 125,  76, 102, 119, 107,
    120, 104,  73, 177,  83, 114, 128,  85, 152, 126,
    137, 115, 149, 109, 163, 133, 110,  98,  54,  61,
     95, 111, 135, 103,  88, 164, 115, 187, 122,  98,
    129, 132,  95,  86,  71, 119, 146, 111,  38,  67,
    102, 100,  66, 148, 137, 103, 145,  95,  35,  85,
     44, 136, 102, 111, 108, 115, 136, 105, 120, 110,
    108, 147, 112, 169, 116, 146,  81, 120,  94,  84,
     93,  97,  90, 119, 102,  91,  48, 147, 204, 151,
    148, 160, 144, 131, 144, 175, 158, 133, 212, 163,
    172, 152, 151, 112, 148, 151, 145, 179, 160, 124,
    164, 164, 167, 161, 141, 120, 131, 141, 198, 177,
    169, 156, 146, 156, 124, 185, 164, 195, 181, 193,
    201, 147, 148, 168, 165, 159, 162, 148, 150, 148,
    146, 157, 158, 149, 164, 129, 160, 214, 174, 166,
    154, 176, 146, 141, 155, 140, 140, 169, 106, 155,
    166, 162, 134, 193, 157, 155, 146, 196, 171, 107,
    177, 174, 163, 155, 147, 203, 162, 146, 150,  83,
    157, 170, 180, 178, 159, 157, 151, 117, 115, 183,
    170, 180, 174, 150, 177, 173, 136, 181, 196, 184,
    164, 168, 165, 148, 175, 168, 209, 189, 159, 114,
    157, 158, 141, 168, 170, 139, 175, 128, 151,  39,
    128, 154, 159, 161, 148, 180, 131, 165, 159, 131,
    163, 150, 174, 178, 178, 198, 172, 138, 184, 191,
    143, 164, 161, 163, 210, 171, 155, 168, 150, 116,
    182, 170, 145, 152, 141, 139, 191, 149, 160, 202,
    145, 169, 145, 181, 148, 183, 197, 165, 146, 171,
    161, 153, 157, 170, 164, 149, 183, 167, 246, 235,
    162, 144, 170, 152, 173, 150, 113, 135, 156, 154,
    158, 148, 178, 159, 161, 114, 180, 156, 116, 163,
    164, 161, 122, 164, 164, 183, 135, 135, 144, 182,
    160, 147, 163, 152, 169, 185, 159, 177,  99, 211,
    168, 167, 215, 170, 150, 157, 154, 176, 154, 143,
    163, 117, 178, 160, 163, 165, 164, 166, 174, 136,
    159, 169, 152, 123, 199, 149, 169, 140, 159, 208,
    155, 161, 186, 122, 134, 167, 171, 145, 148, 176,
    148, 137, 114, 160, 166, 153, 162, 156, 164, 172,
    155, 148, 155, 182, 114, 150, 157, 154, 140, 159,
    166, 160, 169, 206, 182, 145, 157, 165, 147, 202,
    131, 154, 193, 162, 162, 149, 167, 157, 191, 188,
    149, 205, 147, 166, 150, 150, 159, 153, 171, 160
};

static const uint8_t wmavoice_dq_lsp16i1[0x640] = {
    142, 121, 141, 112,  99, 119,  92, 122, 183, 155,
    122,  98,  75,  78,  85, 101, 108, 134, 128, 123,
    115,  90,  79,  58,  73, 127, 106,  60,  97, 107,
    141, 163, 130, 123, 136, 156, 201, 189, 204, 206,
    140, 116,  69,  60, 117, 123, 106, 124,  91,  63,
    150, 144, 110,  80,  63, 112,  80,  70,  76,  63,
    114,  86, 147, 165, 137, 125, 120, 140, 115, 101,
    101,  99, 166, 158, 158, 104, 126, 131, 134, 143,
    121, 102,  73,  36,  83, 132, 113,  76,  38,  20,
    132, 111,  78,  73,  51, 131, 108, 131, 105,  80,
    148, 138, 101,  65,  47, 115,  86,  50, 124, 129,
    116,  89,  85,  87,  64, 111,  74,  39, 115, 113,
    112,  83,  75, 122, 127, 114,  91, 106, 125, 130,
    131, 108,  79, 136, 112, 110, 147, 164, 144, 124,
    121, 236, 218, 190, 168, 106, 101, 160, 172, 191,
    113, 138, 102,  91, 109, 100,  71,  85, 112, 119,
    121,  96,  51,  64, 126, 135, 114,  76,  34, 104,
    145, 127,  90,  56, 131, 142, 131,  92, 123, 102,
    128, 105,  63,  24,  95, 115,  87,  49, 156, 174,
    123, 105,  88,  58,  55, 141, 119,  99,  75,  81,
    137, 117, 114,  80,  56, 119,  91, 106, 166, 135,
    114,  84,  38,  93, 116, 129, 103,  97,  87,  97,
    115, 184, 193, 173, 157, 117,  88, 114, 151, 121,
    126, 111,  75, 129, 133, 130, 107,  71, 115,  92,
    128, 108, 120, 100,  97, 111,  80, 119, 122,  91,
    114,  94, 149, 129, 136, 114,  88, 132, 110,  85,
    116,  99, 101,  71,  71, 110, 140, 142, 131, 110,
    122,  98,  83, 127, 100, 106, 130, 123, 114, 103,
    113,  87, 140, 116, 113, 140, 161, 171, 145, 129,
    115, 178, 158, 161, 160, 118, 195, 209, 221, 228,
     99,  83, 140, 134, 140, 127, 186, 168, 187, 187,
    107, 114, 100, 111, 111, 104, 130, 131, 116, 128,
    128, 104,  64,  18,  49, 126, 107,  69,  56, 153,
    154, 142, 110, 113,  89, 120,  93,  73, 190, 172,
    119,  96,  57,  21,  60, 126, 122,  81,  99, 117,
    159, 141, 108,  88, 120, 144, 125,  89,  44,  94,
    147, 131,  93,  81,  61, 133, 113,  85,  47,  62,
    123, 121,  87,  53,  90, 120,  94,  76,  70,  48,
    125, 103,  93,  64,  35, 140, 129,  88,  47,  30,
    127, 104,  58,  51, 103, 124, 100, 102,  76,  47,
    115,  87,  54,  46,  77, 182, 218, 174, 163, 145,
    140, 126,  89, 105,  82, 125, 119, 101,  69,  58,
    125, 107, 172, 145, 128, 138, 113, 109,  92,  90,
    117,  93,  83,  93, 132, 125, 102,  67, 148, 161,
    131, 110,  96,  99,  74, 119,  92,  54,  84,  81,
    110, 152, 120, 106, 131, 108,  74,  68,  99, 107,
    121,  97, 120, 101,  78, 132, 110, 127, 164, 134,
    111, 159, 204, 189, 178, 158, 183, 146, 144, 137,
    123, 106, 136, 108, 135, 117,  91, 163, 135, 113,
    119, 177, 134, 122, 121, 132, 109, 157, 131, 113,
    115,  87,  87, 100,  92, 120,  95,  59, 146, 139,
    129, 101, 135, 122, 101, 119, 100, 112,  88,  99,
    118,  90, 123, 125, 107, 121,  98,  73, 104,  80,
    112,  79,  86, 122,  96, 104,  81, 107,  90,  93,
    112, 150, 140, 109, 115, 113,  86,  73,  76, 112,
    130, 111, 101, 112,  84, 123,  97,  63, 134, 115,
    109,  77, 128, 141, 119, 125, 101, 108, 147, 119,
    134, 149, 150, 127, 115, 136, 244, 220, 210, 189,
    105, 138, 171, 156, 174, 117, 162, 133, 146, 141,
    115,  93, 119,  98, 122, 114, 106, 154, 145, 162,
    107, 131, 189, 165, 152, 101, 107, 129, 114, 139,
    116, 186, 186, 161, 180, 100,  89, 137, 116, 116,
    106, 130, 194, 196, 207, 110, 156, 157, 138, 149,
    102,  93, 159, 138, 120, 109, 132, 105, 122, 135,
    148, 128,  85,  76, 102, 168, 154, 141, 117, 100,
    125, 106,  62, 101, 146, 124, 102,  65,  25,  15,
    120,  94,  46,  21,  94, 149, 128, 115,  85,  92,
    119,  93,  70,  52,  30, 162, 151, 123,  91,  80,
    126, 112,  84,  47,  33, 138, 114,  73,  60,  87,
    126, 211, 174, 158, 143, 129, 106,  65,  31, 133,
    119,  95,  52,  99, 173, 123,  96, 119, 206, 178,
    127, 104,  60,  61,  67, 152, 136, 104,  63,  83,
    133, 130,  92,  64,  45, 120,  96,  53,  30, 130,
    128, 103,  74,  59,  35, 135, 114,  77,  30,  57,
    108, 130, 123,  90,  87, 143, 125,  93,  54,  60,
    133, 118,  79,  87,  95, 115,  89, 111,  88,  65,
    124, 102,  70,  40,  47, 148, 131, 123, 130, 104,
    127, 109,  87,  56, 121, 147, 123, 121, 107,  85,
    178, 237, 200, 193, 170, 139, 118, 100,  75, 110,
    133, 121,  81,  73,  68, 120, 195, 157, 141, 131,
    127, 102, 107,  88,  60, 136, 113, 100,  69,  45,
    128, 105,  93,  77,  67, 131, 116, 149, 184, 156,
    115,  85,  35,  45, 112, 128, 108,  68,  73, 111,
    118,  93, 187, 162, 139, 136, 115,  84,  57,  37,
    131, 133, 125,  98,  85, 138, 115,  92,  86,  61,
    116,  96,  70,  52, 110, 115, 109, 135, 104,  88,
    136, 159, 122, 109, 115, 122, 110,  98,  70,  95,
    112,  81,  68,  85,  90, 124, 101,  87,  56,  89,
    109,  82,  98, 100, 115, 124, 102,  76,  88,  63,
    111,  78,  42,  78, 102, 110,  71,  64, 131, 111,
    125, 104, 107,  87, 123, 129, 131,  99,  85,  68,
    147, 137, 102,  99,  75, 120, 155, 142, 109,  91,
    132, 109, 131, 141, 113, 136, 119,  94, 152, 128,
    127, 102,  79, 159, 134, 111,  78,  98, 109,  80,
    115,  86,  51,  63, 103, 116,  86, 170, 149, 123,
    135, 178, 159, 125, 114, 113, 189, 226, 203, 202,
    140, 117, 116,  94,  70, 128, 103,  94, 174, 149,
    118,  98,  83,  84, 106, 115, 157, 120,  94,  95,
    131, 112,  75,  96,  74, 121,  97, 144, 117,  95,
    120,  90, 140, 138, 110, 119,  93,  55,  92, 114,
    114,  87, 151, 125, 100, 111,  82,  83, 160, 139,
    114,  86,  56,  90, 138, 104, 109, 101,  77, 118,
    140, 142, 143, 148, 126, 121, 102, 129, 107, 111,
    113,  79,  58, 111,  91, 120,  94,  63, 115,  98,
    121,  94,  99,  97,  78, 120,  92,  68, 173, 148,
    122, 114, 109,  87,  82, 132, 229, 192, 176, 155,
    137, 116, 123,  97, 115, 132, 115,  86, 120,  95,
    135, 116, 101, 136, 108, 109,  74, 100, 125, 115,
    112, 158, 144, 124, 134, 114,  83,  73, 147, 120,
    120, 104, 150, 122, 116, 110, 104, 192, 183, 174,
    134, 112, 116, 120,  93, 121, 101,  93, 110,  90,
    121,  93, 147, 152, 122, 115, 153, 171, 161, 142,
    123,  95, 116, 114,  93, 113,  89,  96,  77,  93,
    113, 174, 180, 143, 138, 116,  86, 100, 135, 106,
    103, 121, 149, 115, 103, 121,  95,  82, 149, 121,
    117,  92,  93, 111, 114, 123, 209, 196, 193, 183,
    125, 102, 107, 130, 104, 115,  91, 113, 103,  99,
    114,  86,  68, 108, 110, 111, 159, 162, 125, 113,
    125, 235, 234, 225, 214,  99,  74, 118, 121, 127,
    104, 123, 158, 128, 127, 113,  96, 116, 136, 158,
    100,  80, 138, 155, 166, 118, 143, 115, 125, 114,
    119, 137, 133, 136, 139, 151, 188, 172, 174, 173,
    138, 161, 158, 158, 155, 121, 198, 194, 211, 202,
    100,  90, 112, 110, 122, 100,  91, 122, 128, 135,
    101, 109, 127, 101, 114, 105, 126, 160, 147, 143,
    109, 138, 142, 158, 163, 113, 174, 185, 188, 206,
    112, 154, 166, 176, 183, 101, 108, 140, 140, 143,
    106, 135, 130, 137, 126, 103, 114, 115, 128, 126,
    107,  86,  21, 115,  75, 117, 139,  97,  65, 105,
     64, 191, 101, 106, 139, 107,  98, 218, 132, 104,
     73, 136, 165,  84, 118, 150, 111,  58, 130, 107,
     99, 136, 132,  56,  52, 102, 136,  69,  78, 163,
     85, 173, 148, 138,  85,  69, 106, 128, 133, 155,
    104,  91, 149,  56, 104, 103, 101, 172,  96,  57,
    104,  97, 125, 197, 166, 107, 169,  47, 120, 103,
    150,  89,  99, 139, 162, 101,  69, 137, 158, 126,
    191, 173, 127,  79, 155,  51, 131, 112,  86,  74,
    135,  61, 114,  81, 125, 117, 112,  72, 175,  72,
    127, 123, 142, 132,  78, 116, 158, 111, 121, 143,
    108, 102,  89,  20, 194,  81,  99, 107,  65, 150,
    103,  78,  91,  69,  96, 104, 116, 116, 103, 105,
    107, 117, 110, 130,  28,  88, 103,  62,  72,  85,
    125, 126, 141, 126, 178, 121, 102,  57,  46, 124,
     97,  91,  89, 138,  95,  98, 143,  99, 169, 123,
    140, 119, 113,  82, 140, 118, 112,  91,  92, 241,
    134,  89,  95, 112,  78, 167, 140, 145, 121, 100,
    109, 205, 144,  91, 100, 113, 103, 142, 175,  95,
    117, 121,  35, 121, 127, 159, 129,  85,  64,  75,
    116,  98, 103, 127, 129,  66,  68, 110,  96,  86,
     79, 100, 156, 133,  92, 135,  96, 164, 132, 121,
     93, 163, 134,  91, 208, 104,  77, 126, 116,  58,
    136, 118, 132,  81,  61,  73, 115,  66, 129, 123,
    111,  85,  42, 178, 134, 108, 132, 159,  45, 157,
    105, 164, 100,  94,  60,  96,  57, 154, 105, 102,
    103, 114,  96,  12,  91, 119, 115,  67,  92,  64,
     94,  61, 106, 106, 165, 105,  94,  98,  68,  30,
    146, 130, 107, 173, 140, 102,  90, 163, 106, 184,
    100,  53,  68, 131,  92, 105, 111,  68, 153, 186,
    101,  82,  48,  99, 147, 122, 136, 176,  96,  96,
    104, 132, 167, 149, 136, 138, 144,  97, 120,  92
};

static const uint8_t wmavoice_dq_lsp16i2[0x3c0] = {
     23,  12, 107, 119, 110, 205, 214, 212, 208, 201,
    102,  95,  69, 117, 107, 118, 123, 118, 123, 121,
     82,  58,  83,  95,  84, 139, 145, 153, 161, 169,
    102, 100, 138, 121, 101, 129, 130, 138, 150, 139,
     76, 104,  86, 112, 133, 113,  91,  63,  73, 129,
    199, 193, 182, 181, 172, 119, 101,  83,  94,  76,
    161, 157, 152, 157, 158, 110,  90, 121,  96,  79,
    124, 107, 114,  88,  73, 152, 137, 121, 107,  99,
     57,  50, 100,  81,  74, 115,  96,  72,  49,  69,
     83,  68,  40,  53, 103,  36, 131, 107,  84,  64,
    236, 245, 242, 231, 213,  95, 109,  88,  69, 110,
    228, 221, 204, 182, 170, 129, 110,  97, 118, 104,
     98,  76,  98,  75,  61,  93,  77, 113,  91,  72,
    116,  94, 106, 134, 118, 177, 188, 169, 162, 153,
    163, 149, 131, 131, 132, 177, 163, 173, 168, 158,
    113, 131, 107, 113, 100, 132, 143, 131, 134, 142,
     45,  36, 121, 113, 102,  43,  95,  84,  67,  56,
     76,  82,  68,  48,  33,  55,  58,  59,  43,  65,
     66,  85,  66,  81,  94, 102,  82,  54,  33,  94,
    113, 111,  89,  60,  34, 138, 120, 101, 101,  86,
     88,  73,  55, 114, 115,  92,  74,  93,  77, 123,
     90, 117,  99,  79,  59,  97,  75,  97, 122, 104,
    233, 237, 227, 208, 190, 209, 230, 233, 240, 241,
    195, 197, 188, 167, 147, 204, 185, 168, 162, 157,
    142, 124, 119, 123, 106, 117, 110,  81, 121, 123,
     74, 116, 124, 119, 120, 178, 168, 146, 132, 125,
    102, 104, 105, 110, 114, 104,  82,  78, 100,  86,
    120, 102, 105,  93, 143, 127, 108, 128, 106,  88,
    177, 189, 203, 207, 215, 101, 131, 119,  95,  73,
    149, 139, 135, 147, 153, 160, 167, 165, 174, 177,
    120, 109, 134, 140, 145, 131, 130, 142, 139, 161,
    143, 158, 148, 145, 145, 123, 142, 132, 116, 102,
     40,  23,  79,  82,  84,  26,  83, 141, 130, 122,
     65,  46,  43,  89,  86,  28,  75,  80,  79,  98,
     84,  65,  47,  26,  44,  49, 112, 101, 100,  94,
     88,  76,  75,  48,  82, 104, 100,  75,  45,  15,
     99,  83,  63,  34,  30,  66,  55,  94, 118, 113,
    122, 106,  91,  68,  60, 135, 122, 104,  77,  59,
     82, 102,  84,  62,  46,  92,  74,  55,  82,  71,
    145, 134, 118,  93,  75,  79,  62,  83,  65,  55,
     91,  94,  64,  70,  98,  89, 117, 110,  87,  97,
    210, 223, 225, 223, 213,  83, 103,  86, 101,  85,
    126, 106,  81,  79, 105, 216, 219, 217, 199, 179,
     86,  78, 115, 138, 135, 102,  84,  87,  59,  46,
    219, 206, 184, 167, 158, 201, 188, 165, 145, 135,
     87, 113, 142, 152, 155, 190, 170, 153, 149, 146,
    205, 208, 201, 185, 167,  84,  73, 124, 104,  96,
     76,  88,  99,  74,  80, 110, 125, 122,  99, 112,
    108,  84,  70, 130, 137, 161, 152, 136, 119, 105,
    110,  91, 101,  74,  96, 111, 101,  93, 153, 149,
    133, 124, 102,  97, 120, 101,  93,  75,  81,  64,
    111,  94, 107,  79,  58, 188, 206, 215, 221, 232,
    163, 175, 165, 150, 136, 103, 106, 123, 133, 132,
    168, 184, 191, 183, 170, 110, 117,  90,  98,  93,
    104,  87, 122,  98, 127, 129, 110, 127, 113, 125,
    134, 118, 102, 140, 132, 186, 199, 202, 198, 188,
    149, 147, 175, 185, 186, 117,  93,  99, 112,  93,
    107, 138, 138, 129, 128,  96, 129, 104, 118, 134,
    145, 136, 115, 121, 129, 138, 155, 148, 134, 120,
    170, 151, 150, 145, 138, 168, 173, 185, 194, 200,
    144, 159, 172, 168, 156, 121, 121, 138, 173, 168,
    126, 111, 140, 139, 117, 149, 133, 142, 137, 130,
    143, 139, 158, 158, 146, 119, 128, 121, 132, 145,
    122, 136, 159, 153, 141, 133, 133, 130, 129, 126,
    120,  76,  50, 149, 109,  92, 155, 118,  90,  66,
    132, 117,  87, 156, 117, 119, 102,  44,  83,  91,
    109,  73, 106,  84,  29,  55, 130, 112,  81, 241,
     75,  40,  91,  89,  67, 112,  90, 149,  81,  72,
    128,  90,  71,  28, 160,  73, 157, 123, 143, 108,
     63,  88,  70,  81,  97,  75, 111, 149, 113,  96,
     78, 104,  83, 179,  95, 105, 106,  65, 130,  66,
     51, 118,  92,  53,  68, 105,  75, 176, 151, 115,
     94,  75,  68,  95, 220, 103, 125, 105,  43,  95,
     39, 114,  65, 145, 135,  33, 142, 138, 103,  52,
     82,  85, 117, 110,  67, 102,  74,  42,  62, 118,
    144, 121,  82,  57, 102,  67,  75,  44, 129,  96,
     75,  63,  88,  48, 116, 135,  94,  85, 102,  66,
    122,  77, 105, 122, 152, 120,  56,  90,  83, 100,
     90, 128,  63,  80, 103, 126, 117, 103,  80, 193,
     42,  73, 117,  93,  91,  95, 128, 100, 128, 162,
     70, 120, 126,  73, 123,  99,  99,  91,  75, 135,
     81, 125, 111,  77,  13,  94,  78,  85, 187, 157,
     11, 143, 109,  99, 119,  53, 141,  82, 122,  68,
    132,  89, 136, 119,  88,  75,  49, 174, 119,  70,
    138, 121, 108,  78,  52, 104,  90,  96,  93,  93,
    114,  90,  78,  46,  58,  62, 114,  69,  44, 162,
    103,  58,  98, 141,  83, 137,  95, 119,  73, 111,
     81,  46, 126, 111, 123, 107, 117, 122, 121,  54,
    106, 104,  59, 110, 148,  97, 155,  97,  83, 133,
     97,  71,  57,  91,  58,  52,  79, 127, 152, 109,
     96,  92, 145, 107, 149, 102,  61, 125,  61, 170,
     56,  89,  77, 106,  38, 147,  96,  77, 105, 123,
     85,  83, 117,  63,  69, 126, 133,  93, 107,  92,
     77, 115,  95, 111, 103,  61,  87, 103,  98, 155,
     94, 111,  80,  78,  54, 117, 128, 130,  99, 109,
    106,  99, 113, 133, 115,  89,  65,  74, 112, 127
};

static const uint8_t wmavoice_dq_lsp16i3[0x300] = {
     70, 100, 121, 129, 132, 132, 201, 188, 165, 145, 144, 136,
    112, 127, 116, 125, 130, 129, 124, 135, 135, 146, 129, 128,
    162, 158, 144, 151, 135, 129, 103,  86, 111, 113, 112, 122,
     90, 139, 129, 117, 126, 129, 142, 145, 167, 147, 124, 124,
    230, 209, 189, 175, 156, 141,  64,  80,  86, 108, 121, 129,
     44,  79, 115, 113, 115, 128, 133, 106,  79, 109, 125, 127,
    171, 156, 132, 109, 103, 115, 106,  70,  93, 145, 141, 128,
    148, 125, 122, 107, 110, 117, 146, 145, 128, 110,  98, 111,
    237, 212, 185, 156, 139, 133,  84,  55,  26,  77, 114, 127,
    172, 170, 171, 168, 162, 143,  82,  82,  76,  70, 104, 126,
     17,  95, 109, 111, 120, 132,  81,  74,  57, 126, 141, 131,
    110, 127, 162, 148, 129, 123, 177, 172, 155, 151, 145, 134,
    144, 123,  90,  66, 109, 130,  82, 127, 103, 123, 132, 131,
    127,  97,  97, 142, 140, 128, 159, 134, 136, 123, 113, 117,
    131, 140, 154, 169, 158, 134,  96, 109, 150, 122, 105, 120,
    120, 150, 152, 122, 119, 125, 123, 126, 124, 107, 100, 113,
    248, 233, 216, 189, 160, 142,  58,  24,  13,  77, 111, 127,
    183, 189, 182, 157, 140, 131,  96,  83,  59,  43,  73, 119,
    222, 196, 171, 146, 129, 128,  32,  13,  53, 101, 114, 127,
    119, 101,  70,  70, 110, 127,  77,  86, 161, 148, 130, 118,
    199, 183, 170, 167, 156, 141,  30, 115, 142, 133, 131, 130,
    101, 103, 181, 176, 152, 126,  66,  44,  73,  94, 111, 128,
    150, 122, 100, 101, 104, 118,  61, 110,  87,  76,  93, 125,
    190, 170, 150, 134, 135, 129, 112,  89,  63, 123, 141, 132,
    175, 154, 136, 142, 140, 132, 117, 143, 129, 128, 136, 132,
    168, 142, 112, 113, 128, 128, 155, 169, 159, 144, 139, 131,
     61, 136, 144, 124, 112, 123,  86,  81, 104, 121, 129, 130,
    160, 127, 118, 150, 151, 134, 126, 115, 121, 132, 134, 131,
    137, 148, 144, 139, 140, 134, 106, 102, 105,  90,  87, 113,
    134, 129, 128, 121, 121, 123, 153, 151, 129, 139, 142, 134,
    150, 142, 141, 148, 149, 141, 100, 121, 133, 147, 150, 134,
    163, 158, 147, 132, 141, 132, 142, 127, 141, 136, 136, 132,
    232, 218, 205, 189, 169, 146, 243, 224, 201, 171, 147, 138,
    224, 196, 169, 162, 154, 140,  51,  20,  59, 111, 121, 128,
    203, 197, 193, 177, 162, 145,  75,  40,  47, 122, 130, 129,
    102,  77,  47,  83, 121, 129, 111, 108,  84,  56,  63, 114,
    211, 181, 154, 137, 126, 125, 213, 198, 186, 162, 144, 138,
     41,  45,  90, 110, 118, 130,  83,  63, 130, 164, 153, 128,
    195, 167, 142, 123, 113, 119,  19,  42, 105, 113, 120, 132,
     50,  63,  49,  64, 112, 128, 114,  90, 132, 171, 162, 134,
    129, 128, 107,  83,  74, 110,  50, 116, 109, 120, 128, 132,
     94,  59,  73, 111, 117, 126, 197, 170, 166, 153, 138, 132,
     65,  48, 109, 133, 131, 128, 170, 163, 172, 158, 138, 130,
     66, 126, 147, 160, 151, 132,  42, 129, 117,  95,  91, 120,
     97, 165, 164, 142, 133, 125, 163, 142, 114,  88,  97, 122,
    104,  77, 142, 143, 128, 120, 136, 160, 188, 169, 149, 130,
    113,  83,  85, 102, 114, 125, 164, 169, 142, 120, 122, 124,
     98, 152, 132, 105,  92, 117,  42,  71, 125, 155, 151, 137,
     94, 105,  81, 107, 118, 126,  84,  56, 123, 117, 108, 122,
    174, 179, 166, 137, 118, 121, 130, 103, 147, 152, 134, 124,
    148, 127,  94, 117, 144, 134, 129, 106, 102,  95, 106, 118,
    147, 157, 153, 125, 103, 117, 155, 128, 113, 132, 120, 122,
    181, 151, 136, 126, 122, 122, 110, 111, 109, 108, 120, 124,
     97, 130, 103,  89, 107, 124, 179, 158, 158, 142, 131, 128,
    142, 111, 115, 122, 126, 125, 145, 145, 134, 115, 129, 128,
    130, 139, 112,  99, 121, 125,  79, 104, 119, 102, 105, 123,
    116, 121, 136, 125, 126, 127, 124, 100, 122, 119, 111, 119,
    159, 140, 139, 128, 138, 131, 105, 100, 116, 128, 135, 132,
    159, 142, 156, 147, 140, 134, 130, 150, 129, 126, 114, 120,
    138, 124, 146, 131, 109, 119,  93, 115, 125, 131, 125, 129,
    125, 121, 101, 119, 114, 120, 163, 154, 151, 153, 153, 139,
    166, 153, 150, 133, 119, 121, 159, 151, 128, 130, 122, 123,
    147, 154, 144, 133, 128, 127, 129, 131, 134, 140, 148, 138,
    138, 136, 120, 131, 135, 131, 150, 140, 137, 144, 129, 129
};

static const uint8_t wmavoice_dq_lsp10r[0x1400] = {
    128, 128, 129, 129, 130, 130, 131, 130, 129, 129,
    134, 133, 127, 125, 136, 135, 135, 134, 173, 172,
    133, 139, 136, 165, 133, 176, 137, 159, 135, 152,
    147, 161, 147, 152, 149, 156, 146, 146, 140, 136,
    134, 135, 136, 140, 139, 155, 123, 133, 132, 142,
    132, 148, 143, 177, 124, 143, 123, 136, 126, 134,
    126, 125, 125, 124, 129, 128, 123, 123, 133, 133,
    116, 116, 121, 121, 121, 120, 129, 128, 131, 131,
    132, 133, 132, 129, 138, 124, 138, 124, 132, 100,
    135,  94, 149, 111, 152, 115, 150, 128, 141, 133,
    129, 129, 130, 129, 147, 145, 136, 137, 120, 122,
    120, 122, 127, 129, 104, 108, 113, 115, 124, 124,
    140, 139, 147, 145, 132, 130, 184, 177, 201, 196,
    170, 171, 160, 161, 145, 147, 137, 145, 131, 131,
    130, 130, 130, 130, 130, 130, 132, 134, 131, 132,
    131, 133, 141, 144, 142, 149,  84,  93, 103, 104,
    139, 139, 142, 140, 147, 147, 172, 165, 122, 121,
     98, 100, 101, 106, 112, 117, 122, 124, 124, 124,
    134, 133, 133, 133, 146, 142, 147, 145, 156, 156,
    143, 146, 119, 124, 129, 132, 151, 149, 136, 135,
    147, 148, 181, 180, 199, 188, 190, 173, 166, 161,
    147, 142, 153, 149, 154, 146, 150, 146, 138, 134,
    131, 135,  96, 136,  48, 138,  56, 131,  63, 124,
     85, 128, 103, 132, 117, 134, 120, 132, 125, 129,
    131, 130, 129, 128, 129, 128, 163, 168, 117, 120,
    121, 121, 136, 138, 131, 132, 135, 136, 131, 133,
    133, 133, 133, 134, 117, 118, 105, 109, 142, 151,
    144, 159, 131, 138, 121, 126, 123, 123, 121, 124,
    131, 131, 129, 129, 141, 140, 142, 134,  87,  90,
    109, 109, 130, 127, 139, 143, 133, 131, 127, 126,
    134, 135, 134, 136,  97,  98, 130, 132, 134, 137,
    115, 119, 125, 130, 107, 109, 119, 118, 126, 127,
    134, 135, 127, 132, 172, 203, 160, 196, 152, 179,
    152, 172, 148, 168, 153, 172, 145, 156, 137, 140,
    102, 116,  42,  56,  74,  61,  82,  70,  86,  78,
    101,  97, 104, 100, 115, 108, 116, 108, 123, 118,
    149, 143, 166, 129, 168,  96, 142,  95, 135,  98,
    117,  86, 116,  93, 121, 108, 119, 107, 121, 117,
    135, 135, 127, 138,  72, 132,  99, 136, 112, 147,
    120, 152, 136, 155, 138, 146, 140, 142, 134, 139,
    163, 145, 192, 130, 147, 124, 147, 125, 133, 125,
    127, 124, 128, 123, 129, 122, 130, 122, 130, 125,
    130, 137, 135, 180, 124, 133, 130, 129, 132, 133,
    124, 124, 131, 130, 132, 136, 126, 124, 127, 125,
    132, 132, 133, 133, 144, 140, 143, 142, 137, 135,
    143, 138, 152, 149, 221, 219, 158, 161, 143, 141,
    130, 129, 140, 135, 170, 145, 193, 156, 186, 152,
    167, 139, 151, 131, 142, 127, 134, 120, 131, 125,
    135, 133, 141, 125, 199, 109, 137, 126, 134, 123,
    130, 129, 132, 123, 128, 125, 122, 126, 125, 125,
    130, 128,  91,  89, 138, 135, 139, 134, 133, 129,
    132, 130, 125, 128, 136, 135, 129, 127, 126, 126,
    132, 131, 133, 131, 128, 120, 132, 126, 126, 119,
    134, 130, 131, 123, 104,  95, 140, 141, 136, 137,
    133, 133, 133, 134, 117,  98,  74,  49, 112, 111,
    123, 122, 126, 127, 131, 131, 127, 126, 128, 129,
    130, 131, 124, 127, 101, 107, 108, 109, 115, 115,
    100,  99, 130, 128, 134, 136, 125, 127, 128, 130,
    136, 137, 145, 150, 149, 164, 136, 151, 114, 111,
    124, 125, 143, 150, 162, 174, 158, 169, 136, 137,
    131, 131, 131, 131, 132, 133, 111, 110, 122, 121,
    136, 136, 134, 133, 131, 132, 127, 127, 125, 125,
    128, 129, 129, 130, 125, 127, 140, 140, 148, 149,
    133, 136, 146, 153, 110, 118, 127, 129, 128, 129,
    131, 133, 127, 131, 140, 161, 167, 224, 131, 139,
    136, 143, 135, 139, 138, 143, 149, 155, 141, 143,
    134, 132, 120, 111,  83,  83, 121, 126, 102, 107,
    112, 115,  97, 104, 120, 115, 129, 123, 122, 122,
    134, 135, 122, 131, 102, 124, 114, 119,  93, 103,
     78,  79,  67,  72,  66,  73,  78,  82, 103, 102,
    144, 135, 165, 139, 165, 129, 160, 126, 153, 127,
    161, 134, 160, 142, 160, 143, 148, 140, 138, 135,
    138,  95, 147,  54, 143,  78, 140, 112, 142, 113,
    140, 121, 135, 117, 135, 122, 136, 131, 131, 132,
    147, 159, 140, 156, 127,  81, 142, 128, 146, 127,
    144, 125, 146, 128, 149, 130, 144, 135, 133, 128,
    130, 131, 131, 131, 134, 139, 126, 134, 141, 154,
    168, 205, 153, 176, 148, 163, 147, 158, 141, 143,
    131, 135, 126, 146, 108, 157, 107, 156, 119, 146,
    100, 138, 104, 125, 119, 134, 101, 122, 113, 122,
     95, 133,  52, 140,  83, 136, 110, 133, 114, 131,
    123, 131, 133, 131, 138, 135, 132, 132, 127, 127,
    129, 128, 124, 122, 128, 126, 145, 170, 143, 172,
    141, 163, 143, 176, 138, 164, 139, 155, 135, 145,
    135, 136, 136, 127, 132,  76, 128,  76, 127,  63,
    125,  66, 123,  67, 120,  71, 124,  92, 122, 111,
    133, 133, 135, 136, 139, 140, 147, 147, 150, 144,
    156, 147, 150, 145, 154, 146, 120, 123, 123, 124,
    137, 133, 170, 141, 124, 124, 135, 134, 134, 135,
    132, 132, 129, 129, 130, 130, 136, 136, 130, 132,
    147, 159, 135, 158, 115, 146, 120, 148, 117, 136,
    115, 137, 113, 132, 133, 142, 140, 144, 132, 134,
    134, 135, 134, 137, 137, 147, 162, 178, 136, 147,
    134, 144, 123, 132, 111, 113, 113, 113, 124, 124,
    132, 131, 126, 126, 117, 114, 100,  95, 130, 125,
    157, 145, 164, 156, 163, 158, 145, 145, 133, 134,
    134, 134, 127, 126, 113, 102, 136, 130, 124, 122,
    143, 145, 127, 131, 135, 143, 133, 137, 132, 132,
     92,  94, 122, 125, 128, 129, 131, 130, 134, 135,
    132, 128, 129, 127, 132, 132, 131, 129, 127, 127,
    129, 129, 132, 131, 139, 131, 137, 132, 216, 178,
    146, 134, 147, 137, 151, 142, 148, 139, 144, 138,
    128, 127, 129, 129, 123, 131,  71,  91, 126, 128,
    130, 134, 117, 123, 125, 125, 135, 140, 129, 132,
    132, 132, 133, 134, 124, 130, 127, 133, 133, 138,
    142, 149, 135, 141, 145, 149, 154, 164, 135, 138,
    135, 135, 141, 142, 138, 137, 116,  96, 105,  86,
    127, 118, 128, 120, 124, 117, 125, 117, 125, 121,
    131, 131, 132, 134, 144, 145, 112, 112, 121, 123,
    113, 116, 121, 123, 139, 138, 128, 128, 131, 131,
    134, 132, 132, 132, 125, 128, 127, 130, 125, 131,
    120, 128,  90, 119,  68,  98,  99, 112, 115, 124,
    135, 135, 134, 134, 128, 129, 137, 137, 137, 138,
    110, 114, 129, 130, 144, 145, 123, 125, 129, 129,
    132, 133, 129, 130, 168, 187, 140, 149, 137, 144,
    129, 130, 129, 134, 133, 138, 118, 118, 122, 120,
    131, 130, 129, 128, 133, 133, 125, 125, 124, 123,
    181, 179, 129, 129, 131, 127, 139, 136, 130, 128,
    133, 133, 132, 132, 121, 120, 122, 119, 132, 129,
    129, 125, 107,  96, 136, 137, 150, 146, 135, 134,
    131, 131, 130, 130, 126, 123, 126, 123, 128, 125,
    130, 123, 134, 127, 183, 159, 143, 135, 137, 134,
    129, 129, 128, 128, 134, 133, 139, 138, 133, 132,
    129, 127, 154, 151, 150, 144, 146, 146, 141, 142,
    132, 132, 131, 131, 130, 130, 132, 133, 114, 115,
    132, 132, 122, 122, 132, 131, 115, 117, 120, 120,
    129, 129, 130, 130, 130, 129, 130, 131, 129, 131,
    130, 130, 129, 129, 133, 132, 143, 144,  91,  91,
    137, 136, 118, 107,  60,  45,  56,  49,  57,  52,
     60,  56,  71,  75,  77,  80,  92,  97, 106, 106,
    112, 131,  58, 121,  19,  65,  84, 101, 108, 122,
    121, 127, 112, 117, 106, 112, 117, 124, 126, 127,
    130, 129, 138, 133, 166, 155, 192, 179, 192, 177,
    208, 191, 204, 192, 186, 179, 163, 163, 138, 142,
    134, 134, 144, 142, 243, 236, 148, 146, 141, 137,
    145, 141, 151, 144, 147, 143, 135, 139, 134, 133,
    134, 128, 138,  88, 142,  10, 127,  76, 130,  96,
    129, 102, 128, 108, 123, 111, 127, 119, 127, 124,
    136, 136, 139, 139, 142, 140, 246, 241, 158, 167,
    143, 145, 146, 149, 143, 145, 148, 152, 133, 134,
    139, 135, 135, 136,  99, 137,  95, 133,  75, 138,
     67, 135,  73, 128,  83, 132,  96, 126, 115, 127,
    130, 132, 137, 136, 140, 135, 134, 130, 137, 131,
    159, 151, 215, 197, 181, 170, 160, 149, 150, 143,
    145, 148, 186, 207, 141, 147, 135, 137, 122, 122,
    126, 125, 128, 126, 127, 127, 134, 126, 131, 123,
    133, 133, 126, 122, 128, 122,  99,  93,  59,  60,
     82,  82, 106, 107, 119, 123, 124, 128, 128, 129,
    134, 137, 133, 139, 133, 136, 141, 132, 139, 122,
    142,  97, 130,  81, 128,  89, 129, 101, 125, 112,
    137, 140, 129, 148, 101, 159, 118, 180, 122, 178,
    120, 178, 116, 168, 118, 153, 127, 151, 126, 136,
    132, 134, 125, 126, 118, 105, 156, 124, 180, 132,
    163, 124, 148, 121, 131, 112, 127, 115, 125, 122,
    129, 131, 128, 129, 136, 134, 142, 141, 165, 158,
    203, 182, 141, 136, 132, 130, 135, 135, 130, 130,
    133, 133, 132, 132, 127, 126, 106, 105, 112, 110,
    106, 105,  80,  84, 100, 101, 122, 125, 126, 128,
    101, 109,  46,  59, 114, 112, 119, 119, 126, 121,
    129, 124, 128, 125, 125, 122, 123, 120, 125, 122,
    135, 134, 121, 134,  56, 139, 131, 145, 135, 138,
    136, 139, 126, 130, 122, 132, 126, 129, 124, 129,
    153, 169, 146, 179, 138, 139, 151, 143, 148, 138,
    153, 137, 142, 129, 144, 126, 140, 128, 133, 126,
    136, 134, 154, 149, 173, 157, 152, 144, 149, 141,
    137, 136, 127, 121, 123, 121, 121, 126, 120, 123,
    157, 143, 166, 135, 120, 122, 112, 118, 102, 118,
    111, 124, 134, 131, 141, 138, 135, 134, 126, 129,
    140, 123, 152,  76, 131, 116, 138, 136, 126, 134,
    130, 142, 126, 136, 120, 132, 126, 128, 124, 127,
    131, 138,  80, 147, 126, 138, 130, 140, 129, 134,
    133, 135, 131, 132, 126, 127, 127, 125, 125, 123,
    132, 132, 130, 132, 123, 130, 102, 102, 107, 110,
    116, 127, 132, 152, 142, 160, 143, 151, 142, 146,
    132, 132, 132, 132, 125, 126, 132, 140, 158, 199,
    135, 149, 134, 140, 135, 131, 129, 120, 127, 121,
    129, 130, 122, 123, 125, 124, 138, 138, 138, 135,
    140, 141, 101,  94, 105,  98, 121, 122, 127, 128,
    126, 127, 119, 121, 133, 156, 132, 159, 130, 148,
    137, 164, 127, 138, 130, 137, 135, 140, 126, 126,
    128, 129, 129, 129, 126, 124, 130, 128, 143, 138,
    149, 143, 185, 170, 129, 127, 138, 133, 138, 135,
    132, 134, 137, 144, 139, 183, 131, 145, 127, 128,
    128, 127, 128, 122, 129, 125, 145, 139, 135, 131,
    132, 133, 132, 130, 152,  96, 159,  85, 150, 105,
    154, 115, 143, 120, 138, 126, 134, 124, 130, 126,
    128, 127, 121, 123, 122, 123, 116, 125,  84,  87,
    133, 135, 129, 131, 123, 126, 133, 135, 131, 130,
    136, 134, 129, 119,  79,  63, 116, 116, 136, 133,
    133, 130, 140, 143, 127, 127, 124, 125, 127, 128,
    128, 126, 124, 120, 139, 128, 153, 134, 151, 134,
    174, 145, 159, 136, 165, 144, 171, 149, 143, 135,
    134, 134, 133, 133, 121, 119, 177, 162, 166, 154,
    127, 130, 132, 132, 136, 137, 142, 143, 138, 137,
    167, 151, 162, 142, 128, 136, 142, 148, 128, 143,
    145, 153, 140, 149, 132, 141, 128, 139, 127, 133,
    156, 169, 131, 129, 126, 120, 127, 125, 129, 120,
    131, 126, 126, 123, 124, 121, 122, 121, 123, 123,
    138, 140, 149, 156, 145, 152, 105, 102, 131, 126,
    151, 146, 147, 139, 144, 137, 143, 133, 135, 130,
    132, 130, 131, 129, 126, 130, 126, 129, 110, 135,
    115, 139, 108, 146, 105, 147, 121, 134, 124, 133,
    137, 137, 135, 134, 143, 142, 146, 146, 120, 121,
    139, 137, 133, 129, 149, 145, 139, 133, 130, 127,
    134, 134, 134, 134, 125, 124, 117, 119, 120, 113,
     84,  80, 122, 125, 108, 112,  97, 102, 118, 120,
    124, 123, 115, 116, 110, 111,  98,  97, 127, 124,
    129, 127, 120, 117, 114, 109, 106, 104, 116, 116,
    138, 138, 139, 141, 142, 146, 127, 125, 133, 130,
    134, 128, 134, 127, 116,  91, 105,  84, 114, 106,
    128, 128, 126, 126, 131, 137, 126, 129, 133, 139,
    134, 145, 132, 143, 150, 192, 131, 142, 138, 141,
    132, 130, 132, 130, 149, 138, 196, 152, 137, 125,
    134, 125, 139, 128, 133, 125, 141, 134, 134, 135,
    134, 135, 134, 135, 131, 130, 136, 133, 110, 106,
    142, 144, 153, 162, 131, 129, 134, 132, 131, 130,
    126, 125, 132, 130, 168, 153, 126, 124, 130, 126,
    140, 135, 140, 134, 138, 133, 145, 137, 135, 134,
    130, 130, 132, 131, 133, 132, 129, 129, 125, 128,
    128, 130, 133, 139, 143, 152, 193, 215, 152, 160,
    130, 131, 129, 131, 130, 131, 135, 136, 136, 141,
     83,  81, 121, 120, 136, 130, 150, 145, 147, 145,
    134, 133, 135, 133, 146, 142, 135, 131, 127, 128,
    134, 135,  93, 102, 126, 132, 131, 133, 127, 129,
    124, 125, 120, 122, 103, 106, 128, 129, 139, 138,
    127, 128, 134, 134, 143, 138, 139, 134, 135, 133,
    131, 130, 133, 131, 139, 134, 138, 136, 166, 156,
    119, 116, 121, 122, 126, 124, 116, 117, 123, 124,
    131, 131, 129, 129, 130, 128, 141, 138, 135, 132,
    154, 145, 137, 129, 131, 125, 146, 137, 138, 135,
    131, 131, 131, 132, 129, 130, 134, 138, 111, 116,
    113, 118, 123, 125, 122, 124, 143, 147, 138, 140,
    116, 113, 114, 112, 130, 126, 117, 115, 127, 126,
    139, 137, 141, 139, 131, 132, 143, 144, 139, 140,
    130, 130, 129, 128, 136, 134, 119, 117, 152, 143,
    155, 143, 120, 119, 142, 139, 124, 130, 126, 128,
    112, 110, 112, 109, 136, 132, 125, 118, 121, 115,
    103, 101, 109, 100, 125, 120, 121, 117, 122, 121,
    128, 128, 127, 127, 124, 124, 128, 127, 131, 129,
    142, 138, 147, 141, 115, 108, 113, 109, 122, 119,
    136, 133, 150, 139, 142, 131, 119, 111, 151, 137,
    121, 116, 146, 134, 137, 129, 121, 123, 127, 129,
    130, 130, 130, 130, 136, 137, 126, 126, 136, 136,
    133, 133, 139, 139, 142, 143, 119, 120, 134, 134,
    132, 132, 133, 133, 135, 138, 129, 131, 133, 134,
    135, 138, 126, 130, 117, 118, 131, 132, 135, 135,
    129, 129, 128, 128, 126, 129, 127, 129, 123, 125,
    115, 117, 156, 157, 127, 131, 129, 129, 128, 129,
    129, 130, 131, 131, 126, 127, 135, 134, 136, 135,
    140, 136, 117, 113, 132, 128, 104,  97, 109, 106,
    131, 131, 131, 131, 121, 123, 124, 125, 126, 127,
    127, 127, 135, 135, 128, 128, 130, 130, 141, 140,
    129, 129, 129, 129, 129, 127, 127, 125, 149, 146,
    125, 123, 134, 133, 134, 132, 152, 150, 138, 138,
    128, 128, 126, 125, 132, 133, 141, 143, 136, 136,
    126, 127, 126, 127, 129, 131, 128, 129, 135, 134,
    176, 139, 192, 135, 145, 122, 149, 117, 155, 134,
    169, 133, 157, 139, 142, 136, 151, 152, 142, 147,
    166, 174, 103, 107, 141, 134, 140, 136, 144, 135,
    147, 135, 156, 131, 153, 127, 133, 126, 130, 124,
    127, 130, 123, 124, 114, 105, 195, 193, 156, 157,
    165, 158, 126, 122, 149, 141, 174, 173, 152, 147,
    136, 139, 131, 138, 163, 169, 103, 124,  80, 102,
    153, 186, 121, 151, 134, 161, 156, 190, 141, 151,
    121, 123, 124, 127, 119, 127, 133, 134, 157, 156,
     81,  69, 136, 134, 160, 169, 118, 114, 135, 128,
    114, 116,  97,  97, 117, 122, 152, 161, 115, 121,
    106, 122, 135, 137, 111, 113, 125, 135, 141, 145,
    143, 146, 143, 150, 132, 136, 142, 150, 151, 167,
    101, 107, 155, 173, 112, 124, 105, 100, 128, 126,
    127, 130, 133, 134, 142, 121, 131, 116, 176, 145,
    161, 120, 209, 150, 196, 133, 147, 115, 149, 130,
    144, 145, 144, 145, 120, 119, 163, 160, 117, 118,
    123, 117, 154, 119, 193,  98, 149, 101, 137, 116,
    133, 135, 140, 143, 144, 156, 131, 146, 186, 201,
    140, 139, 123, 125, 158, 169, 157, 166, 142, 143,
    130, 131, 132, 132, 128, 128, 141, 142, 147, 149,
    145, 148, 137, 139, 129, 129, 107, 108, 157, 157,
    120, 121, 119, 119, 140, 132, 137, 131, 118, 113,
    143, 136, 134, 135, 164, 158, 133, 125, 127, 124,
    148, 122, 197, 130, 173, 145, 110, 139, 123, 165,
     83, 158,  90, 167,  93, 142, 136, 169, 134, 152,
    130, 126, 154, 138, 227, 150, 156, 114, 147, 114,
    142, 109, 135, 110, 166, 135, 176, 150, 152, 142,
    132, 132, 136, 136, 130, 135, 143, 152, 136, 144,
    152, 160, 177, 185, 112, 112, 165, 166, 160, 161,
    145, 145, 138, 139, 116, 118, 127, 131,  66,  80,
    132, 142, 119, 127, 101, 108, 120, 130, 126, 130,
    135, 135, 142, 139, 153, 137,  55,  30, 142, 139,
    139, 143, 135, 133, 129, 133, 109, 108, 129, 129,
    136, 135, 134, 131, 129, 132, 132, 134, 135, 149,
     79, 206, 123, 137, 135, 143, 130, 140, 131, 134,
    100,  99, 165, 164, 142, 123, 148, 133, 133, 122,
    142, 133, 138, 125, 119, 111, 129, 123, 137, 130,
    131, 132, 123, 129, 174, 185, 196, 181, 127, 111,
    156, 141, 132, 114, 129, 106, 132, 107, 126, 117,
    134, 140, 131, 136, 119, 146,  92, 246, 128, 132,
    125, 129, 132, 140, 128, 141, 126, 145, 137, 142,
    130, 130, 110, 115, 124, 139, 127, 151, 118, 152,
     98, 146,  36, 108, 126, 158, 112, 146, 112, 130,
    138, 136, 145, 138, 153, 145, 116, 125,  90, 103,
    137, 138, 189, 185, 141, 151,  86,  93, 111, 111,
    133, 171, 125, 209, 140, 132, 130, 134, 129, 101,
    142, 120, 142, 132, 135, 126, 141, 140, 140, 134,
    128, 123, 131, 123, 138, 118, 163, 133, 240, 197,
    176, 151, 126, 123,  81,  94, 109, 118, 124, 133,
    135, 133, 137, 134, 154, 135, 140, 155,  69, 190,
    119, 149, 141, 151, 142, 123, 135, 125, 129, 130,
    127, 125, 132, 127, 107,  80, 123, 103, 145, 131,
    133, 107, 140, 103, 135, 106, 170, 145, 159, 143,
    136, 137, 127, 130, 105, 119, 129, 134, 141, 151,
    116, 127, 119, 140,  75, 119, 152, 162, 149, 152,
     72, 138,   9, 143, 118, 160, 126, 134, 141, 147,
    135, 131, 129, 129, 135, 129, 136, 126, 133, 125,
    137, 135, 146, 141, 145, 139, 141, 140, 133, 130,
    213, 208, 139, 130, 139, 136, 117, 117, 126, 125,
    133, 130, 138, 131, 141, 100, 145,  93, 159, 121,
    144, 132, 117, 160, 102, 187,  99, 162, 117, 144,
    132, 132, 134, 134, 140, 141, 127, 126, 128, 131,
    116, 116, 121, 127, 119, 126, 114, 114,  99, 100,
    141, 144, 148, 159, 179, 224,  95, 131, 100, 125,
     87, 110, 112, 132, 134, 147, 111, 125, 122, 122,
    137, 140, 141, 129, 169,  12, 144, 132, 133, 144,
    141, 146, 137, 147, 136, 122, 133, 130, 131, 128,
    141, 142, 128, 139,  15,  69, 160, 159, 142, 130,
    137, 126, 159, 141, 145, 143, 128, 125, 134, 128,
    131, 130, 127, 127, 114, 104, 119,  98,  83,  68,
    139, 120, 173, 142, 199, 154, 191, 153, 158, 145,
    128, 130, 127, 127, 148, 150, 110,  99, 119, 109,
    120, 113, 163, 154, 110,  90, 138, 129, 149, 144,
    131, 134, 124, 142,  76, 217, 130, 129, 140, 138,
    133, 135, 145, 150, 136, 138, 127, 130, 130, 134,
    144, 119, 178,  70, 143, 130, 115, 136, 139, 138,
    129, 109, 136, 116, 147, 122, 126, 112, 126, 123,
    132, 139, 128, 144, 107, 156,  75, 163, 120, 164,
    151, 136, 151,  99, 160, 112, 159, 126, 143, 126,
    140, 138, 137, 135, 152, 108, 251,  85, 138, 116,
    137, 118, 141, 119, 136, 121, 150, 134, 138, 131,
    137, 137, 143, 144, 150, 153, 148, 154, 152, 151,
    117, 104, 124,  96,  93,  67, 146, 138, 149, 148,
    149, 153, 172, 193, 108, 114, 125, 128, 145, 165,
    149, 160, 121, 130, 115, 120, 110, 112, 121, 118,
    145, 146, 141, 142, 127, 127, 103,  95, 138, 143,
    114, 126, 109, 115, 143, 136, 153, 149, 144, 142,
    140, 138, 150, 144, 128, 116, 142, 136, 135, 122,
     93,  88, 164, 163, 141, 142, 171, 182, 154, 160,
    124, 125, 122, 123, 158, 155, 111,  97, 138, 130,
    157, 134, 101,  65, 129, 118, 121, 114, 124, 119,
    131, 133, 125, 129, 136, 147, 135, 152, 131, 133,
    110, 115, 118, 114, 161, 159, 233, 218, 172, 166,
    140, 107, 125,   0, 140, 103, 140, 115, 125, 113,
    132, 135, 128, 133, 138, 146, 131, 145, 127, 133,
    131, 131, 122, 122, 135, 132, 126, 124, 132, 133,
    164, 167, 121, 127, 117, 120, 167, 162, 145, 143,
    135, 134, 136, 134, 156, 146, 195, 177, 127, 139,
    108, 140, 141, 173, 141, 178, 131, 155, 129, 141,
    134, 134, 119, 114, 184, 184, 127, 126, 147, 151,
    130, 140, 146, 159, 134, 145, 131, 136, 137, 142,
    135, 137, 128, 136,  83, 108,  97,  98, 152, 119,
    207, 144, 142, 121, 144, 129, 131, 127, 130, 132,
    124, 125, 108, 107,  94, 116,  81, 114, 139, 173,
    131, 158, 145, 177, 141, 163, 136, 140, 143, 144,
    135, 141, 132, 136, 134, 142, 142, 136, 173,  50,
    143, 106, 142, 127, 134, 139, 127, 133, 125, 125,
    129, 130, 131, 133, 132, 148, 110, 138, 113, 135,
    138, 175, 108, 151,  55, 119,  51, 100,  93, 116,
    121, 121, 146, 151,  99, 120, 127, 137, 107, 122,
    125, 139, 110, 132, 135, 156, 141, 156, 148, 157,
    137, 137, 141, 140, 139, 137, 130, 128, 138, 136,
    132, 134, 115, 110, 177, 179,  81,  86, 100,  98,
     84,  83, 121, 121, 148, 157, 127, 133, 146, 156,
    127, 136, 143, 151, 135, 139, 138, 142, 136, 136,
    201, 164, 151, 129, 123, 136, 147, 148, 127, 142,
    128, 143, 101, 126, 119, 133, 114, 131, 116, 126,
    132, 133, 140, 140, 126, 125, 156, 153, 142, 129,
    140, 130,  77,  69, 134, 132, 146, 148, 135, 136,
    133, 132, 123, 116, 116, 103, 150, 135, 144, 127,
    130, 117, 136, 122, 122, 106,  48,  38,  81,  78,
    145, 146, 135, 136, 123, 122, 126, 133, 133, 138,
    145, 145, 144, 150, 160, 181, 142, 139, 150, 150,
    136, 136, 139, 139, 133, 133, 139, 135, 134, 129,
    140, 137, 153, 145, 132, 131, 151, 144,  68,  66,
    137, 137, 139, 139, 146, 146, 142, 139, 129, 128,
    131, 129, 133, 132, 135, 134, 135, 134, 201, 200,
    137, 136, 146, 143, 155, 153, 157, 158, 131, 138,
    140, 139, 143, 144, 128, 123, 216, 192, 159, 150,
    137, 138, 136, 142, 145, 148, 126, 162, 140, 170,
    186,  95, 131, 140, 143, 148, 133, 128, 130, 133,
    141, 139, 153, 150, 122, 122, 134, 144, 124, 130,
    159, 166, 133, 139, 151, 150, 138, 139, 131, 134,
    121, 121, 131, 129, 148, 180, 121, 135, 118, 131,
    124, 148, 119, 119, 129, 126, 150, 156, 155, 160,
     40, 154, 115, 157, 133, 129, 140, 133, 143, 133,
    143, 132, 144, 130, 141, 131, 134, 130, 137, 133,
    134, 136, 141, 140, 145, 137, 152, 124, 183,  91,
    118, 154, 123, 158, 136, 134, 140, 142, 138, 142,
    138, 135, 131, 131, 138, 129, 121, 128, 146, 219,
    124, 123, 125, 135, 120, 126, 127, 141, 133, 136,
    127, 124, 120, 107, 152, 125, 149, 108, 158, 144,
    196, 185, 174, 164, 151, 149, 138, 131, 140, 137,
    149, 148, 144, 145, 143, 145, 140, 143, 141, 147,
    112, 125, 113, 113, 149, 155, 143, 149, 146, 151,
    138, 138, 141, 138, 144, 129, 134, 125, 143, 140,
    153, 154, 142, 123, 162,  42, 154, 106, 153, 130,
    153, 153, 137, 137, 144, 144, 142, 140, 165, 151,
    161, 140, 144, 134, 156, 124, 167, 143, 166, 155,
    132, 132, 137, 138, 137, 132, 124, 127, 140, 144,
    134, 140, 162, 180, 127, 131, 152, 169, 145, 156,
    133, 134, 131, 133, 130, 132, 147, 149, 125, 117,
    127, 118, 159, 155, 147, 142, 122, 117, 145, 144,
    138, 137, 130, 133, 113, 149, 168, 224, 166, 201,
    129, 151, 147, 154, 136, 135, 140, 136, 152, 141,
    120, 112, 140, 127, 161, 100, 132, 115, 118, 125,
    115, 133, 115, 157, 144, 146, 114, 135, 127, 139,
    138, 141, 135, 135, 137, 136, 147, 142, 143, 144,
    139, 152, 142, 136, 147, 143, 177,  39, 125,  71,
    147, 143,  66,  88, 132, 158, 123, 126, 116, 135,
    119, 124, 128, 135, 133, 140, 137, 126, 137, 130,
    155,  38, 149, 103, 130, 135, 139, 143, 127, 137,
    135, 141, 138, 148, 131, 148, 136, 147, 132, 139,
    136, 140, 115, 129, 115, 151, 136, 160,  87, 131,
    157, 176, 150, 164, 140, 141, 135, 119, 137, 133,
    141, 140, 140, 139, 134, 134, 142, 144, 131, 132,
    131, 134, 131, 132, 116, 114, 129, 133, 205, 207,
    130, 133, 160, 170, 137, 127, 124, 112, 158, 146,
    155, 137, 134, 136, 137, 142, 177, 184, 149, 152,
    135, 134, 133, 132, 135, 129, 144, 136, 139, 134,
    161, 155, 126, 109, 215, 186, 177, 153, 160, 149,
    139, 139, 136, 140, 140, 142, 186,  71, 129, 144,
    131, 165, 142, 152, 140, 151, 141, 143, 137, 139,
    144, 138, 150, 135, 133, 126, 136, 143,  99, 152,
    139, 131, 190, 118, 122, 147, 134, 155, 136, 143,
    138, 135, 137, 132, 147, 144, 150, 144, 138, 134,
    129, 133, 130, 138,  56, 175, 129, 166, 147, 165,
    140, 138, 144, 137, 141, 133, 150, 139, 129, 135,
     40,  83, 126, 130, 110, 120, 100, 110, 126, 128,
    141, 142, 217, 175, 172, 151, 146, 153, 125, 132,
    128, 137, 141, 141, 145, 145, 140, 133, 132, 131,
    129, 144, 128, 177, 133, 195, 147, 120, 138, 131,
    161, 114, 166, 134, 162, 118, 161, 115, 155, 129,
    137, 136, 141, 129, 141, 132,  55, 168, 121, 126,
    136, 139, 120, 133, 149, 147, 132, 141, 131, 136,
    147, 150, 151, 132, 101,  31, 117, 101, 129, 132,
    122, 138, 128, 137, 140, 170, 131, 143, 131, 134,
    149, 192, 122, 158, 136, 146, 133, 166, 143, 141,
    141, 136, 141, 129, 125, 155, 140, 138, 137, 131,
    111, 112, 131, 132, 120, 127, 149, 148, 151, 141,
    156, 148, 133, 129, 127, 124, 144, 137, 142, 139,
    134, 133, 141, 138, 133, 135, 124,  96, 226, 152,
    116, 108, 128, 105, 155, 130, 153, 138, 144, 139,
    142, 141, 137, 135, 142, 143, 156, 162, 136,  89,
    188, 145, 181, 152, 138, 146, 146, 154, 145, 149,
    152, 133, 158, 133,  42, 153, 117, 144, 149, 139,
    125, 139, 134, 128, 150, 128, 143, 125, 135, 132,
    143, 141, 143, 141, 164, 173, 141, 142, 156, 155,
    154, 154, 169, 170,  77,  80, 112, 105, 135, 134,
    126, 143, 120, 172, 111, 144, 120, 154, 107, 153,
     95, 134, 104, 134, 128, 116, 163, 131, 151, 136,
    135, 133, 142, 143, 152, 204, 149, 112, 156, 128,
    150, 126, 127, 129, 139, 175, 143, 141, 138, 135,
    168, 148, 152, 105, 164, 121, 134, 122, 119, 109,
    122, 148, 136, 143, 153, 132, 158, 148, 149, 150,
    133, 131, 142, 141, 150, 149, 156, 173, 138, 155,
    129, 144, 111, 107, 130, 129,  96,  89, 106, 104,
    135, 135, 144, 146, 131, 153, 134, 154, 146, 166,
    117, 138, 163, 187, 190, 216, 149, 156, 149, 152,
    142, 142, 153, 154, 109, 145,  40, 102, 116, 126,
    137, 139, 149, 157, 108, 124, 139, 146, 142, 147,
    130, 126, 120, 111, 172, 146, 169, 136, 150, 135,
    126,  96, 159, 143, 150, 122, 162, 129, 156, 142,
    135, 142, 144, 138, 222, 109, 137, 145, 144, 142,
    141, 143, 138, 136, 124, 150, 133, 144, 137, 145,
    141, 144, 139, 144, 134, 154, 114, 136, 145, 173,
    151, 215, 110, 115, 127, 134, 145, 150, 145, 144,
    144, 142, 139, 131, 147, 132, 141, 119, 143, 106,
    165,  41, 147, 129, 129, 144, 138, 135, 138, 140,
    128, 150,  89, 163, 154, 115, 141, 127, 132, 145,
    135, 157, 143, 145, 140, 141, 127, 135, 127, 129,
    142, 147, 116, 147, 104, 162, 153, 143, 146, 130,
    144, 110, 133, 123, 130, 137, 118, 198, 126, 152,
    154, 146, 139, 127, 147, 112, 207, 151, 156, 136,
    162, 137, 108, 121, 130, 135, 125, 131, 131, 134,
    134, 134, 141, 144, 107, 143, 137, 144, 124, 136,
    115, 147, 130, 157, 119, 167,  71, 144,  97, 128,
    134, 138, 132, 133, 138, 138, 146, 146, 147, 131,
    141, 138, 185,  65, 145, 123, 139, 130, 142, 128,
    139, 136, 157, 147, 124, 119, 164, 148, 170, 154,
    133, 130, 157, 148, 140, 141, 130, 135, 134, 137,
    136, 137, 143, 144, 144, 144, 178, 186,  71,  73,
    120, 118, 127, 124, 152, 151, 155, 146, 141, 138,
    142, 143, 139, 143, 133, 134, 139, 140, 138, 135,
    146, 141,  78, 198, 129, 139, 141, 141, 134, 141,
    137, 136, 120, 120, 124, 118, 143, 148, 148, 152,
    131, 143, 129, 137, 152, 158, 157, 160, 175, 178,
    137, 139, 131, 133, 146, 152, 121, 147, 142, 143,
    129, 136, 149, 145, 197, 114, 103, 141, 124, 140,
    141, 140, 129, 129, 127, 130, 131, 124, 123, 117,
    150, 139, 120, 109, 119, 120, 163, 163, 117, 121,
    139, 139, 136, 136,  94,  74, 150, 145, 126, 127,
    147, 150, 158, 162,  84,  74, 136, 129, 140, 132,
    136, 135, 146, 145, 124, 116, 129, 120, 130, 129,
    130, 109, 122, 111, 160, 141, 135, 113, 131, 121,
    136, 135, 135, 135, 147, 147, 140, 140, 144, 145,
    139, 142, 131, 137, 145, 145, 143, 153,  48,  49,
    145, 143, 151, 147, 158, 146, 135, 124, 124, 116,
    159, 140, 131, 126, 123, 120, 103, 117, 113, 119,
    148, 146, 128, 124, 123, 126, 123, 120, 158, 141,
    148, 137, 146, 143, 125, 143,  89, 107, 116, 123,
    149, 147, 141, 139, 149, 153, 118, 121, 139, 138,
    105, 119, 168, 147, 139, 141, 143, 138, 133, 130,
    126, 126, 143, 142, 146, 144, 124, 123, 143, 145,
    149, 148, 147, 141, 151, 143, 118, 113, 175, 171
};

static const uint8_t wmavoice_dq_lsp16r1[0x500] = {
    147, 145, 193, 168, 188, 156, 141, 145, 141, 139,
    148, 149, 148, 149, 153, 157, 144, 144, 152, 152,
    141, 145, 153, 143, 243, 134, 151, 133, 166, 135,
    150, 149, 135, 132,  32,  39, 110, 111, 109, 114,
    126, 127, 147, 146, 177, 169, 162, 156, 210, 187,
    141, 147,  95, 150, 127, 155, 108, 133, 139, 148,
    138, 138, 140, 140, 147, 146, 134, 130, 136, 134,
    147, 146, 142, 150,  62, 174, 126, 151, 122, 156,
    154, 156, 179, 184, 115, 107, 105,  99, 127, 124,
    146, 131, 140,  44, 132, 125, 156, 146, 153, 153,
    136, 137, 145, 144, 141, 139, 158, 152, 138, 132,
    145, 145, 147, 145, 146, 141, 144, 140, 110,  97,
    140, 141, 143, 142, 130, 123, 127, 117, 126, 120,
    147, 146, 161, 155, 169, 135, 122, 117, 166, 155,
    144, 144, 142, 142, 125, 122, 137, 128, 194, 172,
    127,  85, 148, 143, 153, 141, 147, 147, 140, 143,
    118, 140,   0,  69,  51,  60, 111, 123, 137, 135,
    146, 146, 164, 165, 207, 214, 145, 143, 149, 147,
    178, 168, 197, 170, 134, 154, 148, 159, 115, 140,
    103, 118,  13,  38, 139, 138, 135, 138, 140, 141,
    144, 144, 140, 140, 150, 150, 156, 157, 164, 171,
    143, 143, 140, 142, 118, 120, 172, 172, 160, 163,
    146, 147, 150, 151, 176, 176, 230, 237, 153, 153,
    168, 156, 173, 149, 164, 148, 162, 146, 178, 158,
    147, 145, 143, 145, 111, 126, 111, 130,  89, 118,
    153, 158, 122, 120, 142, 125, 124, 105, 148, 138,
    145, 144, 156, 151, 193, 154, 146, 147, 119, 135,
    142, 141, 145, 145, 152, 147, 142, 141, 146, 146,
    139, 138, 154, 154, 148, 150, 147, 149, 144, 145,
    134, 134, 141, 140, 135, 134, 145, 147, 160, 163,
    144, 145, 149, 146, 115,  67, 127, 119, 141, 135,
    145, 141, 130, 124, 143, 144, 151, 165, 141, 144,
    154, 152, 160, 136, 115,  82,  64,  71,  64,  65,
    143, 143, 151, 149, 240, 251, 165, 173, 173, 179,
    148, 134, 156,  55, 160, 105, 133,  91, 129,  96,
    149, 149, 145, 144, 160, 154, 171, 159, 140, 142,
    154, 163, 178, 244, 147, 140, 153, 150, 137, 121,
    145, 144, 145, 146, 138, 139, 149, 152, 189, 198,
    148, 148, 156, 158, 168, 182, 165, 182, 172, 201,
    143, 142,  99,  92, 152, 152, 143, 143, 127, 127,
    165, 148, 173, 124, 113, 122, 134, 142, 127, 142,
    124, 126, 137, 137, 131, 132, 144, 142, 141, 138,
    172, 176, 138, 111, 152, 136, 167, 154, 156, 137,
    140, 150,  78, 145, 158, 157, 161, 154, 155, 147,
    153, 164, 156, 191, 129, 109, 153, 146, 153, 141,
    138, 137, 141, 138, 115,  94, 144, 141, 155, 147,
    144, 142, 144, 137, 168, 113, 141, 134, 145, 137,
    146, 144, 150, 148, 140, 155, 103, 178, 137, 149,
    145, 147, 148, 153, 175, 201, 138, 146, 110, 108,
    143, 146, 124, 134, 124, 127, 164, 158, 127, 135,
    145, 146, 150, 150, 145, 147,  95,  80, 150, 151,
    149, 149, 162, 162, 144, 152, 170, 169, 145, 154,
    145, 149, 143, 146, 142, 145, 152, 146, 160,  98,
    141, 141, 153, 153, 140, 137, 131, 131, 145, 146,
    133, 132, 127, 124, 158, 150, 173, 164, 178, 167,
    146, 146, 154, 155, 117, 127, 143, 147, 147, 156,
    142, 143, 144, 145, 146, 152, 170, 199, 151, 165,
    146, 147, 139, 140, 147, 149, 132, 134, 147, 149,
    138, 139, 142, 143, 162, 188, 145, 149, 160, 164,
    150, 150, 139, 139, 143, 142, 146, 146, 137, 138,
    142, 142, 141, 140, 152, 153, 164, 171, 110, 112,
    139, 139, 143, 143, 138, 138, 142, 142, 143, 143,
    137, 140, 142, 142, 145, 141, 149, 141, 182, 135,
    146, 146, 150, 150, 144, 145, 150, 151, 135, 137,
    137, 145,  51,  62,  68,  54,  69,  57,  62,  41,
    137, 139, 139, 144, 135, 150, 225, 232, 208, 197,
    136, 135, 141, 143, 145, 150, 160, 169, 213, 247,
    142, 137,  72,  54, 110, 107, 105, 107, 127, 130,
    145, 143, 169, 155, 219, 174, 195, 164, 183, 157,
    155, 157, 239, 232, 169, 164, 170, 172, 156, 159,
    142, 143, 136, 144,  59, 100, 139, 142, 130, 138,
    147, 146, 150, 161, 128, 235, 143, 155, 146, 167,
    154, 149, 128, 151,  42, 149,  55, 136,  59, 127,
    128, 126,  74,  92, 143, 153, 140, 150, 166, 176,
    146, 152, 150, 145, 140, 100, 140, 105, 124,  59,
    195, 191, 146, 148, 144, 136, 136, 133, 129, 122,
    133, 148,  40, 147, 102, 140, 123, 148, 118, 136,
    143, 143, 150, 148, 184, 153, 160, 147, 166, 149,
     58,  68, 127, 135, 141, 145, 143, 147, 150, 151,
    140, 143, 137, 137, 120, 114,  71,  65, 125, 123,
    153, 148, 215, 159, 136, 135, 150, 146, 150, 150,
    148, 138, 166,  94, 150, 145, 145, 139, 147, 145,
    146, 147, 150, 139, 171,  63, 158, 142, 153, 133,
    147, 148, 143, 143,  76,  72, 155, 159, 164, 176,
    149, 149, 173, 195, 145, 165, 138, 144, 150, 167,
    180, 169, 146, 151, 146, 166, 147, 166, 149, 171,
    157, 156, 168, 166, 147, 149, 121, 122, 116, 124,
    145, 145, 147, 148, 172, 189, 168, 180, 144, 146,
    139, 145, 141, 150, 115, 172, 141, 146, 143, 148,
    145, 145, 142, 143, 145, 147, 138, 143,  58,  73,
    141, 142, 146, 145, 163, 149, 218, 161, 147, 132,
    152, 147, 146, 147, 140, 150, 141, 152,  89, 150,
     78, 134, 135, 137, 139, 142, 140, 137, 137, 130,
    144, 144, 152, 151, 145, 140, 181, 170, 191, 168,
    164, 166, 136, 148, 112, 124, 139, 144, 146, 149,
    142, 151, 113, 182, 137, 150, 143, 156, 138, 147,
    154, 156, 108, 102, 118, 119, 133, 139, 113, 111,
    145, 144, 150, 147, 175, 151, 104, 106, 116, 114,
    143, 144, 151, 157, 151, 191, 135, 113, 138, 123,
    146, 146, 155, 157, 106, 145, 132, 127, 140, 125,
    161, 165, 146, 150, 151, 154, 139, 140, 142, 143,
    144, 148, 145, 149, 147, 138, 168, 104, 146, 136,
    138, 140,  91, 108, 111, 110, 145, 140, 158, 154,
    130, 112, 122, 118, 136, 135, 119, 118, 141, 140,
    147, 146, 146, 145, 138, 138, 182, 188, 132, 132,
    144, 144, 156, 155, 168, 172, 123, 128, 144, 151,
    142, 140, 145, 145, 137, 144, 141, 152, 128, 188,
    149, 149, 160, 161, 160, 160, 166, 163, 130, 107,
    143, 143, 142, 142, 149, 149, 132, 132, 170, 174,
    148, 148, 154, 153, 118, 111, 157, 155, 114, 109,
    140, 139, 138, 137, 205, 187, 137, 133, 147, 144,
    144, 145, 147, 149, 105, 125, 108, 117, 155, 162,
    146, 146, 162, 157, 144, 122, 154, 143, 161, 139,
    141, 142, 130, 131, 144, 144, 142, 141, 144, 142,
    132, 132, 141, 141, 150, 151, 139, 141, 151, 153,
    142, 142, 154, 154, 150, 150, 148, 148, 166, 165,
    143, 142, 144, 144, 132, 132, 142, 144, 130, 128,
    142, 142, 143, 143, 153, 153, 147, 142, 129, 125,
    142, 141, 143, 142, 143, 147, 105, 122, 135, 140,
    141, 140, 140, 140, 151, 151, 156, 155, 146, 146,
    133, 134, 140, 142, 142, 145, 141, 146, 112, 133,
    142, 142, 145, 145, 137, 138, 155, 157, 149, 150,
    144, 144, 139, 138, 130, 128, 132, 131, 147, 147,
    139, 140, 142, 143, 115, 121, 141, 143, 137, 141,
    146, 146, 150, 150, 145, 144, 133, 133, 133, 135,
    143, 144, 144, 144, 166, 167, 139, 142, 139, 140,
    150, 149, 138, 138, 142, 140, 148, 147, 160, 155,
    146, 146, 147, 147, 138, 137, 143, 142, 151, 150
};

static const uint8_t wmavoice_dq_lsp16r2[0x500] = {
     98,  98, 119, 121, 109, 112, 128, 135, 115, 121,
    159, 113, 113, 106, 127, 114, 101, 102, 105, 111,
    161, 162, 137, 138, 161, 159, 152, 150, 150, 148,
    128,  79, 131, 102, 142, 120, 133, 119, 130, 117,
    121, 115, 142, 133, 186, 155, 179, 144, 169, 135,
    107, 103, 106, 106, 122, 122, 111, 112, 112, 115,
    127, 123, 118, 115, 128, 125, 123, 119, 115, 109,
    124, 130, 117, 126, 121, 133,  84, 144,  99, 114,
    122, 125, 123, 131, 124, 135, 176, 200, 158, 176,
     68,  74,  86,  87, 117, 115, 119, 116, 135, 128,
    115, 116, 102, 104, 119, 123, 133, 148, 102, 109,
     71, 121, 106, 117, 107, 127, 106, 122, 100, 110,
    117, 115, 129, 128,  87,  84, 116, 116, 151, 157,
    116, 128, 110, 117, 119, 134, 100, 114, 120, 129,
    142, 141, 146, 151,  94,  91, 114, 114, 118, 118,
    114, 112, 112, 109, 115, 112, 123, 123, 147, 148,
    110, 164, 106, 152, 110, 158, 106, 151, 105, 135,
     85,  51,  71,  27,  71,  34,  74,  45,  85,  53,
    145, 134, 140, 130, 136, 134, 118, 122, 118, 126,
    117,  84, 121,  81, 106,  80, 109, 106, 121, 127,
     95,  94, 112, 110,  90,  94, 109, 107, 114, 109,
    117, 118, 118, 123, 107, 107,  86,  93,  29,  31,
    125, 112, 104,  60, 121, 111, 127, 116, 133, 130,
    118, 117, 148, 145, 122, 126, 124, 127,  90,  91,
    113, 110, 119, 118, 152, 147, 115, 112, 132, 131,
    129, 140,  98, 112,  73,  85, 109, 115, 122, 126,
    123, 122, 122, 122, 126, 125, 137, 140, 203, 210,
    164, 176, 114, 114, 125, 122, 119, 112, 125, 120,
    124, 122, 118, 115,  95,  96, 141, 144, 132, 131,
    127, 130, 132, 134, 116, 114, 122, 123, 137, 134,
    111, 111, 112, 116, 106, 118,  77, 101, 104, 115,
    111, 111, 125, 126, 118, 121, 113, 115, 113, 113,
    171, 170, 202, 199, 221, 206, 199, 184, 177, 167,
     73,  90,  61,  93,  43,  74,  51,  71,  51,  72,
    130, 130, 140, 137, 134, 132, 164, 160, 118, 111,
    123, 136, 133, 154, 130, 158, 106, 110, 110, 114,
     97,  97,  91,  94,  70,  69, 125, 123, 141, 140,
    119, 100, 116,  77, 111,  67, 105,  52,  95,  34,
    100, 122,  90, 124,  68, 120,  43, 117,  50, 112,
    130, 129, 192, 188, 123, 118, 124, 117, 121, 115,
    122, 111, 129, 111, 157,  85, 125, 109, 125, 119,
    143, 152, 119, 128, 114, 116, 129, 136, 148, 157,
    119, 117, 115, 115, 150, 148, 163, 154, 109, 102,
    120, 126,  73, 119, 106, 121, 102, 122,  96, 113,
     84,  83, 117, 115, 122, 117, 154, 143, 159, 142,
    118, 122, 114, 117, 115, 122, 114, 130,  99, 156,
    123, 120, 122, 116, 100,  81,  99,  91, 121, 112,
    139, 131, 164, 142, 132, 119, 145, 133, 157, 141,
    112, 109, 118, 116, 142, 134, 108, 110,  96,  99,
    111, 110, 113, 112, 111, 104,  98,  94, 131, 131,
    115, 114, 121, 118, 120, 115, 173, 148, 123, 117,
    121, 124, 122, 124, 140, 146,  78,  82,  96,  93,
     86,  90, 124, 125, 121, 123, 105, 106, 134, 135,
    107, 109, 132, 141, 100,  95, 113, 114, 102, 105,
    113, 130,  98, 145, 116, 115, 124, 117, 115, 105,
    120, 123,  89,  87, 109, 108, 102, 101, 117, 117,
    113, 122, 132, 138,  77, 116,  86,  99, 118, 126,
    123, 120, 117, 111, 124, 119, 129, 118,  63,  58,
    141, 135, 108, 106, 109, 111, 108, 110, 135, 138,
    117, 114, 134, 127, 139, 129, 138, 130, 126, 122,
    121, 118, 124, 121, 133, 130,  98,  85, 130, 123,
    147, 129, 118, 112, 148, 130, 136, 123, 148, 131,
    113, 112, 123, 118, 123, 115, 147,  95, 117, 110,
    118, 119, 112, 113, 112, 113, 119, 119, 120, 120,
    158, 133, 198, 145, 188, 129, 197, 137, 195, 133,
    132, 140, 140, 139, 158, 156, 223, 217, 233, 233,
     48,  56,  34,  37,  82,  84, 102, 102, 108, 110,
    120, 142, 136, 169, 146, 195, 136, 186, 140, 182,
    196, 186, 158, 155, 142, 134, 132, 125, 120, 119,
     97, 105,  72,  75,  82,  85,  81,  84, 107, 109,
     67, 121,  43, 119,  69, 124,  87, 129,  88, 128,
     53,  57,  93,  98,  91,  94,  93,  98, 104, 104,
    124, 123, 133, 133, 182, 181, 119, 121, 114, 116,
    128, 105, 134, 112, 131,  72, 119,  59, 111,  84,
    132, 142, 145, 180, 124, 132, 131, 143, 122, 134,
     88,  85, 103, 103, 136, 140, 131, 143, 114, 132,
    116,  57, 113,  57, 121,  76, 126,  80, 118,  86,
    127, 112, 127,  97, 131, 100, 149,  91, 163,  86,
    122, 119, 128, 121, 128, 116, 142, 127, 173, 139,
    162, 116, 166, 107, 149, 103, 152, 107, 141, 108,
    114, 113, 118, 116,  56,  43,  90,  90, 105, 105,
    132, 134, 110, 107, 106, 105,  82,  84,  84,  84,
    102, 106,  79,  89,  99,  99, 127, 129, 114, 118,
    139, 157, 116, 123, 116, 123,  87,  89, 110, 113,
    119, 126,  97,  97, 155, 163, 142, 153, 143, 146,
    117, 114,  66,  67, 125, 126, 127, 128, 114, 113,
    111, 114, 127, 133, 123, 132, 143, 162, 133, 148,
    105, 108, 114, 114, 110, 109,  57,  48, 109, 106,
    113, 130, 104, 131,  88, 139, 102, 169, 100, 172,
    129, 114, 150,  97, 114, 112, 117, 119, 109, 116,
     92, 107,  96, 116,  90, 125, 101, 122, 125, 140,
    125, 133, 122, 129, 136, 153, 125, 135, 131, 139,
     84,  71, 129, 123, 135, 120, 114, 103, 112, 101,
    108, 121, 115, 156, 106, 123, 116, 131, 127, 139,
    137, 147, 109, 117, 119, 126, 135, 144, 117, 119,
    120, 127,  76, 105, 111, 116, 120, 125, 141, 138,
    107, 104, 162, 155, 135, 130, 127, 123, 127, 121,
    102, 104,  84,  87, 112, 115,  97, 102,  78,  82,
    119, 118, 120, 123,  91, 105, 114, 119, 119, 126,
    130, 126, 134, 126, 158, 134, 133,  99, 116, 100,
    125, 122, 145, 143, 126, 117,  98,  96, 121, 120,
    152, 148, 131, 126, 130, 129, 126, 119,  87,  87,
    131, 131, 139, 137, 101, 102, 104, 105,  86,  83,
     92,  89, 111, 105, 121, 115, 137, 124,  96,  84,
    100,  96, 122, 119, 107, 108,  93,  96,  79,  82,
    128, 123, 108, 106, 123, 120, 150, 150, 143, 140,
    121, 120,  97,  99,  79,  80, 116, 116,  88,  90,
    128, 131, 101,  97, 140, 140, 117, 116, 116, 118,
    137, 135, 100,  91, 115, 112, 134, 121, 107,  99,
    120, 122, 122, 125, 124, 126, 136, 141,  89,  95,
    103, 119, 103, 116, 122, 139, 125, 137, 152, 170,
    121, 122, 124, 124,  98,  97, 137, 140,  96,  92,
    115, 113, 136, 136, 128, 132, 122, 124, 151, 158,
    100, 107, 121, 131, 131, 158, 119, 130, 113, 114,
    114, 109, 148, 130, 103,  95, 127, 116, 137, 120,
    103, 108,  97,  97, 133, 128, 113, 109, 136, 128,
    125, 124, 118, 118, 122, 121, 101,  99, 157, 152,
    138, 134, 124, 115, 113, 101, 123, 112, 124, 110,
    116, 113, 128, 121, 119, 110, 124, 113, 128,  67,
    114, 118, 114, 123, 109, 121, 102, 123,  56, 116,
    117, 111, 112,  99, 124, 114, 112,  79, 114,  88,
    112, 113, 115, 117, 126, 127, 130, 132, 123, 122,
    111, 104, 111, 102, 112, 102, 129, 118, 129, 115,
    123, 124, 130, 133, 114, 117, 125, 127, 112, 117,
    124, 125, 119, 120, 117, 116, 105, 104, 110, 110,
    125, 124, 118, 116, 124, 123, 124, 121, 133, 132,
    111, 111, 124, 124, 120, 119, 116, 116, 134, 130,
    114, 116, 112, 113, 109, 111, 116, 118,  95,  98
};

static const uint8_t wmavoice_dq_lsp16r3[0x600] = {
     84,  82,  95,  94, 125, 131,  98, 102,  94,  93, 104, 104,
    127, 113,  87,  77, 125, 114, 109,  94,  94,  91, 106, 105,
    168, 125, 163, 120, 128, 100, 119,  99, 108,  97, 108, 106,
     86,  85, 128, 125,  79,  73, 103, 102, 123, 123, 116, 117,
     84,  76, 135, 131, 133, 133, 129, 130, 125, 123, 115, 114,
     94,  97,  79,  81, 115, 115,  94,  93, 128, 127, 126, 125,
    124, 111, 105, 114, 104, 117, 109, 110, 124, 125, 118, 117,
    107, 110, 106, 110,  93,  93, 149, 148, 118, 119, 111, 110,
    147, 157, 143, 156, 134, 136, 118, 121, 106, 107, 105, 105,
    114,  83, 114,  46, 106,  53, 110,  83, 107,  94, 105, 103,
     92,  90, 109, 106, 172, 160, 114, 110, 109, 110, 110, 109,
     90,  98,  98, 109, 102,  98,  97,  92, 100, 100, 101, 102,
    123, 117, 124,  98,  82,  80, 117, 115, 112, 110, 109, 108,
    107, 111, 100, 115, 105, 120, 104, 105,  83,  82,  95,  96,
    109, 120,  72,  71,  97, 104,  69,  74,  99, 102, 118, 117,
    137, 133, 142, 135, 105, 110, 121, 121, 125, 122, 114, 112,
    151, 186, 115, 132, 103, 111, 100, 104,  99, 101, 104, 105,
     18,  38,  56,  65,  76,  83,  85,  91, 101, 103, 108, 110,
    144, 135, 126, 121, 115, 113,  79,  80, 118, 117, 117, 117,
    117, 124, 115, 115, 126, 113, 130, 116, 112, 106, 108, 105,
     77,  76,  76,  80, 109, 109, 125, 129, 130, 133, 116, 118,
     96,  86, 109,  99, 102,  69,  84,  69, 107, 103, 114, 113,
     78, 118,  82, 114,  84, 129,  69, 112,  78,  98,  96, 103,
     89, 137,  96, 111, 105,  97,  93,  93, 101, 105, 105, 105,
    141, 123, 102,  93,  91,  79,  87,  81, 102,  99, 109, 108,
     94,  92, 124, 123, 130, 134, 100, 107,  71,  75,  92,  91,
     94, 104, 107,  83, 106, 101, 113, 114, 122, 122, 114, 114,
    118, 124, 103, 106,  95, 116,  90,  93, 107, 104, 109, 107,
    116, 118,  76,  72,  88,  88, 132, 132, 140, 141, 116, 116,
     90,  81, 111,  95, 139,  97, 123,  96, 112, 100, 110, 108,
    112, 116, 133, 140, 112, 120,  80,  85,  55,  55,  85,  84,
    125,  94, 111, 104, 116, 103, 112,  86,  93,  84,  99,  98,
    180, 179, 197, 197, 169, 163, 149, 146, 130, 124, 116, 115,
     76,  47,  36,  11,  43,  28,  66,  53,  82,  80, 102,  99,
    119, 123, 176, 201, 113, 120, 112, 111, 103, 105, 106, 110,
    145, 114, 112,  89, 120,  93, 123, 104, 131, 123, 113, 111,
     97, 109,  82, 106,  75, 104, 103, 115, 120, 124, 111, 114,
    114, 111, 113, 105,  34,  33,  63,  63, 105, 106, 122, 122,
     51,  41,  96,  92, 125, 125, 118, 118, 118, 119, 113, 113,
    111, 180, 108, 178, 107, 171, 110, 160, 105, 136, 102, 117,
     76,  79,  90,  92,  80,  88,  88,  93, 123, 124, 122, 122,
    131, 128, 123, 122, 151, 158, 108, 107, 129, 128, 119, 119,
     97,  99, 114, 120, 121, 125, 151, 157,  82,  89,  95,  96,
    128,  94, 130,  95, 149, 113, 149, 120, 127, 115, 113, 109,
    167, 171,  83,  80,  84,  79, 106, 106, 112, 110, 107, 108,
    130, 139,  81,  88, 107, 106, 112, 112, 119, 118, 114, 112,
    108, 105, 100,  98, 120, 116, 122, 117,  38,  37,  72,  73,
    118, 125, 110, 120, 114, 126, 135, 142, 139, 142, 118, 119,
    119, 119, 156, 145,  78,  75,  94,  94, 112, 110, 113, 113,
    101, 108,  98, 104, 103, 109, 117, 118, 167, 167, 132, 132,
    116, 108, 118, 111, 149, 136,  85,  74,  95,  92, 113, 112,
     74,  69, 104, 107,  96, 100, 117, 121, 103, 105, 103, 103,
    110, 106, 111, 101,  82,  72,  96,  92, 132, 130, 120, 121,
    116, 113, 138, 139, 104, 103, 131, 131,  68,  69,  92,  92,
     97,  97, 146, 151, 122, 132,  97,  95, 117, 116, 115, 116,
    139, 134, 110, 110, 124, 129, 100, 110,  86,  91, 100, 102,
    116, 136,  88,  90, 137, 139, 103, 114, 114, 117, 111, 110,
     82,  83, 104, 102,  97,  99,  97,  97,  58,  56,  84,  84,
     83, 122,  76, 105, 112, 126, 120, 134, 112, 120, 108, 110,
    114, 128,  73,  90,  72,  76,  98, 100,  95,  96, 101, 102,
    101, 108, 118, 126,  94, 102,  81,  83, 138, 140, 131, 130,
     88, 100, 112, 124, 105, 106, 122, 123, 121, 121, 114, 114,
     76, 108,  73,  83,  93,  95, 110, 111,  98,  99, 103, 103,
    105, 112,  98, 108, 114,  95, 117,  98, 120, 116, 116, 115,
    231, 238, 150, 146, 124, 126, 115, 122, 117, 121, 112, 112,
     74,  73,  72,  74,  60,  61,  62,  61,  85,  85, 101, 101,
     67,  69,  50,  51,  83,  83, 110, 110, 118, 113, 112, 111,
    199, 124, 184, 115, 176, 117, 165, 120, 138, 115, 116, 114,
     52, 116,  36, 107,  49,  99,  72, 106,  91, 107, 104, 105,
    140, 138, 141, 135, 154, 147, 166, 159, 139, 136, 116, 115,
    130, 119, 180, 157, 183, 149, 136, 121, 119, 114, 111, 110,
    104, 129, 113, 154, 111, 148, 108, 132, 105, 117, 106, 111,
    114,  35,  99,  65, 113,  94, 110,  98, 111, 107, 107, 106,
    106, 110, 128, 135, 162, 175, 143, 155, 115, 116, 109, 109,
    168, 155, 112, 109, 125, 125, 126, 122, 126, 124, 111, 112,
    128,  96, 160,  77, 151,  77, 121,  80, 114,  94, 107, 103,
     97, 104, 101, 116,  56,  79,  74,  83,  92,  95, 104, 106,
     63,  68,  76,  77, 110, 107,  96,  90,  85,  83,  97,  96,
    116, 110,  46,  42, 103, 100, 122, 120, 102, 101, 104, 104,
    106, 101, 109,  98,  96,  61,  67,  35,  72,  61,  96,  93,
     88,  80,  81,  76, 113, 110, 144, 143,  88,  89,  93,  94,
     95,  96, 100, 101, 136, 132, 166, 160, 148, 147, 115, 116,
     80,  78, 130, 129, 120, 108,  91,  85,  95,  91, 104, 102,
    151, 147, 106, 109, 110, 110,  64,  69,  68,  67,  96,  96,
     90, 166,  97, 128,  99, 120, 104, 121, 109, 118, 105, 109,
    122, 138, 110, 143,  75,  97,  83,  94,  89,  94, 102, 103,
    136, 142, 103, 110,  83,  89,  99, 101, 138, 138, 120, 122,
    168,  88, 105,  90, 109, 107, 110, 111, 106, 105, 103, 102,
     68,  72, 102, 104,  92, 102,  65,  75,  89,  94, 106, 106,
     83,  74,  93,  85,  73,  66, 106, 102, 100,  92,  99,  97,
     93,  99, 101,  96, 116, 112, 125, 120,  88,  88,  96,  96,
     44,  98,  93, 115, 104, 116, 103, 107, 112, 113, 107, 107,
     93,  83, 105,  99,  93,  84, 127, 125, 141, 143, 117, 118,
    106, 103, 126, 121, 137, 123, 123, 114, 147, 142, 127, 123,
    103, 110,  89,  91, 121, 124,  66,  71,  68,  69,  96,  97,
    114, 105,  68,  65,  69,  67,  96,  94, 131, 130, 123, 121,
    111, 104, 130, 121,  95,  95,  72,  74,  88,  88, 105, 104,
    135, 124, 110,  98, 114, 111, 159, 158, 111, 113, 104, 106,
    103, 108,  94, 107,  55,  57, 115, 118, 121, 122, 111, 111,
     97,  99, 106, 111, 119, 126,  59,  62, 111, 112, 124, 125,
     86,  93, 100, 110, 118, 145, 113, 132, 120, 125, 112, 112,
    101, 115,  78, 149,  81, 114, 111, 121, 108, 112, 107, 108,
    104, 104,  94,  96,  84,  83, 135, 132,  71,  69,  88,  86,
    100,  98,  62,  60,  81,  80,  90,  89,  63,  66,  89,  90,
    123, 116, 108,  99,  90,  86,  91,  92,  65,  65,  88,  88,
     84,  79, 115, 109, 123, 111,  99,  99, 134, 136, 121, 123,
    127, 137,  84,  88, 104, 107, 128, 130,  74,  69,  89,  89,
    118, 112, 143, 132, 141, 131, 113, 113,  99, 102, 104, 105,
    117, 115, 100,  99, 131, 126,  90,  88, 145, 144, 128, 127,
    112, 114, 131, 133,  85,  84, 118, 119, 151, 152, 117, 117,
    110, 105, 162, 140, 116, 107, 140, 134, 124, 122, 113, 113,
    107, 110, 124, 133,  98, 103,  99, 107, 109, 113, 112, 112,
    115, 105,  82,  77, 125, 122, 133, 132, 118, 120, 113, 113,
    101,  88,  84,  80,  97,  99,  91,  91,  94,  94, 101, 100,
    121,  86, 139, 108, 106,  93, 103,  99, 112, 108, 108, 107,
    113,  83, 105, 102, 125, 125, 114, 115, 110, 112, 108, 109,
     93, 112, 113, 121, 125, 131, 101, 101, 107, 109, 111, 111,
     98, 102, 117, 126,  80,  84, 107, 109,  83,  84,  96,  97,
    132, 136, 112, 118,  94,  93, 121, 118,  99,  98, 102, 103,
    122, 127, 128, 133, 118, 104, 102,  88, 100,  94, 104, 102,
    115, 116, 102, 105, 140, 142, 135, 130,  90,  88, 100, 101,
     94,  86, 112, 112,  89, 121,  92, 101, 109, 108, 110, 112,
     99,  93, 129, 114, 109,  99, 131, 119, 102,  97, 103, 103,
    103, 116, 124, 101, 115,  95, 105, 101,  94,  91, 100, 100,
    113,  90,  94,  86,  92,  92, 117, 111, 106, 103, 106, 105,
    115,  99, 110,  91, 107, 104,  81,  90, 108, 113, 112, 113,
    113, 114,  93, 101, 101, 102, 101, 126,  93, 103, 104, 105,
    117, 106, 124, 107, 104, 119, 108, 133, 104, 111, 104, 106
};

static const float wmavoice_lsp10_intercoeff_a[32][2][10] = {
    { {  0.5108627081,  0.0480548441, -1.5099149644,  0.6736935377,
         0.7536551058,  0.7651474178,  0.8510628343,  0.6667704582,
         0.7576012611,  0.7091397047 },
      {  0.1351471841, -0.1965375543, -1.6313457787,  0.3218626380,
         0.4132472873,  0.4663473070,  0.5805781186,  0.3962165117,
         0.4818550050,  0.4907165468 } },
    { {  0.8556320667,  0.7774704993, -0.0175759494, -0.1882298589,
         0.1892164350,  0.4850396216,  0.6270319819,  0.6327089071,
         0.6513319910,  0.6075088978 },
      {  0.4374088347,  0.3505934179, -0.0762144327, -0.2830760479,
        -0.0626451969,  0.1500318050,  0.2602472305,  0.2781780064,
         0.3167395592,  0.3596626520 } },
    { {  0.1899779737,  0.0650856197,  0.1699010432,  0.9122628570,
         0.9097705483,  0.7433397174,  0.6304935217,  0.5164704025,
         0.4174703658,  0.5215242505 },
      {  0.0704856217,  0.0169009864,  0.0188394487,  0.5587704182,
         0.5194473267,  0.3539164960,  0.2426626086,  0.1721164286,
         0.1371548772,  0.2594856918 } },
    { {  0.8858859241,  0.9100474715,  0.8921859264,  0.9332397878,
         1.0225475132,  1.0555013716,  1.0983552337,  1.1290244758,
         1.0363244414,  0.9277705550 },
      {  0.4810934663,  0.5782935023,  0.6835935414,  0.7650781870,
         0.9018090069,  0.9996321201,  1.0219936669,  1.0474705994,
         0.9109474719,  0.7774704993 } },
    { {  0.4359549880,  0.2275702953,  0.0993548632,  0.1763395071,
         0.1055856347,  0.1018471718,  0.1170087159,  0.1221317947,
         0.1834010482,  0.2988780141 },
      {  0.1573702693,  0.1041317880,  0.0506856143,  0.0781702399,
         0.0058932900, -0.0026913285, -0.0031067133,  0.0070702136,
         0.0116394460,  0.0566394627 } },
    { {  0.8528628349,  0.8028782010,  0.4680088460,  0.9055474699,
         1.3742399514,  1.1093629301,  0.4122780561,  0.4003703594,
         0.6360319853,  0.6415704489 },
      {  0.4252934456,  0.3823703527,  0.1676856577,  0.5241550207,
         1.1995706558,  0.9088013172,  0.1224087179,  0.0730471611,
         0.3071857095,  0.3772472739 } },
    { {  0.5508781075,  0.2829549313, -0.0022067130,  0.1042702496,
         1.0318244398,  1.3258476257,  1.3550630212,  0.9931936562,
         0.7195243239,  0.6807550788 },
      {  0.2679318488,  0.0960317850, -0.1357529163, -0.1291759908,
         0.6451012194,  0.9968628883,  0.9510321021,  0.6608166099,
         0.3799472749,  0.3735780418 } },
    { {  0.9967244267,  1.0255244374,  0.9800398052,  0.7939474285,
         0.8288397491,  0.8390166759,  0.8660166860,  0.9247936308,
         0.9127474725,  0.8684397638 },
      {  0.7921474278,  0.9416859448,  0.8547320664,  0.5348165631,
         0.6231550574,  0.6703012288,  0.6987550855,  0.8147858977,
         0.7406397164,  0.6496012211 } },
    { {  0.1439394951, -0.3193529844, -0.2024914026, -0.1854606271,
         0.0877240896,  0.1617318094,  0.3087087870,  0.3777318895,
         0.3910242021,  0.4797780812 },
      { -0.0157067180, -0.1778452396, -0.1554836929, -0.1759760082,
        -0.0607759655, -0.0161221027,  0.0393317640,  0.0758856237,
         0.1163856387,  0.1947548985 } },
    { {  1.1021629274,  0.9958244264,  0.4658626914,  0.3089164793,
         0.3740626574,  0.2962472439,  0.3170857131,  0.2420395315,
         0.2649549246,  0.2936857045 },
      {  0.4700857699,  0.1809087396,  0.0311625302,  0.0106009841,
         0.0311625302,  0.0266625285,  0.0221625268,  0.0156548321,
         0.0551163852,  0.1010164022 } },
    { {  0.2925087810,  0.3418011069,  0.7339243293,  0.7322627902,
         0.7288704813,  0.7924935818,  0.7724166512,  0.7819012702,
         0.8325782120,  0.7954705060 },
      {  0.0559471548, -0.0456144214, -0.0462374985, -0.1005144417,
        -0.0511528850, -0.0455451906, -0.0044220984,  0.0451471508,
         0.1232394874,  0.2085318267 } },
    { {  0.2230702937, -0.9052532017,  1.2441552877,  1.0825706124,
         0.9088705480,  0.8797243834,  0.8648397624,  0.8091089725,
         0.7633474171,  0.7468704879 },
      { -0.2030452490, -1.4167303145,  1.3542322516,  0.8369397521,
         0.6148473620,  0.5560704172,  0.5450627208,  0.4978473186,
         0.4200319052,  0.4904396236 } },
    { {  0.6088242829,  0.5965704322,  0.6547242999,  0.8554936051,
        -0.2989298999,  0.2404472232,  0.3573780358,  0.7499166429,
         0.7691628039,  0.6824858487 },
      {  0.2582395375,  0.2721549273,  0.3462318778,  0.4820626974,
        -0.4780299664, -0.0712990463,  0.0200163722,  0.4246703684,
         0.4660011530,  0.4172626734 } },
    { {  1.1749937236,  1.0773090720,  1.0566782951,  1.0249013603,
         0.9947167337,  0.9626628757,  0.9562244117,  0.9072782397,
         0.7654243410,  0.6448935270 },
      {  1.1595552564,  0.9340013266,  0.3959395885,  0.3693549633,
         0.3915780485,  0.3104395568,  0.3499011099,  0.2236933708,
         0.1638087332,  0.1811856627 } },
    { {  0.9572628736,  0.9389859438,  0.6619243026,  0.6849089265,
         0.7276935577,  0.7839781940,  0.7987243533,  0.7748397291,
         0.7101089358,  0.7277627885 },
      {  0.5809935033,  0.5575934947,  0.3544703424,  0.3636780381,
         0.3736472726,  0.4486242235,  0.4684934616,  0.4481396079,
         0.3456780314,  0.4478626847 } },
    { {  0.1259394884,  1.3096476197,  1.0794552267,  1.0009475052,
         0.9061013162,  0.9216782451,  0.8954397738,  0.9160013199,
         0.8575012982,  0.7479089499 },
      { -0.3689222336,  1.5293861628,  0.7323320210,  0.4102703631,
         0.3825780451,  0.2828164697,  0.2644010782,  0.2455010712,
         0.2482010722,  0.2335241437 } },
    { {  0.5380704105,  0.1600702703, -0.0657605827, -0.2390452623,
        -0.3885837793, -0.4150299430, -0.3001760542, -0.1451683044,
         0.1312010288,  0.2798395455 },
      {  0.2074933648,  0.0560163856, -0.0956682861, -0.2893068194,
        -0.3889991641, -0.3918376267, -0.3550068438, -0.2649375796,
        -0.0554451942,  0.1167317927 } },
    { {  0.6092396677,  0.5101011693,  0.4012011290,  0.5416011810,
         0.5715781152,  0.6476627588,  0.6988243163,  0.7306012511,
         0.7531704903,  0.6534781456 },
      {  0.2060395181,  0.1409625709,  0.1024702489,  0.1834010482,
         0.1946856678,  0.2547779977,  0.3134857118,  0.3283011019,
         0.3837549686,  0.3501780331 } },
    { {  0.4516011477,  0.5351627171,  0.8068243563,  0.7049858570,
         0.7165473998,  0.6005858183,  0.4870473146,  0.2500010729,
         0.3132087886,  0.4462703764 },
      {  0.1053087115,  0.1348702610,  0.4457857609,  0.3499703407,
         0.3537780344,  0.2628780007,  0.1665087342,  0.0200856030,
         0.0329625309,  0.1525241137 } },
    { {  0.7058166265,  0.7305320203,  1.1684860289,  1.4524707496,
         1.3212091625,  1.2613245249,  1.1712552607,  1.1154552400,
         1.0487167537,  0.9153782427 },
      {  0.2286087573,  0.2851703167,  1.2016475797,  1.5154707730,
         1.2726091444,  1.1459167898,  0.9801090360,  0.9296397865,
         0.8490551412,  0.6772243083 } },
    { {  0.6686396897,  0.5728935003,  0.4734780788,  0.6970243156,
         0.5852165818, -0.0762836635, -0.2054683268, -0.1380375326,
         0.1282933354,  0.3467164934 },
      {  0.2925087810,  0.2344933748,  0.1677548885,  0.2747856975,
         0.2097087502, -0.2795452774, -0.3761222363, -0.3183837533,
        -0.0834836662,  0.1482318044 } },
    { {  0.6559704542,  0.7737320364,  0.9867551923,  0.9912551939,
         0.9508936405,  0.9114320874,  0.8336859047,  0.7905551195,
         0.7672935724,  0.7532397211 },
      {  0.1843702793,  0.2565087676,  0.7571858764,  0.7545551062,
         0.6793704629,  0.5981627405,  0.5078165531,  0.4282011390,
         0.3948318958,  0.4502165318 } },
    { {  0.4430857599,  0.6102781296,  0.8485012949,  0.8573628366,
         0.9078320861,  0.9979705811,  1.0411013663,  1.0524552166,
         1.0194321275,  0.9023628533 },
      {  0.0070009828,  0.0084548295,  0.1613856554,  0.3484472632,
         0.4385857582,  0.5895088911,  0.6367935240,  0.6736935377,
         0.7026320100,  0.5924165845 } },
    { {  1.0532859862,  1.1059706211,  1.1311013997,  1.1250783205,
         1.0425552130,  0.9993551970,  0.9673013389,  0.9386397898,
         0.8836013079,  0.8336859047 },
      {  0.9791398048,  1.1481321752,  1.1275706291,  1.0082167387,
         0.8809705377,  0.8031551242,  0.7287320197,  0.6496704519,
         0.5211088657,  0.4734088480 } },
    { { -0.0251221061, -0.0443682671,  0.1282241046,  0.3850703537,
         0.4252934456,  0.4547857642,  0.4690473080,  0.4873242378,
         0.6001012027,  0.5882627368 },
      { -0.0562759638, -0.0246374905,  0.0070009828,  0.0971394777,
         0.1232394874,  0.1278779507,  0.1302317977,  0.1462241113,
         0.2073549032,  0.2446010709 } },
    { {  1.1749244928,  1.1155937016,  0.9236167073,  0.6288319826,
         0.6515396833,  0.5391781032,  0.5398011804,  0.4997165501,
         0.4066703618,  0.3998857439 },
      {  0.9403013289,  0.7346166372,  0.1841625869,  0.1319625676,
         0.1395087242,  0.0857856274,  0.0952702463,  0.0860625505,
         0.0829471648,  0.1132010221 } },
    { {  0.9047167003,  0.9840551913,  0.9933321178,  0.9360090196,
         0.9164859354,  0.9213320911,  0.8701705337,  0.8815936148,
         0.8414397538,  0.8188012838 },
      {  0.0961010158, -0.0147374868,  0.0202240646,  0.1002548635,
         0.1407548785,  0.1837472022,  0.1858241260,  0.2064549029,
         0.2228626013,  0.2859318554 } },
    { {  0.4034165144,  0.1918472052,  2.1959402561,  0.4763165414,
         0.6577012241,  0.7036704719,  0.6626858413,  0.7650089562,
         0.7702704966,  0.6543781459 },
      {  0.0940933228, -0.1222529113,  2.3491480052,  0.1385394931,
         0.3052472472,  0.3665857315,  0.3350857198,  0.4722319245,
         0.4313857555,  0.3846549690 } },
    { {  0.8215012848,  0.8613782227,  1.0399936736,  1.4082322717,
         0.4075011313,  0.4091626704,  0.5230473280,  0.6101396680,
         0.7510243356,  0.7237474024 },
      {  0.4810934663,  0.5670088828,  0.9207782447,  1.3007860780,
         0.0453548431,  0.0858548582,  0.1803548932,  0.2790087759,
         0.3974626660,  0.4581780732 } },
    { {  1.5921784937,  1.4987169206,  1.1321398616,  0.8235089779,
         0.6888550818,  0.6621319950,  0.6192089021,  0.6533396840,
         0.7196627855,  0.6549319923 },
      {  1.5911400318,  1.4768399894,  0.9358705580,  0.4674549997,
         0.3522549570,  0.3144549429,  0.2985318601,  0.3559241891,
         0.4061857462,  0.3958703578 } },
    { {  0.7975474298,  0.8712782264,  0.8974474669,  0.3008164763,
         0.5562088788,  0.6655935347,  0.8921166956,  1.0918475389,
         0.9544936419,  0.8554936051 },
      {  0.3769703507,  0.4930703938,  0.6619243026, -0.0382759571,
         0.1766856611,  0.3015780151,  0.5952550471,  0.8903859258,
         0.7395320237,  0.6205935180 } },
    { {  0.2206472158,  2.4467634261,  1.2920629978,  1.0239321291,
         0.9014628530,  0.8552166820,  0.8219859004,  0.9005628526,
         0.7614781857,  0.7763628066 },
      { -0.2722068131,  2.8967635930,  1.3039706945,  0.7695089579,
         0.6132550538,  0.5701242685,  0.5737935007,  0.6533396840,
         0.5422934890,  0.5150857866 } },
};

static const float wmavoice_lsp10_intercoeff_b[32][2][10] = {
    { {  0.4881048799, -0.1998192370, -0.3872502148,  0.0109423101,
         0.0406953394,  0.1788437665,  0.1673750877,  0.3409781158,
         0.4061202109,  0.5221177042 },
      {  0.1492218077, -0.1372330189, -0.2683691680, -0.0621950924,
        -0.0624572337, -0.0068177581, -0.0076041818,  0.0680235624,
         0.1055752933,  0.1199930608 } },
    { {  0.7934338748,  0.0012430847,  0.4239458144,  0.5521328747,
         0.6497149467,  0.6423749924,  0.7170197070,  0.7169541717,
         0.7778364718,  0.8397018015 },
      {  0.2768190503, -0.0491535664, -0.0325731337,  0.0261465013,
         0.0469867289,  0.0649434030,  0.0781815350,  0.1031504869,
         0.1194687784,  0.2451654971 } },
    { {  0.7212139666,  0.1658677757,  0.0101558864,  0.5636015534,
         1.3175852597,  1.1911676526,  1.1266809106,  0.8230558336,
         0.8604109585,  0.8094900250 },
      {  0.3658815324,  0.0816549063, -0.2092563212,  0.1946377754,
         1.0856558084,  0.9491457641,  0.8461242616,  0.5193652213,
         0.5975488424,  0.5293265879 } },
    { {  0.9507186115,  0.9078585207,  0.8773190677,  0.8677509129,
         0.8024122119,  0.8127667904,  0.8246286809,  0.8779088855,
         0.9454102516,  0.9863698184 },
      {  0.6883807778,  0.6900191605,  0.7059442401,  0.6552854478,
         0.5843107104,  0.5553441048,  0.5887671113,  0.6494528055,
         0.7725936472,  0.7792782485 } },
    { {  0.2399882078,  0.1938513517,  0.4441962242,  0.4475385249,
         0.3055235147,  0.1745184362,  0.1174371839,  0.0679580271,
         0.0782470703,  0.1695377529 },
      {  0.0170370936,  0.0253600776,  0.2072205544,  0.1907711923,
         0.1096384823,  0.0327000320, -0.0134368241, -0.0461389422,
        -0.0372916758, -0.0243156850 } },
    { {  0.5457104146,  0.3774812818,  0.5235594809,  0.2994287312,
         0.2394639254,  0.5731041729,  0.9971176088,  1.1646913886,
         0.9028123021,  0.7777709365 },
      {  0.2288472056,  0.1181580722,  0.2074171603,  0.0355180502,
        -0.0024924278,  0.2596487999,  0.7474936247,  0.9103488624,
         0.5927647650,  0.4772915542 } },
    { {  0.6541713476,  0.6412608922,  0.7625012100,  0.7826205492,
         0.4839106202,  0.3311478198,  0.4577620327,  0.8572652638,
         0.9442306161,  0.8282986581 },
      {  0.2852075696,  0.2614837885,  0.4221763611,  0.4314823747,
         0.1434547007,  0.0435788929,  0.1397191882,  0.5525916219,
         0.6752081811,  0.5487250388 } },
    { {  0.6742251515,  1.0610800683,  1.0500701368,  0.9570100009,
         0.9325653315,  0.9243078828,  0.9148707986,  0.8317720294,
         0.7696445584,  0.6784849465 },
      {  0.2283884585,  0.9739181101,  0.5336519182,  0.4974764287,
         0.3998288214,  0.3674543798,  0.2719694376,  0.2608939707,
         0.2087934017,  0.1675716937 } },
    { {  0.3736146986, -1.5457833707,  0.9216864705,  0.7959242165,
         0.7358283401,  0.7233110964,  0.7271121442,  0.6852350831,
         0.6891672015,  0.6589554250 },
      {  0.1246460676, -1.7167649865,  0.7037160397,  0.4803061783,
         0.4694928527,  0.4654951990,  0.5208069980,  0.5305717587,
         0.5288023055,  0.5278192759 } },
    { {  1.0116009116,  0.9882703424,  0.8393741250,  0.8889843524,
         0.8934407532,  0.8906227350,  0.9222107530,  0.8973073363,
         0.9257496595,  0.9306648076 },
      {  0.5097970665, -0.0106843412,  0.1419473886,  0.2804890275,
         0.3719763160,  0.3694859743,  0.4640534222,  0.5034401417,
         0.5592106879,  0.6652468145 } },
    { {  0.9718209803,  0.7615181804,  0.2172474563,  0.4920369983,
         0.4310891628,  0.5038333535,  0.4668059051,  0.5339140594,
         0.4453758597,  0.4050061107 },
      {  0.6543679535,  0.1205173433, -0.0050483048,  0.1580035388,
         0.1308719218,  0.1700620353,  0.1740596890,  0.2179683447,
         0.1967349052,  0.1703897119 } },
    { {  0.7663022578,  0.4025157690,  1.3811545074,  1.1642981768,
         1.0709758997,  0.9812580645,  1.0092416406,  0.9089070857,
         0.7776398659,  0.8189926445 },
      {  0.3471384346,  0.0602248609,  1.3968829811,  1.0841484964,
         0.8940305710,  0.7313719392,  0.7345176339,  0.5304406881,
         0.4076275229,  0.4535677731 } },
    { {  0.1300854981,  0.1323136985,  0.7564064264,  0.7335346043,
         0.7924508452,  0.6039057672,  0.6896914840,  0.3694859743,
         0.2825861573,  0.3179096878 },
      { -0.0208423138, -0.0530856848,  0.3449102342,  0.3819376826,
         0.4466865659,  0.2807511687,  0.3842969537,  0.1144880950,
         0.0617321730,  0.0767397583 } },
    { {  0.7559476793,  0.8462553322,  0.6452585459,  1.1308751702,
         1.0606868565,  0.9498666525,  0.7425129414,  0.6221901178,
         0.6574481130,  0.6976212561 },
      {  0.3420922160,  0.4310236275,  0.2800958157,  0.9317133725,
         0.8210897744,  0.6144569516,  0.3227593005,  0.2464762032,
         0.2769501209,  0.3521846533 } },
    { {  0.7609938979,  0.6943444908,  1.1490939856,  0.4350868165,
         0.6101971567,  0.6246149242,  0.7370079756,  0.6522052884,
         0.6966382265,  0.7565374970 },
      {  0.3939306438,  0.3449102342,  0.9874839187,  0.0910919905,
         0.2804234922,  0.2888775468,  0.4060546756,  0.3284608722,
         0.3483836055,  0.4819445610 } },
    { {  0.7828826904,  1.1833034158,  1.9916158915,  0.8667678833,
         0.9218830764,  0.8856420517,  0.9373494089,  0.7415299118,
         0.7450032830,  0.7074515522 },
      {  0.4685098231,  1.1713104546,  1.9853245020,  0.6206828058,
         0.6664264500,  0.6033814847,  0.6089519858,  0.3784643114,
         0.4212588668,  0.3441893458 } },
    { {  0.4671335816,  0.4177199602,  0.0804097354, -0.1836975515,
        -0.1802241802, -0.0775958896, -0.0250365734,  0.0884050429,
         0.2136430144,  0.3472039700 },
      {  0.1187478900,  0.1122598946, -0.0381436348, -0.2284581661,
        -0.2302276194, -0.1738672554, -0.1350048184, -0.0547896028,
         0.0000634491,  0.0545888245 } },
    { {  0.5545576811,  0.4791920781,  0.8204999566,  0.8462553322,
         0.9212277234,  0.8946203887,  0.9659883380,  0.9137566984,
         0.9225384295,  0.9207034409 },
      {  0.1176993251, -0.0429277122, -0.0330318809,  0.0566859543,
         0.0983008742,  0.1593797803,  0.1732077301,  0.2320584357,
         0.2739354968,  0.3753186166 } },
    { {  0.7157745361,  0.6367389560, -1.2036890686,  0.7107283175,
         0.6885118484,  0.7332724631,  0.7436270416,  0.7113181353,
         0.5935511887,  0.6023984551 },
      {  0.3664058149,  0.3280676603, -1.3082178831,  0.3909815550,
         0.3641776145,  0.3926854730,  0.3898674548,  0.4086760879,
         0.3127979338,  0.3949792087 } },
    { {  1.0267395675,  1.0621941686,  1.0415505469,  0.9971176088,
         0.9764739871,  0.9904330075,  0.9591071308,  0.9338760376,
         0.9026156962,  0.9073997736 },
      {  0.9855833948,  1.0548542142,  0.9787021875,  0.8573307991,
         0.8360973597,  0.8193203211,  0.7386463583,  0.7038471103,
         0.6333966553,  0.6434235573 } },
    { {  0.6235008240,  0.7635497749,  0.8094900250,  0.7227212787,
        -0.0610809922, -0.1357912421, -0.2359291911,  0.0800165236,
         0.3972729445,  0.5078965425 },
      {  0.2983146310,  0.4983939230,  0.4145742655,  0.3284608722,
        -0.3203386664, -0.3495018780, -0.4734291434, -0.1808139980,
         0.1211071610,  0.2001427412 } },
    { {  0.8925887942,  0.8804647624,  0.6153089106,  0.6760601401,
         0.7887153327,  1.0065546930,  1.0829033256,  1.0347348750,
         0.9800128937,  0.9125770628 },
      {  0.5955827832,  0.6195687056,  0.2924164534,  0.3553958833,
         0.5417127609,  0.8713553548,  0.9977729619,  0.8817754686,
         0.7645328045,  0.6604627371 } },
    { {  1.1581378579,  1.0359145105,  0.7731179297,  0.6839243770,
         0.6839899123,  0.6664264500,  0.6910677254,  0.6579068601,
         0.6779606640,  0.6243527830 },
      {  1.1508634388,  0.8400294781,  0.2358594835,  0.2542749047,
         0.2484422624,  0.2620736063,  0.2676441073,  0.2713796198,
         0.3068997562,  0.3223005533 } },
    { {  0.1376220584,  1.2572927773,  0.8593623936,  0.6218624413,
         0.5128116906,  0.5393534899,  0.4436064065,  0.4334484339,
         0.4494390488,  0.4002220333 },
      { -0.1159995794,  1.2433337569,  0.4805027843,  0.2632532418,
         0.1769432425,  0.1868390739,  0.1555131972,  0.1530228555,
         0.1490252018,  0.1559064090 } },
    { {  0.1817273200, -0.0085216761,  0.0739872754,  0.1808098257,
         0.2770811915,  0.3344901204,  0.4292541742,  0.5404020548,
         0.5780193210,  0.5707449019 },
      { -0.0035409927, -0.0188107193, -0.0057691932,  0.0132360458,
         0.0560961366,  0.0534747243,  0.1002013981,  0.1737320125,
         0.1706518531,  0.1637706459 } },
    { {  0.9648087025,  1.0030813217,  0.9501943290,  0.8381944895,
         0.7545059025,  0.7621735334,  0.7121700943,  0.7328792512,
         0.7534573376,  0.7414643764 },
      {  0.1872322857, -0.0081939995,  0.0663851798,  0.0963348150,
         0.0509188473,  0.0565548837,  0.0471833348,  0.0809340179,
         0.1049199402,  0.1751082540 } },
    { {  0.6792713702,  0.9521603882,  0.5296542645,  0.3657504618,
         0.3905883431,  0.3121425807,  0.2726903260,  0.3156159520,
         0.2859284580,  0.3179096878 },
      {  0.2307477295,  0.3771536052,  0.0743804872,  0.0260154307,
         0.0477731526,  0.0391880274,  0.0228042006,  0.0572757721,
         0.0337485969,  0.0492149293 } },
    { {  0.8649328947,  0.9505875409,  1.0443030298,  1.1704584956,
         1.2709241211,  1.3232212961,  1.2477901578,  1.1513877213,
         1.0346038043,  0.9695272446 },
      {  0.4620873630,  0.5685822368,  0.8975039423,  1.0476453304,
         1.2278674245,  1.2290470600,  1.1962138712,  1.0051129162,
         0.8706344664,  0.7477557659 } },
    { {  0.4188340604,  0.6011532843,  0.4726385474,  0.6389671564,
         0.6753392518,  0.7842589319,  0.6147846282,  0.6708828509,
         0.6406055391,  0.5398777723 },
      {  0.1012499630,  0.2312064767,  0.1773364544,  0.2800302804,
         0.3348177969,  0.4343003929,  0.2822584808,  0.3293128312,
         0.3024433553,  0.2401848137 } },
    { {  0.5049474537,  0.7943513691,  0.9536021650,  0.9407572448,
         0.9823721647,  0.9747045338,  1.0145500004,  0.9629737139,
         0.9526191354,  0.9283710718 },
      {  0.0566204190,  0.0973178446,  0.5812305510,  0.5687133074,
         0.6834000945,  0.6616423726,  0.7611905038,  0.6683925092,
         0.6463071108,  0.6118355393 } },
    { {  0.8969141245,  0.9359731674,  0.8756151497,  0.8419300020,
         0.8353109360,  0.6807131469,  0.3358008265,  0.3386188447,
         0.3524467945,  0.4495045841 },
      {  0.5298508704,  0.4606455863,  0.4934132397,  0.4415748119,
         0.4015327394,  0.2052544951, -0.0329663455, -0.0154684186,
         0.0418094397,  0.1631152928 } },
    { {  0.6345762908,  2.5209445655,  1.0373562872,  0.9166402519,
         0.8865595460,  0.8907538056,  0.8522190452,  0.7290782034,
         0.7385808229,  0.6345107555 },
      {  0.2641707361,  2.5696372986,  0.8539884984,  0.6532538533,
         0.6087553799,  0.5851626694,  0.5276226699,  0.4330552220,
         0.3971418738,  0.3599833548 } },
};

static const float wmavoice_lsp16_intercoeff_a[32][2][16] = {
    { {  0.5337238312,  0.4810695648, -0.3766536713, -0.1204767227,
        -0.0898437500, -0.0070896149,  0.1134738922,  0.1337728500,
         0.3739156723,  0.3849058151,  0.4220180511,  0.5404901505,
         0.5224876404,  0.5502910614,  0.5313453674,  0.4405946732 },
      {  0.1775283813,  0.1679325104, -0.2702789307, -0.1359367371,
        -0.1452455521, -0.0888595581, -0.0256662369, -0.0023736954,
         0.1074047089,  0.1431636810,  0.1357412338,  0.2045526505,
         0.2686481476,  0.3404531479,  0.3209333420,  0.1493968964 } },
    { {  0.7402400970,  0.0838251114,  0.6486282349,  0.6145095825,
         0.7331047058,  0.7183008194,  0.7436847687,  0.7627944946,
         0.7653779984,  0.7795667648,  0.8399305344,  0.8393154144,
         0.8219690323,  0.7474164963,  0.6681070328,  0.6490793228 },
      {  0.2850513458, -0.0544128418, -0.0300130844,  0.0204677582,
         0.0328931808,  0.0589332581,  0.0796422958,  0.1187639236,
         0.1320505142,  0.1539077759,  0.2189874649,  0.2865276337,
         0.2973947525,  0.2614307404,  0.2416648865,  0.2428951263 } },
    { {  0.6129922867,  0.7300701141,  0.2073822021,  0.5005893707,
         0.5713691711,  0.5374965668,  0.6293134689,  0.5639057159,
         0.7402811050,  0.6982889175,  0.4668397903,  0.6698703766,
         0.8758535385,  0.8678569794,  0.8678569794,  0.7810840607 },
      {  0.2986249924,  0.3269615173,  0.0096416473,  0.1800708771,
         0.2474060059,  0.2203407288,  0.3007984161,  0.2674179077,
         0.4424810410,  0.4046306610,  0.2063980103,  0.4230022430,
         0.6222190857,  0.6574449539,  0.6776618958,  0.6604385376 } },
    { {  0.7258052826,  0.5073966980, -0.3947381973,  0.5254812241,
         1.0561246872,  0.9706230164,  0.9727144241,  0.9185838699,
         0.8184833527,  0.9093980789,  0.8645353317,  0.7870302200,
         0.6347675323,  0.5123996735,  0.2846002579,  0.3252801895 },
      {  0.4306297302,  0.2182903290, -0.4902458191,  0.1783485413,
         0.7783365250,  0.7152252197,  0.7404451370,  0.6012639999,
         0.5421304703,  0.6619558334,  0.6316919327,  0.5596818924,
         0.3952398300,  0.3567333221,  0.1505041122,  0.1290159225 } },
    { {  0.3077287674,  0.2543363571,  0.2834520340,  0.5282287598,
         0.5350360870,  0.4943971634,  0.4521999359,  0.3086309433,
         0.2372770309,  0.0819387436, -0.1385612488, -0.0848407745,
        -0.0380916595,  0.1192150116,  0.3228197098,  0.3012905121 },
      {  0.0567188263,  0.0196886063,  0.0682420731,  0.2102527618,
         0.2452325821,  0.2060699463,  0.1620273590,  0.0784120560,
         0.0418329239, -0.0508041382, -0.2193880081, -0.1644783020,
        -0.1361827850, -0.0307512283,  0.1486587524,  0.2356367111 } },
    { {  0.4387903214,  0.5723943710,  0.6147556305,  0.9973602295,
         1.1645498276,  1.1898927689,  1.0326681137,  0.6939010620,
         0.6064310074,  0.4686441422,  0.4646663666,  0.4895582199,
         0.5654230118,  0.6004848480,  0.6179132462,  0.6439123154 },
      {  0.1324195862,  0.2426080704,  0.3132238388,  0.7359752655,
         0.9749288559,  0.9535636902,  0.8105278015,  0.4118890762,
         0.3013315201,  0.2006158829,  0.2331352234,  0.2535161972,
         0.3375005722,  0.4103307724,  0.4102897644,  0.4529380798 } },
    { {  0.7335557938,  0.9203472137,  0.4852113724,  0.8646993637,
         0.7304391861,  0.7503690720,  0.6289854050,  0.6900463104,
         0.6421079636,  0.5184278488,  0.4444904327,  0.2660236359,
         0.2143125534,  0.2406396866,  0.4836940765,  0.5597229004 },
      {  0.3689947128,  0.4967346191,  0.1176567078,  0.5127687454,
         0.3235168457,  0.3426265717,  0.2417469025,  0.3310623169,
         0.2629890442,  0.2130823135,  0.1329116821,  0.0468769073,
        -0.0081968307,  0.0146446228,  0.2440433502,  0.3408632278 } },
    { {  0.9425325394,  0.9597969055,  0.6160678864,  0.7050962448,
         0.8063859940,  0.9063224792,  0.9890356064,  1.0038805008,
         1.0338163376,  0.9453620911,  0.9634056091,  0.8068370819,
         0.6859455109,  0.8909034729,  0.9990415573,  1.0122871399 },
      {  0.6895952225,  0.6451835632,  0.3169965744,  0.4268569946,
         0.5666122437,  0.7722673416,  0.8845882416,  0.9061584473,
         0.9550399780,  0.8118810654,  0.8601064682,  0.6129922867,
         0.5069866180,  0.7065315247,  0.7862920761,  0.7766551971 } },
    { {  0.5641517639, -0.0941905975,  0.0412998199,  0.1810550690,
         0.3459482193,  0.4213209152,  0.4401025772,  0.5397109985,
         0.5607891083,  0.6348905563,  0.6861915588,  0.7280607224,
         0.7267074585,  0.6447324753,  0.5948257446,  0.5475025177 },
      {  0.1906919479, -0.0519113541, -0.0608100891, -0.0018815994,
         0.0383062363,  0.0362558365,  0.0529870987,  0.0692672729,
         0.0953073502,  0.1327886581,  0.1390628815,  0.1904459000,
         0.2362518311,  0.2063980103,  0.2311668396,  0.2291574478 } },
    { {  0.9901428223,  0.9589767456,  0.9012374878,  0.8017930984,
         0.8929538727,  0.8512077332,  0.8790111542,  0.8832759857,
         0.8949632645,  0.9159183502,  0.9293279648,  0.9152622223,
         0.9247350693,  0.8753614426,  0.8730239868,  0.8066730499 },
      {  0.4230432510, -0.0464572906,  0.0182533264,  0.1159753799,
         0.2349395752,  0.2740612030,  0.2987070084,  0.3620643616,
         0.3923282623,  0.4694643021,  0.5202322006,  0.5356512070,
         0.5564012527,  0.5362663269,  0.4791831970,  0.5046901703 } },
    { {  0.9785375595,  0.8820457458,  0.3965110779,  0.4790191650,
         0.3907699585,  0.4195575714,  0.2938270569,  0.4091415405,
         0.3659191132,  0.4030723572,  0.4168510437,  0.5030908585,
         0.5023117065,  0.5511522293,  0.5354051590,  0.5563192368 },
      {  0.6592903137,  0.2933759689,  0.0562677383,  0.1286878586,
         0.0758285522,  0.1192560196,  0.0508956909,  0.1175336838,
         0.0684061050,  0.0988750458,  0.0923957825,  0.1819572449,
         0.1965150833,  0.2257537842,  0.3049812317,  0.2993221283 } },
    { {  0.7120265961,  0.7847747803,  0.6065950394,  0.7235908508,
         0.6740531921,  0.6535081863,  0.3734235764,  0.4788551331,
         0.4410867691,  0.6927528381,  1.0758495331,  1.1148891449,
         1.0708875656,  0.8896322250,  0.6401805878,  0.5057153702 },
      {  0.4210338593,  0.4763126373,  0.3229017258,  0.4079113007,
         0.3922462463,  0.3529195786,  0.1258993149,  0.2168960571,
         0.2207508087,  0.4605655670,  0.8759355545,  0.9526205063,
         0.8843832016,  0.7001342773,  0.4503545761,  0.3484086990 } },
    { {  0.5254402161,  0.5349540710,  0.7036199570,  0.6240234375,
         0.6464548111,  0.7537727356,  0.8311548233,  0.7334327698,
         0.3484907150,  0.1846637726,  0.0894021988,  0.3977823257,
         0.7672233582,  0.9224796295,  0.8818407059,  0.7453250885 },
      {  0.2587652206,  0.2524499893,  0.4135704041,  0.3129367828,
         0.3403711319,  0.4473199844,  0.5330266953,  0.4227561951,
         0.1080198288, -0.0044651031, -0.0727024078,  0.1583776474,
         0.5302381516,  0.7313823700,  0.6735610962,  0.5630855560 } },
    { {  0.7936325073,  0.8551034927,  0.9755849838,  0.8953323364,
         0.9345769882,  0.7202281952,  0.8388233185,  0.7941656113,
         0.7550849915,  0.7894906998,  0.8590402603,  0.7813711166,
         0.8483371735,  0.8652324677,  0.8586711884,  0.9584846497 },
      {  0.4781579971,  0.4731960297,  0.8289403915,  0.6175031662,
         0.7262973785,  0.3638277054,  0.5544328690,  0.4761896133,
         0.4388723373,  0.5021476746,  0.5630445480,  0.4562187195,
         0.5190429688,  0.5937595367,  0.6121721268,  0.6973457336 } },
    { {  1.0724458694,  1.0449705124,  0.8594503403,  0.7604160309,
         0.7837905884,  0.8136444092,  0.7623023987,  0.6098756790,
         0.6432561874,  0.6395244598,  0.6853713989,  0.7401580811,
         0.7399530411,  0.7652549744,  0.7675104141,  0.7393789291 },
      {  0.9382266998,  0.8419809341,  0.3087539673,  0.3620233536,
         0.3547649384,  0.4241094589,  0.2857894897,  0.2123851776,
         0.2355957031,  0.2794332504,  0.3219995499,  0.3898267746,
         0.3937635422,  0.4058198929,  0.4228382111,  0.4181222916 } },
    { {  1.0275421143,  1.0940570831,  1.0164289474,  0.9097671509,
         0.9400720596,  0.8976287842,  0.9175586700,  0.8900833130,
         0.9154262543,  0.9492578506,  1.0011329651,  1.0361537933,
         1.0359487534,  0.9320344925,  0.8974237442,  0.8811845779 },
      {  1.0046186447,  1.0860195160,  0.9442958832,  0.7473344803,
         0.7876043320,  0.7410602570,  0.7422084808,  0.6844692230,
         0.7256412506,  0.8455486298,  0.8969316483,  0.9362173080,
         0.9092340469,  0.8227071762,  0.7481546402,  0.7088689804 } },
    { {  0.2205047607, -0.0129537582,  0.0972347260,  0.1154832840,
         0.0951843262,  0.1532516479,  0.1288108826,  0.1749858856,
         0.1591157913,  0.2134923935,  0.2477340698,  0.2634811401,
         0.3032999039,  0.3272485733,  0.3170785904,  0.3172016144 },
      {  0.0032854080, -0.0446119308,  0.0284643173,  0.0155467987,
        -0.0063104630,  0.0226001740,  0.0086984634,  0.0262088776,
         0.0173921585,  0.0360507965,  0.0366659164,  0.0215339661,
         0.0412178040,  0.1047391891,  0.1258172989,  0.0609836578 } },
    { {  0.1495609283,  0.3275766373,  0.8598194122,  0.6847562790,
         0.7550849915,  0.5662431717,  0.6930398941,  0.7526245117,
         0.7300291061,  0.7284708023,  0.6608896255,  0.5224056244,
         0.4273900986,  0.5757160187,  0.4625749588,  0.5123586655 },
      { -0.0352210999, -0.0428895950,  0.3110914230,  0.2699604034,
         0.3307752609,  0.2059469223,  0.2332172394,  0.3204412460,
         0.2846412659,  0.3354911804,  0.2448635101,  0.1514062881,
         0.1062564850,  0.2613077164,  0.2123441696,  0.3000602722 } },
    { {  0.6218910217,  0.6033554077,  0.4551525116,  0.3161764145,
         0.2864866257,  0.6195125580,  0.7577505112,  1.0062179565,
         0.8485012054,  0.6777849197,  0.7455301285,  0.3630485535,
         0.2327661514,  0.5563192368,  0.4448595047,  0.3806819916 },
      {  0.2624969482,  0.2679510117,  0.1839666367,  0.0335903168,
         0.0294075012,  0.2902593613,  0.4959144592,  0.7905979156,
         0.5748548508,  0.3753919601,  0.4855394363,  0.1089630127,
         0.0362968445,  0.3632535934,  0.2681150436,  0.2735691071 } },
    { {  0.7064495087,  0.4431781769,  0.7628355026,  0.7271585464,
         0.7812070847,  0.7806739807,  0.8909854889,  0.8958654404,
         0.9126787186,  0.9038209915,  0.9246120453,  0.9624624252,
         0.9732475281,  0.7420034409,  0.5060844421,  0.5189199448 },
      {  0.3457021713, -0.0149221420,  0.3174476624,  0.3580865860,
         0.4243965149,  0.4275541306,  0.5887155533,  0.6478490829,
         0.6320610046,  0.6627349854,  0.6868886948,  0.7396659851,
         0.7551259995,  0.5275316238,  0.3075237274,  0.3806819916 } },
    { {  0.4376831055,  0.4904603958,  0.6262788773,  0.5901098251,
         0.4176712036,  0.0221490860, -0.1612796783, -0.2236118317,
        -0.1087894440, -0.0022506714,  0.1051902771,  0.3307752609,
         0.4167690277,  0.4997692108,  0.4645843506,  0.5228567123 },
      {  0.1228237152,  0.1671123505,  0.2931299210,  0.2549924850,
         0.1435737610, -0.1124801636, -0.2181987762, -0.2723293304,
        -0.1573429108, -0.0837745667, -0.0325555801,  0.1024427414,
         0.1938495636,  0.2825498581,  0.2247285843,  0.2879629135 } },
    { {  0.6100807190,  0.7900238037,  0.9581155777,  0.8999662399,
         0.9277286530,  0.9720993042,  0.9966220856,  0.9630365372,
         0.9571723938,  0.8992280960,  0.8370189667,  0.7417984009,
         0.7174396515,  0.6122951508,  0.6746683121,  0.7030458450 },
      {  0.0859165192,  0.0914115906,  0.6077432632,  0.5471334457,
         0.5943746567,  0.6805324554,  0.6680250168,  0.6033554077,
         0.6302976608,  0.4874258041,  0.3647298813,  0.2770137787,
         0.2544183731,  0.2608156204,  0.3331537247,  0.4950942993 } },
    { {  0.4051227570,  1.1022176743,  0.8262338638,  0.6573219299,
         0.5948667526,  0.5426225662,  0.4987850189,  0.4370269775,
         0.4421119690,  0.3837165833,  0.3728494644,  0.3706760406,
         0.4169740677,  0.3559951782,  0.2994041443,  0.3896217346 },
      {  0.0716867447,  0.9253911972,  0.2780799866,  0.2460117340,
         0.1675224304,  0.1527595520,  0.1278266907,  0.1226596832,
         0.1165084839,  0.0982189178,  0.0952253342,  0.1113414764,
         0.1498889923,  0.0940361023,  0.0802984238,  0.1560811996 } },
    { {  0.7024717331,  0.7363853455,  0.9629545212,  0.9635286331,
         1.0819597244,  1.1529855728,  1.2984409332,  1.2693252563,
         1.2848672867,  1.2877378464,  1.2133083344,  1.0696573257,
         1.0864706039,  0.9851808548,  0.8312368393,  0.8047866821 },
      {  0.3001422882,  0.2273120880,  0.6279602051,  0.6936140060,
         0.8097076416,  0.9440498352,  1.1028738022,  1.1766471863,
         1.1199741364,  1.1608181000,  1.0665817261,  0.8872537613,
         0.9082908630,  0.7602519989,  0.6542053223,  0.7317514420 } },
    { {  0.0643463135, -0.6808919907,  0.2889881134,  0.6142225266,
         0.6356697083,  0.6825828552,  0.6259508133,  0.4945611954,
         0.5866651535,  0.6357517242,  0.5208883286,  0.4207878113,
         0.5125637054,  0.3758020401,  0.5424175262,  0.6172571182 },
      { -0.0636806488, -0.7585611343,  0.0850553513,  0.2996912003,
         0.3620643616,  0.4444084167,  0.4597454071,  0.3120756149,
         0.4016780853,  0.5026807785,  0.4111919403,  0.3183498383,
         0.3666572571,  0.1829824448,  0.3269205093,  0.4095926285 } },
    { {  0.9277286530,  0.9651279449,  0.9602069855,  0.9327726364,
         0.9208393097,  0.8868436813,  0.9011554718,  0.8569488525,
         0.9015245438,  0.8969726562,  0.9367094040,  0.9445009232,
         0.8617057800,  0.8215589523,  0.8333692551,  0.7939195633 },
      {  0.1719102859,  0.1142530441,  0.1245460510,  0.1646108627,
         0.1408672333,  0.0949792862,  0.0271930695,  0.0265779495,
        -0.0064334869, -0.0109033585,  0.0152187347,  0.0252656937,
         0.0166950226,  0.0736141205,  0.1205682755,  0.1895437241 } },
    { {  0.5964250565,  0.6065130234,  0.7228116989,  0.7348270416,
         0.0718097687,  0.2369899750,  0.2456426620,  0.4961194992,
         0.6410417557,  0.6765956879,  0.6771287918,  0.7285938263,
         0.6706905365,  0.5105543137,  0.5068635941,  0.5430326462 },
      {  0.2782440186,  0.2620048523,  0.4424400330,  0.4124631882,
        -0.1158838272,  0.0186223984,  0.0059919357,  0.1853609085,
         0.3568563461,  0.3791646957,  0.4100847244,  0.4654865265,
         0.4614677429,  0.3209743500,  0.3199081421,  0.3836755753 } },
    { {  0.8051557541,  0.8506336212,  0.9544658661,  0.5584516525,
         0.5874032974,  0.5727224350,  0.6177902222,  0.7659521103,
         0.9526205063,  1.0424280167,  1.0705595016,  1.0042905807,
         0.6005258560,  0.3886785507,  0.4739751816,  0.6542463303 },
      {  0.4775428772,  0.5541868210,  0.7128057480,  0.2146816254,
         0.2502765656,  0.2488822937,  0.3009214401,  0.4667987823,
         0.6929988861,  0.8599834442,  0.8784780502,  0.7463912964,
         0.3217535019,  0.1274986267,  0.2767267227,  0.5119485855 } },
    { {  0.5978193283,  0.5092830658,  1.0738401413,  0.7688636780,
         0.8214769363,  0.7682075500,  0.4970626831,  0.2783260345,
         0.2652854919,  0.3625154495,  0.5700569153,  0.5044031143,
         0.4003248215,  0.5162544250,  0.5727634430,  0.5538587570 },
      {  0.2752094269,  0.1747808456,  0.8557186127,  0.4280872345,
         0.5143680573,  0.4139804840,  0.1810960770,  0.0109539032,
         0.0317039490,  0.0842351913,  0.3129367828,  0.2614717484,
         0.1564092636,  0.2352676392,  0.3249931335,  0.3505821228 } },
    { {  0.7093610764,  0.7587757111,  1.8517618179,  1.0092525482,
         0.8078622818,  0.8792982101,  0.8210668564,  0.8600654602,
         0.6913585663,  0.6436662674,  0.6216859818,  0.6123771667,
         0.5940465927,  0.5910940170,  0.6505966187,  0.5801038742 },
      {  0.3370904922,  0.4681930542,  1.9236078262,  0.8053607941,
         0.5321245193,  0.6342344284,  0.5054693222,  0.5788326263,
         0.4400615692,  0.4086904526,  0.3924102783,  0.4220180511,
         0.3835115433,  0.4230432510,  0.5190839767,  0.3990535736 } },
    { {  0.6277141571,  1.1122236252,  1.0259838104,  0.9486427307,
         0.9184608459,  0.9059944153,  0.9080038071,  0.8282022476,
         0.8440313339,  0.7887935638,  0.7468013763,  0.6746683121,
         0.6319379807,  0.6246795654,  0.7263793945,  0.7349090576 },
      {  0.2427721024,  1.0851583481,  0.6180362701,  0.5837125778,
         0.4324750900,  0.4684801102,  0.3745307922,  0.3027257919,
         0.3646888733,  0.2409267426,  0.2158298492,  0.2052907944,
         0.2100887299,  0.2276401520,  0.3409452438,  0.4045896530 } },
    { {  0.8391513824,  0.8713426590,  1.1366233826,  1.1440868378,
         1.1443738937,  1.0877418518,  1.0516138077,  1.0099496841,
         0.9216184616,  0.8990640640,  0.9001302719,  0.8993101120,
         0.8055248260,  0.8150796890,  0.7272815704,  0.7196130753 },
      {  0.4634771347,  0.5807189941,  1.1287908554,  1.1066875458,
         1.0765056610,  0.9287538528,  0.8956193924,  0.8026132584,
         0.6725769043,  0.5856809616,  0.5527515411,  0.5183868408,
         0.4529380798,  0.5074377060,  0.4632720947,  0.5554990768 } },
};

static const float wmavoice_lsp16_intercoeff_b[32][2][16] = {
    { {  0.5431776047, -0.1212130189, -0.2471650839,  0.0683670044,
         0.1418520808,  0.2518971562,  0.3708084226,  0.4141484499,
         0.5712364912,  0.5852659345,  0.5670641661,  0.6401320100,
         0.6447737217,  0.6726239920,  0.4994724989,  0.5574678183 },
      {  0.2040718794, -0.1271064281, -0.2266163826, -0.0406349897,
        -0.0145058036,  0.0283126831,  0.0851084590,  0.0913147926,
         0.1307432652,  0.1926501393,  0.2310355306,  0.2828245163,
         0.3171940446,  0.4424681067,  0.2960716486,  0.3510941863 } },
    { {  0.8073900938,  0.0403081179,  0.5392660499,  0.6928597689,
         0.6499369740,  0.7328097820,  0.7755761147,  0.7766191959,
         0.8820225596,  0.8423333168,  0.8898978233,  0.8488525748,
         0.8654375672,  0.6728326082,  0.6169234514,  0.6755967736 },
      {  0.3653843999, -0.0846008658, -0.0224332213,  0.1120721102,
         0.1020585299,  0.1741876006,  0.2129902244,  0.2160151601,
         0.3619422317,  0.4185815454,  0.5455245376,  0.5363975763,
         0.5429168344,  0.3505726457,  0.3296067119,  0.3620986938 } },
    { {  0.1843576431,  0.0179861784,  0.3122915626,  0.3600125313,
         0.2466817498,  0.2172668576,  0.1975526214,  0.1177569032,
         0.1196866035,  0.0849519968,  0.0962694287,  0.1591672301,
         0.2300446033,  0.3082756996,  0.4047607183,  0.3925045133 },
      { -0.0275964737, -0.0794897676,  0.1168181300,  0.1591150761,
         0.0915755630,  0.0460972190,  0.0562151074,  0.0084419847,
        -0.0095511675, -0.0408957601, -0.0376100540, -0.0166962743,
         0.0656028390,  0.1226072311,  0.2293144464,  0.2142419219 } },
    { {  0.4781936407, -1.2478972673,  0.4884679914,  0.7755239606,
         0.6785174012,  0.6590117812,  0.6177057624,  0.6427918673,
         0.5402048230,  0.5512614846,  0.6424267888,  0.4229103327,
         0.5106334686,  0.5136062503,  0.4490395188,  0.4753251672 },
      {  0.2852236032, -1.3815159798,  0.1904075146,  0.4874770641,
         0.4593138695,  0.4182686210,  0.4174863100,  0.4604612589,
         0.4089330435,  0.3891666532,  0.4700576067,  0.2383370996,
         0.2801646590,  0.3398289084,  0.2766703367,  0.3374298215 } },
    { {  0.5925153494,  0.3858809471,  1.0754098296,  0.5752002001,
         0.5516265631,  0.4853909016,  0.4719351530,  0.5018194318,
         0.3037382960,  0.5154316425,  0.8809794784,  0.7755761147,
         0.5941321254,  0.3974069953,  0.5925675035,  0.6097261906 },
      {  0.3008176684,  0.0706617832,  0.8484353423,  0.2574254870,
         0.2815728188,  0.1930673718,  0.2523665428,  0.2691601515,
         0.1271967888,  0.2653007507,  0.6473292708,  0.5275835395,
         0.3928174376,  0.2405275702,  0.4008491635,  0.4556109309 } },
    { {  0.7339050174,  0.4290645123,  0.6859754324,  0.6349166036,
         0.8034263849,  0.8509387374,  0.8591269255,  1.1049811840,
         1.3928194642,  1.3423343301,  1.0849018693,  0.8943830729,
         0.8579795361,  0.6920774579,  0.5613272190,  0.4303162098 },
      {  0.4534726143,  0.0901674032,  0.3465046287,  0.3470261693,
         0.5217422843,  0.5874564052,  0.6014336944,  0.9161834717,
         1.2823571563,  1.2193550467,  0.8868207335,  0.6514494419,
         0.6249030232,  0.4453887343,  0.3665317893,  0.2242033482 } },
    { {  0.4293252826,  0.3303368688,  0.6181751490,  0.9884168506,
         0.9915460944,  0.7939864993,  0.3019129038,  0.2443348169,
         0.4543070793,  0.5617444515,  0.4895110726,  0.6600027084,
         0.6290231943,  0.5580936670,  0.5459417701,  0.4647378922 },
      {  0.1409133077, -0.0050137639,  0.2551307082,  0.6764833927,
         0.7112701535,  0.4648943543,  0.0301380754, -0.0235806108,
         0.1018499136,  0.2422486544,  0.2406318784,  0.4000146985,
         0.3713299632,  0.3259559274,  0.3820737004,  0.2888743877 } },
    { {  0.7733334899,  0.8321111202,  1.3098945022,  1.0331128836,
         1.0380675197,  0.9479974508,  0.9740223289,  0.9442945123,
         0.8926619887,  0.8719046712,  0.8640815616,  0.8404036164,
         0.8359183669,  0.7675965428,  0.6895219088,  0.7266034484 },
      {  0.3655408621,  0.4643206596,  1.2171645761,  0.8341451287,
         0.8387868404,  0.6713201404,  0.6814901829,  0.6294404268,
         0.5172048807,  0.5205948949,  0.5408828259,  0.5298783183,
         0.5781729817,  0.5000983477,  0.4727174640,  0.4326109886 } },
    { {  0.8902629018,  0.4598354101,  0.6392975450,  0.4483093619,
         0.6220867038,  0.6323089004,  0.7063676715,  0.3717993498,
         0.6718416810,  0.7876758575,  0.2807383537,  0.3118221760,
         0.6703813672,  0.7662405372,  0.7122610807,  0.7851724625 },
      {  0.6301705837,  0.1221378446,  0.3532846570,  0.1412783861,
         0.3471826315,  0.3435318470,  0.4466925859,  0.1390357614,
         0.4092981219,  0.5406742096,  0.0690450072,  0.0829179883,
         0.4625995755,  0.5700891018,  0.5542864203,  0.6545265317 } },
    { { -0.1100520492,  0.3803526163,  0.8075987101,  0.6903563738,
         0.8012359142,  0.7835035324,  0.8195941448,  0.8381088376,
         0.8033220768,  0.7511680126,  0.6393496990,  0.6096218824,
         0.6934856176,  0.6690253615,  0.6401841640,  0.5600233674 },
      { -0.1776958704, -0.0293175578,  0.1520742774,  0.1746048331,
         0.2222214937,  0.3052507639,  0.2977927327,  0.3797789216,
         0.3395681381,  0.2976884246,  0.2516885400,  0.2403711081,
         0.3567789793,  0.3302847147,  0.3368039727,  0.3310148716 } },
    { {  0.5587195158,  0.4676063657,  0.1392965317, -0.0990996957,
        -0.0816280842, -0.1146416068, -0.0116894841,  0.0521992445,
         0.1626615524,  0.2923687100,  0.4029874802,  0.4528989196,
         0.4694839120,  0.5058352947,  0.5369191170,  0.5105291605 },
      {  0.2193530202,  0.1211469173,  0.0179861784, -0.2022604346,
        -0.1409794092, -0.2121175528, -0.1152674556, -0.0594626069,
        -0.0122110248,  0.0274260640,  0.1414870024,  0.2044369578,
         0.2167974710,  0.2615978122,  0.3348221183,  0.3707562685 } },
    { {  0.5948622823,  0.7065241337,  0.9414781928,  0.9340723157,
         0.8835350275,  0.9730835557,  0.8503650427,  0.8902629018,
         0.8746688366,  0.6910865307,  0.6404449344,  0.6976057887,
         0.5916287303,  0.6022160053,  0.7729684114,  0.6096740365 },
      {  0.1262058616,  0.1300652623,  0.6594290137,  0.6535877585,
         0.5639349222,  0.6982316375,  0.4828875065,  0.5577285886,
         0.4591052532,  0.2964367270,  0.2695252299,  0.3324751854,
         0.2860580683,  0.2902825475,  0.4623388052,  0.3369604349 } },
    { {  0.8821268678,  0.8539636731,  0.2898653150,  0.7478301525,
         0.5109463930,  0.8577187657,  0.4884679914,  0.7846509218,
         0.7684310079,  0.7032384276,  0.6691296697,  0.8593355417,
         0.9383489490,  0.9808023572,  0.6804992557,  0.6403927803 },
      {  0.5590324402,  0.4209806323,  0.0259135962,  0.4318808317,
         0.2104346752,  0.5453680754,  0.1783599257,  0.4467447400,
         0.4352708459,  0.4089330435,  0.3994410038,  0.5984609127,
         0.6872792840,  0.7321317792,  0.4408513308,  0.4542027712 } },
    { {  0.6371070743,  0.6311093569,  0.7152860165,  0.6929640770,
         0.2292101383,  0.3234525323,  0.9644259810,  0.9881039262,
         0.8722697496,  0.4370440841,  0.4051779509,  0.4944135547,
         0.5392660499,  0.5969484448,  0.4268740416,  0.4990552664 },
      {  0.4233797193,  0.3647063971,  0.4345406890,  0.4180078506,
        -0.0006328225,  0.0586141944,  0.7620160580,  0.8152132034,
         0.6707985997,  0.2095480561,  0.2178405523,  0.2776612639,
         0.3142212629,  0.3808741570,  0.2676998377,  0.2804775834 } },
    { {  0.4509170651,  0.9490405321,  0.8557890654,  0.8271043301,
         0.6915559173,  0.7321839333,  0.6257896423,  0.6274064183,
         0.5238284469,  0.5194996595,  0.4116972089,  0.3382642865,
         0.3755022883,  0.4867990613,  0.5686287880,  0.5106856227 },
      {  0.0989292860,  0.6244857907,  0.4700576067,  0.3905226588,
         0.2630059719,  0.3009741306,  0.2150763869,  0.2067838907,
         0.1533781290,  0.1815934777,  0.1023714542,  0.0373874903,
         0.0897501707,  0.1849313378,  0.2852757573,  0.2625887394 } },
    { {  0.9954054952,  0.9554033279,  0.8237664700,  0.9780903459,
         0.7261862159,  0.7884581685,  0.7933084965,  0.7393290401,
         0.8783196211,  1.0409359932,  1.0217954516,  0.9159227014,
         0.8698185086,  0.7057939768,  0.7662926912,  0.7339571714 },
      {  0.7913266420,  0.6739278436,  0.5061482191,  0.7058982849,
         0.3480692506,  0.4338105321,  0.4428853393,  0.3758152127,
         0.5962182879,  0.7925261855,  0.7968549728,  0.6629754901,
         0.6325175166,  0.4598354101,  0.5310778618,  0.5518873334 } },
    { {  0.4638512731,  0.0604917407,  0.1897295117,  0.3403504491,
         0.4708399177,  0.5241413713,  0.6061275601,  0.6446694136,
         0.7313494682,  0.7208143473,  0.6268848777,  0.6081094146,
         0.4913364649,  0.3529717326,  0.4954566360,  0.5767126679 },
      {  0.1353849769, -0.0274400115,  0.0002537966,  0.0272174478,
         0.0555371046,  0.0652899146,  0.1010676026,  0.1073260903,
         0.1568724513,  0.2207611799,  0.1434167027,  0.2262373567,
         0.1177047491,  0.0162650943,  0.2529402375,  0.4087765813 } },
    { {  0.9700064659,  0.9917025566,  0.9159227014,  0.9309430718,
         0.8991290927,  0.9314124584,  0.9059612751,  0.9473194480,
         0.9604622722,  0.9377752542,  0.9197821021,  0.8869771957,
         0.8506779671,  0.8594920039,  0.8320589662,  0.8739908338 },
      {  0.2892394662,  0.0551198721,  0.0892807841,  0.1158793569,
         0.0905846357,  0.0738953352,  0.0395258069,  0.0240360498,
         0.0477139950,  0.0751470327,  0.1171310544,  0.1555164456,
         0.1384620667,  0.1818542480,  0.2104868293,  0.1288135648 } },
    { {  0.4101847410,  0.3326316476,  0.4666675925,  0.5077128410,
         0.5892296433,  0.4272912741,  0.0603352785, -0.8668596745,
        -1.1103670001, -0.0900248885,  0.1626615524,  0.1487885714,
         0.4130010605,  0.5119373202,  0.5820323825,  0.5486016273 },
      {  0.0383262634,  0.1300652623,  0.2295230627,  0.2706204653,
         0.3722165823,  0.1698066592, -0.0934670568, -0.8677462935,
        -1.0724509954, -0.2164463401, -0.0056917667, -0.0301520228,
         0.1299088001,  0.2579991817,  0.3482257128,  0.2469425201 } },
    { {  0.6031547785,  0.5515222549,  0.4292209744,  0.5027582049,
         0.8167778254,  1.0925685167,  0.9878953099,  0.7019345760,
         0.2509583831,  0.2475162148,  0.5660732388,  0.5145971775,
         0.4824181199,  0.5970005989,  0.5996604562,  0.5384315848 },
      {  0.3677313328,  0.2650399804,  0.1585935354,  0.2213348746,
         0.5566333532,  0.8425940871,  0.7604514360,  0.4523773789,
         0.0681062341,  0.0737388730,  0.3169854283,  0.2868403792,
         0.2661873698,  0.3635068536,  0.4300554395,  0.3743027449 } },
    { {  0.5017672777,  0.6634970307,  0.6869142056,  0.7066284418,
         0.5669598579,  0.0621085167,  0.0634645224,  0.2321307659,
         0.8322675824,  0.9855483770,  0.8296598792,  0.6140028238,
         0.5462546945,  0.6730412245,  0.6856103539,  0.5975221395 },
      {  0.2680649161,  0.3324230313,  0.3688787222,  0.3886451125,
         0.2774004936, -0.1695076823, -0.1353467703,  0.0159000158,
         0.5895425677,  0.7586781979,  0.5639870763,  0.3687744141,
         0.3401418328,  0.4477356672,  0.4782979488,  0.4034568667 } },
    { {  0.8838479519,  0.9025712609,  0.7326533198,  0.8124490380,
         0.8956347704,  1.1007045507,  1.2731780410,  1.2029786706,
         1.0839109421,  0.9664078355,  0.7356782556,  0.6942157745,
         0.6917645335,  0.6383587718,  0.6503020525,  0.5989302993 },
      {  0.5576764345,  0.4596789479,  0.3790487647,  0.5514179468,
         0.7333834767,  0.9612445831,  1.1976589561,  1.1094664335,
         0.8868207335,  0.6789346337,  0.4643206596,  0.4029353261,
         0.4384522438,  0.3871847987,  0.4326109886,  0.3691916466 } },
    { {  0.8520861268,  0.8413423896,  0.7238392830,  0.9103943706,
         0.7072542906,  0.6479029655,  0.4557673931,  0.1908247471,
        -0.0569070578, -0.1013423204,  0.2517406940,  0.4854952097,
         0.5820845366,  0.5886037946,  0.6177579165,  0.6226603985 },
      {  0.6160889864,  0.4592095613,  0.4752208591,  0.6685559750,
         0.4326109886,  0.4077335000,  0.2314006090,  0.0173603296,
        -0.2208272815, -0.3014574647,  0.0321199298,  0.2559130192,
         0.3603254557,  0.3466089368,  0.4072119594,  0.4776199460 } },
    { {  0.7083495259,  0.9001721740,  0.6795083284,  1.2743254304,
         1.3672639728,  1.2563322783,  0.8557369113,  0.8287732601,
         0.7942472696,  0.8006622195,  0.7034991980,  0.5479236245,
         0.6391932368,  0.6248508692,  0.5495925546,  0.4719351530 },
      {  0.4000146985,  0.6493632793,  0.4583229423,  1.1484255195,
         1.2521599531,  1.1232351065,  0.6150459051,  0.5347808003,
         0.4726653099,  0.5269576907,  0.4278128147,  0.2745841742,
         0.3868718743,  0.4183729291,  0.3474434018,  0.3150035739 } },
    { {  0.9070043564,  0.7648323774,  0.4281778932,  0.5475063920,
         0.4134704471,  0.4706834555,  0.4549329281,  0.4648422003,
         0.4572798610,  0.4823138118,  0.4666154385,  0.4841913581,
         0.4018922448,  0.4297946692,  0.4646857381,  0.6091003418 },
      {  0.4925360084,  0.2065231204,  0.0948612690,  0.1716842055,
         0.0992422104,  0.1332988143,  0.1255800128,  0.1257364750,
         0.0955392718,  0.1118634939,  0.1372103691,  0.1525958180,
         0.0902717113,  0.1591672301,  0.2335910797,  0.3767018318 } },
    { {  0.3185500503,  0.8677845001,  0.7776622772,  0.8160476685,
         0.8624126315,  0.8057211637,  0.8852561116,  0.8471314907,
         0.9145145416,  0.8945916891,  0.8638729453,  0.8531292081,
         0.7425104380,  0.6215651631,  0.6501455903,  0.6341864467 },
      { -0.0499705672,  0.0687842369,  0.3051464558,  0.3368039727,
         0.4942049384,  0.3823344707,  0.5683158636,  0.5044271350,
         0.6278236508,  0.5777035952,  0.5745221972,  0.5502184033,
         0.4244228005,  0.3163595796,  0.3525545001,  0.3582914472 } },
    { {  0.3200625181,  0.9415303469,  0.6067534089,  0.3568832874,
         0.1600538492,  0.2938811779,  0.2037589550,  0.3017564416,
         0.2572168708,  0.4796018004,  0.6938506961,  0.6847758889,
         0.7232134342,  0.6111343503,  0.5159531832,  0.4856516719 },
      {  0.0680540800,  0.6285016537,  0.2514277697,  0.0790064335,
        -0.0687981844,  0.0521992445, -0.0055874586,  0.0537117124,
         0.0188206434,  0.1883213520,  0.4493002892,  0.4300554395,
         0.4750122428,  0.3658016324,  0.3119786382,  0.2818335891 } },
    { {  0.6864969730,  1.0815640092,  0.9838794470,  0.8845259547,
         0.9438772798,  0.8888025880,  0.8178730607,  0.8581881523,
         0.7128347754,  0.7120524645,  0.7345308661,  0.7945601940,
         0.7854853868,  0.8261655569,  0.6941114664,  0.6646444201 },
      {  0.2847542167,  0.9535257816,  0.6691818237,  0.5026538968,
         0.5945493579,  0.4125838280,  0.3886451125,  0.3740941286,
         0.2453778982,  0.2928902507,  0.3219922185,  0.4065861106,
         0.3838469386,  0.4289602041,  0.3910441995,  0.3821780086 } },
    { {  1.1335094571,  1.0390062928,  0.7019867301,  0.6203134656,
         0.6951545477,  0.4863818288,  0.6171320677,  0.6247465611,
         0.5907421112,  0.6711115241,  0.7322882414,  0.7042293549,
         0.5635698438,  0.6174449921,  0.6727283001,  0.6431047916 },
      {  1.0146503448,  0.7762541175,  0.2200310230,  0.2459515929,
         0.2703596950,  0.1376276016,  0.2522100806,  0.2622758150,
         0.2389107943,  0.2956544161,  0.3799875379,  0.3653843999,
         0.2561216354,  0.2842326760,  0.4034568667,  0.3700782657 } },
    { {  0.6342907548,  0.9627570510,  0.5214815140, -0.0226939917,
         0.5616401434,  0.7231091261,  0.7417802811,  0.9092991352,
         0.9739701748,  0.7804785967,  0.6771092415,  0.6352295280,
         0.4660417438,  0.5869870186,  0.6692339778,  0.5986173749 },
      {  0.3988673091,  0.6997441053,  0.2316613793, -0.2566571236,
         0.2685343027,  0.4484136701,  0.4490395188,  0.6886874437,
         0.7703085542,  0.5847443938,  0.4539941549,  0.4098196626,
         0.2579991817,  0.3376384377,  0.4754816294,  0.5095382333 } },
    { {  0.4443456531,  2.0296727419,  0.6569256186,  0.6439914107,
         0.6436263323,  0.5507399440,  0.6095175743,  0.6066491008,
         0.5347808003,  0.2529402375,  0.4443978071,  0.7000570297,
         0.8259569407,  0.5927761197,  0.5078171492,  0.4418422580 },
      {  0.2430831194,  1.9133691788,  0.3723730445,  0.3764410615,
         0.3874977231,  0.3212099075,  0.3832210898,  0.4474227428,
         0.3644977808,  0.0814055204,  0.2752621770,  0.4647378922,
         0.6619845629,  0.4304205179,  0.3143777251,  0.2705683112 } },
    { {  0.9740744829,  1.0730628967,  0.9743352532,  0.9098728299,
         0.9453375936,  0.9661470652,  0.9270836711,  0.9643738270,
         0.9989519715,  0.9627048969,  0.9348546267,  0.9865393043,
         0.9399657249,  0.9752218723,  0.8440544009,  0.8819182515 },
      {  0.9258319736,  1.0357205868,  0.8463491797,  0.8108844161,
         0.8391519189,  0.8566235304,  0.8305986524,  0.8880724311,
         0.9181653261,  0.8670021892,  0.8305986524,  0.8995984793,
         0.8300249577,  0.8711223602,  0.7195626497,  0.8138571978 } },
};

static const double wmavoice_mean_lsf10[2][10] = {
    { 0.2235394066, 0.4097484909, 0.7025292732, 1.1077160169,
      1.3939179044, 1.6741291716, 1.9552949226, 2.2199793918,
      2.5103400247, 2.7829212906 },
    { 0.1493683393, 0.3714357373, 0.7702730245, 1.0609411394,
      1.3270362536, 1.5806033119, 1.8398507524, 2.1116740248,
      2.3823505771, 2.6865718527 }
};

static const double wmavoice_mean_lsf16[2][16] = {
    { 0.0999206754, 0.2345933590, 0.4621011210, 0.6772546160,
      0.8346396060, 1.0067495130, 1.1571691668, 1.3292508688,
      1.4941465650, 1.6600755584, 1.8461284908, 2.0529487333,
      2.2690810112, 2.4949894820, 2.7172752965, 2.9164840903 },
    { 0.0918298402, 0.2475621892, 0.4782937721, 0.6284774045,
      0.7861951264, 0.9303736000, 1.0940441024, 1.2521029300,
      1.4434732098, 1.6551410742, 1.8917962963, 2.0967280403,
      2.2981430375, 2.4826173497, 2.6827972461, 2.8811350800 }
};

static const float wmavoice_std_codebook[1000] = {
    -0.185013, -0.150405, -0.707267, -0.284100,  0.882898,
    -0.788627,  0.061005,  0.374431,  0.053843, -0.909826,
     0.543602,  0.219326,  0.285698,  0.154709, -0.455005,
     0.426276, -0.868852, -0.952324, -0.550001,  0.813814,
    -0.352815,  0.242122,  0.820495, -0.189574, -0.449538,
     0.499132, -0.247783,  0.598159,  0.732040, -0.564406,
    -0.631788, -0.452973,  0.285189, -0.339055,  0.262927,
     0.168087, -0.127682, -0.676067, -0.457481,  0.926161,
    -0.585893, -0.913880,  0.145487,  0.699804,  0.240829,
     0.690482,  0.126081,  0.371977,  0.738158,  0.576080,
     0.185791, -0.614657, -0.181799,  0.006285,  0.195768,
     0.368663, -0.494583,  0.947985, -0.033178, -0.762543,
    -0.616421,  0.335034, -0.215516,  0.668769,  0.995979,
    -0.952588, -0.163144, -0.131704, -0.628655,  0.379374,
    -0.205543, -0.214549,  0.465494,  0.939944, -0.514744,
    -0.293676,  0.630426,  0.611336, -0.921699,  0.368584,
     0.187416,  0.264092,  0.753927, -0.994382, -0.729623,
    -0.050304,  0.374280, -0.224205, -0.102319, -0.658897,
     0.013252,  0.281260,  0.676137,  0.797736, -0.049971,
     0.672115,  0.845148,  0.786885, -0.459588, -0.783507,
     0.166259,  0.334869,  0.001944, -0.368247,  0.274813,
     0.487200,  0.338077, -0.094761,  0.098536,  0.416378,
    -0.726176, -0.714048, -0.319530, -0.972249, -0.708430,
    -0.049153, -0.022553,  0.665850,  0.726642,  0.875127,
    -0.993047, -0.260106,  0.156387,  0.683090, -0.462370,
    -0.893584,  0.355205, -0.617222,  0.893301,  0.895617,
    -0.400729,  0.059559,  0.230486,  0.601215,  0.691313,
    -0.494701,  0.088415,  0.029390,  0.410539, -0.813049,
    -0.554232,  0.684362, -0.527097,  0.126238,  0.712113,
    -0.235528, -0.922915, -0.310440, -0.569678,  0.803727,
    -0.435313, -0.562725, -0.456380,  0.721075, -0.879635,
     0.081250,  0.827491,  0.475570,  0.464029,  0.720792,
     0.371187, -0.936700, -0.219649, -0.398327,  0.664515,
    -0.528336,  0.106972, -0.247070,  0.501053, -0.482490,
    -0.060119,  0.946821, -0.798127,  0.412784,  0.073058,
     0.913986, -0.822744,  0.150143, -0.396453, -0.392421,
    -0.046130,  0.168234,  0.044854,  0.497490, -0.110691,
     0.165219, -0.421259, -0.283200, -0.359212, -0.957231,
    -0.562409, -0.988025, -0.893931,  0.217942, -0.386352,
     0.770585,  0.689606,  0.720620, -0.476485,  0.190659,
    -0.761870,  0.463395,  0.137480, -0.559997, -0.123821,
    -0.789461, -0.646011,  0.053435,  0.360682, -0.042464,
     0.661014, -0.685448, -0.874230, -0.294133,  0.812042,
     0.015078,  0.871086, -0.609218,  0.731878, -0.488126,
    -0.566448, -0.830530, -0.476150, -0.460379,  0.387412,
     0.137497, -0.689794,  0.077018, -0.141883, -0.166280,
    -0.732322,  0.096247, -0.702884,  0.405158,  0.536250,
     0.173295,  0.615696,  0.890239, -0.773270, -0.023622,
    -0.152226,  0.887744,  0.290930, -0.026456, -0.406389,
     0.102972,  0.988622, -0.535303,  0.493754,  0.720500,
    -0.023428,  0.927306,  0.889970,  0.500421, -0.533073,
     0.277382, -0.362081, -0.222867, -0.645599,  0.496035,
     0.610853, -0.377922, -0.407718,  0.907969, -0.972764,
    -0.871468,  0.081264,  0.642933, -0.981230,  0.307994,
    -0.380689, -0.133456,  0.195738,  0.910241,  0.840088,
     0.789349,  0.013213,  0.828710, -0.745954, -0.493033,
     0.549210,  0.230618, -0.565727,  0.439180, -0.268961,
    -0.098800, -0.283438,  0.368958,  0.678333,  0.070963,
    -0.135007,  0.289186,  0.693041,  0.457275,  0.197155,
     0.720277,  0.585807, -0.721581,  0.363210,  0.604577,
     0.586413,  0.982521, -0.528878, -0.217849,  0.892762,
    -0.688791, -0.428500, -0.094025, -0.860081, -0.174454,
     0.412942,  0.689129, -0.943836,  0.847215,  0.128309,
    -0.212797, -0.251585,  0.844871, -0.843839, -0.573252,
    -0.084167,  0.021154,  0.715935, -0.391126, -0.521570,
    -0.086910, -0.670848, -0.935763,  0.191509,  0.692361,
     0.668814, -0.222078,  0.674882, -0.860064,  0.560073,
     0.567644, -0.548855, -0.868427, -0.526382, -0.408936,
    -0.042881,  0.886560, -0.719807,  0.013283,  0.733775,
     0.408502,  0.800487, -0.517810,  0.253372,  0.956648,
    -0.091062, -0.830794, -0.022198, -0.375127, -0.221920,
     0.456232,  0.537963,  0.107232,  0.520469, -0.270529,
    -0.200406,  0.189284,  0.507393, -0.525524,  0.329220,
     0.067466, -0.957881,  0.780365,  0.199039, -0.484262,
    -0.628570, -0.843843, -0.597703, -0.348377,  0.169441,
    -0.863928, -0.939875, -0.030073, -0.381738,  0.313497,
    -0.073425,  0.527200,  0.482703,  0.904377, -0.847927,
    -0.739217,  0.360609,  0.690035,  0.368015, -0.118921,
    -0.580493, -0.832391, -0.929638,  0.926900, -0.357915,
     0.399582, -0.005634, -0.315796,  0.179947, -0.806596,
     0.393360,  0.732931, -0.415833, -0.724526,  0.957347,
    -0.892887,  0.475366,  0.173583, -0.418554, -0.302536,
     0.627315,  0.782000,  0.497542,  0.139082,  0.570111,
     0.732375, -0.454643,  0.302218, -0.019505,  0.881778,
    -0.057606,  0.273041,  0.414170, -0.503501, -0.079602,
    -0.083941,  0.007178, -0.171925,  0.506856,  0.520953,
     0.631684, -0.099784,  0.253885, -0.784149,  0.175691,
     0.211231, -0.677036, -0.348943, -0.615186, -0.095591,
     0.348521, -0.987871, -0.313590, -0.153938,  0.151210,
    -0.743479, -0.421562,  0.696567,  0.558739,  0.558933,
     0.578346, -0.498867, -0.168026, -0.007485, -0.002368,
     0.752372,  0.908575, -0.995190, -0.419553,  0.415430,
     0.525763, -0.787869, -0.684353, -0.220353, -0.572018,
     0.491337,  0.990879, -0.249054, -0.857606, -0.624307,
     0.655355,  0.490915, -0.612178, -0.658235, -0.663023,
     0.539032, -0.401714, -0.084585,  0.235599, -0.842975,
    -0.525653, -0.186055, -0.341841,  0.306321,  0.806460,
     0.655791,  0.058693,  0.715035,  0.660601,  0.639140,
     0.130465,  0.186363,  0.851271,  0.446112,  0.966011,
    -0.720746, -0.062551,  0.956890,  0.030200,  0.079843,
    -0.667418, -0.314445, -0.429243, -0.279596,  0.027320,
    -0.092266, -0.740564,  0.625606,  0.823149,  0.495035,
     0.782632, -0.702504, -0.691020, -0.559209,  0.603818,
    -0.884560, -0.903419, -0.337489,  0.830475,  0.757182,
    -0.698349, -0.039060, -0.056455, -0.847078, -0.592948,
    -0.090444, -0.567824,  0.344501, -0.133554,  0.462375,
    -0.575656,  0.199028, -0.852070, -0.004899,  0.919432,
     0.175251,  0.902835, -0.821132, -0.199143,  0.725984,
     0.673903, -0.416511, -0.976519,  0.982883,  0.024279,
     0.627298, -0.901677,  0.120861, -0.710191,  0.928798,
    -0.121958, -0.408540, -0.110261,  0.821588, -0.255618,
     0.296790, -0.268856,  0.176557, -0.358709,  0.597589,
    -0.361067,  0.065635, -0.203382, -0.213137, -0.939264,
    -0.283951,  0.962113,  0.963571, -0.105083, -0.237030,
     0.689556, -0.431180,  0.346459,  0.713037, -0.448297,
    -0.629262,  0.340335, -0.349973,  0.491599,  0.630144,
    -0.421175, -0.630359, -0.778396,  0.468564, -0.808771,
    -0.034014, -0.234646, -0.077627, -0.857457,  0.406645,
    -0.480038, -0.218524, -0.527720,  0.316580,  0.568338,
    -0.466984, -0.967371,  0.530452, -0.503413, -0.072454,
    -0.706578, -0.813857,  0.496366,  0.639881,  0.899179,
    -0.951931, -0.989381,  0.239514, -0.301904,  0.502218,
    -0.130341,  0.276921,  0.871860,  0.091262, -0.254515,
    -0.936911, -0.942752,  0.510839, -0.014539, -0.800209,
    -0.082516,  0.505423, -0.018733,  0.389763, -0.177997,
    -0.450395,  0.922779, -0.145368, -0.919943, -0.580634,
     0.782178, -0.626521, -0.394491,  0.278545, -0.986640,
    -0.495312,  0.326614, -0.976021,  0.744203, -0.975290,
     0.526197, -0.386139,  0.301631,  0.398057,  0.705124,
    -0.952884,  0.461146,  0.762372,  0.557954, -0.553393,
     0.962163, -0.524562,  0.952030, -0.056570,  0.865202,
    -0.225967,  0.493035,  0.787981,  0.628665,  0.573093,
    -0.792653,  0.410844,  0.946571, -0.187144, -0.310612,
     0.959931,  0.317544, -0.983998,  0.983911,  0.061747,
    -0.959287,  0.510108,  0.675608,  0.342344, -0.091835,
     0.380731,  0.389460, -0.630689,  0.143103, -0.052586,
    -0.184083,  0.105266,  0.422852, -0.232052, -0.951303,
     0.288054,  0.541981,  0.541732,  0.076035,  0.170646,
     0.114825,  0.283382, -0.418510,  0.061396, -0.903763,
     0.270879,  0.021327,  0.413782,  0.286881,  0.005238,
    -0.524472,  0.327594, -0.484654, -0.848864, -0.330063,
     0.423511,  0.531868, -0.940603,  0.792822, -0.325029,
     0.006811, -0.391261,  0.780237, -0.570337,  0.376687,
     0.828934,  0.717717, -0.081333,  0.370666, -0.206248,
    -0.910686, -0.514510, -0.922867, -0.329196,  0.546886,
    -0.826629,  0.941683, -0.431786,  0.587152,  0.228564,
     0.573452, -0.937320, -0.443843, -0.911202, -0.786184,
     0.226094,  0.512309,  0.745684,  0.285491,  0.305131,
    -0.579345, -0.707698,  0.913870, -0.799108, -0.278035,
     0.290556, -0.970174, -0.560318, -0.790776,  0.400492,
     0.233434, -0.701462,  0.885982,  0.310567, -0.030658,
     0.432868,  0.483938, -0.088976, -0.998918,  0.071090,
    -0.860412,  0.574534,  0.133770, -0.304255,  0.663332,
     0.347586,  0.921839,  0.175641,  0.093270,  0.207330,
    -0.519228,  0.513925,  0.499633, -0.605358,  0.714817,
    -0.778402,  0.685198,  0.744643, -0.338720,  0.894422,
     0.145135,  0.894714, -0.807041,  0.031117,  0.205281,
     0.162301, -0.536015, -0.310781, -0.926675, -0.534932,
     0.760308, -0.787088, -0.960398, -0.105922, -0.091343,
     0.702934, -0.758336, -0.169504, -0.121425,  0.334935,
    -0.962173,  0.359347, -0.151140,  0.537460,  0.753989,
    -0.436323,  0.759058,  0.439187, -0.691680, -0.579662,
     0.333608,  0.453454, -0.684948,  0.526567, -0.515429,
     0.520333, -0.311132, -0.051443, -0.790448, -0.237807,
     0.413625,  0.969861, -0.024895,  0.453226, -0.136061,
     0.883762,  0.156160,  0.105603, -0.285741, -0.965264,
    -0.559462, -0.247914,  0.394083,  0.289398, -0.710455,
     0.148072,  0.853074, -0.951397, -0.412742, -0.838606,
    -0.531059,  0.920866,  0.614848, -0.216007,  0.447434,
    -0.900580, -0.695673, -0.863698,  0.047977, -0.486121,
    -0.101505, -0.538399, -0.516261,  0.873600,  0.914828,
     0.347678,  0.757362,  0.070988, -0.546718, -0.528380,
     0.105724, -0.106180,  0.223706, -0.500194, -0.816782,
     0.513251,  0.647878, -0.963708,  0.561854, -0.764864,
    -0.802314, -0.969205, -0.843997,  0.812534, -0.185212,
     0.603436,  0.911954,  0.119114,  0.739738, -0.040069,
     0.632993, -0.361767,  0.421532, -0.883268, -0.488168,
     0.336360,  0.464411, -0.730806, -0.592652,  0.917693,
    -0.259186,  0.513071, -0.188487,  0.964520, -0.987122,
    -0.005270,  0.477771,  0.660756,  0.031023,  0.039625,
     0.895892,  0.228709,  0.070419, -0.948105,  0.041243,
     0.885207,  0.655331, -0.046803,  0.004321,  0.395069,
     0.913128, -0.362686, -0.966698,  0.334661, -0.245954,
    -0.454865, -0.328980, -0.781543, -0.185671,  0.078368,
    -0.863850,  0.555143, -0.408560, -0.052338,  0.519663,
    -0.395683,  0.942393, -0.002565, -0.734927, -0.026585,
    -0.962941, -0.839035, -0.797876,  0.107479, -0.787140,
     0.243367, -0.007314,  0.868191, -0.803435,  0.997007,
     0.263261, -0.890307, -0.365679,  0.296563,  0.444354,
     0.388367,  0.841698, -0.884626,  0.606824, -0.343973,
     0.193743,  0.742974, -0.788830,  0.785182, -0.309364,
     0.730833, -0.610500, -0.366971, -0.271732, -0.345427,
     0.606444, -0.234673, -0.184462,  0.808568,  0.872806,
     0.028398,  0.051936, -0.134508, -0.103410,  0.248500,
    -0.137501, -0.840150,  0.358194,  0.496819,  0.456413,
    -0.197453, -0.114814,  0.298111, -0.082078, -0.507990,
     0.954138, -0.888336, -0.765016, -0.834692,  0.896847,
    -0.074380,  0.896141, -0.713654,  0.558649, -0.375591,
    -0.059081,  0.165093,  0.389736,  0.756458, -0.026339,
     0.262542, -0.215144, -0.974403, -0.871966,  0.681446
};

static const float wmavoice_gain_silence[256] = {
    0.0000188351, 0.0000249147, 0.0000294447, 0.0000365973,
    0.0000423193, 0.0000464916, 0.0000498295, 0.0000525713,
    0.0000550747, 0.0000574589, 0.0000596046, 0.0000615120,
    0.0000634193, 0.0000649691, 0.0000665188, 0.0000679493,
    0.0000692606, 0.0000704527, 0.0000716448, 0.0000728369,
    0.0000737906, 0.0000747442, 0.0000755787, 0.0000762939,
    0.0000770092, 0.0000778437, 0.0000785589, 0.0000792742,
    0.0000799894, 0.0000807047, 0.0000814199, 0.0000822544,
    0.0000829697, 0.0000838041, 0.0000845194, 0.0000854731,
    0.0000865459, 0.0000876188, 0.0000889301, 0.0000904799,
    0.0000923872, 0.0000950098, 0.0000988245, 0.0001032352,
    0.0001088381, 0.0001147985, 0.0001225471, 0.0001319647,
    0.0001431704, 0.0001568794, 0.0001744032, 0.0001952648,
    0.0002206564, 0.0002535582, 0.0002965927, 0.0003464222,
    0.0004109144, 0.0004891157, 0.0005909204, 0.0007261038,
    0.0008867979, 0.0010721684, 0.0012696981, 0.0015079975,
    0.0017461777, 0.0019979477, 0.0022052526, 0.0023679733,
    0.0025173426, 0.0026556253, 0.0027927160, 0.0029264688,
    0.0030447245, 0.0031807423, 0.0033060312, 0.0034313202,
    0.0035454035, 0.0036598444, 0.0037686825, 0.0038731098,
    0.0039769411, 0.0040702820, 0.0041661263, 0.0042562485,
    0.0043400526, 0.0044249296, 0.0045082569, 0.0045900345,
    0.0046693087, 0.0047430992, 0.0048171282, 0.0048881769,
    0.0049589872, 0.0050252676, 0.0050880909, 0.0051497221,
    0.0052082539, 0.0052671432, 0.0053246021, 0.0053800344,
    0.0054348707, 0.0054861307, 0.0055367947, 0.0055862665,
    0.0056355000, 0.0056805611, 0.0057252645, 0.0057705641,
    0.0058110952, 0.0058538914, 0.0058966875, 0.0059366226,
    0.0059723854, 0.0060091019, 0.0060437918, 0.0060794353,
    0.0061159134, 0.0061485767, 0.0061824322, 0.0062153339,
    0.0062497854, 0.0062820911, 0.0063197613, 0.0063550472,
    0.0063927174, 0.0064336061, 0.0064769983, 0.0065194368,
    0.0065603256, 0.0066006184, 0.0066410303, 0.0066826344,
    0.0067234039, 0.0067654848, 0.0068060160, 0.0068466663,
    0.0068866014, 0.0069231987, 0.0069609880, 0.0069983006,
    0.0070366859, 0.0070750713, 0.0071122646, 0.0071535110,
    0.0071973801, 0.0072410107, 0.0072846413, 0.0073343515,
    0.0073832273, 0.0074360371, 0.0074878931, 0.0075426102,
    0.0076007843, 0.0076560974, 0.0077134371, 0.0077683926,
    0.0078265667, 0.0078855753, 0.0079488754, 0.0080170631,
    0.0080827475, 0.0081528425, 0.0082212687, 0.0082877874,
    0.0083510876, 0.0084129572, 0.0084775686, 0.0085455179,
    0.0086110830, 0.0086781979, 0.0087503195, 0.0088242292,
    0.0089002848, 0.0089734793, 0.0090423822, 0.0091133118,
    0.0091816187, 0.0092473030, 0.0093164444, 0.0093911886,
    0.0094678402, 0.0095427036, 0.0096175671, 0.0096931458,
    0.0097666979, 0.0098397732, 0.0099166632, 0.0099946260,
    0.0100749731, 0.0101612806, 0.0102528334, 0.0103493929,
    0.0104434490, 0.0105448961, 0.0106583834, 0.0107737780,
    0.0108981133, 0.0110142231, 0.0111318827, 0.0112472773,
    0.0113576651, 0.0114786625, 0.0116028786, 0.0117331743,
    0.0118676424, 0.0120122433, 0.0121580362, 0.0123010874,
    0.0124633312, 0.0126402378, 0.0128232241, 0.0130140781,
    0.0132108927, 0.0134289265, 0.0136625767, 0.0138912201,
    0.0141364336, 0.0144006014, 0.0146615505, 0.0149335861,
    0.0152134895, 0.0155050755, 0.0158376694, 0.0162067413,
    0.0165973902, 0.0169926882, 0.0174319744, 0.0179271698,
    0.0184448957, 0.0190744400, 0.0197248459, 0.0204203129,
    0.0212460756, 0.0221523046, 0.0231562853, 0.0243031979,
    0.0256397724, 0.0271918774, 0.0289602280, 0.0310072899,
    0.0333702564, 0.0363805294, 0.0401413441, 0.0443998575,
    0.0498176813, 0.0562580824, 0.0640066862, 0.0732775927,
    0.0836604834, 0.0962959528, 0.1122496128, 0.1335854530,
    0.1608980894, 0.1990102530, 0.2616490126, 0.3926030397
};

static const float wmavoice_gain_universal[64] = {
    0.0000000000, 0.0000000000, 0.0000015497, 0.0000015497,
    0.0000095367, 0.0000164509, 0.0000379086, 0.0000494719,
    0.0000799894, 0.0001058578, 0.0001349449, 0.0001627207,
    0.0001972914, 0.0002325773, 0.0002671480, 0.0003106594,
    0.0003589392, 0.0004127026, 0.0004582405, 0.0005071163,
    0.0005759001, 0.0006588697, 0.0007554293, 0.0008602142,
    0.0009772778, 0.0011068583, 0.0012603998, 0.0013889074,
    0.0015437603, 0.0016924143, 0.0018980503, 0.0021264553,
    0.0023632050, 0.0025693178, 0.0028522015, 0.0031896830,
    0.0034654140, 0.0037885904, 0.0041683912, 0.0046081543,
    0.0050576925, 0.0055632591, 0.0061818361, 0.0068151951,
    0.0073953867, 0.0081818104, 0.0091186762, 0.0102789402,
    0.0119919777, 0.0134155750, 0.0154829025, 0.0173798800,
    0.0199711323, 0.0229473114, 0.0268185139, 0.0319474936,
    0.0393068790, 0.0460114479, 0.0523469448, 0.0637906790,
    0.0845471621, 0.1105458736, 0.1499300003, 0.2219169140
};

static const float wmavoice_gain_codebook_acb[128] = {
    0.05, 0.14, 0.16, 0.05, 0.17, 0.25, 0.07, 0.21,
    0.12, 0.22, 0.23, 0.13, 0.24, 0.32, 0.14, 0.29,
    0.31, 0.41, 0.43, 0.32, 0.43, 0.51, 0.34, 0.48,
    0.38, 0.47, 0.49, 0.38, 0.49, 0.57, 0.40, 0.54,
    0.49, 0.59, 0.61, 0.50, 0.61, 0.69, 0.52, 0.66,
    0.56, 0.65, 0.67, 0.56, 0.67, 0.75, 0.58, 0.72,
    0.65, 0.74, 0.76, 0.65, 0.76, 0.84, 0.67, 0.81,
    0.71, 0.80, 0.82, 0.71, 0.82, 0.90, 0.73, 0.87,
    0.81, 0.90, 0.92, 0.81, 0.93, 1.01, 0.83, 0.97,
    0.87, 0.96, 0.98, 0.87, 0.98, 1.06, 0.89, 1.03,
    0.92, 1.02, 1.04, 0.93, 1.04, 1.12, 0.95, 1.09,
    0.93, 1.02, 1.04, 0.93, 1.04, 1.12, 0.95, 1.09,
    0.94, 1.04, 1.05, 0.10, 1.06, 1.14, 0.96, 1.11,
    0.98, 1.08, 1.10, 0.99, 1.10, 1.18, 1.01, 1.15,
    1.06, 1.15, 1.17, 1.06, 1.17, 1.25, 1.08, 1.22,
    1.16, 1.25, 1.27, 1.16, 1.28, 1.36, 1.18, 1.32
};

static const float wmavoice_gain_codebook_fcb[128] = {
    -0.8439700703 /* log(0.430) */, -0.6143360001 /* log(0.541) */,
    -0.1531511795 /* log(0.858) */, -0.0998203353 /* log(0.905) */,
     0.3213585988 /* log(1.379) */,  0.3777512695 /* log(1.459) */,
     0.7158866675 /* log(2.046) */,  1.2700414043 /* log(3.561) */,
    -1.6873994539 /* log(0.185) */, -1.2173958247 /* log(0.296) */,
    -0.4893903430 /* log(0.613) */, -0.4155154440 /* log(0.660) */,
     0.1257512053 /* log(1.134) */,  0.1947440768 /* log(1.215) */,
     0.5883420662 /* log(1.801) */,  1.1987592373 /* log(3.316) */,
    -1.3586791941 /* log(0.257) */, -0.9996723408 /* log(0.368) */,
    -0.3768776513 /* log(0.686) */, -0.3119747650 /* log(0.732) */,
     0.1881379421 /* log(1.207) */,  0.2523139286 /* log(1.287) */,
     0.6280751838 /* log(1.874) */,  1.2202397768 /* log(3.388) */,
    -0.7381445465 /* log(0.478) */, -0.5310283311 /* log(0.588) */,
    -0.0987159729 /* log(0.906) */, -0.0491902442 /* log(0.952) */,
     0.3555743385 /* log(1.427) */,  0.4101209196 /* log(1.507) */,
     0.7390761124 /* log(2.094) */,  1.2831536022 /* log(3.608) */,
    -0.2497442331 /* log(0.779) */, -0.1165338163 /* log(0.890) */,
     0.1881379421 /* log(1.207) */,  0.2255406759 /* log(1.253) */,
     0.5469646704 /* log(1.728) */,  0.5922212620 /* log(1.808) */,
     0.8733832309 /* log(2.395) */,  1.3632815868 /* log(3.909) */,
    -1.3903023825 /* log(0.249) */, -1.0216512475 /* log(0.360) */,
    -0.3900840061 /* log(0.677) */, -0.3229638866 /* log(0.724) */,
     0.1806534997 /* log(1.198) */,  0.2460785226 /* log(1.279) */,
     0.6232610531 /* log(1.865) */,  1.2178757095 /* log(3.380) */,
    -0.6033064766 /* log(0.547) */, -0.4185503477 /* log(0.658) */,
    -0.0253178080 /* log(0.975) */,  0.0217614918 /* log(1.022) */,
     0.4027948796 /* log(1.496) */,  0.4555243080 /* log(1.577) */,
     0.7714961470 /* log(2.163) */,  1.3023691262 /* log(3.678) */,
    -1.1056369036 /* log(0.331) */, -0.8164453969 /* log(0.442) */,
    -0.2757535016 /* log(0.759) */, -0.2156715365 /* log(0.806) */,
     0.2468600779 /* log(1.280) */,  0.3082197237 /* log(1.361) */,
     0.6662897264 /* log(1.947) */,  1.2418464568 /* log(3.462) */,
    -0.5395680926 /* log(0.583) */, -0.3652833185 /* log(0.694) */,
     0.0109399400 /* log(1.011) */,  0.0554347069 /* log(1.057) */,
     0.4265740713 /* log(1.532) */,  0.4774756441 /* log(1.612) */,
     0.7880027116 /* log(2.199) */,  1.3118401752 /* log(3.713) */,
    -0.9571127264 /* log(0.384) */, -0.7031975164 /* log(0.495) */,
    -0.2082549388 /* log(0.812) */, -0.1519863570 /* log(0.859) */,
     0.2874320412 /* log(1.333) */,  0.3464225675 /* log(1.414) */,
     0.6931471806 /* log(2.000) */,  1.2570395253 /* log(3.515) */,
    -0.2420715612 /* log(0.785) */, -0.1098148660 /* log(0.896) */,
     0.1930966300 /* log(1.213) */,  0.2311117210 /* log(1.260) */,
     0.5504308784 /* log(1.734) */,  0.5960854677 /* log(1.815) */,
     0.8758853172 /* log(2.401) */,  1.3650707247 /* log(3.916) */,
     0.6564831962 /* log(1.928) */,  0.7124594916 /* log(2.039) */,
     0.8569652658 /* log(2.356) */,  0.8767179568 /* log(2.403) */,
     1.0567480846 /* log(2.877) */,  1.0841752409 /* log(2.957) */,
     1.2652560327 /* log(3.544) */,  1.6211688353 /* log(5.059) */,
    -1.5417792640 /* log(0.214) */, -1.1239300967 /* log(0.325) */,
    -0.4431669753 /* log(0.642) */, -5.2983173665 /* log(0.005) */,
     0.1510028735 /* log(1.163) */,  0.2183319943 /* log(1.244) */,
     0.6043159669 /* log(1.830) */,  1.2074666936 /* log(3.345) */,
    -0.5124936809 /* log(0.599) */, -0.3424903089 /* log(0.710) */,
     0.0266419309 /* log(1.027) */,  0.0713899961 /* log(1.074) */,
     0.4369637752 /* log(1.548) */,  0.4879663296 /* log(1.629) */,
     0.7952524035 /* log(2.215) */,  1.3164082337 /* log(3.730) */,
    -0.8867319296 /* log(0.412) */, -0.6481738149 /* log(0.523) */,
    -0.1743533871 /* log(0.840) */, -0.1199102967 /* log(0.887) */,
     0.3089542077 /* log(1.362) */,  0.3660310389 /* log(1.442) */,
     0.7075430608 /* log(2.029) */,  1.2649738259 /* log(3.543) */,
    -0.0943106795 /* log(0.910) */,  0.0207825392 /* log(1.021) */,
     0.2911759617 /* log(1.338) */,  0.3249778572 /* log(1.384) */,
     0.6200387087 /* log(1.859) */,  0.6621723763 /* log(1.939) */,
     0.9266370239 /* log(2.526) */,  1.3962446920 /* log(4.040) */
};

static const float wmavoice_ipol1_coeffs[17*9] = {
     0,
     0.6308171151,  0.7613050340,  0.8632577061,  0.9280143976,
     0.9499985575,  0.9273047447,  0.8618999123,  0.7594153284,
    -0.1791058179, -0.1351341452, -0.0589959878,  0.0472882274,
     0.1784339990,  0.3262237605,  0.4801855979,  0.6285545824,
     0,
    -0.1921342459, -0.1786532696, -0.1341681625, -0.0575229186,
     0.0492091286,  0.1806929555,  0.3286687729,  0.4826357064,
     0.0807464118,  0.0506337392,  0.0080115446, -0.0428523305,
    -0.0958572026, -0.1436148431, -0.1782128509, -0.1921164688,
     0,
     0.0960653644,  0.0803771760,  0.0500416081,  0.0072485465,
    -0.0437018941, -0.0966834794, -0.1442930843, -0.1786170151,
    -0.0391932014, -0.0189622506,  0.0070230183,  0.0356589290,
     0.0630142610,  0.0847979258,  0.0969368290,  0.0961942221,
     0,
    -0.0515680681, -0.0389267015, -0.0185848991,  0.0074699190,
     0.0361179407,  0.0634181346,  0.0850781347,  0.0970333587,
     0.0178811825,  0.0048708571, -0.0108041526, -0.0271167825,
    -0.0416534986, -0.0519338618, -0.0557823736, -0.0517020743,
     0,
     0.0267091128,  0.0177022810,  0.0046363524, -0.0110662053,
    -0.0273700613, -0.0418578978, -0.0520511451, -0.0557823028,
    -0.0069270437,  0.0008217385,  0.0097293532,  0.0185749526,
     0.0259542684,  0.0304777338,  0.0309953480,  0.0268154419,
     0,
    -0.0125539196, -0.0068173436,  0.0009580161,  0.0098749646,
     0.0187084037,  0.0260526291,  0.0305201071,  0.0309665180,
     0.0019149571, -0.0022503408, -0.0068592466, -0.0112465904,
    -0.0146595868, -0.0163685936, -0.0157934162, -0.0126258885,
     0,
     0.0050976076,  0.0018546581, -0.0023221741, -0.0069331308,
    -0.0113109085, -0.0147021576, -0.0163786146, -0.0157635096,
    -0.0001162733,  0.0019313511,  0.0040823850,  0.0060192454,
     0.0073876535,  0.0078486321,  0.0071403184,  0.0051400312,
     0,
    -0.0017920607, -0.0000857157,  0.0019657183,  0.0041159806,
     0.0060465694,  0.0074030068,  0.0078470460,  0.0071185785,
    -0.0004100171, -0.0015364708, -0.0025490071, -0.0033188616,
    -0.0037196307, -0.0036417283, -0.0030119629, -0.0018155784,
     0,
     0.0006907531, -0.0004282868, -0.0015539061, -0.0025635813,
    -0.0033285026, -0.0037224069, -0.0036361245, -0.0029972247,
     0, 0, 0, 0, 0, 0, 0, 0
};

/**
 * Hamming-window sinc function (num = 32, x = [ 0, 31 ]):
 * (0.54 + 0.46 * cos(2 * M_PI * x / (num - 1))) *
 *     sin(x * M_PI / 4) / (x * M_PI / 4)
 */
static const float wmavoice_ipol2_coeffs[32] = {
    1,  0.8563459515,  0.5888634918,  0.2648358640,
    0, -0.1360490318, -0.1434589471, -0.0758505310,
    0,  0.0410402636,  0.0412485781,  0.0200064587,
    0, -0.0081391358, -0.0068223253, -0.0029313546,
    0,  0.0025864919,  0.0053062555,  0.0055688801,
    0, -0.0104795941, -0.0187493577, -0.0160592399,
    0,  0.0212381664,  0.0331059131,  0.0251942366,
    0, -0.0273968070, -0.0392575669, -0.0276240534
};

/**
 * LUT for 1.071575641632 * pow(1.0331663, n - 127)
 */
static const float wmavoice_energy_table[128] = {
    0.0169982178, 0.0175619858, 0.0181444519, 0.0187462362,
    0.0193679795, 0.0200103437, 0.0206740128, 0.0213596933,
    0.0220681153, 0.0228000330, 0.0235562258, 0.0243374986,
    0.0251446834, 0.0259786395, 0.0268402549, 0.0277304468,
    0.0286501631, 0.0296003830, 0.0305821182, 0.0315964139,
    0.0326443501, 0.0337270424, 0.0348456436, 0.0360013446,
    0.0371953760, 0.0384290090, 0.0397035571, 0.0410203772,
    0.0423808713, 0.0437864880, 0.0452387238, 0.0467391249,
    0.0482892887, 0.0498908657, 0.0515455612, 0.0532551367,
    0.0550214125, 0.0568462692, 0.0587316496, 0.0606795611,
    0.0626920777, 0.0647713419, 0.0669195677, 0.0691390421,
    0.0714321284, 0.0738012678, 0.0762489827, 0.0787778794,
    0.0813906502, 0.0840900769, 0.0868790336, 0.0897604897,
    0.0927375130, 0.0958132732, 0.0989910450, 0.1022742117,
    0.1056662688, 0.1091708280, 0.1127916204, 0.1165325012,
    0.1203974531, 0.1243905911, 0.1285161668, 0.1327785725,
    0.1371823465, 0.1417321773, 0.1464329093, 0.1512895470,
    0.1563072616, 0.1614913951, 0.1668474671, 0.1723811803,
    0.1780984262, 0.1840052921, 0.1901080668, 0.1964132480,
    0.2029275487, 0.2096579046, 0.2166114816, 0.2237956830,
    0.2312181577, 0.2388868085, 0.2468098001, 0.2549955679,
    0.2634528274, 0.2721905830, 0.2812181375, 0.2905451026,
    0.3001814086, 0.3101373153, 0.3204234225, 0.3310506819,
    0.3420304081, 0.3533742912, 0.3650944090, 0.3772032397,
    0.3897136755, 0.4026390362, 0.4159930832, 0.4297900346,
    0.4440445799, 0.4587718956, 0.4739876619, 0.4897080789,
    0.5059498840, 0.5227303696, 0.5400674019, 0.5579794393,
    0.5764855528, 0.5956054456, 0.6153594745, 0.6357686714,
    0.6568547659, 0.6786402082, 0.7011481929, 0.7244026842,
    0.7484284410, 0.7732510432, 0.7988969192, 0.8253933741,
    0.8527686184, 0.8810517982, 0.9102730265, 0.9404634147,
    0.9716551065, 1.0038813113, 1.0371763400, 1.0715756416
};

/**
 * LUT for f(x,y) = pow((y + 6.9) / 64, 0.025 * (x + 1)).
 */
static const float wmavoice_denoise_power_table[12][64] = {
    { 0.9458379339, 0.9490436287, 0.9518757236, 0.9544130754,
      0.9567118717, 0.9588135761, 0.9607496688, 0.9625446194,
      0.9642178285, 0.9657849396, 0.9672587526, 0.9686498743,
      0.9699671937, 0.9712182343, 0.9724094211, 0.9735462842,
      0.9746336187, 0.9756756090, 0.9766759291, 0.9776378218,
      0.9785641645, 0.9794575217, 0.9803201890, 0.9811542296,
      0.9819615045, 0.9827436985, 0.9835023412, 0.9842388263,
      0.9849544265, 0.9856503078, 0.9863275406, 0.9869871101,
      0.9876299254, 0.9882568267, 0.9888685922, 0.9894659445,
      0.9900495551, 0.9906200497, 0.9911780119, 0.9917239872,
      0.9922584859, 0.9927819864, 0.9932949377, 0.9937977618,
      0.9942908555, 0.9947745929, 0.9952493267, 0.9957153901,
      0.9961730980, 0.9966227482, 0.9970646231, 0.9974989903,
      0.9979261037, 0.9983462046, 0.9987595223, 0.9991662752,
      0.9995666709, 0.9999609077, 1.0003491745, 1.0007316515,
      1.0011085110, 1.0014799178, 1.0018460292, 1.0022069960 },
    { 0.8946093973, 0.9006838092, 0.9060673931, 0.9109043185,
      0.9152976055, 0.9193234737, 0.9230399260, 0.9264921443,
      0.9297160207, 0.9327405496, 0.9355894944, 0.9382825789,
      0.9408363568, 0.9432648587, 0.9455800822, 0.9477923675,
      0.9499106907, 0.9519428941, 0.9538958704, 0.9557757107,
      0.9575878241, 0.9593370368, 0.9610276730, 0.9626636222,
      0.9642483964, 0.9657851769, 0.9672768552, 0.9687260672,
      0.9701352224, 0.9715065293, 0.9728420173, 0.9741435556,
      0.9754128696, 0.9766515555, 0.9778610927, 0.9790428553,
      0.9801981216, 0.9813280829, 0.9824338513, 0.9835164667,
      0.9845769028, 0.9856160726, 0.9866348334, 0.9876339913,
      0.9886143053, 0.9895764906, 0.9905212223, 0.9914491381,
      0.9923608411, 0.9932569022, 0.9941378627, 0.9950042356,
      0.9958565084, 0.9966951442, 0.9975205834, 0.9983332454,
      0.9991335296, 0.9999218170, 1.0006984708, 1.0014638383,
      1.0022182509, 1.0029620257, 1.0036954662, 1.0044188628 },
    { 0.8461555040, 0.8547882305, 0.8624635555, 0.8693789920,
      0.8756760853, 0.8814598273, 0.8868103032, 0.8917900284,
      0.8964487626, 0.9008267754, 0.9049571273, 0.9088673021,
      0.9125804007, 0.9161160306, 0.9194909803, 0.9227197376,
      0.9258148939, 0.9287874629, 0.9316471355, 0.9344024839,
      0.9370611291, 0.9396298766, 0.9421148300, 0.9445214846,
      0.9468548060, 0.9491192967, 0.9513190517, 0.9534578074,
      0.9555389816, 0.9575657096, 0.9595408742, 0.9614671327,
      0.9633469396, 0.9651825670, 0.9669761222, 0.9687295635,
      0.9704447142, 0.9721232742, 0.9737668316, 0.9753768718,
      0.9769547868, 0.9785018824, 0.9800193854, 0.9815084500,
      0.9829701633, 0.9844055505, 0.9858155796, 0.9872011653,
      0.9885631734, 0.9899024236, 0.9912196934, 0.9925157203,
      0.9937912053, 0.9950468143, 0.9962831814, 0.9975009102,
      0.9987005760, 0.9998827277, 1.0010478892, 1.0021965608,
      1.0033292209, 1.0044463270, 1.0055483173, 1.0066356112 },
    { 0.8003259737, 0.8112313241, 0.8209581209, 0.8297466775,
      0.8377697066, 0.8451556492, 0.8520027051, 0.8583876935,
      0.8643718792, 0.8700049328, 0.8753277020, 0.8803741979,
      0.8851730502, 0.8897485937, 0.8941216918, 0.8983103719,
      0.9023303202, 0.9061952736, 0.9099173316, 0.9135072091,
      0.9169744409, 0.9203275502, 0.9235741882, 0.9267212496,
      0.9297749699, 0.9327410079, 0.9356245146, 0.9384301933,
      0.9411623497, 0.9438249364, 0.9464215906, 0.9489556668,
      0.9514302661, 0.9538482608, 0.9562123167, 0.9585249126,
      0.9607883576, 0.9630048062, 0.9651762722, 0.9673046403,
      0.9693916775, 0.9714390425, 0.9734482944, 0.9754209007,
      0.9773582446, 0.9792616307, 0.9811322918, 0.9829713934,
      0.9847800389, 0.9865592739, 0.9883100900, 0.9900334289,
      0.9917301853, 0.9934012104, 0.9950473143, 0.9966692689,
      0.9982678100, 0.9998436400, 1.0013974295, 1.0029298194,
      1.0044414224, 1.0059328250, 1.0074045889, 1.0088572520 },
    { 0.7569786654, 0.7698939195, 0.7814501054, 0.7919210783,
      0.8015042240, 0.8103467104, 0.8185613167, 0.8262364557,
      0.8334427763, 0.8402376615, 0.8466683811, 0.8527743561,
      0.8585888194, 0.8641400582, 0.8694523567, 0.8745467247,
      0.8794414652, 0.8841526254, 0.8886943552, 0.8930791981,
      0.8973183276, 0.9014217415, 0.9053984227, 0.9092564737,
      0.9130032283, 0.9166453478, 0.9201889007, 0.9236394320,
      0.9270020224, 0.9302813390, 0.9334816797, 0.9366070112,
      0.9396610028, 0.9426470554, 0.9455683275, 0.9484277579,
      0.9512280860, 0.9539718690, 0.9566614986, 0.9592992147,
      0.9618871182, 0.9644271823, 0.9669212630, 0.9693711079,
      0.9717783651, 0.9741445900, 0.9764712529, 0.9787597445,
      0.9810113822, 0.9832274148, 0.9854090274, 0.9875573457,
      0.9896734398, 0.9917583281, 0.9938129803, 0.9958383209,
      0.9978352315, 0.9998045539, 1.0017470919, 1.0036636145,
      1.0055548568, 1.0074215229, 1.0092642871, 1.0110837959 },
    { 0.7159791370, 0.7306629191, 0.7438433845, 0.7558198318,
      0.7668086064, 0.7769714272, 0.7864325139, 0.7952894548,
      0.8036203840, 0.8114888792, 0.8189474022, 0.8260397728,
      0.8328029877, 0.8392685815, 0.8454636629, 0.8514117142,
      0.8571332177, 0.8626461513, 0.8679663850, 0.8731080020,
      0.8780835596, 0.8829043049, 0.8875803529, 0.8921208349,
      0.8965340237, 0.9008274393, 0.9050079382, 0.9090817905,
      0.9130547454, 0.9169320882, 0.9207186893, 0.9244190474,
      0.9280373261, 0.9315773876, 0.9350428208, 0.9384369673,
      0.9417629433, 0.9450236603, 0.9482218422, 0.9513600421,
      0.9544406555, 0.9574659338, 0.9604379957, 0.9633588374,
      0.9662303420, 0.9690542879, 0.9718323569, 0.9745661408,
      0.9772571477, 0.9799068082, 0.9825164805, 0.9850874551,
      0.9876209597, 0.9901181627, 0.9925801775, 0.9950080658,
      0.9974028405, 0.9997654692, 1.0020968764, 1.0043979464,
      1.0066695255, 1.0089124239, 1.0111274185, 1.0133152537 },
    { 0.6772002277, 0.6934309881, 0.7080464599, 0.7213643301,
      0.7336148970, 0.7449707526, 0.7555647772, 0.7655015856,
      0.7748651015, 0.7837237382, 0.7921340426, 0.8001433220,
      0.8077915768, 0.8151129499, 0.8221368310, 0.8288887107,
      0.8353908496, 0.8416628090, 0.8477218755, 0.8535834053,
      0.8592611049, 0.8647672624, 0.8701129393, 0.8753081305,
      0.8803618988, 0.8852824894, 0.8900774261, 0.8947535945,
      0.8993173131, 0.9037743949, 0.9081302004, 0.9123896841,
      0.9165574352, 0.9206377129, 0.9246344779, 0.9285514202,
      0.9323919830, 0.9361593853, 0.9398566405, 0.9434865742,
      0.9470518396, 0.9505549317, 0.9539981992, 0.9573838564,
      0.9607139933, 0.9639905847, 0.9672154989, 0.9703905051,
      0.9735172803, 0.9765974162, 0.9796324243, 0.9826237418,
      0.9855727362, 0.9884807098, 0.9913489039, 0.9941785028,
      0.9969706369, 0.9997263861, 1.0024467831, 1.0051328157,
      1.0077854297, 1.0104055314, 1.0129939892, 1.0155516364 },
    { 0.6405216642, 0.6580962612, 0.6739722363, 0.6884795488,
      0.7018580813, 0.7142880714, 0.7259086094, 0.7368294324,
      0.7471387455, 0.7569085832, 0.7661985859, 0.7750587283,
      0.7835313288, 0.7916525600, 0.7994535998, 0.8069615243,
      0.8142000068, 0.8211898738, 0.8279495504, 0.8344954211,
      0.8408421252, 0.8470027997, 0.8529892811, 0.8588122744,
      0.8644814947, 0.8700057878, 0.8753932324, 0.8806512276,
      0.8857865684, 0.8908055105, 0.8957138271, 0.9005168576,
      0.9052195513, 0.9098265046, 0.9143419945, 0.9187700080,
      0.9231142680, 0.9273782568, 0.9315652364, 0.9356782672,
      0.9397202245, 0.9436938133, 0.9476015819, 0.9514459336,
      0.9552291382, 0.9589533414, 0.9626205741, 0.9662327603,
      0.9697917251, 0.9732992008, 0.9767568340, 0.9801661903,
      0.9835287605, 0.9868459649, 0.9901191578, 0.9933496315,
      0.9965386205, 0.9996873045, 1.0027968119, 1.0058682226,
      1.0089025710, 1.0119008485, 1.0148640056, 1.0177929548 },
    { 0.6058296875, 0.6245620637, 0.6415378101, 0.6570938835,
      0.6714759586, 0.6848691001, 0.6974164561, 0.7092312055,
      0.7204044988, 0.7310109103, 0.7411122884, 0.7507605397,
      0.7599996842, 0.7688674015, 0.7773962122, 0.7856143935,
      0.7935466990, 0.8012149303, 0.8086383963, 0.8158342858,
      0.8228179717, 0.8296032631, 0.8362026133, 0.8426272954,
      0.8488875492, 0.8549927056, 0.8609512936, 0.8667711307,
      0.8724594015, 0.8780227256, 0.8834672161, 0.8887985309,
      0.8940219180, 0.8991422543, 0.9041640810, 0.9090916337,
      0.9139288704, 0.9186794948, 0.9233469789, 0.9279345818,
      0.9324453671, 0.9368822185, 0.9412478543, 0.9455448393,
      0.9497755970, 0.9539424198, 0.9580474782, 0.9620928299,
      0.9660804271, 0.9700121244, 0.9738896845, 0.9777147851,
      0.9814890239, 0.9852139236, 0.9888909370, 0.9925214512,
      0.9961067913, 0.9996482244, 1.0031469629, 1.0066041676,
      1.0100209506, 1.0133983785, 1.0167374742, 1.0200392198 },
    { 0.5730166999, 0.5927366473, 0.6106642672, 0.6271389942,
      0.6424090212, 0.6566617910, 0.6700426292, 0.6826666808,
      0.6946268614, 0.7059993279, 0.7168473476, 0.7272241023,
      0.7371747608, 0.7467380401, 0.7559474006, 0.7648319736,
      0.7734172908, 0.7817258650, 0.7897776570, 0.7975904541,
      0.8051801811, 0.8125611560, 0.8197463039, 0.8267473349,
      0.8335748949, 0.8402386937, 0.8467476129, 0.8531098003,
      0.8593327495, 0.8654233698, 0.8713880464, 0.8772326935,
      0.8829628002, 0.8885834710, 0.8940994619, 0.8995152120,
      0.9048348715, 0.9100623268, 0.9152012229, 0.9202549833,
      0.9252268281, 0.9301197899, 0.9349367288, 0.9396803449,
      0.9443531909, 0.9489576823, 0.9534961076, 0.9579706374,
      0.9623833320, 0.9667361492, 0.9710309512, 0.9752695109,
      0.9794535174, 0.9835845813, 0.9876642399, 0.9916939614,
      0.9956751493, 0.9996091459, 1.0034972362, 1.0073406510,
      1.0111405700, 1.0148981248, 1.0186144013, 1.0222904422 },
    { 0.5419809316, 0.5625329386, 0.5812764912, 0.5985496562,
      0.6146003370, 0.6296162401, 0.6437432340, 0.6570971404,
      0.6697716039, 0.6818435182, 0.6933768712, 0.7044255353,
      0.7150353340, 0.7252456009, 0.7350903742, 0.7445993259,
      0.7537984929, 0.7627108595, 0.7713568269, 0.7797545943,
      0.7879204712, 0.7958691361, 0.8036138516, 0.8111666444,
      0.8185384580, 0.8257392814, 0.8327782597, 0.8396637886,
      0.8464035955, 0.8530048108, 0.8594740287, 0.8658173611,
      0.8720404845, 0.8781486812, 0.8841468762, 0.8900396688,
      0.8958313620, 0.9015259874, 0.9071273286, 0.9126389413,
      0.9180641715, 0.9234061727, 0.9286679198, 0.9338522236,
      0.9389617420, 0.9439989920, 0.9489663591, 0.9538661069,
      0.9587003852, 0.9634712378, 0.9681806094, 0.9728303524,
      0.9774222323, 0.9819579336, 0.9864390644, 0.9908671615,
      0.9952436943, 0.9995700689, 1.0038476318, 1.0080776733,
      1.0122614305, 1.0164000906, 1.0204947932, 1.0245466331 },
    { 0.5126261246, 0.5338683013, 0.5533029807, 0.5712636181,
      0.5879954388, 0.6036845987, 0.6184760989, 0.6324853169,
      0.6458057215, 0.6585142011, 0.6706748475, 0.6823417062,
      0.6935608163, 0.7043717519, 0.7148088052, 0.7249019070,
      0.7346773529, 0.7441583823, 0.7533656456, 0.7623175831,
      0.7710307376, 0.7795200117, 0.7877988829, 0.7958795841,
      0.8037732557, 0.8114900754, 0.8190393682, 0.8264297018,
      0.8336689680, 0.8407644543, 0.8477229049, 0.8545505751,
      0.8612532786, 0.8678364291, 0.8743050768, 0.8806639416,
      0.8869174414, 0.8930697184, 0.8991246621, 0.9050859297,
      0.9109569648, 0.9167410144, 0.9224411436, 0.9280602496,
      0.9336010737, 0.9390662129, 0.9444581300, 0.9497791628,
      0.9550315328, 0.9602173528, 0.9653386345, 0.9703972943,
      0.9753951600, 0.9803339761, 0.9852154088, 0.9900410510,
      0.9948124263, 0.9995309934, 1.0041981497, 1.0088152348,
      1.0133835335, 1.0179042791, 1.0223786564, 1.0268078035 },
};

#endif /* AVCODEC_WMAVOICE_DATA_H */
