<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'NodesBrowser.php';
	require_once 'NodesEditor.php';
	require_once 'NodesMoveCmd.php';

	/**
	*  Nodes manager
	*
	*  Author: Nicolas Dufresne
	*/
	switch ($module_action) {
		case 'build':
			// Default destination = current node
			if ($termonly && !isset($_POST["nb_find_dest"]) && !isset($_GET["node_id_dest"]))
			{
				$_GET["node_id_dest"] = $_GET["node_id"];
			}
			$dest = new NodesBrowser(NODE_TYPE,"destination","node_id_dest","nb_find_dest");
			$dest->load(NODE_TYPE,"destination","node_id_dest","nb_find_dest");
			if (!$termonly) {
				$source = new NodesBrowser(NODE_TYPE,"source");
				$perm = $source->getPermissions();
				$ne = new NodesEditor($source->getNode(),$dest->getNode(),$perm);
				$source->load(NODE_TYPE,"source");
			} else { // Load type 1 nodebrowser in termonly mode
				$source = new NodesBrowser();
				$ne = new NodesMoveCmd($source->getNode(),$dest->getNode());
				$source->load();
			}
			break;
		case 'print':
			$source->printView();
			if (!$termonly) {
				$ne->printView();
				$dest->printView();
			} else { // Different order in termonly mode
				$dest->printView();
				$ne->printView();
			}
			break;
	}
?>
