<?php


/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/**
 * This class manage current node attributes
 *
 * 9 aug 2004 - Nicolas Dufresne
 */

require_once 'Attribute.php';
require_once 'AttributeDef.php';
require_once 'dbFunctions.php';

class ListManager {
	var $attributes;
	var $isError;
	var $errors;
	var $editableAttributes;
	var $dictionary;

	function ListManager() {
		/////////////////////////////
		// General construction
		////////////////////////////

		$this->isError = false;

		/////////////////////////
		// Actions
		/////////////////////////

		// Cancel
		if (isset ($_POST['cancel'])) {
			unset ($GLOBALS['_POST']);
		}
		// Generating all attribute list
		$this->editableAttributes = $this->getEditableAttributes();
		if (isset ($_POST['save_def'])) {
			$attributeDef = new AttributeDef($_POST['modAttributeDef']);
			$index=0;
			foreach ($_POST['textfield'] as $value) {
				$oldValue=$_POST['hiddenfield'][$index];
			  	$index++;
		    	if ($error = $attributeDef->updateDictValue($value,$oldValue)) {
				   	$this->errors[] = $error;
				  	unset($error);
			    }
			}
		}


		if (isset ($_POST['del_def'])) {
			if (is_array($_POST['selection'])) {
				$attributeDef = new AttributeDef($_POST['modAttributeDef']);
				foreach ($_POST['selection'] as $value) {
					$attributeDef->deleteDictValue($value);
				}
			}
		}
		if (isset ($_POST['save_new_def'])) {
			$attributeDef = new AttributeDef($_POST['modAttributeDef']);
     		if ($error = $attributeDef->insertDictValue($_POST['newDictValue'])) {
				$this->errors[] = $error;
				unset($error);
			}
		}
		// Change attributesdefdict
		if (isset ($_POST['mod_def'])) {
			$this->dictionary = $this->getDictionaryValue($_POST['modAttributeDef']);
		}

	}

	function getEditableAttributes() {
		$attributes = select("SELECT id,name FROM attributesDef WHERE editable=1 ORDER BY name");
		if (!is_null($attributes) && !is_array($attributes)) {
			$this->errors[] = getMessage('db_error') . $attributes;
			//$this->isError = true;
			return NULL;
		}
		if (is_array($attributes)) {
			foreach ($attributes as $attribute) {
				$attributesAssoc[$attribute['id']] = $attribute['name'];
			}
		}
		return $attributesAssoc;
	}

	function getDictionaryValue($attributesdefId) {
		$query = "SELECT value FROM attributesdefdict WHERE attributesdef_id=" . $attributesdefId . "ORDER BY sortval,value";
		$dictionaryValues = select($query);
		if (!is_null($dictionaryValues) && !is_array($dictionaryValues)) {
			$this->errors[] = getMessage('db_error') . $dictionaryValues;
			//$this->isError = true;
			return NULL;
		}
		for ($index = 0; $index < sizeof($dictionaryValues); $index++) {
			$result[$index] = $dictionaryValues[$index]["value"];
		}
		return $result;
	}

	function isError() {
		return $this->isError;
	}

	function printErrors() {
		if (isset ($this->errors[0]))
			print "<p>\n";
		else
			return;
		foreach ($this->errors as $error) {
			print "<font color=\"red\" size=\"-1\">" . $error . "</font><br>\n";
		}
		print "</p>\n";
	}

	function printView() {
		if ($this->isError) {
			$this->printErrors();
			return;
		}
		include 'listManagerView.php';
	}

}
?>

