# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=amdgcn -mcpu=gfx1010 --timeline --iterations=1 --timeline-max-cycles=0 < %s | FileCheck %s

v_add_f32 v0, v0, v0
v_add_f32 v1, v1, v1
v_add_f32 v2, v1, v0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      3
# CHECK-NEXT: Total Cycles:      12
# CHECK-NEXT: Total uOps:        3

# CHECK:      Dispatch Width:    1
# CHECK-NEXT: uOps Per Cycle:    0.25
# CHECK-NEXT: IPC:               0.25
# CHECK-NEXT: Block RThroughput: 3.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      5     1.00                  U     v_add_f32_e32 v0, v0, v0
# CHECK-NEXT:  1      5     1.00                  U     v_add_f32_e32 v1, v1, v1
# CHECK-NEXT:  1      5     1.00                  U     v_add_f32_e32 v2, v1, v0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - HWBranch
# CHECK-NEXT: [1]   - HWExport
# CHECK-NEXT: [2]   - HWLGKM
# CHECK-NEXT: [3]   - HWRC
# CHECK-NEXT: [4]   - HWSALU
# CHECK-NEXT: [5]   - HWTransVALU
# CHECK-NEXT: [6]   - HWVALU
# CHECK-NEXT: [7]   - HWVMEM

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -      -     3.00    -      -     3.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -      -     1.00    -     v_add_f32_e32 v0, v0, v0
# CHECK-NEXT:  -      -      -     1.00    -      -     1.00    -     v_add_f32_e32 v1, v1, v1
# CHECK-NEXT:  -      -      -     1.00    -      -     1.00    -     v_add_f32_e32 v2, v1, v0

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeE    ..   v_add_f32_e32 v0, v0, v0
# CHECK-NEXT: [0,1]     .DeeeeE   ..   v_add_f32_e32 v1, v1, v1
# CHECK-NEXT: [0,2]     .    .DeeeeE   v_add_f32_e32 v2, v1, v0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       v_add_f32_e32 v0, v0, v0
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       v_add_f32_e32 v1, v1, v1
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       v_add_f32_e32 v2, v1, v0
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
