; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -S -passes=globalopt | FileCheck %s

declare dso_local i32 @atexit(ptr)

define dso_local void @empty_atexit_handler() {
; CHECK-LABEL: define dso_local void @empty_atexit_handler() local_unnamed_addr {
; CHECK-NEXT:    ret void
;
  ret void
}

; Check that `atexit` is removed if the handler is empty.
; Check that a removed `atexit` call returns `0` which is the value that denotes success.
define dso_local noundef i32 @register_atexit_handler() {
; CHECK-LABEL: define dso_local noundef i32 @register_atexit_handler() local_unnamed_addr {
; CHECK-NEXT:    ret i32 0
;
  %1 = call i32 @atexit(ptr @empty_atexit_handler)
  ret i32 %1
}

declare dso_local void @declared_atexit_handler()

; Check that an atexit handler with only a declaration is not removed.
define dso_local noundef i32 @register_declared_atexit_handler() {
; CHECK-LABEL: define dso_local noundef i32 @register_declared_atexit_handler() local_unnamed_addr {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @atexit(ptr @declared_atexit_handler)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = call i32 @atexit(ptr @declared_atexit_handler)
  ret i32 %1
}

declare dso_local void @external_exit_func()

define dso_local void @nonempty_atexit_handler() {
; CHECK-LABEL: define dso_local void @nonempty_atexit_handler() {
; CHECK-NEXT:    call void @external_exit_func()
; CHECK-NEXT:    ret void
;
  call void @external_exit_func()
  ret void
}

; Check that an atexit handler that consists of any instructions other than `ret` is considered nonempty and not removed.
define dso_local noundef i32 @register_nonempty_atexit_handler() {
; CHECK-LABEL: define dso_local noundef i32 @register_nonempty_atexit_handler() local_unnamed_addr {
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @atexit(ptr @nonempty_atexit_handler)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = call i32 @atexit(ptr @nonempty_atexit_handler)
  ret i32 %1
}
