; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi lp64f -disable-strictnode-mutation < %s | \
; RUN:   FileCheck %s -check-prefix=RV64IZFHMIN

; This file exhaustively checks half<->i32 conversions.

define i32 @aext_fptosi(half %a) nounwind {
; RV64IZFHMIN-LABEL: aext_fptosi:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptosi.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}
declare i32 @llvm.experimental.constrained.fptosi.i32.f16(half, metadata)

define signext i32 @sext_fptosi(half %a) nounwind {
; RV64IZFHMIN-LABEL: sext_fptosi:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptosi.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}

define zeroext i32 @zext_fptosi(half %a) nounwind {
; RV64IZFHMIN-LABEL: zext_fptosi:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    slli a0, a0, 32
; RV64IZFHMIN-NEXT:    srli a0, a0, 32
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptosi.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}

define i32 @aext_fptoui(half %a) nounwind {
; RV64IZFHMIN-LABEL: aext_fptoui:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}
declare i32 @llvm.experimental.constrained.fptoui.i32.f16(half, metadata)

define signext i32 @sext_fptoui(half %a) nounwind {
; RV64IZFHMIN-LABEL: sext_fptoui:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.wu.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}

define zeroext i32 @zext_fptoui(half %a) nounwind {
; RV64IZFHMIN-LABEL: zext_fptoui:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h ft0, fa0
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, ft0, rtz
; RV64IZFHMIN-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %a, metadata !"fpexcept.strict") strictfp
  ret i32 %1
}

define half @uitofp_aext_i32_to_f16(i32 %a) nounwind {
; RV64IZFHMIN-LABEL: uitofp_aext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    slli a0, a0, 32
; RV64IZFHMIN-NEXT:    srli a0, a0, 32
; RV64IZFHMIN-NEXT:    fcvt.s.lu ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}
declare half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata, metadata)

define half @uitofp_sext_i32_to_f16(i32 signext %a) nounwind {
; RV64IZFHMIN-LABEL: uitofp_sext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    slli a0, a0, 32
; RV64IZFHMIN-NEXT:    srli a0, a0, 32
; RV64IZFHMIN-NEXT:    fcvt.s.lu ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}

define half @uitofp_zext_i32_to_f16(i32 zeroext %a) nounwind {
; RV64IZFHMIN-LABEL: uitofp_zext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.lu ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}

define half @sitofp_aext_i32_to_f16(i32 %a) nounwind {
; RV64IZFHMIN-LABEL: sitofp_aext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    sext.w a0, a0
; RV64IZFHMIN-NEXT:    fcvt.s.l ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}
declare half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata, metadata)

define half @sitofp_sext_i32_to_f16(i32 signext %a) nounwind {
; RV64IZFHMIN-LABEL: sitofp_sext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.l ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}

define half @sitofp_zext_i32_to_f16(i32 zeroext %a) nounwind {
; RV64IZFHMIN-LABEL: sitofp_zext_i32_to_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    sext.w a0, a0
; RV64IZFHMIN-NEXT:    fcvt.s.l ft0, a0
; RV64IZFHMIN-NEXT:    fcvt.h.s fa0, ft0
; RV64IZFHMIN-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret half %1
}
