// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -no-opaque-pointers -triple riscv64 -target-feature +experimental-zbf -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBF

// RV64ZBF-LABEL: @bfp32(
// RV64ZBF-NEXT:  entry:
// RV64ZBF-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// RV64ZBF-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// RV64ZBF-NEXT:    store i32 [[A:%.*]], i32* [[A_ADDR]], align 4
// RV64ZBF-NEXT:    store i32 [[B:%.*]], i32* [[B_ADDR]], align 4
// RV64ZBF-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// RV64ZBF-NEXT:    [[TMP1:%.*]] = load i32, i32* [[B_ADDR]], align 4
// RV64ZBF-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.bfp.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV64ZBF-NEXT:    ret i32 [[TMP2]]
//
int bfp32(int a, int b) {
  return __builtin_riscv_bfp_32(a, b);
}

// RV64ZBF-LABEL: @bfp64(
// RV64ZBF-NEXT:  entry:
// RV64ZBF-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// RV64ZBF-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// RV64ZBF-NEXT:    store i64 [[A:%.*]], i64* [[A_ADDR]], align 8
// RV64ZBF-NEXT:    store i64 [[B:%.*]], i64* [[B_ADDR]], align 8
// RV64ZBF-NEXT:    [[TMP0:%.*]] = load i64, i64* [[A_ADDR]], align 8
// RV64ZBF-NEXT:    [[TMP1:%.*]] = load i64, i64* [[B_ADDR]], align 8
// RV64ZBF-NEXT:    [[TMP2:%.*]] = call i64 @llvm.riscv.bfp.i64(i64 [[TMP0]], i64 [[TMP1]])
// RV64ZBF-NEXT:    ret i64 [[TMP2]]
//
long bfp64(long a, long b) {
  return __builtin_riscv_bfp_64(a, b);
}
